/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.ClassicLinkDnsSupport;
import software.amazon.awssdk.services.ec2.model.ClassicLinkDnsSupportListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVpcClassicLinkDnsSupportResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeVpcClassicLinkDnsSupportResponse> {
    private final String nextToken;
    private final List<ClassicLinkDnsSupport> vpcs;

    private DescribeVpcClassicLinkDnsSupportResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.vpcs = builder.vpcs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<ClassicLinkDnsSupport> vpcs() {
        return this.vpcs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.vpcs() == null ? 0 : this.vpcs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcClassicLinkDnsSupportResponse)) {
            return false;
        }
        DescribeVpcClassicLinkDnsSupportResponse other = (DescribeVpcClassicLinkDnsSupportResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.vpcs() == null ^ this.vpcs() == null) {
            return false;
        }
        return other.vpcs() == null || other.vpcs().equals(this.vpcs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.vpcs() != null) {
            sb.append("Vpcs: ").append(this.vpcs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ClassicLinkDnsSupport> vpcs;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcClassicLinkDnsSupportResponse model) {
            this.setNextToken(model.nextToken);
            this.setVpcs(model.vpcs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ClassicLinkDnsSupport> getVpcs() {
            return this.vpcs;
        }

        @Override
        public final Builder vpcs(Collection<ClassicLinkDnsSupport> vpcs) {
            this.vpcs = ClassicLinkDnsSupportListCopier.copy(vpcs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcs(ClassicLinkDnsSupport ... vpcs) {
            this.vpcs(Arrays.asList(vpcs));
            return this;
        }

        public final void setVpcs(Collection<ClassicLinkDnsSupport> vpcs) {
            this.vpcs = ClassicLinkDnsSupportListCopier.copy(vpcs);
        }

        @SafeVarargs
        public final void setVpcs(ClassicLinkDnsSupport ... vpcs) {
            this.vpcs(Arrays.asList(vpcs));
        }

        public DescribeVpcClassicLinkDnsSupportResponse build() {
            return new DescribeVpcClassicLinkDnsSupportResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVpcClassicLinkDnsSupportResponse> {
        public Builder nextToken(String var1);

        public Builder vpcs(Collection<ClassicLinkDnsSupport> var1);

        public Builder vpcs(ClassicLinkDnsSupport ... var1);
    }
}

