/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.VolumeIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVolumesModificationsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeVolumesModificationsRequest> {
    private final List<String> volumeIds;
    private final List<Filter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeVolumesModificationsRequest(BuilderImpl builder) {
        this.volumeIds = builder.volumeIds;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public List<String> volumeIds() {
        return this.volumeIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.volumeIds() == null ? 0 : this.volumeIds().hashCode());
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesModificationsRequest)) {
            return false;
        }
        DescribeVolumesModificationsRequest other = (DescribeVolumesModificationsRequest)((Object)obj);
        if (other.volumeIds() == null ^ this.volumeIds() == null) {
            return false;
        }
        if (other.volumeIds() != null && !other.volumeIds().equals(this.volumeIds())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        return other.maxResults() == null || other.maxResults().equals(this.maxResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.volumeIds() != null) {
            sb.append("VolumeIds: ").append(this.volumeIds()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> volumeIds;
        private List<Filter> filters;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumesModificationsRequest model) {
            this.setVolumeIds(model.volumeIds);
            this.setFilters(model.filters);
            this.setNextToken(model.nextToken);
            this.setMaxResults(model.maxResults);
        }

        public final Collection<String> getVolumeIds() {
            return this.volumeIds;
        }

        @Override
        public final Builder volumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdStringListCopier.copy(volumeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeIds(String ... volumeIds) {
            this.volumeIds(Arrays.asList(volumeIds));
            return this;
        }

        public final void setVolumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdStringListCopier.copy(volumeIds);
        }

        @SafeVarargs
        public final void setVolumeIds(String ... volumeIds) {
            this.volumeIds(Arrays.asList(volumeIds));
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public DescribeVolumesModificationsRequest build() {
            return new DescribeVolumesModificationsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVolumesModificationsRequest> {
        public Builder volumeIds(Collection<String> var1);

        public Builder volumeIds(String ... var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);
    }
}

