/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailability;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailabilitySetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScheduledInstanceAvailabilityResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeScheduledInstanceAvailabilityResponse> {
    private final String nextToken;
    private final List<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet;

    private DescribeScheduledInstanceAvailabilityResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.scheduledInstanceAvailabilitySet = builder.scheduledInstanceAvailabilitySet;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet() {
        return this.scheduledInstanceAvailabilitySet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.scheduledInstanceAvailabilitySet() == null ? 0 : this.scheduledInstanceAvailabilitySet().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstanceAvailabilityResponse)) {
            return false;
        }
        DescribeScheduledInstanceAvailabilityResponse other = (DescribeScheduledInstanceAvailabilityResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.scheduledInstanceAvailabilitySet() == null ^ this.scheduledInstanceAvailabilitySet() == null) {
            return false;
        }
        return other.scheduledInstanceAvailabilitySet() == null || other.scheduledInstanceAvailabilitySet().equals(this.scheduledInstanceAvailabilitySet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.scheduledInstanceAvailabilitySet() != null) {
            sb.append("ScheduledInstanceAvailabilitySet: ").append(this.scheduledInstanceAvailabilitySet()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledInstanceAvailabilityResponse model) {
            this.setNextToken(model.nextToken);
            this.setScheduledInstanceAvailabilitySet(model.scheduledInstanceAvailabilitySet);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ScheduledInstanceAvailability> getScheduledInstanceAvailabilitySet() {
            return this.scheduledInstanceAvailabilitySet;
        }

        @Override
        public final Builder scheduledInstanceAvailabilitySet(Collection<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet) {
            this.scheduledInstanceAvailabilitySet = ScheduledInstanceAvailabilitySetCopier.copy(scheduledInstanceAvailabilitySet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceAvailabilitySet(ScheduledInstanceAvailability ... scheduledInstanceAvailabilitySet) {
            this.scheduledInstanceAvailabilitySet(Arrays.asList(scheduledInstanceAvailabilitySet));
            return this;
        }

        public final void setScheduledInstanceAvailabilitySet(Collection<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet) {
            this.scheduledInstanceAvailabilitySet = ScheduledInstanceAvailabilitySetCopier.copy(scheduledInstanceAvailabilitySet);
        }

        @SafeVarargs
        public final void setScheduledInstanceAvailabilitySet(ScheduledInstanceAvailability ... scheduledInstanceAvailabilitySet) {
            this.scheduledInstanceAvailabilitySet(Arrays.asList(scheduledInstanceAvailabilitySet));
        }

        public DescribeScheduledInstanceAvailabilityResponse build() {
            return new DescribeScheduledInstanceAvailabilityResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeScheduledInstanceAvailabilityResponse> {
        public Builder nextToken(String var1);

        public Builder scheduledInstanceAvailabilitySet(Collection<ScheduledInstanceAvailability> var1);

        public Builder scheduledInstanceAvailabilitySet(ScheduledInstanceAvailability ... var1);
    }
}

