/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesModificationIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedInstancesModificationsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeReservedInstancesModificationsRequest> {
    private final List<Filter> filters;
    private final List<String> reservedInstancesModificationIds;
    private final String nextToken;

    private DescribeReservedInstancesModificationsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.reservedInstancesModificationIds = builder.reservedInstancesModificationIds;
        this.nextToken = builder.nextToken;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> reservedInstancesModificationIds() {
        return this.reservedInstancesModificationIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.reservedInstancesModificationIds() == null ? 0 : this.reservedInstancesModificationIds().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesModificationsRequest)) {
            return false;
        }
        DescribeReservedInstancesModificationsRequest other = (DescribeReservedInstancesModificationsRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.reservedInstancesModificationIds() == null ^ this.reservedInstancesModificationIds() == null) {
            return false;
        }
        if (other.reservedInstancesModificationIds() != null && !other.reservedInstancesModificationIds().equals(this.reservedInstancesModificationIds())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.reservedInstancesModificationIds() != null) {
            sb.append("ReservedInstancesModificationIds: ").append(this.reservedInstancesModificationIds()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private List<String> reservedInstancesModificationIds;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesModificationsRequest model) {
            this.setFilters(model.filters);
            this.setReservedInstancesModificationIds(model.reservedInstancesModificationIds);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
        }

        public final Collection<String> getReservedInstancesModificationIds() {
            return this.reservedInstancesModificationIds;
        }

        @Override
        public final Builder reservedInstancesModificationIds(Collection<String> reservedInstancesModificationIds) {
            this.reservedInstancesModificationIds = ReservedInstancesModificationIdStringListCopier.copy(reservedInstancesModificationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesModificationIds(String ... reservedInstancesModificationIds) {
            this.reservedInstancesModificationIds(Arrays.asList(reservedInstancesModificationIds));
            return this;
        }

        public final void setReservedInstancesModificationIds(Collection<String> reservedInstancesModificationIds) {
            this.reservedInstancesModificationIds = ReservedInstancesModificationIdStringListCopier.copy(reservedInstancesModificationIds);
        }

        @SafeVarargs
        public final void setReservedInstancesModificationIds(String ... reservedInstancesModificationIds) {
            this.reservedInstancesModificationIds(Arrays.asList(reservedInstancesModificationIds));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeReservedInstancesModificationsRequest build() {
            return new DescribeReservedInstancesModificationsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReservedInstancesModificationsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder reservedInstancesModificationIds(Collection<String> var1);

        public Builder reservedInstancesModificationIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

