/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.Region;
import software.amazon.awssdk.services.ec2.model.RegionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRegionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeRegionsResponse> {
    private final List<Region> regions;

    private DescribeRegionsResponse(BuilderImpl builder) {
        this.regions = builder.regions;
    }

    public List<Region> regions() {
        return this.regions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.regions() == null ? 0 : this.regions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegionsResponse)) {
            return false;
        }
        DescribeRegionsResponse other = (DescribeRegionsResponse)((Object)obj);
        if (other.regions() == null ^ this.regions() == null) {
            return false;
        }
        return other.regions() == null || other.regions().equals(this.regions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.regions() != null) {
            sb.append("Regions: ").append(this.regions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Region> regions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegionsResponse model) {
            this.setRegions(model.regions);
        }

        public final Collection<Region> getRegions() {
            return this.regions;
        }

        @Override
        public final Builder regions(Collection<Region> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(Region ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final void setRegions(Collection<Region> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        @SafeVarargs
        public final void setRegions(Region ... regions) {
            this.regions(Arrays.asList(regions));
        }

        public DescribeRegionsResponse build() {
            return new DescribeRegionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeRegionsResponse> {
        public Builder regions(Collection<Region> var1);

        public Builder regions(Region ... var1);
    }
}

