/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.HostOffering;
import software.amazon.awssdk.services.ec2.model.HostOfferingSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeHostReservationOfferingsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeHostReservationOfferingsResponse> {
    private final String nextToken;
    private final List<HostOffering> offeringSet;

    private DescribeHostReservationOfferingsResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.offeringSet = builder.offeringSet;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<HostOffering> offeringSet() {
        return this.offeringSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.offeringSet() == null ? 0 : this.offeringSet().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationOfferingsResponse)) {
            return false;
        }
        DescribeHostReservationOfferingsResponse other = (DescribeHostReservationOfferingsResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.offeringSet() == null ^ this.offeringSet() == null) {
            return false;
        }
        return other.offeringSet() == null || other.offeringSet().equals(this.offeringSet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.offeringSet() != null) {
            sb.append("OfferingSet: ").append(this.offeringSet()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<HostOffering> offeringSet;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostReservationOfferingsResponse model) {
            this.setNextToken(model.nextToken);
            this.setOfferingSet(model.offeringSet);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<HostOffering> getOfferingSet() {
            return this.offeringSet;
        }

        @Override
        public final Builder offeringSet(Collection<HostOffering> offeringSet) {
            this.offeringSet = HostOfferingSetCopier.copy(offeringSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringSet(HostOffering ... offeringSet) {
            this.offeringSet(Arrays.asList(offeringSet));
            return this;
        }

        public final void setOfferingSet(Collection<HostOffering> offeringSet) {
            this.offeringSet = HostOfferingSetCopier.copy(offeringSet);
        }

        @SafeVarargs
        public final void setOfferingSet(HostOffering ... offeringSet) {
            this.offeringSet(Arrays.asList(offeringSet));
        }

        public DescribeHostReservationOfferingsResponse build() {
            return new DescribeHostReservationOfferingsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeHostReservationOfferingsResponse> {
        public Builder nextToken(String var1);

        public Builder offeringSet(Collection<HostOffering> var1);

        public Builder offeringSet(HostOffering ... var1);
    }
}

