/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.PriceScheduleSpecification;
import software.amazon.awssdk.services.ec2.model.PriceScheduleSpecificationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateReservedInstancesListingRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateReservedInstancesListingRequest> {
    private final String clientToken;
    private final Integer instanceCount;
    private final List<PriceScheduleSpecification> priceSchedules;
    private final String reservedInstancesId;

    private CreateReservedInstancesListingRequest(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.instanceCount = builder.instanceCount;
        this.priceSchedules = builder.priceSchedules;
        this.reservedInstancesId = builder.reservedInstancesId;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public List<PriceScheduleSpecification> priceSchedules() {
        return this.priceSchedules;
    }

    public String reservedInstancesId() {
        return this.reservedInstancesId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.instanceCount() == null ? 0 : this.instanceCount().hashCode());
        hashCode = 31 * hashCode + (this.priceSchedules() == null ? 0 : this.priceSchedules().hashCode());
        hashCode = 31 * hashCode + (this.reservedInstancesId() == null ? 0 : this.reservedInstancesId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReservedInstancesListingRequest)) {
            return false;
        }
        CreateReservedInstancesListingRequest other = (CreateReservedInstancesListingRequest)((Object)obj);
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.priceSchedules() == null ^ this.priceSchedules() == null) {
            return false;
        }
        if (other.priceSchedules() != null && !other.priceSchedules().equals(this.priceSchedules())) {
            return false;
        }
        if (other.reservedInstancesId() == null ^ this.reservedInstancesId() == null) {
            return false;
        }
        return other.reservedInstancesId() == null || other.reservedInstancesId().equals(this.reservedInstancesId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.instanceCount() != null) {
            sb.append("InstanceCount: ").append(this.instanceCount()).append(",");
        }
        if (this.priceSchedules() != null) {
            sb.append("PriceSchedules: ").append(this.priceSchedules()).append(",");
        }
        if (this.reservedInstancesId() != null) {
            sb.append("ReservedInstancesId: ").append(this.reservedInstancesId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clientToken;
        private Integer instanceCount;
        private List<PriceScheduleSpecification> priceSchedules;
        private String reservedInstancesId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReservedInstancesListingRequest model) {
            this.setClientToken(model.clientToken);
            this.setInstanceCount(model.instanceCount);
            this.setPriceSchedules(model.priceSchedules);
            this.setReservedInstancesId(model.reservedInstancesId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Collection<PriceScheduleSpecification> getPriceSchedules() {
            return this.priceSchedules;
        }

        @Override
        public final Builder priceSchedules(Collection<PriceScheduleSpecification> priceSchedules) {
            this.priceSchedules = PriceScheduleSpecificationListCopier.copy(priceSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(PriceScheduleSpecification ... priceSchedules) {
            this.priceSchedules(Arrays.asList(priceSchedules));
            return this;
        }

        public final void setPriceSchedules(Collection<PriceScheduleSpecification> priceSchedules) {
            this.priceSchedules = PriceScheduleSpecificationListCopier.copy(priceSchedules);
        }

        @SafeVarargs
        public final void setPriceSchedules(PriceScheduleSpecification ... priceSchedules) {
            this.priceSchedules(Arrays.asList(priceSchedules));
        }

        public final String getReservedInstancesId() {
            return this.reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        public CreateReservedInstancesListingRequest build() {
            return new CreateReservedInstancesListingRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateReservedInstancesListingRequest> {
        public Builder clientToken(String var1);

        public Builder instanceCount(Integer var1);

        public Builder priceSchedules(Collection<PriceScheduleSpecification> var1);

        public Builder priceSchedules(PriceScheduleSpecification ... var1);

        public Builder reservedInstancesId(String var1);
    }
}

