/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsResponse;
import software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfig;

public class DescribeSpotFleetRequestsPublisher
implements SdkPublisher<DescribeSpotFleetRequestsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeSpotFleetRequestsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSpotFleetRequestsPublisher(Ec2AsyncClient client, DescribeSpotFleetRequestsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSpotFleetRequestsPublisher(Ec2AsyncClient client, DescribeSpotFleetRequestsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSpotFleetRequestsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSpotFleetRequestsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SpotFleetRequestConfig> spotFleetRequestConfigs() {
        Function<DescribeSpotFleetRequestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.spotFleetRequestConfigs() != null) {
                return response.spotFleetRequestConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSpotFleetRequestsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeSpotFleetRequestsPublisher resume(DescribeSpotFleetRequestsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeSpotFleetRequestsPublisher(this.client, (DescribeSpotFleetRequestsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeSpotFleetRequestsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeSpotFleetRequestsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeSpotFleetRequestsResponseFetcher
    implements AsyncPageFetcher<DescribeSpotFleetRequestsResponse> {
        private DescribeSpotFleetRequestsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSpotFleetRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSpotFleetRequestsResponse> nextPage(DescribeSpotFleetRequestsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSpotFleetRequestsPublisher.this.client.describeSpotFleetRequests(DescribeSpotFleetRequestsPublisher.this.firstRequest);
            }
            return DescribeSpotFleetRequestsPublisher.this.client.describeSpotFleetRequests((DescribeSpotFleetRequestsRequest)((Object)DescribeSpotFleetRequestsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

