/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ebs.model.ChangedBlock;
import software.amazon.awssdk.services.ebs.model.ChangedBlocksCopier;
import software.amazon.awssdk.services.ebs.model.EbsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChangedBlocksResponse
extends EbsResponse
implements ToCopyableBuilder<Builder, ListChangedBlocksResponse> {
    private static final SdkField<List<ChangedBlock>> CHANGED_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChangedBlocks").getter(ListChangedBlocksResponse.getter(ListChangedBlocksResponse::changedBlocks)).setter(ListChangedBlocksResponse.setter(Builder::changedBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangedBlocks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChangedBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> EXPIRY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpiryTime").getter(ListChangedBlocksResponse.getter(ListChangedBlocksResponse::expiryTime)).setter(ListChangedBlocksResponse.setter(Builder::expiryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryTime").build()}).build();
    private static final SdkField<Long> VOLUME_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VolumeSize").getter(ListChangedBlocksResponse.getter(ListChangedBlocksResponse::volumeSize)).setter(ListChangedBlocksResponse.setter(Builder::volumeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize").build()}).build();
    private static final SdkField<Integer> BLOCK_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BlockSize").getter(ListChangedBlocksResponse.getter(ListChangedBlocksResponse::blockSize)).setter(ListChangedBlocksResponse.setter(Builder::blockSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockSize").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListChangedBlocksResponse.getter(ListChangedBlocksResponse::nextToken)).setter(ListChangedBlocksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGED_BLOCKS_FIELD, EXPIRY_TIME_FIELD, VOLUME_SIZE_FIELD, BLOCK_SIZE_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListChangedBlocksResponse.memberNameToFieldInitializer();
    private final List<ChangedBlock> changedBlocks;
    private final Instant expiryTime;
    private final Long volumeSize;
    private final Integer blockSize;
    private final String nextToken;

    private ListChangedBlocksResponse(BuilderImpl builder) {
        super(builder);
        this.changedBlocks = builder.changedBlocks;
        this.expiryTime = builder.expiryTime;
        this.volumeSize = builder.volumeSize;
        this.blockSize = builder.blockSize;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasChangedBlocks() {
        return this.changedBlocks != null && !(this.changedBlocks instanceof SdkAutoConstructList);
    }

    public final List<ChangedBlock> changedBlocks() {
        return this.changedBlocks;
    }

    public final Instant expiryTime() {
        return this.expiryTime;
    }

    public final Long volumeSize() {
        return this.volumeSize;
    }

    public final Integer blockSize() {
        return this.blockSize;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChangedBlocks() ? this.changedBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.expiryTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChangedBlocksResponse)) {
            return false;
        }
        ListChangedBlocksResponse other = (ListChangedBlocksResponse)((Object)obj);
        return this.hasChangedBlocks() == other.hasChangedBlocks() && Objects.equals(this.changedBlocks(), other.changedBlocks()) && Objects.equals(this.expiryTime(), other.expiryTime()) && Objects.equals(this.volumeSize(), other.volumeSize()) && Objects.equals(this.blockSize(), other.blockSize()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListChangedBlocksResponse").add("ChangedBlocks", (Object)(this.changedBlocks() == null ? null : "*** Sensitive Data Redacted ***")).add("ExpiryTime", (Object)this.expiryTime()).add("VolumeSize", (Object)this.volumeSize()).add("BlockSize", (Object)this.blockSize()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChangedBlocks": {
                return Optional.ofNullable(clazz.cast(this.changedBlocks()));
            }
            case "ExpiryTime": {
                return Optional.ofNullable(clazz.cast(this.expiryTime()));
            }
            case "VolumeSize": {
                return Optional.ofNullable(clazz.cast(this.volumeSize()));
            }
            case "BlockSize": {
                return Optional.ofNullable(clazz.cast(this.blockSize()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChangedBlocks", CHANGED_BLOCKS_FIELD);
        map.put("ExpiryTime", EXPIRY_TIME_FIELD);
        map.put("VolumeSize", VOLUME_SIZE_FIELD);
        map.put("BlockSize", BLOCK_SIZE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListChangedBlocksResponse, T> g) {
        return obj -> g.apply((ListChangedBlocksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EbsResponse.BuilderImpl
    implements Builder {
        private List<ChangedBlock> changedBlocks = DefaultSdkAutoConstructList.getInstance();
        private Instant expiryTime;
        private Long volumeSize;
        private Integer blockSize;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChangedBlocksResponse model) {
            super(model);
            this.changedBlocks(model.changedBlocks);
            this.expiryTime(model.expiryTime);
            this.volumeSize(model.volumeSize);
            this.blockSize(model.blockSize);
            this.nextToken(model.nextToken);
        }

        public final List<ChangedBlock.Builder> getChangedBlocks() {
            List<ChangedBlock.Builder> result = ChangedBlocksCopier.copyToBuilder(this.changedBlocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangedBlocks(Collection<ChangedBlock.BuilderImpl> changedBlocks) {
            this.changedBlocks = ChangedBlocksCopier.copyFromBuilder(changedBlocks);
        }

        @Override
        public final Builder changedBlocks(Collection<ChangedBlock> changedBlocks) {
            this.changedBlocks = ChangedBlocksCopier.copy(changedBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changedBlocks(ChangedBlock ... changedBlocks) {
            this.changedBlocks(Arrays.asList(changedBlocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changedBlocks(Consumer<ChangedBlock.Builder> ... changedBlocks) {
            this.changedBlocks(Stream.of(changedBlocks).map(c -> (ChangedBlock)((ChangedBlock.Builder)ChangedBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getExpiryTime() {
            return this.expiryTime;
        }

        public final void setExpiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
        }

        @Override
        public final Builder expiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public final Long getVolumeSize() {
            return this.volumeSize;
        }

        public final void setVolumeSize(Long volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        public final Builder volumeSize(Long volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final Integer getBlockSize() {
            return this.blockSize;
        }

        public final void setBlockSize(Integer blockSize) {
            this.blockSize = blockSize;
        }

        @Override
        public final Builder blockSize(Integer blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListChangedBlocksResponse build() {
            return new ListChangedBlocksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EbsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChangedBlocksResponse> {
        public Builder changedBlocks(Collection<ChangedBlock> var1);

        public Builder changedBlocks(ChangedBlock ... var1);

        public Builder changedBlocks(Consumer<ChangedBlock.Builder> ... var1);

        public Builder expiryTime(Instant var1);

        public Builder volumeSize(Long var1);

        public Builder blockSize(Integer var1);

        public Builder nextToken(String var1);
    }
}

