/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ebs.EbsClient;
import software.amazon.awssdk.services.ebs.internal.UserAgentUtils;
import software.amazon.awssdk.services.ebs.model.ListSnapshotBlocksRequest;
import software.amazon.awssdk.services.ebs.model.ListSnapshotBlocksResponse;

public class ListSnapshotBlocksIterable
implements SdkIterable<ListSnapshotBlocksResponse> {
    private final EbsClient client;
    private final ListSnapshotBlocksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSnapshotBlocksIterable(EbsClient client, ListSnapshotBlocksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSnapshotBlocksResponseFetcher();
    }

    public Iterator<ListSnapshotBlocksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSnapshotBlocksResponseFetcher
    implements SyncPageFetcher<ListSnapshotBlocksResponse> {
        private ListSnapshotBlocksResponseFetcher() {
        }

        public boolean hasNextPage(ListSnapshotBlocksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSnapshotBlocksResponse nextPage(ListSnapshotBlocksResponse previousPage) {
            if (previousPage == null) {
                return ListSnapshotBlocksIterable.this.client.listSnapshotBlocks(ListSnapshotBlocksIterable.this.firstRequest);
            }
            return ListSnapshotBlocksIterable.this.client.listSnapshotBlocks((ListSnapshotBlocksRequest)((Object)ListSnapshotBlocksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

