/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ebs.model.ChecksumAggregationMethod;
import software.amazon.awssdk.services.ebs.model.ChecksumAlgorithm;
import software.amazon.awssdk.services.ebs.model.EbsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompleteSnapshotRequest
extends EbsRequest
implements ToCopyableBuilder<Builder, CompleteSnapshotRequest> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(CompleteSnapshotRequest.getter(CompleteSnapshotRequest::snapshotId)).setter(CompleteSnapshotRequest.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("snapshotId").build()}).build();
    private static final SdkField<Integer> CHANGED_BLOCKS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ChangedBlocksCount").getter(CompleteSnapshotRequest.getter(CompleteSnapshotRequest::changedBlocksCount)).setter(CompleteSnapshotRequest.setter(Builder::changedBlocksCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-ChangedBlocksCount").build()}).build();
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Checksum").getter(CompleteSnapshotRequest.getter(CompleteSnapshotRequest::checksum)).setter(CompleteSnapshotRequest.setter(Builder::checksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-Checksum").build()}).build();
    private static final SdkField<String> CHECKSUM_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChecksumAlgorithm").getter(CompleteSnapshotRequest.getter(CompleteSnapshotRequest::checksumAlgorithmAsString)).setter(CompleteSnapshotRequest.setter(Builder::checksumAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-Checksum-Algorithm").build()}).build();
    private static final SdkField<String> CHECKSUM_AGGREGATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChecksumAggregationMethod").getter(CompleteSnapshotRequest.getter(CompleteSnapshotRequest::checksumAggregationMethodAsString)).setter(CompleteSnapshotRequest.setter(Builder::checksumAggregationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-Checksum-Aggregation-Method").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, CHANGED_BLOCKS_COUNT_FIELD, CHECKSUM_FIELD, CHECKSUM_ALGORITHM_FIELD, CHECKSUM_AGGREGATION_METHOD_FIELD));
    private final String snapshotId;
    private final Integer changedBlocksCount;
    private final String checksum;
    private final String checksumAlgorithm;
    private final String checksumAggregationMethod;

    private CompleteSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.changedBlocksCount = builder.changedBlocksCount;
        this.checksum = builder.checksum;
        this.checksumAlgorithm = builder.checksumAlgorithm;
        this.checksumAggregationMethod = builder.checksumAggregationMethod;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final Integer changedBlocksCount() {
        return this.changedBlocksCount;
    }

    public final String checksum() {
        return this.checksum;
    }

    public final ChecksumAlgorithm checksumAlgorithm() {
        return ChecksumAlgorithm.fromValue(this.checksumAlgorithm);
    }

    public final String checksumAlgorithmAsString() {
        return this.checksumAlgorithm;
    }

    public final ChecksumAggregationMethod checksumAggregationMethod() {
        return ChecksumAggregationMethod.fromValue(this.checksumAggregationMethod);
    }

    public final String checksumAggregationMethodAsString() {
        return this.checksumAggregationMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changedBlocksCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksumAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksumAggregationMethodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteSnapshotRequest)) {
            return false;
        }
        CompleteSnapshotRequest other = (CompleteSnapshotRequest)((Object)obj);
        return Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.changedBlocksCount(), other.changedBlocksCount()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.checksumAlgorithmAsString(), other.checksumAlgorithmAsString()) && Objects.equals(this.checksumAggregationMethodAsString(), other.checksumAggregationMethodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CompleteSnapshotRequest").add("SnapshotId", (Object)this.snapshotId()).add("ChangedBlocksCount", (Object)this.changedBlocksCount()).add("Checksum", (Object)this.checksum()).add("ChecksumAlgorithm", (Object)this.checksumAlgorithmAsString()).add("ChecksumAggregationMethod", (Object)this.checksumAggregationMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "ChangedBlocksCount": {
                return Optional.ofNullable(clazz.cast(this.changedBlocksCount()));
            }
            case "Checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "ChecksumAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.checksumAlgorithmAsString()));
            }
            case "ChecksumAggregationMethod": {
                return Optional.ofNullable(clazz.cast(this.checksumAggregationMethodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompleteSnapshotRequest, T> g) {
        return obj -> g.apply((CompleteSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EbsRequest.BuilderImpl
    implements Builder {
        private String snapshotId;
        private Integer changedBlocksCount;
        private String checksum;
        private String checksumAlgorithm;
        private String checksumAggregationMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteSnapshotRequest model) {
            super(model);
            this.snapshotId(model.snapshotId);
            this.changedBlocksCount(model.changedBlocksCount);
            this.checksum(model.checksum);
            this.checksumAlgorithm(model.checksumAlgorithm);
            this.checksumAggregationMethod(model.checksumAggregationMethod);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Integer getChangedBlocksCount() {
            return this.changedBlocksCount;
        }

        public final void setChangedBlocksCount(Integer changedBlocksCount) {
            this.changedBlocksCount = changedBlocksCount;
        }

        @Override
        public final Builder changedBlocksCount(Integer changedBlocksCount) {
            this.changedBlocksCount = changedBlocksCount;
            return this;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final String getChecksumAlgorithm() {
            return this.checksumAlgorithm;
        }

        public final void setChecksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
        }

        @Override
        public final Builder checksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
            return this;
        }

        @Override
        public final Builder checksumAlgorithm(ChecksumAlgorithm checksumAlgorithm) {
            this.checksumAlgorithm(checksumAlgorithm == null ? null : checksumAlgorithm.toString());
            return this;
        }

        public final String getChecksumAggregationMethod() {
            return this.checksumAggregationMethod;
        }

        public final void setChecksumAggregationMethod(String checksumAggregationMethod) {
            this.checksumAggregationMethod = checksumAggregationMethod;
        }

        @Override
        public final Builder checksumAggregationMethod(String checksumAggregationMethod) {
            this.checksumAggregationMethod = checksumAggregationMethod;
            return this;
        }

        @Override
        public final Builder checksumAggregationMethod(ChecksumAggregationMethod checksumAggregationMethod) {
            this.checksumAggregationMethod(checksumAggregationMethod == null ? null : checksumAggregationMethod.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CompleteSnapshotRequest build() {
            return new CompleteSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EbsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CompleteSnapshotRequest> {
        public Builder snapshotId(String var1);

        public Builder changedBlocksCount(Integer var1);

        public Builder checksum(String var1);

        public Builder checksumAlgorithm(String var1);

        public Builder checksumAlgorithm(ChecksumAlgorithm var1);

        public Builder checksumAggregationMethod(String var1);

        public Builder checksumAggregationMethod(ChecksumAggregationMethod var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

