/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ebs.EbsClient;
import software.amazon.awssdk.services.ebs.model.ListChangedBlocksRequest;
import software.amazon.awssdk.services.ebs.model.ListChangedBlocksResponse;

public class ListChangedBlocksIterable
implements SdkIterable<ListChangedBlocksResponse> {
    private final EbsClient client;
    private final ListChangedBlocksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChangedBlocksIterable(EbsClient client, ListChangedBlocksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListChangedBlocksResponseFetcher();
    }

    public Iterator<ListChangedBlocksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListChangedBlocksResponseFetcher
    implements SyncPageFetcher<ListChangedBlocksResponse> {
        private ListChangedBlocksResponseFetcher() {
        }

        public boolean hasNextPage(ListChangedBlocksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChangedBlocksResponse nextPage(ListChangedBlocksResponse previousPage) {
            if (previousPage == null) {
                return ListChangedBlocksIterable.this.client.listChangedBlocks(ListChangedBlocksIterable.this.firstRequest);
            }
            return ListChangedBlocksIterable.this.client.listChangedBlocks((ListChangedBlocksRequest)((Object)ListChangedBlocksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

