/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ebs.model.EbsRequest;
import software.amazon.awssdk.services.ebs.model.Tag;
import software.amazon.awssdk.services.ebs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSnapshotRequest
extends EbsRequest
implements ToCopyableBuilder<Builder, StartSnapshotRequest> {
    private static final SdkField<Long> VOLUME_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VolumeSize").getter(StartSnapshotRequest.getter(StartSnapshotRequest::volumeSize)).setter(StartSnapshotRequest.setter(Builder::volumeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize").build()}).build();
    private static final SdkField<String> PARENT_SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentSnapshotId").getter(StartSnapshotRequest.getter(StartSnapshotRequest::parentSnapshotId)).setter(StartSnapshotRequest.setter(Builder::parentSnapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentSnapshotId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(StartSnapshotRequest.getter(StartSnapshotRequest::tags)).setter(StartSnapshotRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StartSnapshotRequest.getter(StartSnapshotRequest::description)).setter(StartSnapshotRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartSnapshotRequest.getter(StartSnapshotRequest::clientToken)).setter(StartSnapshotRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(StartSnapshotRequest.getter(StartSnapshotRequest::encrypted)).setter(StartSnapshotRequest.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(StartSnapshotRequest.getter(StartSnapshotRequest::kmsKeyArn)).setter(StartSnapshotRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(StartSnapshotRequest.getter(StartSnapshotRequest::timeout)).setter(StartSnapshotRequest.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_SIZE_FIELD, PARENT_SNAPSHOT_ID_FIELD, TAGS_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, ENCRYPTED_FIELD, KMS_KEY_ARN_FIELD, TIMEOUT_FIELD));
    private final Long volumeSize;
    private final String parentSnapshotId;
    private final List<Tag> tags;
    private final String description;
    private final String clientToken;
    private final Boolean encrypted;
    private final String kmsKeyArn;
    private final Integer timeout;

    private StartSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.volumeSize = builder.volumeSize;
        this.parentSnapshotId = builder.parentSnapshotId;
        this.tags = builder.tags;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.encrypted = builder.encrypted;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.timeout = builder.timeout;
    }

    public final Long volumeSize() {
        return this.volumeSize;
    }

    public final String parentSnapshotId() {
        return this.parentSnapshotId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String description() {
        return this.description;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentSnapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSnapshotRequest)) {
            return false;
        }
        StartSnapshotRequest other = (StartSnapshotRequest)((Object)obj);
        return Objects.equals(this.volumeSize(), other.volumeSize()) && Objects.equals(this.parentSnapshotId(), other.parentSnapshotId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.timeout(), other.timeout());
    }

    public final String toString() {
        return ToString.builder((String)"StartSnapshotRequest").add("VolumeSize", (Object)this.volumeSize()).add("ParentSnapshotId", (Object)this.parentSnapshotId()).add("Tags", this.hasTags() ? this.tags() : null).add("Description", (Object)this.description()).add("ClientToken", (Object)this.clientToken()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyArn", (Object)(this.kmsKeyArn() == null ? null : "*** Sensitive Data Redacted ***")).add("Timeout", (Object)this.timeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeSize": {
                return Optional.ofNullable(clazz.cast(this.volumeSize()));
            }
            case "ParentSnapshotId": {
                return Optional.ofNullable(clazz.cast(this.parentSnapshotId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSnapshotRequest, T> g) {
        return obj -> g.apply((StartSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EbsRequest.BuilderImpl
    implements Builder {
        private Long volumeSize;
        private String parentSnapshotId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String clientToken;
        private Boolean encrypted;
        private String kmsKeyArn;
        private Integer timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSnapshotRequest model) {
            super(model);
            this.volumeSize(model.volumeSize);
            this.parentSnapshotId(model.parentSnapshotId);
            this.tags(model.tags);
            this.description(model.description);
            this.clientToken(model.clientToken);
            this.encrypted(model.encrypted);
            this.kmsKeyArn(model.kmsKeyArn);
            this.timeout(model.timeout);
        }

        public final Long getVolumeSize() {
            return this.volumeSize;
        }

        public final void setVolumeSize(Long volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        @Transient
        public final Builder volumeSize(Long volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final String getParentSnapshotId() {
            return this.parentSnapshotId;
        }

        public final void setParentSnapshotId(String parentSnapshotId) {
            this.parentSnapshotId = parentSnapshotId;
        }

        @Override
        @Transient
        public final Builder parentSnapshotId(String parentSnapshotId) {
            this.parentSnapshotId = parentSnapshotId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        @Transient
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        @Transient
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        @Transient
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSnapshotRequest build() {
            return new StartSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EbsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSnapshotRequest> {
        public Builder volumeSize(Long var1);

        public Builder parentSnapshotId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder description(String var1);

        public Builder clientToken(String var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyArn(String var1);

        public Builder timeout(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

