/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.ebs.DefaultEbsAsyncClientBuilder;
import software.amazon.awssdk.services.ebs.EbsAsyncClientBuilder;
import software.amazon.awssdk.services.ebs.model.CompleteSnapshotRequest;
import software.amazon.awssdk.services.ebs.model.CompleteSnapshotResponse;
import software.amazon.awssdk.services.ebs.model.GetSnapshotBlockRequest;
import software.amazon.awssdk.services.ebs.model.GetSnapshotBlockResponse;
import software.amazon.awssdk.services.ebs.model.ListChangedBlocksRequest;
import software.amazon.awssdk.services.ebs.model.ListChangedBlocksResponse;
import software.amazon.awssdk.services.ebs.model.ListSnapshotBlocksRequest;
import software.amazon.awssdk.services.ebs.model.ListSnapshotBlocksResponse;
import software.amazon.awssdk.services.ebs.model.PutSnapshotBlockRequest;
import software.amazon.awssdk.services.ebs.model.PutSnapshotBlockResponse;
import software.amazon.awssdk.services.ebs.model.StartSnapshotRequest;
import software.amazon.awssdk.services.ebs.model.StartSnapshotResponse;
import software.amazon.awssdk.services.ebs.paginators.ListChangedBlocksPublisher;
import software.amazon.awssdk.services.ebs.paginators.ListSnapshotBlocksPublisher;

public interface EbsAsyncClient
extends SdkClient {
    public static final String SERVICE_NAME = "ebs";
    public static final String SERVICE_METADATA_ID = "ebs";

    public static EbsAsyncClient create() {
        return (EbsAsyncClient)EbsAsyncClient.builder().build();
    }

    public static EbsAsyncClientBuilder builder() {
        return new DefaultEbsAsyncClientBuilder();
    }

    default public CompletableFuture<CompleteSnapshotResponse> completeSnapshot(CompleteSnapshotRequest completeSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CompleteSnapshotResponse> completeSnapshot(Consumer<CompleteSnapshotRequest.Builder> completeSnapshotRequest) {
        return this.completeSnapshot((CompleteSnapshotRequest)((Object)((CompleteSnapshotRequest.Builder)CompleteSnapshotRequest.builder().applyMutation(completeSnapshotRequest)).build()));
    }

    default public <ReturnT> CompletableFuture<ReturnT> getSnapshotBlock(GetSnapshotBlockRequest getSnapshotBlockRequest, AsyncResponseTransformer<GetSnapshotBlockResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> CompletableFuture<ReturnT> getSnapshotBlock(Consumer<GetSnapshotBlockRequest.Builder> getSnapshotBlockRequest, AsyncResponseTransformer<GetSnapshotBlockResponse, ReturnT> asyncResponseTransformer) {
        return this.getSnapshotBlock((GetSnapshotBlockRequest)((Object)((GetSnapshotBlockRequest.Builder)GetSnapshotBlockRequest.builder().applyMutation(getSnapshotBlockRequest)).build()), asyncResponseTransformer);
    }

    default public CompletableFuture<GetSnapshotBlockResponse> getSnapshotBlock(GetSnapshotBlockRequest getSnapshotBlockRequest, Path destinationPath) {
        return this.getSnapshotBlock(getSnapshotBlockRequest, AsyncResponseTransformer.toFile((Path)destinationPath));
    }

    default public CompletableFuture<GetSnapshotBlockResponse> getSnapshotBlock(Consumer<GetSnapshotBlockRequest.Builder> getSnapshotBlockRequest, Path destinationPath) {
        return this.getSnapshotBlock((GetSnapshotBlockRequest)((Object)((GetSnapshotBlockRequest.Builder)GetSnapshotBlockRequest.builder().applyMutation(getSnapshotBlockRequest)).build()), destinationPath);
    }

    default public CompletableFuture<ListChangedBlocksResponse> listChangedBlocks(ListChangedBlocksRequest listChangedBlocksRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListChangedBlocksResponse> listChangedBlocks(Consumer<ListChangedBlocksRequest.Builder> listChangedBlocksRequest) {
        return this.listChangedBlocks((ListChangedBlocksRequest)((Object)((ListChangedBlocksRequest.Builder)ListChangedBlocksRequest.builder().applyMutation(listChangedBlocksRequest)).build()));
    }

    default public ListChangedBlocksPublisher listChangedBlocksPaginator(ListChangedBlocksRequest listChangedBlocksRequest) {
        throw new UnsupportedOperationException();
    }

    default public ListChangedBlocksPublisher listChangedBlocksPaginator(Consumer<ListChangedBlocksRequest.Builder> listChangedBlocksRequest) {
        return this.listChangedBlocksPaginator((ListChangedBlocksRequest)((Object)((ListChangedBlocksRequest.Builder)ListChangedBlocksRequest.builder().applyMutation(listChangedBlocksRequest)).build()));
    }

    default public CompletableFuture<ListSnapshotBlocksResponse> listSnapshotBlocks(ListSnapshotBlocksRequest listSnapshotBlocksRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListSnapshotBlocksResponse> listSnapshotBlocks(Consumer<ListSnapshotBlocksRequest.Builder> listSnapshotBlocksRequest) {
        return this.listSnapshotBlocks((ListSnapshotBlocksRequest)((Object)((ListSnapshotBlocksRequest.Builder)ListSnapshotBlocksRequest.builder().applyMutation(listSnapshotBlocksRequest)).build()));
    }

    default public ListSnapshotBlocksPublisher listSnapshotBlocksPaginator(ListSnapshotBlocksRequest listSnapshotBlocksRequest) {
        throw new UnsupportedOperationException();
    }

    default public ListSnapshotBlocksPublisher listSnapshotBlocksPaginator(Consumer<ListSnapshotBlocksRequest.Builder> listSnapshotBlocksRequest) {
        return this.listSnapshotBlocksPaginator((ListSnapshotBlocksRequest)((Object)((ListSnapshotBlocksRequest.Builder)ListSnapshotBlocksRequest.builder().applyMutation(listSnapshotBlocksRequest)).build()));
    }

    default public CompletableFuture<PutSnapshotBlockResponse> putSnapshotBlock(PutSnapshotBlockRequest putSnapshotBlockRequest, AsyncRequestBody requestBody) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutSnapshotBlockResponse> putSnapshotBlock(Consumer<PutSnapshotBlockRequest.Builder> putSnapshotBlockRequest, AsyncRequestBody requestBody) {
        return this.putSnapshotBlock((PutSnapshotBlockRequest)((Object)((PutSnapshotBlockRequest.Builder)PutSnapshotBlockRequest.builder().applyMutation(putSnapshotBlockRequest)).build()), requestBody);
    }

    default public CompletableFuture<PutSnapshotBlockResponse> putSnapshotBlock(PutSnapshotBlockRequest putSnapshotBlockRequest, Path sourcePath) {
        return this.putSnapshotBlock(putSnapshotBlockRequest, AsyncRequestBody.fromFile((Path)sourcePath));
    }

    default public CompletableFuture<PutSnapshotBlockResponse> putSnapshotBlock(Consumer<PutSnapshotBlockRequest.Builder> putSnapshotBlockRequest, Path sourcePath) {
        return this.putSnapshotBlock((PutSnapshotBlockRequest)((Object)((PutSnapshotBlockRequest.Builder)PutSnapshotBlockRequest.builder().applyMutation(putSnapshotBlockRequest)).build()), sourcePath);
    }

    default public CompletableFuture<StartSnapshotResponse> startSnapshot(StartSnapshotRequest startSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StartSnapshotResponse> startSnapshot(Consumer<StartSnapshotRequest.Builder> startSnapshotRequest) {
        return this.startSnapshot((StartSnapshotRequest)((Object)((StartSnapshotRequest.Builder)StartSnapshotRequest.builder().applyMutation(startSnapshotRequest)).build()));
    }
}

