/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ebs.model.EbsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSnapshotBlockRequest
extends EbsRequest
implements ToCopyableBuilder<Builder, GetSnapshotBlockRequest> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(GetSnapshotBlockRequest.getter(GetSnapshotBlockRequest::snapshotId)).setter(GetSnapshotBlockRequest.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("snapshotId").build()}).build();
    private static final SdkField<Integer> BLOCK_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BlockIndex").getter(GetSnapshotBlockRequest.getter(GetSnapshotBlockRequest::blockIndex)).setter(GetSnapshotBlockRequest.setter(Builder::blockIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("blockIndex").build()}).build();
    private static final SdkField<String> BLOCK_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlockToken").getter(GetSnapshotBlockRequest.getter(GetSnapshotBlockRequest::blockToken)).setter(GetSnapshotBlockRequest.setter(Builder::blockToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("blockToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, BLOCK_INDEX_FIELD, BLOCK_TOKEN_FIELD));
    private final String snapshotId;
    private final Integer blockIndex;
    private final String blockToken;

    private GetSnapshotBlockRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.blockIndex = builder.blockIndex;
        this.blockToken = builder.blockToken;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public Integer blockIndex() {
        return this.blockIndex;
    }

    public String blockToken() {
        return this.blockToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSnapshotBlockRequest)) {
            return false;
        }
        GetSnapshotBlockRequest other = (GetSnapshotBlockRequest)((Object)obj);
        return Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.blockIndex(), other.blockIndex()) && Objects.equals(this.blockToken(), other.blockToken());
    }

    public String toString() {
        return ToString.builder((String)"GetSnapshotBlockRequest").add("SnapshotId", (Object)this.snapshotId()).add("BlockIndex", (Object)this.blockIndex()).add("BlockToken", (Object)this.blockToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "BlockIndex": {
                return Optional.ofNullable(clazz.cast(this.blockIndex()));
            }
            case "BlockToken": {
                return Optional.ofNullable(clazz.cast(this.blockToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSnapshotBlockRequest, T> g) {
        return obj -> g.apply((GetSnapshotBlockRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EbsRequest.BuilderImpl
    implements Builder {
        private String snapshotId;
        private Integer blockIndex;
        private String blockToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSnapshotBlockRequest model) {
            super(model);
            this.snapshotId(model.snapshotId);
            this.blockIndex(model.blockIndex);
            this.blockToken(model.blockToken);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final Integer getBlockIndex() {
            return this.blockIndex;
        }

        @Override
        public final Builder blockIndex(Integer blockIndex) {
            this.blockIndex = blockIndex;
            return this;
        }

        public final void setBlockIndex(Integer blockIndex) {
            this.blockIndex = blockIndex;
        }

        public final String getBlockToken() {
            return this.blockToken;
        }

        @Override
        public final Builder blockToken(String blockToken) {
            this.blockToken = blockToken;
            return this;
        }

        public final void setBlockToken(String blockToken) {
            this.blockToken = blockToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSnapshotBlockRequest build() {
            return new GetSnapshotBlockRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EbsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSnapshotBlockRequest> {
        public Builder snapshotId(String var1);

        public Builder blockIndex(Integer var1);

        public Builder blockToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

