/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ebs.DefaultEbsClientBuilder;
import software.amazon.awssdk.services.ebs.EbsClientBuilder;
import software.amazon.awssdk.services.ebs.model.EbsException;
import software.amazon.awssdk.services.ebs.model.GetSnapshotBlockRequest;
import software.amazon.awssdk.services.ebs.model.GetSnapshotBlockResponse;
import software.amazon.awssdk.services.ebs.model.ListChangedBlocksRequest;
import software.amazon.awssdk.services.ebs.model.ListChangedBlocksResponse;
import software.amazon.awssdk.services.ebs.model.ListSnapshotBlocksRequest;
import software.amazon.awssdk.services.ebs.model.ListSnapshotBlocksResponse;
import software.amazon.awssdk.services.ebs.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ebs.model.ValidationException;
import software.amazon.awssdk.services.ebs.paginators.ListChangedBlocksIterable;
import software.amazon.awssdk.services.ebs.paginators.ListSnapshotBlocksIterable;

public interface EbsClient
extends SdkClient {
    public static final String SERVICE_NAME = "ebs";

    public static EbsClient create() {
        return (EbsClient)EbsClient.builder().build();
    }

    public static EbsClientBuilder builder() {
        return new DefaultEbsClientBuilder();
    }

    default public <ReturnT> ReturnT getSnapshotBlock(GetSnapshotBlockRequest getSnapshotBlockRequest, ResponseTransformer<GetSnapshotBlockResponse, ReturnT> responseTransformer) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EbsException {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT getSnapshotBlock(Consumer<GetSnapshotBlockRequest.Builder> getSnapshotBlockRequest, ResponseTransformer<GetSnapshotBlockResponse, ReturnT> responseTransformer) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EbsException {
        return this.getSnapshotBlock((GetSnapshotBlockRequest)((Object)((GetSnapshotBlockRequest.Builder)GetSnapshotBlockRequest.builder().applyMutation(getSnapshotBlockRequest)).build()), responseTransformer);
    }

    default public GetSnapshotBlockResponse getSnapshotBlock(GetSnapshotBlockRequest getSnapshotBlockRequest, Path filePath) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EbsException {
        return (GetSnapshotBlockResponse)((Object)this.getSnapshotBlock(getSnapshotBlockRequest, ResponseTransformer.toFile((Path)filePath)));
    }

    default public GetSnapshotBlockResponse getSnapshotBlock(Consumer<GetSnapshotBlockRequest.Builder> getSnapshotBlockRequest, Path filePath) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EbsException {
        return this.getSnapshotBlock((GetSnapshotBlockRequest)((Object)((GetSnapshotBlockRequest.Builder)GetSnapshotBlockRequest.builder().applyMutation(getSnapshotBlockRequest)).build()), filePath);
    }

    default public ResponseInputStream<GetSnapshotBlockResponse> getSnapshotBlock(GetSnapshotBlockRequest getSnapshotBlockRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EbsException {
        return (ResponseInputStream)this.getSnapshotBlock(getSnapshotBlockRequest, ResponseTransformer.toInputStream());
    }

    default public ResponseInputStream<GetSnapshotBlockResponse> getSnapshotBlock(Consumer<GetSnapshotBlockRequest.Builder> getSnapshotBlockRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EbsException {
        return this.getSnapshotBlock((GetSnapshotBlockRequest)((Object)((GetSnapshotBlockRequest.Builder)GetSnapshotBlockRequest.builder().applyMutation(getSnapshotBlockRequest)).build()));
    }

    default public ResponseBytes<GetSnapshotBlockResponse> getSnapshotBlockAsBytes(GetSnapshotBlockRequest getSnapshotBlockRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EbsException {
        return (ResponseBytes)this.getSnapshotBlock(getSnapshotBlockRequest, ResponseTransformer.toBytes());
    }

    default public ResponseBytes<GetSnapshotBlockResponse> getSnapshotBlockAsBytes(Consumer<GetSnapshotBlockRequest.Builder> getSnapshotBlockRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EbsException {
        return this.getSnapshotBlockAsBytes((GetSnapshotBlockRequest)((Object)((GetSnapshotBlockRequest.Builder)GetSnapshotBlockRequest.builder().applyMutation(getSnapshotBlockRequest)).build()));
    }

    default public ListChangedBlocksResponse listChangedBlocks(ListChangedBlocksRequest listChangedBlocksRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EbsException {
        throw new UnsupportedOperationException();
    }

    default public ListChangedBlocksResponse listChangedBlocks(Consumer<ListChangedBlocksRequest.Builder> listChangedBlocksRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EbsException {
        return this.listChangedBlocks((ListChangedBlocksRequest)((Object)((ListChangedBlocksRequest.Builder)ListChangedBlocksRequest.builder().applyMutation(listChangedBlocksRequest)).build()));
    }

    default public ListChangedBlocksIterable listChangedBlocksPaginator(ListChangedBlocksRequest listChangedBlocksRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EbsException {
        throw new UnsupportedOperationException();
    }

    default public ListChangedBlocksIterable listChangedBlocksPaginator(Consumer<ListChangedBlocksRequest.Builder> listChangedBlocksRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EbsException {
        return this.listChangedBlocksPaginator((ListChangedBlocksRequest)((Object)((ListChangedBlocksRequest.Builder)ListChangedBlocksRequest.builder().applyMutation(listChangedBlocksRequest)).build()));
    }

    default public ListSnapshotBlocksResponse listSnapshotBlocks(ListSnapshotBlocksRequest listSnapshotBlocksRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EbsException {
        throw new UnsupportedOperationException();
    }

    default public ListSnapshotBlocksResponse listSnapshotBlocks(Consumer<ListSnapshotBlocksRequest.Builder> listSnapshotBlocksRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EbsException {
        return this.listSnapshotBlocks((ListSnapshotBlocksRequest)((Object)((ListSnapshotBlocksRequest.Builder)ListSnapshotBlocksRequest.builder().applyMutation(listSnapshotBlocksRequest)).build()));
    }

    default public ListSnapshotBlocksIterable listSnapshotBlocksPaginator(ListSnapshotBlocksRequest listSnapshotBlocksRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EbsException {
        throw new UnsupportedOperationException();
    }

    default public ListSnapshotBlocksIterable listSnapshotBlocksPaginator(Consumer<ListSnapshotBlocksRequest.Builder> listSnapshotBlocksRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, EbsException {
        return this.listSnapshotBlocksPaginator((ListSnapshotBlocksRequest)((Object)((ListSnapshotBlocksRequest.Builder)ListSnapshotBlocksRequest.builder().applyMutation(listSnapshotBlocksRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

