/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.CreateBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableResponse;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeExportRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeExportResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeImportRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeImportResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeLimitsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeLimitsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveResponse;
import software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse;
import software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest;
import software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeResponse;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.dynamodb.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.dynamodb.model.ImportTableRequest;
import software.amazon.awssdk.services.dynamodb.model.ImportTableResponse;
import software.amazon.awssdk.services.dynamodb.model.ListBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListBackupsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListExportsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListExportsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.ListImportsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListImportsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.dynamodb.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeRequest;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.TagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.TagResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.UntagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.UntagResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveResponse;
import software.amazon.awssdk.services.dynamodb.paginators.BatchGetItemPublisher;
import software.amazon.awssdk.services.dynamodb.paginators.ListContributorInsightsPublisher;
import software.amazon.awssdk.services.dynamodb.paginators.ListExportsPublisher;
import software.amazon.awssdk.services.dynamodb.paginators.ListImportsPublisher;
import software.amazon.awssdk.services.dynamodb.paginators.ListTablesPublisher;
import software.amazon.awssdk.services.dynamodb.paginators.QueryPublisher;
import software.amazon.awssdk.services.dynamodb.paginators.ScanPublisher;
import software.amazon.awssdk.services.dynamodb.waiters.DynamoDbAsyncWaiter;

/**
 * Service client for accessing DynamoDB asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <fullname>Amazon DynamoDB</fullname>
 * <p>
 * Amazon DynamoDB is a fully managed NoSQL database service that provides fast and predictable performance with
 * seamless scalability. DynamoDB lets you offload the administrative burdens of operating and scaling a distributed
 * database, so that you don't have to worry about hardware provisioning, setup and configuration, replication, software
 * patching, or cluster scaling.
 * </p>
 * <p>
 * With DynamoDB, you can create database tables that can store and retrieve any amount of data, and serve any level of
 * request traffic. You can scale up or scale down your tables' throughput capacity without downtime or performance
 * degradation, and use the Amazon Web Services Management Console to monitor resource utilization and performance
 * metrics.
 * </p>
 * <p>
 * DynamoDB automatically spreads the data and traffic for your tables over a sufficient number of servers to handle
 * your throughput and storage requirements, while maintaining consistent and fast performance. All of your data is
 * stored on solid state disks (SSDs) and automatically replicated across multiple Availability Zones in an Amazon Web
 * Services Region, providing built-in high availability and data durability.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DynamoDbAsyncClient extends AwsClient {
    String SERVICE_NAME = "dynamodb";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "dynamodb";

    /**
     * <p>
     * This operation allows you to perform batch reads or writes on data stored in DynamoDB, using PartiQL. Each read
     * statement in a <code>BatchExecuteStatement</code> must specify an equality condition on all key attributes. This
     * enforces that each <code>SELECT</code> statement in a batch returns at most a single item. For more information,
     * see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ql-reference.multiplestatements.batching.html"
     * >Running batch operations with PartiQL for DynamoDB </a>.
     * </p>
     * <note>
     * <p>
     * The entire batch must consist of either read statements or write statements, you cannot mix both in one batch.
     * </p>
     * </note> <important>
     * <p>
     * A HTTP 200 response does not mean that all statements in the BatchExecuteStatement succeeded. Error details for
     * individual statements can be found under the <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_BatchStatementResponse.html#DDB-Type-BatchStatementResponse-Error"
     * >Error</a> field of the <code>BatchStatementResponse</code> for each statement.
     * </p>
     * </important>
     *
     * @param batchExecuteStatementRequest
     * @return A Java Future containing the result of the BatchExecuteStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.BatchExecuteStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchExecuteStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchExecuteStatementResponse> batchExecuteStatement(
            BatchExecuteStatementRequest batchExecuteStatementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation allows you to perform batch reads or writes on data stored in DynamoDB, using PartiQL. Each read
     * statement in a <code>BatchExecuteStatement</code> must specify an equality condition on all key attributes. This
     * enforces that each <code>SELECT</code> statement in a batch returns at most a single item. For more information,
     * see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ql-reference.multiplestatements.batching.html"
     * >Running batch operations with PartiQL for DynamoDB </a>.
     * </p>
     * <note>
     * <p>
     * The entire batch must consist of either read statements or write statements, you cannot mix both in one batch.
     * </p>
     * </note> <important>
     * <p>
     * A HTTP 200 response does not mean that all statements in the BatchExecuteStatement succeeded. Error details for
     * individual statements can be found under the <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_BatchStatementResponse.html#DDB-Type-BatchStatementResponse-Error"
     * >Error</a> field of the <code>BatchStatementResponse</code> for each statement.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchExecuteStatementRequest.Builder} avoiding the
     * need to create one manually via {@link BatchExecuteStatementRequest#builder()}
     * </p>
     *
     * @param batchExecuteStatementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchExecuteStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.BatchExecuteStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchExecuteStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchExecuteStatementResponse> batchExecuteStatement(
            Consumer<BatchExecuteStatementRequest.Builder> batchExecuteStatementRequest) {
        return batchExecuteStatement(BatchExecuteStatementRequest.builder().applyMutation(batchExecuteStatementRequest).build());
    }

    /**
     * <p>
     * The <code>BatchGetItem</code> operation returns the attributes of one or more items from one or more tables. You
     * identify requested items by primary key.
     * </p>
     * <p>
     * A single operation can retrieve up to 16 MB of data, which can contain as many as 100 items.
     * <code>BatchGetItem</code> returns a partial result if the response size limit is exceeded, the table's
     * provisioned throughput is exceeded, more than 1MB per partition is requested, or an internal processing failure
     * occurs. If a partial result is returned, the operation returns a value for <code>UnprocessedKeys</code>. You can
     * use this value to retry the operation starting with the next item to get.
     * </p>
     * <important>
     * <p>
     * If you request more than 100 items, <code>BatchGetItem</code> returns a <code>ValidationException</code> with the
     * message "Too many items requested for the BatchGetItem call."
     * </p>
     * </important>
     * <p>
     * For example, if you ask to retrieve 100 items, but each individual item is 300 KB in size, the system returns 52
     * items (so as not to exceed the 16 MB limit). It also returns an appropriate <code>UnprocessedKeys</code> value so
     * you can get the next page of results. If desired, your application can include its own logic to assemble the
     * pages of results into one dataset.
     * </p>
     * <p>
     * If <i>none</i> of the items can be processed due to insufficient provisioned throughput on all of the tables in
     * the request, then <code>BatchGetItem</code> returns a <code>ProvisionedThroughputExceededException</code>. If
     * <i>at least one</i> of the items is successfully processed, then <code>BatchGetItem</code> completes
     * successfully, while returning the keys of the unread items in <code>UnprocessedKeys</code>.
     * </p>
     * <important>
     * <p>
     * If DynamoDB returns any unprocessed items, you should retry the batch operation on those items. However, <i>we
     * strongly recommend that you use an exponential backoff algorithm</i>. If you retry the batch operation
     * immediately, the underlying read or write requests can still fail due to throttling on the individual tables. If
     * you delay the batch operation using exponential backoff, the individual requests in the batch are much more
     * likely to succeed.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ErrorHandling.html#BatchOperations">Batch
     * Operations and Error Handling</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * By default, <code>BatchGetItem</code> performs eventually consistent reads on every table in the request. If you
     * want strongly consistent reads instead, you can set <code>ConsistentRead</code> to <code>true</code> for any or
     * all tables.
     * </p>
     * <p>
     * In order to minimize response latency, <code>BatchGetItem</code> may retrieve items in parallel.
     * </p>
     * <p>
     * When designing your application, keep in mind that DynamoDB does not return items in any particular order. To
     * help parse the response by item, include the primary key values for the items in your request in the
     * <code>ProjectionExpression</code> parameter.
     * </p>
     * <p>
     * If a requested item does not exist, it is not returned in the result. Requests for nonexistent items consume the
     * minimum read capacity units according to the type of read. For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#CapacityUnitCalculations"
     * >Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * <code>BatchGetItem</code> will result in a <code>ValidationException</code> if the same key is specified multiple
     * times.
     * </p>
     * </note>
     *
     * @param batchGetItemRequest
     *        Represents the input of a <code>BatchGetItem</code> operation.
     * @return A Java Future containing the result of the BatchGetItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.BatchGetItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchGetItem" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_BatchGetItem_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<BatchGetItemResponse> batchGetItem(BatchGetItemRequest batchGetItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>BatchGetItem</code> operation returns the attributes of one or more items from one or more tables. You
     * identify requested items by primary key.
     * </p>
     * <p>
     * A single operation can retrieve up to 16 MB of data, which can contain as many as 100 items.
     * <code>BatchGetItem</code> returns a partial result if the response size limit is exceeded, the table's
     * provisioned throughput is exceeded, more than 1MB per partition is requested, or an internal processing failure
     * occurs. If a partial result is returned, the operation returns a value for <code>UnprocessedKeys</code>. You can
     * use this value to retry the operation starting with the next item to get.
     * </p>
     * <important>
     * <p>
     * If you request more than 100 items, <code>BatchGetItem</code> returns a <code>ValidationException</code> with the
     * message "Too many items requested for the BatchGetItem call."
     * </p>
     * </important>
     * <p>
     * For example, if you ask to retrieve 100 items, but each individual item is 300 KB in size, the system returns 52
     * items (so as not to exceed the 16 MB limit). It also returns an appropriate <code>UnprocessedKeys</code> value so
     * you can get the next page of results. If desired, your application can include its own logic to assemble the
     * pages of results into one dataset.
     * </p>
     * <p>
     * If <i>none</i> of the items can be processed due to insufficient provisioned throughput on all of the tables in
     * the request, then <code>BatchGetItem</code> returns a <code>ProvisionedThroughputExceededException</code>. If
     * <i>at least one</i> of the items is successfully processed, then <code>BatchGetItem</code> completes
     * successfully, while returning the keys of the unread items in <code>UnprocessedKeys</code>.
     * </p>
     * <important>
     * <p>
     * If DynamoDB returns any unprocessed items, you should retry the batch operation on those items. However, <i>we
     * strongly recommend that you use an exponential backoff algorithm</i>. If you retry the batch operation
     * immediately, the underlying read or write requests can still fail due to throttling on the individual tables. If
     * you delay the batch operation using exponential backoff, the individual requests in the batch are much more
     * likely to succeed.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ErrorHandling.html#BatchOperations">Batch
     * Operations and Error Handling</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * By default, <code>BatchGetItem</code> performs eventually consistent reads on every table in the request. If you
     * want strongly consistent reads instead, you can set <code>ConsistentRead</code> to <code>true</code> for any or
     * all tables.
     * </p>
     * <p>
     * In order to minimize response latency, <code>BatchGetItem</code> may retrieve items in parallel.
     * </p>
     * <p>
     * When designing your application, keep in mind that DynamoDB does not return items in any particular order. To
     * help parse the response by item, include the primary key values for the items in your request in the
     * <code>ProjectionExpression</code> parameter.
     * </p>
     * <p>
     * If a requested item does not exist, it is not returned in the result. Requests for nonexistent items consume the
     * minimum read capacity units according to the type of read. For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#CapacityUnitCalculations"
     * >Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * <code>BatchGetItem</code> will result in a <code>ValidationException</code> if the same key is specified multiple
     * times.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetItemRequest.Builder} avoiding the need to
     * create one manually via {@link BatchGetItemRequest#builder()}
     * </p>
     *
     * @param batchGetItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest.Builder} to create a request.
     *        Represents the input of a <code>BatchGetItem</code> operation.
     * @return A Java Future containing the result of the BatchGetItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.BatchGetItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchGetItem" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_BatchGetItem_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<BatchGetItemResponse> batchGetItem(Consumer<BatchGetItemRequest.Builder> batchGetItemRequest) {
        return batchGetItem(BatchGetItemRequest.builder().applyMutation(batchGetItemRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #batchGetItem(software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.BatchGetItemPublisher publisher = client.batchGetItemPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.BatchGetItemPublisher publisher = client.batchGetItemPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #batchGetItem(software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest)} operation.</b>
     * </p>
     *
     * @param batchGetItemRequest
     *        Represents the input of a <code>BatchGetItem</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.BatchGetItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchGetItem" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_BatchGetItem_section.html"
     *      target="_top">Code Example</a>
     */
    default BatchGetItemPublisher batchGetItemPaginator(BatchGetItemRequest batchGetItemRequest) {
        return new BatchGetItemPublisher(this, batchGetItemRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #batchGetItem(software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.BatchGetItemPublisher publisher = client.batchGetItemPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.BatchGetItemPublisher publisher = client.batchGetItemPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #batchGetItem(software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetItemRequest.Builder} avoiding the need to
     * create one manually via {@link BatchGetItemRequest#builder()}
     * </p>
     *
     * @param batchGetItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest.Builder} to create a request.
     *        Represents the input of a <code>BatchGetItem</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.BatchGetItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchGetItem" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_BatchGetItem_section.html"
     *      target="_top">Code Example</a>
     */
    default BatchGetItemPublisher batchGetItemPaginator(Consumer<BatchGetItemRequest.Builder> batchGetItemRequest) {
        return batchGetItemPaginator(BatchGetItemRequest.builder().applyMutation(batchGetItemRequest).build());
    }

    /**
     * <p>
     * The <code>BatchWriteItem</code> operation puts or deletes multiple items in one or more tables. A single call to
     * <code>BatchWriteItem</code> can transmit up to 16MB of data over the network, consisting of up to 25 item put or
     * delete operations. While individual items can be up to 400 KB once stored, it's important to note that an item's
     * representation might be greater than 400KB while being sent in DynamoDB's JSON format for the API call. For more
     * details on this distinction, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html"
     * >Naming Rules and Data Types</a>.
     * </p>
     * <note>
     * <p>
     * <code>BatchWriteItem</code> cannot update items. If you perform a <code>BatchWriteItem</code> operation on an
     * existing item, that item's values will be overwritten by the operation and it will appear like it was updated. To
     * update items, we recommend you use the <code>UpdateItem</code> action.
     * </p>
     * </note>
     * <p>
     * The individual <code>PutItem</code> and <code>DeleteItem</code> operations specified in
     * <code>BatchWriteItem</code> are atomic; however <code>BatchWriteItem</code> as a whole is not. If any requested
     * operations fail because the table's provisioned throughput is exceeded or an internal processing failure occurs,
     * the failed operations are returned in the <code>UnprocessedItems</code> response parameter. You can investigate
     * and optionally resend the requests. Typically, you would call <code>BatchWriteItem</code> in a loop. Each
     * iteration would check for unprocessed items and submit a new <code>BatchWriteItem</code> request with those
     * unprocessed items until all items have been processed.
     * </p>
     * <p>
     * For tables and indexes with provisioned capacity, if none of the items can be processed due to insufficient
     * provisioned throughput on all of the tables in the request, then <code>BatchWriteItem</code> returns a
     * <code>ProvisionedThroughputExceededException</code>. For all tables and indexes, if none of the items can be
     * processed due to other throttling scenarios (such as exceeding partition level limits), then
     * <code>BatchWriteItem</code> returns a <code>ThrottlingException</code>.
     * </p>
     * <important>
     * <p>
     * If DynamoDB returns any unprocessed items, you should retry the batch operation on those items. However, <i>we
     * strongly recommend that you use an exponential backoff algorithm</i>. If you retry the batch operation
     * immediately, the underlying read or write requests can still fail due to throttling on the individual tables. If
     * you delay the batch operation using exponential backoff, the individual requests in the batch are much more
     * likely to succeed.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ErrorHandling.html#Programming.Errors.BatchOperations"
     * >Batch Operations and Error Handling</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * With <code>BatchWriteItem</code>, you can efficiently write or delete large amounts of data, such as from Amazon
     * EMR, or copy data from another database into DynamoDB. In order to improve performance with these large-scale
     * operations, <code>BatchWriteItem</code> does not behave in the same way as individual <code>PutItem</code> and
     * <code>DeleteItem</code> calls would. For example, you cannot specify conditions on individual put and delete
     * requests, and <code>BatchWriteItem</code> does not return deleted items in the response.
     * </p>
     * <p>
     * If you use a programming language that supports concurrency, you can use threads to write items in parallel. Your
     * application must include the necessary logic to manage the threads. With languages that don't support threading,
     * you must update or delete the specified items one at a time. In both situations, <code>BatchWriteItem</code>
     * performs the specified put and delete operations in parallel, giving you the power of the thread pool approach
     * without having to introduce complexity into your application.
     * </p>
     * <p>
     * Parallel processing reduces latency, but each specified put and delete request consumes the same number of write
     * capacity units whether it is processed in parallel or not. Delete operations on nonexistent items consume one
     * write capacity unit.
     * </p>
     * <p>
     * If one or more of the following is true, DynamoDB rejects the entire batch write operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * One or more tables specified in the <code>BatchWriteItem</code> request does not exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * Primary key attributes specified on an item in the request do not match those in the corresponding table's
     * primary key schema.
     * </p>
     * </li>
     * <li>
     * <p>
     * You try to perform multiple operations on the same item in the same <code>BatchWriteItem</code> request. For
     * example, you cannot put and delete the same item in the same <code>BatchWriteItem</code> request.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your request contains at least two items with identical hash and range keys (which essentially is two put
     * operations).
     * </p>
     * </li>
     * <li>
     * <p>
     * There are more than 25 requests in the batch.
     * </p>
     * </li>
     * <li>
     * <p>
     * Any individual item in a batch exceeds 400 KB.
     * </p>
     * </li>
     * <li>
     * <p>
     * The total request size exceeds 16 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * Any individual items with keys exceeding the key length limits. For a partition key, the limit is 2048 bytes and
     * for a sort key, the limit is 1024 bytes.
     * </p>
     * </li>
     * </ul>
     *
     * @param batchWriteItemRequest
     *        Represents the input of a <code>BatchWriteItem</code> operation.
     * @return A Java Future containing the result of the BatchWriteItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>ItemCollectionSizeLimitExceededException An item collection is too large. This exception is only
     *         returned for tables that have one or more local secondary indexes.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ReplicatedWriteConflictException The request was rejected because one or more items in the request
     *         are being modified by a request in another Region.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.BatchWriteItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchWriteItem" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_BatchWriteItem_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<BatchWriteItemResponse> batchWriteItem(BatchWriteItemRequest batchWriteItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>BatchWriteItem</code> operation puts or deletes multiple items in one or more tables. A single call to
     * <code>BatchWriteItem</code> can transmit up to 16MB of data over the network, consisting of up to 25 item put or
     * delete operations. While individual items can be up to 400 KB once stored, it's important to note that an item's
     * representation might be greater than 400KB while being sent in DynamoDB's JSON format for the API call. For more
     * details on this distinction, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html"
     * >Naming Rules and Data Types</a>.
     * </p>
     * <note>
     * <p>
     * <code>BatchWriteItem</code> cannot update items. If you perform a <code>BatchWriteItem</code> operation on an
     * existing item, that item's values will be overwritten by the operation and it will appear like it was updated. To
     * update items, we recommend you use the <code>UpdateItem</code> action.
     * </p>
     * </note>
     * <p>
     * The individual <code>PutItem</code> and <code>DeleteItem</code> operations specified in
     * <code>BatchWriteItem</code> are atomic; however <code>BatchWriteItem</code> as a whole is not. If any requested
     * operations fail because the table's provisioned throughput is exceeded or an internal processing failure occurs,
     * the failed operations are returned in the <code>UnprocessedItems</code> response parameter. You can investigate
     * and optionally resend the requests. Typically, you would call <code>BatchWriteItem</code> in a loop. Each
     * iteration would check for unprocessed items and submit a new <code>BatchWriteItem</code> request with those
     * unprocessed items until all items have been processed.
     * </p>
     * <p>
     * For tables and indexes with provisioned capacity, if none of the items can be processed due to insufficient
     * provisioned throughput on all of the tables in the request, then <code>BatchWriteItem</code> returns a
     * <code>ProvisionedThroughputExceededException</code>. For all tables and indexes, if none of the items can be
     * processed due to other throttling scenarios (such as exceeding partition level limits), then
     * <code>BatchWriteItem</code> returns a <code>ThrottlingException</code>.
     * </p>
     * <important>
     * <p>
     * If DynamoDB returns any unprocessed items, you should retry the batch operation on those items. However, <i>we
     * strongly recommend that you use an exponential backoff algorithm</i>. If you retry the batch operation
     * immediately, the underlying read or write requests can still fail due to throttling on the individual tables. If
     * you delay the batch operation using exponential backoff, the individual requests in the batch are much more
     * likely to succeed.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ErrorHandling.html#Programming.Errors.BatchOperations"
     * >Batch Operations and Error Handling</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * With <code>BatchWriteItem</code>, you can efficiently write or delete large amounts of data, such as from Amazon
     * EMR, or copy data from another database into DynamoDB. In order to improve performance with these large-scale
     * operations, <code>BatchWriteItem</code> does not behave in the same way as individual <code>PutItem</code> and
     * <code>DeleteItem</code> calls would. For example, you cannot specify conditions on individual put and delete
     * requests, and <code>BatchWriteItem</code> does not return deleted items in the response.
     * </p>
     * <p>
     * If you use a programming language that supports concurrency, you can use threads to write items in parallel. Your
     * application must include the necessary logic to manage the threads. With languages that don't support threading,
     * you must update or delete the specified items one at a time. In both situations, <code>BatchWriteItem</code>
     * performs the specified put and delete operations in parallel, giving you the power of the thread pool approach
     * without having to introduce complexity into your application.
     * </p>
     * <p>
     * Parallel processing reduces latency, but each specified put and delete request consumes the same number of write
     * capacity units whether it is processed in parallel or not. Delete operations on nonexistent items consume one
     * write capacity unit.
     * </p>
     * <p>
     * If one or more of the following is true, DynamoDB rejects the entire batch write operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * One or more tables specified in the <code>BatchWriteItem</code> request does not exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * Primary key attributes specified on an item in the request do not match those in the corresponding table's
     * primary key schema.
     * </p>
     * </li>
     * <li>
     * <p>
     * You try to perform multiple operations on the same item in the same <code>BatchWriteItem</code> request. For
     * example, you cannot put and delete the same item in the same <code>BatchWriteItem</code> request.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your request contains at least two items with identical hash and range keys (which essentially is two put
     * operations).
     * </p>
     * </li>
     * <li>
     * <p>
     * There are more than 25 requests in the batch.
     * </p>
     * </li>
     * <li>
     * <p>
     * Any individual item in a batch exceeds 400 KB.
     * </p>
     * </li>
     * <li>
     * <p>
     * The total request size exceeds 16 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * Any individual items with keys exceeding the key length limits. For a partition key, the limit is 2048 bytes and
     * for a sort key, the limit is 1024 bytes.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchWriteItemRequest.Builder} avoiding the need to
     * create one manually via {@link BatchWriteItemRequest#builder()}
     * </p>
     *
     * @param batchWriteItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest.Builder} to create a request.
     *        Represents the input of a <code>BatchWriteItem</code> operation.
     * @return A Java Future containing the result of the BatchWriteItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>ItemCollectionSizeLimitExceededException An item collection is too large. This exception is only
     *         returned for tables that have one or more local secondary indexes.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ReplicatedWriteConflictException The request was rejected because one or more items in the request
     *         are being modified by a request in another Region.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.BatchWriteItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchWriteItem" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_BatchWriteItem_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<BatchWriteItemResponse> batchWriteItem(Consumer<BatchWriteItemRequest.Builder> batchWriteItemRequest) {
        return batchWriteItem(BatchWriteItemRequest.builder().applyMutation(batchWriteItemRequest).build());
    }

    /**
     * <p>
     * Creates a backup for an existing table.
     * </p>
     * <p>
     * Each time you create an on-demand backup, the entire table data is backed up. There is no limit to the number of
     * on-demand backups that can be taken.
     * </p>
     * <p>
     * When you create an on-demand backup, a time marker of the request is cataloged, and the backup is created
     * asynchronously, by applying all changes until the time of the request to the last full table snapshot. Backup
     * requests are processed instantaneously and become available for restore within minutes.
     * </p>
     * <p>
     * You can call <code>CreateBackup</code> at a maximum rate of 50 times per second.
     * </p>
     * <p>
     * All backups in DynamoDB work without consuming any provisioned throughput on the table.
     * </p>
     * <p>
     * If you submit a backup request on 2018-12-14 at 14:25:00, the backup is guaranteed to contain all data committed
     * to the table up to 14:24:00, and data committed after 14:26:00 will not be. The backup might contain data
     * modifications made between 14:24:00 and 14:26:00. On-demand backup does not support causal consistency.
     * </p>
     * <p>
     * Along with data, the following are also included on the backups:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Global secondary indexes (GSIs)
     * </p>
     * </li>
     * <li>
     * <p>
     * Local secondary indexes (LSIs)
     * </p>
     * </li>
     * <li>
     * <p>
     * Streams
     * </p>
     * </li>
     * <li>
     * <p>
     * Provisioned read and write capacity
     * </p>
     * </li>
     * </ul>
     *
     * @param createBackupRequest
     * @return A Java Future containing the result of the CreateBackup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TableNotFoundException A source table with the name <code>TableName</code> does not currently exist
     *         within the subscriber's account or the subscriber is operating in the wrong Amazon Web Services Region.</li>
     *         <li>TableInUseException A target table with the specified name is either being created or deleted.</li>
     *         <li>ContinuousBackupsUnavailableException Backups have not yet been enabled for this table.</li>
     *         <li>BackupInUseException There is another ongoing conflicting backup control plane operation on the
     *         table. The backup is either being created, deleted or restored to a table.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.CreateBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateBackup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBackupResponse> createBackup(CreateBackupRequest createBackupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a backup for an existing table.
     * </p>
     * <p>
     * Each time you create an on-demand backup, the entire table data is backed up. There is no limit to the number of
     * on-demand backups that can be taken.
     * </p>
     * <p>
     * When you create an on-demand backup, a time marker of the request is cataloged, and the backup is created
     * asynchronously, by applying all changes until the time of the request to the last full table snapshot. Backup
     * requests are processed instantaneously and become available for restore within minutes.
     * </p>
     * <p>
     * You can call <code>CreateBackup</code> at a maximum rate of 50 times per second.
     * </p>
     * <p>
     * All backups in DynamoDB work without consuming any provisioned throughput on the table.
     * </p>
     * <p>
     * If you submit a backup request on 2018-12-14 at 14:25:00, the backup is guaranteed to contain all data committed
     * to the table up to 14:24:00, and data committed after 14:26:00 will not be. The backup might contain data
     * modifications made between 14:24:00 and 14:26:00. On-demand backup does not support causal consistency.
     * </p>
     * <p>
     * Along with data, the following are also included on the backups:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Global secondary indexes (GSIs)
     * </p>
     * </li>
     * <li>
     * <p>
     * Local secondary indexes (LSIs)
     * </p>
     * </li>
     * <li>
     * <p>
     * Streams
     * </p>
     * </li>
     * <li>
     * <p>
     * Provisioned read and write capacity
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBackupRequest#builder()}
     * </p>
     *
     * @param createBackupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.CreateBackupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateBackup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TableNotFoundException A source table with the name <code>TableName</code> does not currently exist
     *         within the subscriber's account or the subscriber is operating in the wrong Amazon Web Services Region.</li>
     *         <li>TableInUseException A target table with the specified name is either being created or deleted.</li>
     *         <li>ContinuousBackupsUnavailableException Backups have not yet been enabled for this table.</li>
     *         <li>BackupInUseException There is another ongoing conflicting backup control plane operation on the
     *         table. The backup is either being created, deleted or restored to a table.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.CreateBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateBackup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBackupResponse> createBackup(Consumer<CreateBackupRequest.Builder> createBackupRequest) {
        return createBackup(CreateBackupRequest.builder().applyMutation(createBackupRequest).build());
    }

    /**
     * <p>
     * Creates a global table from an existing table. A global table creates a replication relationship between two or
     * more DynamoDB tables with the same table name in the provided Regions.
     * </p>
     * <important>
     * <p>
     * This documentation is for version 2017.11.29 (Legacy) of global tables, which should be avoided for new global
     * tables. Customers should use <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">Global Tables version
     * 2019.11.21 (Current)</a> when possible, because it provides greater flexibility, higher efficiency, and consumes
     * less write capacity than 2017.11.29 (Legacy).
     * </p>
     * <p>
     * To determine which version you're using, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.DetermineVersion.html"
     * >Determining the global table version you are using</a>. To update existing global tables from version 2017.11.29
     * (Legacy) to version 2019.11.21 (Current), see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/V2globaltables_upgrade.html">Upgrading
     * global tables</a>.
     * </p>
     * </important>
     * <p>
     * If you want to add a new replica table to a global table, each of the following conditions must be true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The table must have the same primary key as all of the other replicas.
     * </p>
     * </li>
     * <li>
     * <p>
     * The table must have the same name as all of the other replicas.
     * </p>
     * </li>
     * <li>
     * <p>
     * The table must have DynamoDB Streams enabled, with the stream containing both the new and the old images of the
     * item.
     * </p>
     * </li>
     * <li>
     * <p>
     * None of the replica tables in the global table can contain any data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If global secondary indexes are specified, then the following conditions must also be met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The global secondary indexes must have the same name.
     * </p>
     * </li>
     * <li>
     * <p>
     * The global secondary indexes must have the same hash key and sort key (if present).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If local secondary indexes are specified, then the following conditions must also be met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The local secondary indexes must have the same name.
     * </p>
     * </li>
     * <li>
     * <p>
     * The local secondary indexes must have the same hash key and sort key (if present).
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * Write capacity settings should be set consistently across your replica tables and secondary indexes. DynamoDB
     * strongly recommends enabling auto scaling to manage the write capacity settings for all of your global tables
     * replicas and indexes.
     * </p>
     * <p>
     * If you prefer to manage write capacity settings manually, you should provision equal replicated write capacity
     * units to your replica tables. You should also provision equal replicated write capacity units to matching
     * secondary indexes across your global table.
     * </p>
     * </important>
     *
     * @param createGlobalTableRequest
     * @return A Java Future containing the result of the CreateGlobalTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>GlobalTableAlreadyExistsException The specified global table already exists.</li>
     *         <li>TableNotFoundException A source table with the name <code>TableName</code> does not currently exist
     *         within the subscriber's account or the subscriber is operating in the wrong Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.CreateGlobalTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateGlobalTable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGlobalTableResponse> createGlobalTable(CreateGlobalTableRequest createGlobalTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a global table from an existing table. A global table creates a replication relationship between two or
     * more DynamoDB tables with the same table name in the provided Regions.
     * </p>
     * <important>
     * <p>
     * This documentation is for version 2017.11.29 (Legacy) of global tables, which should be avoided for new global
     * tables. Customers should use <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">Global Tables version
     * 2019.11.21 (Current)</a> when possible, because it provides greater flexibility, higher efficiency, and consumes
     * less write capacity than 2017.11.29 (Legacy).
     * </p>
     * <p>
     * To determine which version you're using, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.DetermineVersion.html"
     * >Determining the global table version you are using</a>. To update existing global tables from version 2017.11.29
     * (Legacy) to version 2019.11.21 (Current), see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/V2globaltables_upgrade.html">Upgrading
     * global tables</a>.
     * </p>
     * </important>
     * <p>
     * If you want to add a new replica table to a global table, each of the following conditions must be true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The table must have the same primary key as all of the other replicas.
     * </p>
     * </li>
     * <li>
     * <p>
     * The table must have the same name as all of the other replicas.
     * </p>
     * </li>
     * <li>
     * <p>
     * The table must have DynamoDB Streams enabled, with the stream containing both the new and the old images of the
     * item.
     * </p>
     * </li>
     * <li>
     * <p>
     * None of the replica tables in the global table can contain any data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If global secondary indexes are specified, then the following conditions must also be met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The global secondary indexes must have the same name.
     * </p>
     * </li>
     * <li>
     * <p>
     * The global secondary indexes must have the same hash key and sort key (if present).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If local secondary indexes are specified, then the following conditions must also be met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The local secondary indexes must have the same name.
     * </p>
     * </li>
     * <li>
     * <p>
     * The local secondary indexes must have the same hash key and sort key (if present).
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * Write capacity settings should be set consistently across your replica tables and secondary indexes. DynamoDB
     * strongly recommends enabling auto scaling to manage the write capacity settings for all of your global tables
     * replicas and indexes.
     * </p>
     * <p>
     * If you prefer to manage write capacity settings manually, you should provision equal replicated write capacity
     * units to your replica tables. You should also provision equal replicated write capacity units to matching
     * secondary indexes across your global table.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGlobalTableRequest.Builder} avoiding the need
     * to create one manually via {@link CreateGlobalTableRequest#builder()}
     * </p>
     *
     * @param createGlobalTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGlobalTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>GlobalTableAlreadyExistsException The specified global table already exists.</li>
     *         <li>TableNotFoundException A source table with the name <code>TableName</code> does not currently exist
     *         within the subscriber's account or the subscriber is operating in the wrong Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.CreateGlobalTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateGlobalTable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGlobalTableResponse> createGlobalTable(
            Consumer<CreateGlobalTableRequest.Builder> createGlobalTableRequest) {
        return createGlobalTable(CreateGlobalTableRequest.builder().applyMutation(createGlobalTableRequest).build());
    }

    /**
     * <p>
     * The <code>CreateTable</code> operation adds a new table to your account. In an Amazon Web Services account, table
     * names must be unique within each Region. That is, you can have two tables with same name if you create the tables
     * in different Regions.
     * </p>
     * <p>
     * <code>CreateTable</code> is an asynchronous operation. Upon receiving a <code>CreateTable</code> request,
     * DynamoDB immediately returns a response with a <code>TableStatus</code> of <code>CREATING</code>. After the table
     * is created, DynamoDB sets the <code>TableStatus</code> to <code>ACTIVE</code>. You can perform read and write
     * operations only on an <code>ACTIVE</code> table.
     * </p>
     * <p>
     * You can optionally define secondary indexes on the new table, as part of the <code>CreateTable</code> operation.
     * If you want to create multiple tables with secondary indexes on them, you must create the tables sequentially.
     * Only one table with secondary indexes can be in the <code>CREATING</code> state at any given time.
     * </p>
     * <p>
     * You can use the <code>DescribeTable</code> action to check the table status.
     * </p>
     *
     * @param createTableRequest
     *        Represents the input of a <code>CreateTable</code> operation.
     * @return A Java Future containing the result of the CreateTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.CreateTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateTable" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_CreateTable_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<CreateTableResponse> createTable(CreateTableRequest createTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>CreateTable</code> operation adds a new table to your account. In an Amazon Web Services account, table
     * names must be unique within each Region. That is, you can have two tables with same name if you create the tables
     * in different Regions.
     * </p>
     * <p>
     * <code>CreateTable</code> is an asynchronous operation. Upon receiving a <code>CreateTable</code> request,
     * DynamoDB immediately returns a response with a <code>TableStatus</code> of <code>CREATING</code>. After the table
     * is created, DynamoDB sets the <code>TableStatus</code> to <code>ACTIVE</code>. You can perform read and write
     * operations only on an <code>ACTIVE</code> table.
     * </p>
     * <p>
     * You can optionally define secondary indexes on the new table, as part of the <code>CreateTable</code> operation.
     * If you want to create multiple tables with secondary indexes on them, you must create the tables sequentially.
     * Only one table with secondary indexes can be in the <code>CREATING</code> state at any given time.
     * </p>
     * <p>
     * You can use the <code>DescribeTable</code> action to check the table status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTableRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTableRequest#builder()}
     * </p>
     *
     * @param createTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.CreateTableRequest.Builder} to create a request.
     *        Represents the input of a <code>CreateTable</code> operation.
     * @return A Java Future containing the result of the CreateTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.CreateTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateTable" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_CreateTable_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<CreateTableResponse> createTable(Consumer<CreateTableRequest.Builder> createTableRequest) {
        return createTable(CreateTableRequest.builder().applyMutation(createTableRequest).build());
    }

    /**
     * <p>
     * Deletes an existing backup of a table.
     * </p>
     * <p>
     * You can call <code>DeleteBackup</code> at a maximum rate of 10 times per second.
     * </p>
     *
     * @param deleteBackupRequest
     * @return A Java Future containing the result of the DeleteBackup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BackupNotFoundException Backup not found for the given BackupARN.</li>
     *         <li>BackupInUseException There is another ongoing conflicting backup control plane operation on the
     *         table. The backup is either being created, deleted or restored to a table.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DeleteBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteBackup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBackupResponse> deleteBackup(DeleteBackupRequest deleteBackupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing backup of a table.
     * </p>
     * <p>
     * You can call <code>DeleteBackup</code> at a maximum rate of 10 times per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBackupRequest#builder()}
     * </p>
     *
     * @param deleteBackupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.DeleteBackupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteBackup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BackupNotFoundException Backup not found for the given BackupARN.</li>
     *         <li>BackupInUseException There is another ongoing conflicting backup control plane operation on the
     *         table. The backup is either being created, deleted or restored to a table.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DeleteBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteBackup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBackupResponse> deleteBackup(Consumer<DeleteBackupRequest.Builder> deleteBackupRequest) {
        return deleteBackup(DeleteBackupRequest.builder().applyMutation(deleteBackupRequest).build());
    }

    /**
     * <p>
     * Deletes a single item in a table by primary key. You can perform a conditional delete operation that deletes the
     * item if it exists, or if it has an expected attribute value.
     * </p>
     * <p>
     * In addition to deleting an item, you can also return the item's attribute values in the same operation, using the
     * <code>ReturnValues</code> parameter.
     * </p>
     * <p>
     * Unless you specify conditions, the <code>DeleteItem</code> is an idempotent operation; running it multiple times
     * on the same item or attribute does <i>not</i> result in an error response.
     * </p>
     * <p>
     * Conditional deletes are useful for deleting items only if specific conditions are met. If those conditions are
     * met, DynamoDB performs the delete. Otherwise, the item is not deleted.
     * </p>
     *
     * @param deleteItemRequest
     *        Represents the input of a <code>DeleteItem</code> operation.
     * @return A Java Future containing the result of the DeleteItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConditionalCheckFailedException A condition specified in the operation failed to be evaluated.</li>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>ItemCollectionSizeLimitExceededException An item collection is too large. This exception is only
     *         returned for tables that have one or more local secondary indexes.</li>
     *         <li>TransactionConflictException Operation was rejected because there is an ongoing transaction for the
     *         item.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ReplicatedWriteConflictException The request was rejected because one or more items in the request
     *         are being modified by a request in another Region.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DeleteItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteItem" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_DeleteItem_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<DeleteItemResponse> deleteItem(DeleteItemRequest deleteItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a single item in a table by primary key. You can perform a conditional delete operation that deletes the
     * item if it exists, or if it has an expected attribute value.
     * </p>
     * <p>
     * In addition to deleting an item, you can also return the item's attribute values in the same operation, using the
     * <code>ReturnValues</code> parameter.
     * </p>
     * <p>
     * Unless you specify conditions, the <code>DeleteItem</code> is an idempotent operation; running it multiple times
     * on the same item or attribute does <i>not</i> result in an error response.
     * </p>
     * <p>
     * Conditional deletes are useful for deleting items only if specific conditions are met. If those conditions are
     * met, DynamoDB performs the delete. Otherwise, the item is not deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteItemRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteItemRequest#builder()}
     * </p>
     *
     * @param deleteItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest.Builder} to create a request.
     *        Represents the input of a <code>DeleteItem</code> operation.
     * @return A Java Future containing the result of the DeleteItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConditionalCheckFailedException A condition specified in the operation failed to be evaluated.</li>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>ItemCollectionSizeLimitExceededException An item collection is too large. This exception is only
     *         returned for tables that have one or more local secondary indexes.</li>
     *         <li>TransactionConflictException Operation was rejected because there is an ongoing transaction for the
     *         item.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ReplicatedWriteConflictException The request was rejected because one or more items in the request
     *         are being modified by a request in another Region.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DeleteItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteItem" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_DeleteItem_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<DeleteItemResponse> deleteItem(Consumer<DeleteItemRequest.Builder> deleteItemRequest) {
        return deleteItem(DeleteItemRequest.builder().applyMutation(deleteItemRequest).build());
    }

    /**
     * <p>
     * Deletes the resource-based policy attached to the resource, which can be a table or stream.
     * </p>
     * <p>
     * <code>DeleteResourcePolicy</code> is an idempotent operation; running it multiple times on the same resource
     * <i>doesn't</i> result in an error response, unless you specify an <code>ExpectedRevisionId</code>, which will
     * then return a <code>PolicyNotFoundException</code>.
     * </p>
     * <important>
     * <p>
     * To make sure that you don't inadvertently lock yourself out of your own resources, the root principal in your
     * Amazon Web Services account can perform <code>DeleteResourcePolicy</code> requests, even if your resource-based
     * policy explicitly denies the root principal's access.
     * </p>
     * </important> <note>
     * <p>
     * <code>DeleteResourcePolicy</code> is an asynchronous operation. If you issue a <code>GetResourcePolicy</code>
     * request immediately after running the <code>DeleteResourcePolicy</code> request, DynamoDB might still return the
     * deleted policy. This is because the policy for your resource might not have been deleted yet. Wait for a few
     * seconds, and then try the <code>GetResourcePolicy</code> request again.
     * </p>
     * </note>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>PolicyNotFoundException The operation tried to access a nonexistent resource-based policy.</p>
     *         <p>
     *         If you specified an <code>ExpectedRevisionId</code>, it's possible that a policy is present for the
     *         resource but its revision ID didn't match the expected value.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the resource-based policy attached to the resource, which can be a table or stream.
     * </p>
     * <p>
     * <code>DeleteResourcePolicy</code> is an idempotent operation; running it multiple times on the same resource
     * <i>doesn't</i> result in an error response, unless you specify an <code>ExpectedRevisionId</code>, which will
     * then return a <code>PolicyNotFoundException</code>.
     * </p>
     * <important>
     * <p>
     * To make sure that you don't inadvertently lock yourself out of your own resources, the root principal in your
     * Amazon Web Services account can perform <code>DeleteResourcePolicy</code> requests, even if your resource-based
     * policy explicitly denies the root principal's access.
     * </p>
     * </important> <note>
     * <p>
     * <code>DeleteResourcePolicy</code> is an asynchronous operation. If you issue a <code>GetResourcePolicy</code>
     * request immediately after running the <code>DeleteResourcePolicy</code> request, DynamoDB might still return the
     * deleted policy. This is because the policy for your resource might not have been deleted yet. Wait for a few
     * seconds, and then try the <code>GetResourcePolicy</code> request again.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.DeleteResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>PolicyNotFoundException The operation tried to access a nonexistent resource-based policy.</p>
     *         <p>
     *         If you specified an <code>ExpectedRevisionId</code>, it's possible that a policy is present for the
     *         resource but its revision ID didn't match the expected value.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * The <code>DeleteTable</code> operation deletes a table and all of its items. After a <code>DeleteTable</code>
     * request, the specified table is in the <code>DELETING</code> state until DynamoDB completes the deletion. If the
     * table is in the <code>ACTIVE</code> state, you can delete it. If a table is in <code>CREATING</code> or
     * <code>UPDATING</code> states, then DynamoDB returns a <code>ResourceInUseException</code>. If the specified table
     * does not exist, DynamoDB returns a <code>ResourceNotFoundException</code>. If table is already in the
     * <code>DELETING</code> state, no error is returned.
     * </p>
     * <note>
     * <p>
     * DynamoDB might continue to accept data read and write operations, such as <code>GetItem</code> and
     * <code>PutItem</code>, on a table in the <code>DELETING</code> state until the table deletion is complete. For the
     * full list of table states, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TableDescription.html#DDB-Type-TableDescription-TableStatus"
     * >TableStatus</a>.
     * </p>
     * </note>
     * <p>
     * When you delete a table, any indexes on that table are also deleted.
     * </p>
     * <p>
     * If you have DynamoDB Streams enabled on the table, then the corresponding stream on that table goes into the
     * <code>DISABLED</code> state, and the stream is automatically deleted after 24 hours.
     * </p>
     * <p>
     * Use the <code>DescribeTable</code> action to check the status of the table.
     * </p>
     *
     * @param deleteTableRequest
     *        Represents the input of a <code>DeleteTable</code> operation.
     * @return A Java Future containing the result of the DeleteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DeleteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteTable" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_DeleteTable_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<DeleteTableResponse> deleteTable(DeleteTableRequest deleteTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>DeleteTable</code> operation deletes a table and all of its items. After a <code>DeleteTable</code>
     * request, the specified table is in the <code>DELETING</code> state until DynamoDB completes the deletion. If the
     * table is in the <code>ACTIVE</code> state, you can delete it. If a table is in <code>CREATING</code> or
     * <code>UPDATING</code> states, then DynamoDB returns a <code>ResourceInUseException</code>. If the specified table
     * does not exist, DynamoDB returns a <code>ResourceNotFoundException</code>. If table is already in the
     * <code>DELETING</code> state, no error is returned.
     * </p>
     * <note>
     * <p>
     * DynamoDB might continue to accept data read and write operations, such as <code>GetItem</code> and
     * <code>PutItem</code>, on a table in the <code>DELETING</code> state until the table deletion is complete. For the
     * full list of table states, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TableDescription.html#DDB-Type-TableDescription-TableStatus"
     * >TableStatus</a>.
     * </p>
     * </note>
     * <p>
     * When you delete a table, any indexes on that table are also deleted.
     * </p>
     * <p>
     * If you have DynamoDB Streams enabled on the table, then the corresponding stream on that table goes into the
     * <code>DISABLED</code> state, and the stream is automatically deleted after 24 hours.
     * </p>
     * <p>
     * Use the <code>DescribeTable</code> action to check the status of the table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTableRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTableRequest#builder()}
     * </p>
     *
     * @param deleteTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest.Builder} to create a request.
     *        Represents the input of a <code>DeleteTable</code> operation.
     * @return A Java Future containing the result of the DeleteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DeleteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteTable" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_DeleteTable_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<DeleteTableResponse> deleteTable(Consumer<DeleteTableRequest.Builder> deleteTableRequest) {
        return deleteTable(DeleteTableRequest.builder().applyMutation(deleteTableRequest).build());
    }

    /**
     * <p>
     * Describes an existing backup of a table.
     * </p>
     * <p>
     * You can call <code>DescribeBackup</code> at a maximum rate of 10 times per second.
     * </p>
     *
     * @param describeBackupRequest
     * @return A Java Future containing the result of the DescribeBackup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BackupNotFoundException Backup not found for the given BackupARN.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeBackup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBackupResponse> describeBackup(DescribeBackupRequest describeBackupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing backup of a table.
     * </p>
     * <p>
     * You can call <code>DescribeBackup</code> at a maximum rate of 10 times per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBackupRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeBackupRequest#builder()}
     * </p>
     *
     * @param describeBackupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.DescribeBackupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeBackup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BackupNotFoundException Backup not found for the given BackupARN.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeBackup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBackupResponse> describeBackup(Consumer<DescribeBackupRequest.Builder> describeBackupRequest) {
        return describeBackup(DescribeBackupRequest.builder().applyMutation(describeBackupRequest).build());
    }

    /**
     * <p>
     * Checks the status of continuous backups and point in time recovery on the specified table. Continuous backups are
     * <code>ENABLED</code> on all tables at table creation. If point in time recovery is enabled,
     * <code>PointInTimeRecoveryStatus</code> will be set to ENABLED.
     * </p>
     * <p>
     * After continuous backups and point in time recovery are enabled, you can restore to any point in time within
     * <code>EarliestRestorableDateTime</code> and <code>LatestRestorableDateTime</code>.
     * </p>
     * <p>
     * <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. You can restore your table
     * to any point in time in the last 35 days. You can set the recovery period to any value between 1 and 35 days.
     * </p>
     * <p>
     * You can call <code>DescribeContinuousBackups</code> at a maximum rate of 10 times per second.
     * </p>
     *
     * @param describeContinuousBackupsRequest
     * @return A Java Future containing the result of the DescribeContinuousBackups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TableNotFoundException A source table with the name <code>TableName</code> does not currently exist
     *         within the subscriber's account or the subscriber is operating in the wrong Amazon Web Services Region.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeContinuousBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeContinuousBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeContinuousBackupsResponse> describeContinuousBackups(
            DescribeContinuousBackupsRequest describeContinuousBackupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks the status of continuous backups and point in time recovery on the specified table. Continuous backups are
     * <code>ENABLED</code> on all tables at table creation. If point in time recovery is enabled,
     * <code>PointInTimeRecoveryStatus</code> will be set to ENABLED.
     * </p>
     * <p>
     * After continuous backups and point in time recovery are enabled, you can restore to any point in time within
     * <code>EarliestRestorableDateTime</code> and <code>LatestRestorableDateTime</code>.
     * </p>
     * <p>
     * <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. You can restore your table
     * to any point in time in the last 35 days. You can set the recovery period to any value between 1 and 35 days.
     * </p>
     * <p>
     * You can call <code>DescribeContinuousBackups</code> at a maximum rate of 10 times per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContinuousBackupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeContinuousBackupsRequest#builder()}
     * </p>
     *
     * @param describeContinuousBackupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeContinuousBackups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TableNotFoundException A source table with the name <code>TableName</code> does not currently exist
     *         within the subscriber's account or the subscriber is operating in the wrong Amazon Web Services Region.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeContinuousBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeContinuousBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeContinuousBackupsResponse> describeContinuousBackups(
            Consumer<DescribeContinuousBackupsRequest.Builder> describeContinuousBackupsRequest) {
        return describeContinuousBackups(DescribeContinuousBackupsRequest.builder()
                .applyMutation(describeContinuousBackupsRequest).build());
    }

    /**
     * <p>
     * Returns information about contributor insights for a given table or global secondary index.
     * </p>
     *
     * @param describeContributorInsightsRequest
     * @return A Java Future containing the result of the DescribeContributorInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeContributorInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeContributorInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeContributorInsightsResponse> describeContributorInsights(
            DescribeContributorInsightsRequest describeContributorInsightsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about contributor insights for a given table or global secondary index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContributorInsightsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeContributorInsightsRequest#builder()}
     * </p>
     *
     * @param describeContributorInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeContributorInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeContributorInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeContributorInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeContributorInsightsResponse> describeContributorInsights(
            Consumer<DescribeContributorInsightsRequest.Builder> describeContributorInsightsRequest) {
        return describeContributorInsights(DescribeContributorInsightsRequest.builder()
                .applyMutation(describeContributorInsightsRequest).build());
    }

    /**
     * <p>
     * Returns the regional endpoint information. For more information on policy permissions, please see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/inter-network-traffic-privacy.html#inter-network-traffic-DescribeEndpoints"
     * >Internetwork traffic privacy</a>.
     * </p>
     *
     * @param describeEndpointsRequest
     * @return A Java Future containing the result of the DescribeEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointsResponse> describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the regional endpoint information. For more information on policy permissions, please see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/inter-network-traffic-privacy.html#inter-network-traffic-DescribeEndpoints"
     * >Internetwork traffic privacy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointsRequest#builder()}
     * </p>
     *
     * @param describeEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointsResponse> describeEndpoints(
            Consumer<DescribeEndpointsRequest.Builder> describeEndpointsRequest) {
        return describeEndpoints(DescribeEndpointsRequest.builder().applyMutation(describeEndpointsRequest).build());
    }

    /**
     * <p>
     * Returns the regional endpoint information. For more information on policy permissions, please see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/inter-network-traffic-privacy.html#inter-network-traffic-DescribeEndpoints"
     * >Internetwork traffic privacy</a>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointsResponse> describeEndpoints() {
        return describeEndpoints(DescribeEndpointsRequest.builder().build());
    }

    /**
     * <p>
     * Describes an existing table export.
     * </p>
     *
     * @param describeExportRequest
     * @return A Java Future containing the result of the DescribeExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ExportNotFoundException The specified export was not found.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeExport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeExportResponse> describeExport(DescribeExportRequest describeExportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing table export.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExportRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeExportRequest#builder()}
     * </p>
     *
     * @param describeExportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.DescribeExportRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ExportNotFoundException The specified export was not found.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeExport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeExportResponse> describeExport(Consumer<DescribeExportRequest.Builder> describeExportRequest) {
        return describeExport(DescribeExportRequest.builder().applyMutation(describeExportRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified global table.
     * </p>
     * <important>
     * <p>
     * This documentation is for version 2017.11.29 (Legacy) of global tables, which should be avoided for new global
     * tables. Customers should use <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">Global Tables version
     * 2019.11.21 (Current)</a> when possible, because it provides greater flexibility, higher efficiency, and consumes
     * less write capacity than 2017.11.29 (Legacy).
     * </p>
     * <p>
     * To determine which version you're using, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.DetermineVersion.html"
     * >Determining the global table version you are using</a>. To update existing global tables from version 2017.11.29
     * (Legacy) to version 2019.11.21 (Current), see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/V2globaltables_upgrade.html">Upgrading
     * global tables</a>.
     * </p>
     * </important>
     *
     * @param describeGlobalTableRequest
     * @return A Java Future containing the result of the DescribeGlobalTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>GlobalTableNotFoundException The specified global table does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeGlobalTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeGlobalTable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeGlobalTableResponse> describeGlobalTable(
            DescribeGlobalTableRequest describeGlobalTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified global table.
     * </p>
     * <important>
     * <p>
     * This documentation is for version 2017.11.29 (Legacy) of global tables, which should be avoided for new global
     * tables. Customers should use <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">Global Tables version
     * 2019.11.21 (Current)</a> when possible, because it provides greater flexibility, higher efficiency, and consumes
     * less write capacity than 2017.11.29 (Legacy).
     * </p>
     * <p>
     * To determine which version you're using, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.DetermineVersion.html"
     * >Determining the global table version you are using</a>. To update existing global tables from version 2017.11.29
     * (Legacy) to version 2019.11.21 (Current), see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/V2globaltables_upgrade.html">Upgrading
     * global tables</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGlobalTableRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGlobalTableRequest#builder()}
     * </p>
     *
     * @param describeGlobalTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeGlobalTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>GlobalTableNotFoundException The specified global table does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeGlobalTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeGlobalTable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeGlobalTableResponse> describeGlobalTable(
            Consumer<DescribeGlobalTableRequest.Builder> describeGlobalTableRequest) {
        return describeGlobalTable(DescribeGlobalTableRequest.builder().applyMutation(describeGlobalTableRequest).build());
    }

    /**
     * <p>
     * Describes Region-specific settings for a global table.
     * </p>
     * <important>
     * <p>
     * This documentation is for version 2017.11.29 (Legacy) of global tables, which should be avoided for new global
     * tables. Customers should use <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">Global Tables version
     * 2019.11.21 (Current)</a> when possible, because it provides greater flexibility, higher efficiency, and consumes
     * less write capacity than 2017.11.29 (Legacy).
     * </p>
     * <p>
     * To determine which version you're using, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.DetermineVersion.html"
     * >Determining the global table version you are using</a>. To update existing global tables from version 2017.11.29
     * (Legacy) to version 2019.11.21 (Current), see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/V2globaltables_upgrade.html">Upgrading
     * global tables</a>.
     * </p>
     * </important>
     *
     * @param describeGlobalTableSettingsRequest
     * @return A Java Future containing the result of the DescribeGlobalTableSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GlobalTableNotFoundException The specified global table does not exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeGlobalTableSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeGlobalTableSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGlobalTableSettingsResponse> describeGlobalTableSettings(
            DescribeGlobalTableSettingsRequest describeGlobalTableSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes Region-specific settings for a global table.
     * </p>
     * <important>
     * <p>
     * This documentation is for version 2017.11.29 (Legacy) of global tables, which should be avoided for new global
     * tables. Customers should use <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">Global Tables version
     * 2019.11.21 (Current)</a> when possible, because it provides greater flexibility, higher efficiency, and consumes
     * less write capacity than 2017.11.29 (Legacy).
     * </p>
     * <p>
     * To determine which version you're using, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.DetermineVersion.html"
     * >Determining the global table version you are using</a>. To update existing global tables from version 2017.11.29
     * (Legacy) to version 2019.11.21 (Current), see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/V2globaltables_upgrade.html">Upgrading
     * global tables</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGlobalTableSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeGlobalTableSettingsRequest#builder()}
     * </p>
     *
     * @param describeGlobalTableSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeGlobalTableSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GlobalTableNotFoundException The specified global table does not exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeGlobalTableSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeGlobalTableSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGlobalTableSettingsResponse> describeGlobalTableSettings(
            Consumer<DescribeGlobalTableSettingsRequest.Builder> describeGlobalTableSettingsRequest) {
        return describeGlobalTableSettings(DescribeGlobalTableSettingsRequest.builder()
                .applyMutation(describeGlobalTableSettingsRequest).build());
    }

    /**
     * <p>
     * Represents the properties of the import.
     * </p>
     *
     * @param describeImportRequest
     * @return A Java Future containing the result of the DescribeImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ImportNotFoundException The specified import was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeImport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeImportResponse> describeImport(DescribeImportRequest describeImportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents the properties of the import.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImportRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeImportRequest#builder()}
     * </p>
     *
     * @param describeImportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.DescribeImportRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ImportNotFoundException The specified import was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeImport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeImportResponse> describeImport(Consumer<DescribeImportRequest.Builder> describeImportRequest) {
        return describeImport(DescribeImportRequest.builder().applyMutation(describeImportRequest).build());
    }

    /**
     * <p>
     * Returns information about the status of Kinesis streaming.
     * </p>
     *
     * @param describeKinesisStreamingDestinationRequest
     * @return A Java Future containing the result of the DescribeKinesisStreamingDestination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeKinesisStreamingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeKinesisStreamingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeKinesisStreamingDestinationResponse> describeKinesisStreamingDestination(
            DescribeKinesisStreamingDestinationRequest describeKinesisStreamingDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the status of Kinesis streaming.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeKinesisStreamingDestinationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeKinesisStreamingDestinationRequest#builder()}
     * </p>
     *
     * @param describeKinesisStreamingDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeKinesisStreamingDestination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeKinesisStreamingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeKinesisStreamingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeKinesisStreamingDestinationResponse> describeKinesisStreamingDestination(
            Consumer<DescribeKinesisStreamingDestinationRequest.Builder> describeKinesisStreamingDestinationRequest) {
        return describeKinesisStreamingDestination(DescribeKinesisStreamingDestinationRequest.builder()
                .applyMutation(describeKinesisStreamingDestinationRequest).build());
    }

    /**
     * <p>
     * Returns the current provisioned-capacity quotas for your Amazon Web Services account in a Region, both for the
     * Region as a whole and for any one DynamoDB table that you create there.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum read capacity
     * units and write capacity units that you can provision across all of your DynamoDB tables in a given Region. Also,
     * there are per-table quotas that apply when you create a table there. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table
     * Quotas</a> page in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Although you can increase these quotas by filing a case at <a
     * href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support Center</a>, obtaining the
     * increase is not instantaneous. The <code>DescribeLimits</code> action lets you write code to compare the capacity
     * you are currently using to those quotas imposed by your account so that you have enough time to apply for an
     * increase before you hit a quota.
     * </p>
     * <p>
     * For example, you could use one of the Amazon Web Services SDKs to do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Call <code>DescribeLimits</code> for a particular Region to obtain your current account quotas on provisioned
     * capacity there.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create a variable to hold the aggregate read capacity units provisioned for all your tables in that Region, and
     * one to hold the aggregate write capacity units. Zero them both.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>ListTables</code> to obtain a list of all your DynamoDB tables.
     * </p>
     * </li>
     * <li>
     * <p>
     * For each table name listed by <code>ListTables</code>, do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Call <code>DescribeTable</code> with the table name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the data returned by <code>DescribeTable</code> to add the read capacity units and write capacity units
     * provisioned for the table itself to your variables.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the table has one or more global secondary indexes (GSIs), loop over these GSIs and add their provisioned
     * capacity values to your variables as well.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Report the account quotas for that Region returned by <code>DescribeLimits</code>, along with the total current
     * provisioned capacity levels you have calculated.
     * </p>
     * </li>
     * </ol>
     * <p>
     * This will let you see whether you are getting close to your account-level quotas.
     * </p>
     * <p>
     * The per-table quotas apply only when you are creating a new table. They restrict the sum of the provisioned
     * capacity of the new table itself and all its global secondary indexes.
     * </p>
     * <p>
     * For existing tables and their GSIs, DynamoDB doesn't let you increase provisioned capacity extremely rapidly, but
     * the only quota that applies is that the aggregate provisioned capacity over all your tables and GSIs cannot
     * exceed either of the per-account quotas.
     * </p>
     * <note>
     * <p>
     * <code>DescribeLimits</code> should only be called periodically. You can expect throttling errors if you call it
     * more than once in a minute.
     * </p>
     * </note>
     * <p>
     * The <code>DescribeLimits</code> Request element has no content.
     * </p>
     *
     * @param describeLimitsRequest
     *        Represents the input of a <code>DescribeLimits</code> operation. Has no content.
     * @return A Java Future containing the result of the DescribeLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeLimits" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeLimitsResponse> describeLimits(DescribeLimitsRequest describeLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current provisioned-capacity quotas for your Amazon Web Services account in a Region, both for the
     * Region as a whole and for any one DynamoDB table that you create there.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum read capacity
     * units and write capacity units that you can provision across all of your DynamoDB tables in a given Region. Also,
     * there are per-table quotas that apply when you create a table there. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table
     * Quotas</a> page in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Although you can increase these quotas by filing a case at <a
     * href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support Center</a>, obtaining the
     * increase is not instantaneous. The <code>DescribeLimits</code> action lets you write code to compare the capacity
     * you are currently using to those quotas imposed by your account so that you have enough time to apply for an
     * increase before you hit a quota.
     * </p>
     * <p>
     * For example, you could use one of the Amazon Web Services SDKs to do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Call <code>DescribeLimits</code> for a particular Region to obtain your current account quotas on provisioned
     * capacity there.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create a variable to hold the aggregate read capacity units provisioned for all your tables in that Region, and
     * one to hold the aggregate write capacity units. Zero them both.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>ListTables</code> to obtain a list of all your DynamoDB tables.
     * </p>
     * </li>
     * <li>
     * <p>
     * For each table name listed by <code>ListTables</code>, do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Call <code>DescribeTable</code> with the table name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the data returned by <code>DescribeTable</code> to add the read capacity units and write capacity units
     * provisioned for the table itself to your variables.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the table has one or more global secondary indexes (GSIs), loop over these GSIs and add their provisioned
     * capacity values to your variables as well.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Report the account quotas for that Region returned by <code>DescribeLimits</code>, along with the total current
     * provisioned capacity levels you have calculated.
     * </p>
     * </li>
     * </ol>
     * <p>
     * This will let you see whether you are getting close to your account-level quotas.
     * </p>
     * <p>
     * The per-table quotas apply only when you are creating a new table. They restrict the sum of the provisioned
     * capacity of the new table itself and all its global secondary indexes.
     * </p>
     * <p>
     * For existing tables and their GSIs, DynamoDB doesn't let you increase provisioned capacity extremely rapidly, but
     * the only quota that applies is that the aggregate provisioned capacity over all your tables and GSIs cannot
     * exceed either of the per-account quotas.
     * </p>
     * <note>
     * <p>
     * <code>DescribeLimits</code> should only be called periodically. You can expect throttling errors if you call it
     * more than once in a minute.
     * </p>
     * </note>
     * <p>
     * The <code>DescribeLimits</code> Request element has no content.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLimitsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeLimitsRequest#builder()}
     * </p>
     *
     * @param describeLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.DescribeLimitsRequest.Builder} to create a request.
     *        Represents the input of a <code>DescribeLimits</code> operation. Has no content.
     * @return A Java Future containing the result of the DescribeLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeLimits" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeLimitsResponse> describeLimits(Consumer<DescribeLimitsRequest.Builder> describeLimitsRequest) {
        return describeLimits(DescribeLimitsRequest.builder().applyMutation(describeLimitsRequest).build());
    }

    /**
     * <p>
     * Returns the current provisioned-capacity quotas for your Amazon Web Services account in a Region, both for the
     * Region as a whole and for any one DynamoDB table that you create there.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum read capacity
     * units and write capacity units that you can provision across all of your DynamoDB tables in a given Region. Also,
     * there are per-table quotas that apply when you create a table there. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table
     * Quotas</a> page in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Although you can increase these quotas by filing a case at <a
     * href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support Center</a>, obtaining the
     * increase is not instantaneous. The <code>DescribeLimits</code> action lets you write code to compare the capacity
     * you are currently using to those quotas imposed by your account so that you have enough time to apply for an
     * increase before you hit a quota.
     * </p>
     * <p>
     * For example, you could use one of the Amazon Web Services SDKs to do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Call <code>DescribeLimits</code> for a particular Region to obtain your current account quotas on provisioned
     * capacity there.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create a variable to hold the aggregate read capacity units provisioned for all your tables in that Region, and
     * one to hold the aggregate write capacity units. Zero them both.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>ListTables</code> to obtain a list of all your DynamoDB tables.
     * </p>
     * </li>
     * <li>
     * <p>
     * For each table name listed by <code>ListTables</code>, do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Call <code>DescribeTable</code> with the table name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the data returned by <code>DescribeTable</code> to add the read capacity units and write capacity units
     * provisioned for the table itself to your variables.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the table has one or more global secondary indexes (GSIs), loop over these GSIs and add their provisioned
     * capacity values to your variables as well.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Report the account quotas for that Region returned by <code>DescribeLimits</code>, along with the total current
     * provisioned capacity levels you have calculated.
     * </p>
     * </li>
     * </ol>
     * <p>
     * This will let you see whether you are getting close to your account-level quotas.
     * </p>
     * <p>
     * The per-table quotas apply only when you are creating a new table. They restrict the sum of the provisioned
     * capacity of the new table itself and all its global secondary indexes.
     * </p>
     * <p>
     * For existing tables and their GSIs, DynamoDB doesn't let you increase provisioned capacity extremely rapidly, but
     * the only quota that applies is that the aggregate provisioned capacity over all your tables and GSIs cannot
     * exceed either of the per-account quotas.
     * </p>
     * <note>
     * <p>
     * <code>DescribeLimits</code> should only be called periodically. You can expect throttling errors if you call it
     * more than once in a minute.
     * </p>
     * </note>
     * <p>
     * The <code>DescribeLimits</code> Request element has no content.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeLimits" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeLimitsResponse> describeLimits() {
        return describeLimits(DescribeLimitsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the table, including the current status of the table, when it was created, the primary
     * key schema, and any indexes on the table.
     * </p>
     * <note>
     * <p>
     * If you issue a <code>DescribeTable</code> request immediately after a <code>CreateTable</code> request, DynamoDB
     * might return a <code>ResourceNotFoundException</code>. This is because <code>DescribeTable</code> uses an
     * eventually consistent query, and the metadata for your table might not be available at that moment. Wait for a
     * few seconds, and then try the <code>DescribeTable</code> request again.
     * </p>
     * </note>
     *
     * @param describeTableRequest
     *        Represents the input of a <code>DescribeTable</code> operation.
     * @return A Java Future containing the result of the DescribeTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTable" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_DescribeTable_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<DescribeTableResponse> describeTable(DescribeTableRequest describeTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the table, including the current status of the table, when it was created, the primary
     * key schema, and any indexes on the table.
     * </p>
     * <note>
     * <p>
     * If you issue a <code>DescribeTable</code> request immediately after a <code>CreateTable</code> request, DynamoDB
     * might return a <code>ResourceNotFoundException</code>. This is because <code>DescribeTable</code> uses an
     * eventually consistent query, and the metadata for your table might not be available at that moment. Wait for a
     * few seconds, and then try the <code>DescribeTable</code> request again.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTableRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTableRequest#builder()}
     * </p>
     *
     * @param describeTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest.Builder} to create a request.
     *        Represents the input of a <code>DescribeTable</code> operation.
     * @return A Java Future containing the result of the DescribeTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTable" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_DescribeTable_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<DescribeTableResponse> describeTable(Consumer<DescribeTableRequest.Builder> describeTableRequest) {
        return describeTable(DescribeTableRequest.builder().applyMutation(describeTableRequest).build());
    }

    /**
     * <p>
     * Describes auto scaling settings across replicas of the global table at once.
     * </p>
     *
     * @param describeTableReplicaAutoScalingRequest
     * @return A Java Future containing the result of the DescribeTableReplicaAutoScaling operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeTableReplicaAutoScaling
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTableReplicaAutoScaling"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTableReplicaAutoScalingResponse> describeTableReplicaAutoScaling(
            DescribeTableReplicaAutoScalingRequest describeTableReplicaAutoScalingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes auto scaling settings across replicas of the global table at once.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTableReplicaAutoScalingRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeTableReplicaAutoScalingRequest#builder()}
     * </p>
     *
     * @param describeTableReplicaAutoScalingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeTableReplicaAutoScaling operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeTableReplicaAutoScaling
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTableReplicaAutoScaling"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTableReplicaAutoScalingResponse> describeTableReplicaAutoScaling(
            Consumer<DescribeTableReplicaAutoScalingRequest.Builder> describeTableReplicaAutoScalingRequest) {
        return describeTableReplicaAutoScaling(DescribeTableReplicaAutoScalingRequest.builder()
                .applyMutation(describeTableReplicaAutoScalingRequest).build());
    }

    /**
     * <p>
     * Gives a description of the Time to Live (TTL) status on the specified table.
     * </p>
     *
     * @param describeTimeToLiveRequest
     * @return A Java Future containing the result of the DescribeTimeToLive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeTimeToLive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTimeToLive" target="_top">AWS
     *      API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_DescribeTimeToLive_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<DescribeTimeToLiveResponse> describeTimeToLive(DescribeTimeToLiveRequest describeTimeToLiveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gives a description of the Time to Live (TTL) status on the specified table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTimeToLiveRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTimeToLiveRequest#builder()}
     * </p>
     *
     * @param describeTimeToLiveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeTimeToLive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DescribeTimeToLive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTimeToLive" target="_top">AWS
     *      API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_DescribeTimeToLive_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<DescribeTimeToLiveResponse> describeTimeToLive(
            Consumer<DescribeTimeToLiveRequest.Builder> describeTimeToLiveRequest) {
        return describeTimeToLive(DescribeTimeToLiveRequest.builder().applyMutation(describeTimeToLiveRequest).build());
    }

    /**
     * <p>
     * Stops replication from the DynamoDB table to the Kinesis data stream. This is done without deleting either of the
     * resources.
     * </p>
     *
     * @param disableKinesisStreamingDestinationRequest
     * @return A Java Future containing the result of the DisableKinesisStreamingDestination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DisableKinesisStreamingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DisableKinesisStreamingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableKinesisStreamingDestinationResponse> disableKinesisStreamingDestination(
            DisableKinesisStreamingDestinationRequest disableKinesisStreamingDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops replication from the DynamoDB table to the Kinesis data stream. This is done without deleting either of the
     * resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableKinesisStreamingDestinationRequest.Builder}
     * avoiding the need to create one manually via {@link DisableKinesisStreamingDestinationRequest#builder()}
     * </p>
     *
     * @param disableKinesisStreamingDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisableKinesisStreamingDestination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.DisableKinesisStreamingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DisableKinesisStreamingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableKinesisStreamingDestinationResponse> disableKinesisStreamingDestination(
            Consumer<DisableKinesisStreamingDestinationRequest.Builder> disableKinesisStreamingDestinationRequest) {
        return disableKinesisStreamingDestination(DisableKinesisStreamingDestinationRequest.builder()
                .applyMutation(disableKinesisStreamingDestinationRequest).build());
    }

    /**
     * <p>
     * Starts table data replication to the specified Kinesis data stream at a timestamp chosen during the enable
     * workflow. If this operation doesn't return results immediately, use DescribeKinesisStreamingDestination to check
     * if streaming to the Kinesis data stream is ACTIVE.
     * </p>
     *
     * @param enableKinesisStreamingDestinationRequest
     * @return A Java Future containing the result of the EnableKinesisStreamingDestination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.EnableKinesisStreamingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/EnableKinesisStreamingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableKinesisStreamingDestinationResponse> enableKinesisStreamingDestination(
            EnableKinesisStreamingDestinationRequest enableKinesisStreamingDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts table data replication to the specified Kinesis data stream at a timestamp chosen during the enable
     * workflow. If this operation doesn't return results immediately, use DescribeKinesisStreamingDestination to check
     * if streaming to the Kinesis data stream is ACTIVE.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableKinesisStreamingDestinationRequest.Builder}
     * avoiding the need to create one manually via {@link EnableKinesisStreamingDestinationRequest#builder()}
     * </p>
     *
     * @param enableKinesisStreamingDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the EnableKinesisStreamingDestination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.EnableKinesisStreamingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/EnableKinesisStreamingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableKinesisStreamingDestinationResponse> enableKinesisStreamingDestination(
            Consumer<EnableKinesisStreamingDestinationRequest.Builder> enableKinesisStreamingDestinationRequest) {
        return enableKinesisStreamingDestination(EnableKinesisStreamingDestinationRequest.builder()
                .applyMutation(enableKinesisStreamingDestinationRequest).build());
    }

    /**
     * <p>
     * This operation allows you to perform reads and singleton writes on data stored in DynamoDB, using PartiQL.
     * </p>
     * <p>
     * For PartiQL reads (<code>SELECT</code> statement), if the total number of processed items exceeds the maximum
     * dataset size limit of 1 MB, the read stops and results are returned to the user as a
     * <code>LastEvaluatedKey</code> value to continue the read in a subsequent operation. If the filter criteria in
     * <code>WHERE</code> clause does not match any data, the read will return an empty result set.
     * </p>
     * <p>
     * A single <code>SELECT</code> statement response can return up to the maximum number of items (if using the Limit
     * parameter) or a maximum of 1 MB of data (and then apply any filtering to the results using <code>WHERE</code>
     * clause). If <code>LastEvaluatedKey</code> is present in the response, you need to paginate the result set. If
     * <code>NextToken</code> is present, you need to paginate the result set and include <code>NextToken</code>.
     * </p>
     *
     * @param executeStatementRequest
     * @return A Java Future containing the result of the ExecuteStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConditionalCheckFailedException A condition specified in the operation failed to be evaluated.</li>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>ItemCollectionSizeLimitExceededException An item collection is too large. This exception is only
     *         returned for tables that have one or more local secondary indexes.</li>
     *         <li>TransactionConflictException Operation was rejected because there is an ongoing transaction for the
     *         item.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>DuplicateItemException There was an attempt to insert an item with the same primary key as an item
     *         that already exists in the DynamoDB table.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ExecuteStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ExecuteStatement" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExecuteStatementResponse> executeStatement(ExecuteStatementRequest executeStatementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation allows you to perform reads and singleton writes on data stored in DynamoDB, using PartiQL.
     * </p>
     * <p>
     * For PartiQL reads (<code>SELECT</code> statement), if the total number of processed items exceeds the maximum
     * dataset size limit of 1 MB, the read stops and results are returned to the user as a
     * <code>LastEvaluatedKey</code> value to continue the read in a subsequent operation. If the filter criteria in
     * <code>WHERE</code> clause does not match any data, the read will return an empty result set.
     * </p>
     * <p>
     * A single <code>SELECT</code> statement response can return up to the maximum number of items (if using the Limit
     * parameter) or a maximum of 1 MB of data (and then apply any filtering to the results using <code>WHERE</code>
     * clause). If <code>LastEvaluatedKey</code> is present in the response, you need to paginate the result set. If
     * <code>NextToken</code> is present, you need to paginate the result set and include <code>NextToken</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteStatementRequest.Builder} avoiding the need
     * to create one manually via {@link ExecuteStatementRequest#builder()}
     * </p>
     *
     * @param executeStatementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.ExecuteStatementRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ExecuteStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConditionalCheckFailedException A condition specified in the operation failed to be evaluated.</li>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>ItemCollectionSizeLimitExceededException An item collection is too large. This exception is only
     *         returned for tables that have one or more local secondary indexes.</li>
     *         <li>TransactionConflictException Operation was rejected because there is an ongoing transaction for the
     *         item.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>DuplicateItemException There was an attempt to insert an item with the same primary key as an item
     *         that already exists in the DynamoDB table.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ExecuteStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ExecuteStatement" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExecuteStatementResponse> executeStatement(
            Consumer<ExecuteStatementRequest.Builder> executeStatementRequest) {
        return executeStatement(ExecuteStatementRequest.builder().applyMutation(executeStatementRequest).build());
    }

    /**
     * <p>
     * This operation allows you to perform transactional reads or writes on data stored in DynamoDB, using PartiQL.
     * </p>
     * <note>
     * <p>
     * The entire transaction must consist of either read statements or write statements, you cannot mix both in one
     * transaction. The EXISTS function is an exception and can be used to check the condition of specific attributes of
     * the item in a similar manner to <code>ConditionCheck</code> in the <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/transaction-apis.html#transaction-apis-txwriteitems"
     * >TransactWriteItems</a> API.
     * </p>
     * </note>
     *
     * @param executeTransactionRequest
     * @return A Java Future containing the result of the ExecuteTransaction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>TransactionCanceledException The entire transaction request was canceled.</p>
     *         <p>
     *         DynamoDB cancels a <code>TransactWriteItems</code> request under the following circumstances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A condition in one of the condition expressions is not met.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A table in the <code>TransactWriteItems</code> request is in a different account or region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         More than one action in the <code>TransactWriteItems</code> operation targets the same item.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is insufficient provisioned capacity for the transaction to be completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An item size becomes too large (larger than 400 KB), or a local secondary index (LSI) becomes too large,
     *         or a similar validation error occurs because of changes made by the transaction.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a user error, such as an invalid data format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is an ongoing <code>TransactWriteItems</code> operation that conflicts with a concurrent
     *         <code>TransactWriteItems</code> request. In this case the <code>TransactWriteItems</code> operation fails
     *         with a <code>TransactionCanceledException</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         DynamoDB cancels a <code>TransactGetItems</code> request under the following circumstances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There is an ongoing <code>TransactGetItems</code> operation that conflicts with a concurrent
     *         <code>PutItem</code>, <code>UpdateItem</code>, <code>DeleteItem</code> or <code>TransactWriteItems</code>
     *         request. In this case the <code>TransactGetItems</code> operation fails with a
     *         <code>TransactionCanceledException</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A table in the <code>TransactGetItems</code> request is in a different account or region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is insufficient provisioned capacity for the transaction to be completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a user error, such as an invalid data format.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         DynamoDB lists the cancellation reasons on the <code>CancellationReasons</code> property. Transaction
     *         cancellation reasons are ordered in the order of requested items, if an item has no error it will have
     *         <code>None</code> code and <code>Null</code> message.
     *         </p>
     *         </note>
     *         <p>
     *         Cancellation reason codes and possible error messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No Errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>None</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: <code>null</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Conditional Check Failed:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ConditionalCheckFailed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: The conditional request failed.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Item Collection Size Limit Exceeded:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ItemCollectionSizeLimitExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: Collection size exceeded.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Transaction Conflict:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>TransactionConflict</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: Transaction is ongoing for the item.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned Throughput Exceeded:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The level of configured provisioned throughput for the table was exceeded. Consider increasing your
     *         provisioning level with the UpdateTable API.
     *         </p>
     *         <note>
     *         <p>
     *         This Message is received when provisioned throughput is exceeded is on a provisioned DynamoDB table.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         The level of configured provisioned throughput for one or more global secondary indexes of the table was
     *         exceeded. Consider increasing your provisioning level for the under-provisioned global secondary indexes
     *         with the UpdateTable API.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when provisioned throughput is exceeded is on a provisioned GSI.
     *         </p>
     *         </note></li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Throttling Error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ThrottlingError</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Throughput exceeds the current capacity of your table or index. DynamoDB is automatically scaling your
     *         table or index so please try again shortly. If exceptions persist, check if you have a hot key:
     *         https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/bp-partition-key-design.html.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when writes get throttled on an On-Demand table as DynamoDB is automatically
     *         scaling the table.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         Throughput exceeds the current capacity for one or more global secondary indexes. DynamoDB is
     *         automatically scaling your index so please try again shortly.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when writes get throttled on an On-Demand GSI as DynamoDB is automatically
     *         scaling the GSI.
     *         </p>
     *         </note></li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Validation Error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ValidationError</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         One or more parameter values were invalid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The update expression attempted to update the secondary index key beyond allowed size limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The update expression attempted to update the secondary index key to unsupported type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An operand in the update expression has an incorrect data type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Item size to update has exceeded the maximum allowed size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Number overflow. Attempting to store a number with magnitude larger than supported range.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type mismatch for attribute to update.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Nesting Levels have exceeded supported limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The document path provided in the update expression is invalid for update.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The provided expression refers to an attribute that does not exist in the item.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>TransactionInProgressException The transaction with the given request token is already in
     *         progress.</p>
     *         <p>
     *         Recommended Settings
     *         </p>
     *         <note>
     *         <p>
     *         This is a general recommendation for handling the <code>TransactionInProgressException</code>. These
     *         settings help ensure that the client retries will trigger completion of the ongoing
     *         <code>TransactWriteItems</code> request.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         Set <code>clientExecutionTimeout</code> to a value that allows at least one retry to be processed after 5
     *         seconds have elapsed since the first attempt for the <code>TransactWriteItems</code> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set <code>socketTimeout</code> to a value a little lower than the <code>requestTimeout</code> setting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requestTimeout</code> should be set based on the time taken for the individual retries of a single
     *         HTTP request for your use case, but setting it to 1 second or higher should work well to reduce chances
     *         of retries and <code>TransactionInProgressException</code> errors.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use exponential backoff when retrying and tune backoff if needed.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Assuming <a href=
     *         "https://github.com/aws/aws-sdk-java/blob/fd409dee8ae23fb8953e0bb4dbde65536a7e0514/aws-java-sdk-core/src/main/java/com/amazonaws/retry/PredefinedRetryPolicies.java#L97"
     *         >default retry policy</a>, example timeout settings based on the guidelines above are as follows:
     *         </p>
     *         <p>
     *         Example timeline:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         0-1000 first attempt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1000-1500 first sleep/delay (default retry policy uses 500 ms as base delay for 4xx errors)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1500-2500 second attempt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2500-3500 second sleep/delay (500 * 2, exponential backoff)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3500-4500 third attempt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         4500-6500 third sleep/delay (500 * 2^2)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         6500-7500 fourth attempt (this can trigger inline recovery since 5 seconds have elapsed since the first
     *         attempt reached TC)
     *         </p>
     *         </li></li>
     *         <li>IdempotentParameterMismatchException DynamoDB rejected the request because you retried a request with
     *         a different payload but with an idempotent token that was already used.</li>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ExecuteTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ExecuteTransaction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ExecuteTransactionResponse> executeTransaction(ExecuteTransactionRequest executeTransactionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation allows you to perform transactional reads or writes on data stored in DynamoDB, using PartiQL.
     * </p>
     * <note>
     * <p>
     * The entire transaction must consist of either read statements or write statements, you cannot mix both in one
     * transaction. The EXISTS function is an exception and can be used to check the condition of specific attributes of
     * the item in a similar manner to <code>ConditionCheck</code> in the <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/transaction-apis.html#transaction-apis-txwriteitems"
     * >TransactWriteItems</a> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteTransactionRequest.Builder} avoiding the
     * need to create one manually via {@link ExecuteTransactionRequest#builder()}
     * </p>
     *
     * @param executeTransactionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ExecuteTransaction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>TransactionCanceledException The entire transaction request was canceled.</p>
     *         <p>
     *         DynamoDB cancels a <code>TransactWriteItems</code> request under the following circumstances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A condition in one of the condition expressions is not met.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A table in the <code>TransactWriteItems</code> request is in a different account or region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         More than one action in the <code>TransactWriteItems</code> operation targets the same item.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is insufficient provisioned capacity for the transaction to be completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An item size becomes too large (larger than 400 KB), or a local secondary index (LSI) becomes too large,
     *         or a similar validation error occurs because of changes made by the transaction.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a user error, such as an invalid data format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is an ongoing <code>TransactWriteItems</code> operation that conflicts with a concurrent
     *         <code>TransactWriteItems</code> request. In this case the <code>TransactWriteItems</code> operation fails
     *         with a <code>TransactionCanceledException</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         DynamoDB cancels a <code>TransactGetItems</code> request under the following circumstances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There is an ongoing <code>TransactGetItems</code> operation that conflicts with a concurrent
     *         <code>PutItem</code>, <code>UpdateItem</code>, <code>DeleteItem</code> or <code>TransactWriteItems</code>
     *         request. In this case the <code>TransactGetItems</code> operation fails with a
     *         <code>TransactionCanceledException</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A table in the <code>TransactGetItems</code> request is in a different account or region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is insufficient provisioned capacity for the transaction to be completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a user error, such as an invalid data format.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         DynamoDB lists the cancellation reasons on the <code>CancellationReasons</code> property. Transaction
     *         cancellation reasons are ordered in the order of requested items, if an item has no error it will have
     *         <code>None</code> code and <code>Null</code> message.
     *         </p>
     *         </note>
     *         <p>
     *         Cancellation reason codes and possible error messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No Errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>None</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: <code>null</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Conditional Check Failed:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ConditionalCheckFailed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: The conditional request failed.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Item Collection Size Limit Exceeded:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ItemCollectionSizeLimitExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: Collection size exceeded.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Transaction Conflict:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>TransactionConflict</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: Transaction is ongoing for the item.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned Throughput Exceeded:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The level of configured provisioned throughput for the table was exceeded. Consider increasing your
     *         provisioning level with the UpdateTable API.
     *         </p>
     *         <note>
     *         <p>
     *         This Message is received when provisioned throughput is exceeded is on a provisioned DynamoDB table.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         The level of configured provisioned throughput for one or more global secondary indexes of the table was
     *         exceeded. Consider increasing your provisioning level for the under-provisioned global secondary indexes
     *         with the UpdateTable API.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when provisioned throughput is exceeded is on a provisioned GSI.
     *         </p>
     *         </note></li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Throttling Error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ThrottlingError</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Throughput exceeds the current capacity of your table or index. DynamoDB is automatically scaling your
     *         table or index so please try again shortly. If exceptions persist, check if you have a hot key:
     *         https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/bp-partition-key-design.html.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when writes get throttled on an On-Demand table as DynamoDB is automatically
     *         scaling the table.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         Throughput exceeds the current capacity for one or more global secondary indexes. DynamoDB is
     *         automatically scaling your index so please try again shortly.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when writes get throttled on an On-Demand GSI as DynamoDB is automatically
     *         scaling the GSI.
     *         </p>
     *         </note></li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Validation Error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ValidationError</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         One or more parameter values were invalid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The update expression attempted to update the secondary index key beyond allowed size limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The update expression attempted to update the secondary index key to unsupported type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An operand in the update expression has an incorrect data type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Item size to update has exceeded the maximum allowed size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Number overflow. Attempting to store a number with magnitude larger than supported range.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type mismatch for attribute to update.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Nesting Levels have exceeded supported limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The document path provided in the update expression is invalid for update.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The provided expression refers to an attribute that does not exist in the item.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>TransactionInProgressException The transaction with the given request token is already in
     *         progress.</p>
     *         <p>
     *         Recommended Settings
     *         </p>
     *         <note>
     *         <p>
     *         This is a general recommendation for handling the <code>TransactionInProgressException</code>. These
     *         settings help ensure that the client retries will trigger completion of the ongoing
     *         <code>TransactWriteItems</code> request.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         Set <code>clientExecutionTimeout</code> to a value that allows at least one retry to be processed after 5
     *         seconds have elapsed since the first attempt for the <code>TransactWriteItems</code> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set <code>socketTimeout</code> to a value a little lower than the <code>requestTimeout</code> setting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requestTimeout</code> should be set based on the time taken for the individual retries of a single
     *         HTTP request for your use case, but setting it to 1 second or higher should work well to reduce chances
     *         of retries and <code>TransactionInProgressException</code> errors.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use exponential backoff when retrying and tune backoff if needed.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Assuming <a href=
     *         "https://github.com/aws/aws-sdk-java/blob/fd409dee8ae23fb8953e0bb4dbde65536a7e0514/aws-java-sdk-core/src/main/java/com/amazonaws/retry/PredefinedRetryPolicies.java#L97"
     *         >default retry policy</a>, example timeout settings based on the guidelines above are as follows:
     *         </p>
     *         <p>
     *         Example timeline:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         0-1000 first attempt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1000-1500 first sleep/delay (default retry policy uses 500 ms as base delay for 4xx errors)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1500-2500 second attempt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2500-3500 second sleep/delay (500 * 2, exponential backoff)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3500-4500 third attempt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         4500-6500 third sleep/delay (500 * 2^2)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         6500-7500 fourth attempt (this can trigger inline recovery since 5 seconds have elapsed since the first
     *         attempt reached TC)
     *         </p>
     *         </li></li>
     *         <li>IdempotentParameterMismatchException DynamoDB rejected the request because you retried a request with
     *         a different payload but with an idempotent token that was already used.</li>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ExecuteTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ExecuteTransaction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ExecuteTransactionResponse> executeTransaction(
            Consumer<ExecuteTransactionRequest.Builder> executeTransactionRequest) {
        return executeTransaction(ExecuteTransactionRequest.builder().applyMutation(executeTransactionRequest).build());
    }

    /**
     * <p>
     * Exports table data to an S3 bucket. The table must have point in time recovery enabled, and you can export data
     * from any time within the point in time recovery window.
     * </p>
     *
     * @param exportTableToPointInTimeRequest
     * @return A Java Future containing the result of the ExportTableToPointInTime operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TableNotFoundException A source table with the name <code>TableName</code> does not currently exist
     *         within the subscriber's account or the subscriber is operating in the wrong Amazon Web Services Region.</li>
     *         <li>PointInTimeRecoveryUnavailableException Point in time recovery has not yet been enabled for this
     *         source table.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InvalidExportTimeException The specified <code>ExportTime</code> is outside of the point in time
     *         recovery window.</li>
     *         <li>ExportConflictException There was a conflict when writing to the specified S3 bucket.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ExportTableToPointInTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ExportTableToPointInTime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportTableToPointInTimeResponse> exportTableToPointInTime(
            ExportTableToPointInTimeRequest exportTableToPointInTimeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports table data to an S3 bucket. The table must have point in time recovery enabled, and you can export data
     * from any time within the point in time recovery window.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportTableToPointInTimeRequest.Builder} avoiding
     * the need to create one manually via {@link ExportTableToPointInTimeRequest#builder()}
     * </p>
     *
     * @param exportTableToPointInTimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ExportTableToPointInTime operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TableNotFoundException A source table with the name <code>TableName</code> does not currently exist
     *         within the subscriber's account or the subscriber is operating in the wrong Amazon Web Services Region.</li>
     *         <li>PointInTimeRecoveryUnavailableException Point in time recovery has not yet been enabled for this
     *         source table.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InvalidExportTimeException The specified <code>ExportTime</code> is outside of the point in time
     *         recovery window.</li>
     *         <li>ExportConflictException There was a conflict when writing to the specified S3 bucket.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ExportTableToPointInTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ExportTableToPointInTime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportTableToPointInTimeResponse> exportTableToPointInTime(
            Consumer<ExportTableToPointInTimeRequest.Builder> exportTableToPointInTimeRequest) {
        return exportTableToPointInTime(ExportTableToPointInTimeRequest.builder().applyMutation(exportTableToPointInTimeRequest)
                .build());
    }

    /**
     * <p>
     * The <code>GetItem</code> operation returns a set of attributes for the item with the given primary key. If there
     * is no matching item, <code>GetItem</code> does not return any data and there will be no <code>Item</code> element
     * in the response.
     * </p>
     * <p>
     * <code>GetItem</code> provides an eventually consistent read by default. If your application requires a strongly
     * consistent read, set <code>ConsistentRead</code> to <code>true</code>. Although a strongly consistent read might
     * take more time than an eventually consistent read, it always returns the last updated value.
     * </p>
     *
     * @param getItemRequest
     *        Represents the input of a <code>GetItem</code> operation.
     * @return A Java Future containing the result of the GetItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.GetItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GetItem" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_GetItem_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<GetItemResponse> getItem(GetItemRequest getItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>GetItem</code> operation returns a set of attributes for the item with the given primary key. If there
     * is no matching item, <code>GetItem</code> does not return any data and there will be no <code>Item</code> element
     * in the response.
     * </p>
     * <p>
     * <code>GetItem</code> provides an eventually consistent read by default. If your application requires a strongly
     * consistent read, set <code>ConsistentRead</code> to <code>true</code>. Although a strongly consistent read might
     * take more time than an eventually consistent read, it always returns the last updated value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetItemRequest.Builder} avoiding the need to create
     * one manually via {@link GetItemRequest#builder()}
     * </p>
     *
     * @param getItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.GetItemRequest.Builder} to create a request.
     *        Represents the input of a <code>GetItem</code> operation.
     * @return A Java Future containing the result of the GetItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.GetItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GetItem" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_GetItem_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<GetItemResponse> getItem(Consumer<GetItemRequest.Builder> getItemRequest) {
        return getItem(GetItemRequest.builder().applyMutation(getItemRequest).build());
    }

    /**
     * <p>
     * Returns the resource-based policy document attached to the resource, which can be a table or stream, in JSON
     * format.
     * </p>
     * <p>
     * <code>GetResourcePolicy</code> follows an <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html">
     * <i>eventually consistent</i> </a> model. The following list describes the outcomes when you issue the
     * <code>GetResourcePolicy</code> request immediately after issuing another request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you issue a <code>GetResourcePolicy</code> request immediately after a <code>PutResourcePolicy</code> request,
     * DynamoDB might return a <code>PolicyNotFoundException</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you issue a <code>GetResourcePolicy</code>request immediately after a <code>DeleteResourcePolicy</code>
     * request, DynamoDB might return the policy that was present before the deletion request.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you issue a <code>GetResourcePolicy</code> request immediately after a <code>CreateTable</code> request, which
     * includes a resource-based policy, DynamoDB might return a <code>ResourceNotFoundException</code> or a
     * <code>PolicyNotFoundException</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Because <code>GetResourcePolicy</code> uses an <i>eventually consistent</i> query, the metadata for your policy
     * or table might not be available at that moment. Wait for a few seconds, and then retry the
     * <code>GetResourcePolicy</code> request.
     * </p>
     * <p>
     * After a <code>GetResourcePolicy</code> request returns a policy created using the <code>PutResourcePolicy</code>
     * request, the policy will be applied in the authorization of requests to the resource. Because this process is
     * eventually consistent, it will take some time to apply the policy to all requests to a resource. Policies that
     * you attach while creating a table using the <code>CreateTable</code> request will always be applied to all
     * requests for that table.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>PolicyNotFoundException The operation tried to access a nonexistent resource-based policy.</p>
     *         <p>
     *         If you specified an <code>ExpectedRevisionId</code>, it's possible that a policy is present for the
     *         resource but its revision ID didn't match the expected value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GetResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the resource-based policy document attached to the resource, which can be a table or stream, in JSON
     * format.
     * </p>
     * <p>
     * <code>GetResourcePolicy</code> follows an <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html">
     * <i>eventually consistent</i> </a> model. The following list describes the outcomes when you issue the
     * <code>GetResourcePolicy</code> request immediately after issuing another request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you issue a <code>GetResourcePolicy</code> request immediately after a <code>PutResourcePolicy</code> request,
     * DynamoDB might return a <code>PolicyNotFoundException</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you issue a <code>GetResourcePolicy</code>request immediately after a <code>DeleteResourcePolicy</code>
     * request, DynamoDB might return the policy that was present before the deletion request.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you issue a <code>GetResourcePolicy</code> request immediately after a <code>CreateTable</code> request, which
     * includes a resource-based policy, DynamoDB might return a <code>ResourceNotFoundException</code> or a
     * <code>PolicyNotFoundException</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Because <code>GetResourcePolicy</code> uses an <i>eventually consistent</i> query, the metadata for your policy
     * or table might not be available at that moment. Wait for a few seconds, and then retry the
     * <code>GetResourcePolicy</code> request.
     * </p>
     * <p>
     * After a <code>GetResourcePolicy</code> request returns a policy created using the <code>PutResourcePolicy</code>
     * request, the policy will be applied in the authorization of requests to the resource. Because this process is
     * eventually consistent, it will take some time to apply the policy to all requests to a resource. Policies that
     * you attach while creating a table using the <code>CreateTable</code> request will always be applied to all
     * requests for that table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.GetResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>PolicyNotFoundException The operation tried to access a nonexistent resource-based policy.</p>
     *         <p>
     *         If you specified an <code>ExpectedRevisionId</code>, it's possible that a policy is present for the
     *         resource but its revision ID didn't match the expected value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GetResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(
            Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest) {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Imports table data from an S3 bucket.
     * </p>
     *
     * @param importTableRequest
     * @return A Java Future containing the result of the ImportTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>ImportConflictException There was a conflict when importing from the specified S3 source. This can
     *         occur when the current import conflicts with a previous import request that had the same client token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ImportTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ImportTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ImportTableResponse> importTable(ImportTableRequest importTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports table data from an S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportTableRequest.Builder} avoiding the need to
     * create one manually via {@link ImportTableRequest#builder()}
     * </p>
     *
     * @param importTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.ImportTableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ImportTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>ImportConflictException There was a conflict when importing from the specified S3 source. This can
     *         occur when the current import conflicts with a previous import request that had the same client token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ImportTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ImportTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ImportTableResponse> importTable(Consumer<ImportTableRequest.Builder> importTableRequest) {
        return importTable(ImportTableRequest.builder().applyMutation(importTableRequest).build());
    }

    /**
     * <p>
     * List DynamoDB backups that are associated with an Amazon Web Services account and weren't made with Amazon Web
     * Services Backup. To list these backups for a given table, specify <code>TableName</code>.
     * <code>ListBackups</code> returns a paginated list of results with at most 1 MB worth of items in a page. You can
     * also specify a maximum number of entries to be returned in a page.
     * </p>
     * <p>
     * In the request, start time is inclusive, but end time is exclusive. Note that these boundaries are for the time
     * at which the original backup was requested.
     * </p>
     * <p>
     * You can call <code>ListBackups</code> a maximum of five times per second.
     * </p>
     * <p>
     * If you want to retrieve the complete list of backups made with Amazon Web Services Backup, use the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupJobs.html">Amazon Web Services Backup
     * list API.</a>
     * </p>
     *
     * @param listBackupsRequest
     * @return A Java Future containing the result of the ListBackups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListBackups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBackupsResponse> listBackups(ListBackupsRequest listBackupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List DynamoDB backups that are associated with an Amazon Web Services account and weren't made with Amazon Web
     * Services Backup. To list these backups for a given table, specify <code>TableName</code>.
     * <code>ListBackups</code> returns a paginated list of results with at most 1 MB worth of items in a page. You can
     * also specify a maximum number of entries to be returned in a page.
     * </p>
     * <p>
     * In the request, start time is inclusive, but end time is exclusive. Note that these boundaries are for the time
     * at which the original backup was requested.
     * </p>
     * <p>
     * You can call <code>ListBackups</code> a maximum of five times per second.
     * </p>
     * <p>
     * If you want to retrieve the complete list of backups made with Amazon Web Services Backup, use the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupJobs.html">Amazon Web Services Backup
     * list API.</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBackupsRequest#builder()}
     * </p>
     *
     * @param listBackupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.ListBackupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListBackups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListBackups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBackupsResponse> listBackups(Consumer<ListBackupsRequest.Builder> listBackupsRequest) {
        return listBackups(ListBackupsRequest.builder().applyMutation(listBackupsRequest).build());
    }

    /**
     * <p>
     * List DynamoDB backups that are associated with an Amazon Web Services account and weren't made with Amazon Web
     * Services Backup. To list these backups for a given table, specify <code>TableName</code>.
     * <code>ListBackups</code> returns a paginated list of results with at most 1 MB worth of items in a page. You can
     * also specify a maximum number of entries to be returned in a page.
     * </p>
     * <p>
     * In the request, start time is inclusive, but end time is exclusive. Note that these boundaries are for the time
     * at which the original backup was requested.
     * </p>
     * <p>
     * You can call <code>ListBackups</code> a maximum of five times per second.
     * </p>
     * <p>
     * If you want to retrieve the complete list of backups made with Amazon Web Services Backup, use the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupJobs.html">Amazon Web Services Backup
     * list API.</a>
     * </p>
     *
     * @return A Java Future containing the result of the ListBackups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListBackups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBackupsResponse> listBackups() {
        return listBackups(ListBackupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of ContributorInsightsSummary for a table and all its global secondary indexes.
     * </p>
     *
     * @param listContributorInsightsRequest
     * @return A Java Future containing the result of the ListContributorInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListContributorInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListContributorInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListContributorInsightsResponse> listContributorInsights(
            ListContributorInsightsRequest listContributorInsightsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of ContributorInsightsSummary for a table and all its global secondary indexes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContributorInsightsRequest.Builder} avoiding
     * the need to create one manually via {@link ListContributorInsightsRequest#builder()}
     * </p>
     *
     * @param listContributorInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListContributorInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListContributorInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListContributorInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListContributorInsightsResponse> listContributorInsights(
            Consumer<ListContributorInsightsRequest.Builder> listContributorInsightsRequest) {
        return listContributorInsights(ListContributorInsightsRequest.builder().applyMutation(listContributorInsightsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContributorInsights(software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ListContributorInsightsPublisher publisher = client.listContributorInsightsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ListContributorInsightsPublisher publisher = client.listContributorInsightsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContributorInsights(software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listContributorInsightsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListContributorInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListContributorInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContributorInsightsPublisher listContributorInsightsPaginator(
            ListContributorInsightsRequest listContributorInsightsRequest) {
        return new ListContributorInsightsPublisher(this, listContributorInsightsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContributorInsights(software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ListContributorInsightsPublisher publisher = client.listContributorInsightsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ListContributorInsightsPublisher publisher = client.listContributorInsightsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContributorInsights(software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContributorInsightsRequest.Builder} avoiding
     * the need to create one manually via {@link ListContributorInsightsRequest#builder()}
     * </p>
     *
     * @param listContributorInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListContributorInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListContributorInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContributorInsightsPublisher listContributorInsightsPaginator(
            Consumer<ListContributorInsightsRequest.Builder> listContributorInsightsRequest) {
        return listContributorInsightsPaginator(ListContributorInsightsRequest.builder()
                .applyMutation(listContributorInsightsRequest).build());
    }

    /**
     * <p>
     * Lists completed exports within the past 90 days.
     * </p>
     *
     * @param listExportsRequest
     * @return A Java Future containing the result of the ListExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExportsResponse> listExports(ListExportsRequest listExportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists completed exports within the past 90 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportsRequest#builder()}
     * </p>
     *
     * @param listExportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.ListExportsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExportsResponse> listExports(Consumer<ListExportsRequest.Builder> listExportsRequest) {
        return listExports(ListExportsRequest.builder().applyMutation(listExportsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listExports(software.amazon.awssdk.services.dynamodb.model.ListExportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.dynamodb.model.ListExportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.dynamodb.model.ListExportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.dynamodb.model.ListExportsRequest)} operation.</b>
     * </p>
     *
     * @param listExportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportsPublisher listExportsPaginator(ListExportsRequest listExportsRequest) {
        return new ListExportsPublisher(this, listExportsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listExports(software.amazon.awssdk.services.dynamodb.model.ListExportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.dynamodb.model.ListExportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.dynamodb.model.ListExportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.dynamodb.model.ListExportsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportsRequest#builder()}
     * </p>
     *
     * @param listExportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.ListExportsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportsPublisher listExportsPaginator(Consumer<ListExportsRequest.Builder> listExportsRequest) {
        return listExportsPaginator(ListExportsRequest.builder().applyMutation(listExportsRequest).build());
    }

    /**
     * <p>
     * Lists all global tables that have a replica in the specified Region.
     * </p>
     * <important>
     * <p>
     * This documentation is for version 2017.11.29 (Legacy) of global tables, which should be avoided for new global
     * tables. Customers should use <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">Global Tables version
     * 2019.11.21 (Current)</a> when possible, because it provides greater flexibility, higher efficiency, and consumes
     * less write capacity than 2017.11.29 (Legacy).
     * </p>
     * <p>
     * To determine which version you're using, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.DetermineVersion.html"
     * >Determining the global table version you are using</a>. To update existing global tables from version 2017.11.29
     * (Legacy) to version 2019.11.21 (Current), see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/V2globaltables_upgrade.html">Upgrading
     * global tables</a>.
     * </p>
     * </important>
     *
     * @param listGlobalTablesRequest
     * @return A Java Future containing the result of the ListGlobalTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListGlobalTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListGlobalTables" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGlobalTablesResponse> listGlobalTables(ListGlobalTablesRequest listGlobalTablesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all global tables that have a replica in the specified Region.
     * </p>
     * <important>
     * <p>
     * This documentation is for version 2017.11.29 (Legacy) of global tables, which should be avoided for new global
     * tables. Customers should use <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">Global Tables version
     * 2019.11.21 (Current)</a> when possible, because it provides greater flexibility, higher efficiency, and consumes
     * less write capacity than 2017.11.29 (Legacy).
     * </p>
     * <p>
     * To determine which version you're using, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.DetermineVersion.html"
     * >Determining the global table version you are using</a>. To update existing global tables from version 2017.11.29
     * (Legacy) to version 2019.11.21 (Current), see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/V2globaltables_upgrade.html">Upgrading
     * global tables</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGlobalTablesRequest.Builder} avoiding the need
     * to create one manually via {@link ListGlobalTablesRequest#builder()}
     * </p>
     *
     * @param listGlobalTablesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListGlobalTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListGlobalTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListGlobalTables" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGlobalTablesResponse> listGlobalTables(
            Consumer<ListGlobalTablesRequest.Builder> listGlobalTablesRequest) {
        return listGlobalTables(ListGlobalTablesRequest.builder().applyMutation(listGlobalTablesRequest).build());
    }

    /**
     * <p>
     * Lists all global tables that have a replica in the specified Region.
     * </p>
     * <important>
     * <p>
     * This documentation is for version 2017.11.29 (Legacy) of global tables, which should be avoided for new global
     * tables. Customers should use <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">Global Tables version
     * 2019.11.21 (Current)</a> when possible, because it provides greater flexibility, higher efficiency, and consumes
     * less write capacity than 2017.11.29 (Legacy).
     * </p>
     * <p>
     * To determine which version you're using, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.DetermineVersion.html"
     * >Determining the global table version you are using</a>. To update existing global tables from version 2017.11.29
     * (Legacy) to version 2019.11.21 (Current), see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/V2globaltables_upgrade.html">Upgrading
     * global tables</a>.
     * </p>
     * </important>
     *
     * @return A Java Future containing the result of the ListGlobalTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListGlobalTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListGlobalTables" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGlobalTablesResponse> listGlobalTables() {
        return listGlobalTables(ListGlobalTablesRequest.builder().build());
    }

    /**
     * <p>
     * Lists completed imports within the past 90 days.
     * </p>
     *
     * @param listImportsRequest
     * @return A Java Future containing the result of the ListImports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportsResponse> listImports(ListImportsRequest listImportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists completed imports within the past 90 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.ListImportsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListImports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportsResponse> listImports(Consumer<ListImportsRequest.Builder> listImportsRequest) {
        return listImports(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listImports(software.amazon.awssdk.services.dynamodb.model.ListImportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.dynamodb.model.ListImportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.dynamodb.model.ListImportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.dynamodb.model.ListImportsRequest)} operation.</b>
     * </p>
     *
     * @param listImportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsPublisher listImportsPaginator(ListImportsRequest listImportsRequest) {
        return new ListImportsPublisher(this, listImportsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listImports(software.amazon.awssdk.services.dynamodb.model.ListImportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.dynamodb.model.ListImportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.dynamodb.model.ListImportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.dynamodb.model.ListImportsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.ListImportsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsPublisher listImportsPaginator(Consumer<ListImportsRequest.Builder> listImportsRequest) {
        return listImportsPaginator(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * Returns an array of table names associated with the current account and endpoint. The output from
     * <code>ListTables</code> is paginated, with each page returning a maximum of 100 table names.
     * </p>
     *
     * @param listTablesRequest
     *        Represents the input of a <code>ListTables</code> operation.
     * @return A Java Future containing the result of the ListTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTables" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_ListTables_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<ListTablesResponse> listTables(ListTablesRequest listTablesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of table names associated with the current account and endpoint. The output from
     * <code>ListTables</code> is paginated, with each page returning a maximum of 100 table names.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTablesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTablesRequest#builder()}
     * </p>
     *
     * @param listTablesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.ListTablesRequest.Builder} to create a request.
     *        Represents the input of a <code>ListTables</code> operation.
     * @return A Java Future containing the result of the ListTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTables" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_ListTables_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<ListTablesResponse> listTables(Consumer<ListTablesRequest.Builder> listTablesRequest) {
        return listTables(ListTablesRequest.builder().applyMutation(listTablesRequest).build());
    }

    /**
     * <p>
     * Returns an array of table names associated with the current account and endpoint. The output from
     * <code>ListTables</code> is paginated, with each page returning a maximum of 100 table names.
     * </p>
     *
     * @return A Java Future containing the result of the ListTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTables" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_ListTables_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<ListTablesResponse> listTables() {
        return listTables(ListTablesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTables(software.amazon.awssdk.services.dynamodb.model.ListTablesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ListTablesPublisher publisher = client.listTablesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ListTablesPublisher publisher = client.listTablesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.dynamodb.model.ListTablesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.dynamodb.model.ListTablesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTables(software.amazon.awssdk.services.dynamodb.model.ListTablesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTables" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_ListTables_section.html"
     *      target="_top">Code Example</a>
     */
    default ListTablesPublisher listTablesPaginator() {
        return listTablesPaginator(ListTablesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTables(software.amazon.awssdk.services.dynamodb.model.ListTablesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ListTablesPublisher publisher = client.listTablesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ListTablesPublisher publisher = client.listTablesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.dynamodb.model.ListTablesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.dynamodb.model.ListTablesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTables(software.amazon.awssdk.services.dynamodb.model.ListTablesRequest)} operation.</b>
     * </p>
     *
     * @param listTablesRequest
     *        Represents the input of a <code>ListTables</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTables" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_ListTables_section.html"
     *      target="_top">Code Example</a>
     */
    default ListTablesPublisher listTablesPaginator(ListTablesRequest listTablesRequest) {
        return new ListTablesPublisher(this, listTablesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTables(software.amazon.awssdk.services.dynamodb.model.ListTablesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ListTablesPublisher publisher = client.listTablesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ListTablesPublisher publisher = client.listTablesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.dynamodb.model.ListTablesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.dynamodb.model.ListTablesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTables(software.amazon.awssdk.services.dynamodb.model.ListTablesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTablesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTablesRequest#builder()}
     * </p>
     *
     * @param listTablesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.ListTablesRequest.Builder} to create a request.
     *        Represents the input of a <code>ListTables</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTables" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_ListTables_section.html"
     *      target="_top">Code Example</a>
     */
    default ListTablesPublisher listTablesPaginator(Consumer<ListTablesRequest.Builder> listTablesRequest) {
        return listTablesPaginator(ListTablesRequest.builder().applyMutation(listTablesRequest).build());
    }

    /**
     * <p>
     * List all tags on an Amazon DynamoDB resource. You can call ListTagsOfResource up to 10 times per second, per
     * account.
     * </p>
     * <p>
     * For an overview on tagging DynamoDB resources, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     *
     * @param listTagsOfResourceRequest
     * @return A Java Future containing the result of the ListTagsOfResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListTagsOfResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTagsOfResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsOfResourceResponse> listTagsOfResource(ListTagsOfResourceRequest listTagsOfResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tags on an Amazon DynamoDB resource. You can call ListTagsOfResource up to 10 times per second, per
     * account.
     * </p>
     * <p>
     * For an overview on tagging DynamoDB resources, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsOfResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsOfResourceRequest#builder()}
     * </p>
     *
     * @param listTagsOfResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsOfResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.ListTagsOfResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTagsOfResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsOfResourceResponse> listTagsOfResource(
            Consumer<ListTagsOfResourceRequest.Builder> listTagsOfResourceRequest) {
        return listTagsOfResource(ListTagsOfResourceRequest.builder().applyMutation(listTagsOfResourceRequest).build());
    }

    /**
     * <p>
     * Creates a new item, or replaces an old item with a new item. If an item that has the same primary key as the new
     * item already exists in the specified table, the new item completely replaces the existing item. You can perform a
     * conditional put operation (add a new item if one with the specified primary key doesn't exist), or replace an
     * existing item if it has certain attribute values. You can return the item's attribute values in the same
     * operation, using the <code>ReturnValues</code> parameter.
     * </p>
     * <p>
     * When you add an item, the primary key attributes are the only required attributes.
     * </p>
     * <p>
     * Empty String and Binary attribute values are allowed. Attribute values of type String and Binary must have a
     * length greater than zero if the attribute is used as a key attribute for a table or index. Set type attributes
     * cannot be empty.
     * </p>
     * <p>
     * Invalid Requests with empty values will be rejected with a <code>ValidationException</code> exception.
     * </p>
     * <note>
     * <p>
     * To prevent a new item from replacing an existing item, use a conditional expression that contains the
     * <code>attribute_not_exists</code> function with the name of the attribute being used as the partition key for the
     * table. Since every record must contain that attribute, the <code>attribute_not_exists</code> function will only
     * succeed if no matching item exists.
     * </p>
     * </note>
     * <p>
     * For more information about <code>PutItem</code>, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithItems.html">Working with
     * Items</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     *
     * @param putItemRequest
     *        Represents the input of a <code>PutItem</code> operation.
     * @return A Java Future containing the result of the PutItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConditionalCheckFailedException A condition specified in the operation failed to be evaluated.</li>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>ItemCollectionSizeLimitExceededException An item collection is too large. This exception is only
     *         returned for tables that have one or more local secondary indexes.</li>
     *         <li>TransactionConflictException Operation was rejected because there is an ongoing transaction for the
     *         item.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ReplicatedWriteConflictException The request was rejected because one or more items in the request
     *         are being modified by a request in another Region.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.PutItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/PutItem" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_PutItem_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<PutItemResponse> putItem(PutItemRequest putItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new item, or replaces an old item with a new item. If an item that has the same primary key as the new
     * item already exists in the specified table, the new item completely replaces the existing item. You can perform a
     * conditional put operation (add a new item if one with the specified primary key doesn't exist), or replace an
     * existing item if it has certain attribute values. You can return the item's attribute values in the same
     * operation, using the <code>ReturnValues</code> parameter.
     * </p>
     * <p>
     * When you add an item, the primary key attributes are the only required attributes.
     * </p>
     * <p>
     * Empty String and Binary attribute values are allowed. Attribute values of type String and Binary must have a
     * length greater than zero if the attribute is used as a key attribute for a table or index. Set type attributes
     * cannot be empty.
     * </p>
     * <p>
     * Invalid Requests with empty values will be rejected with a <code>ValidationException</code> exception.
     * </p>
     * <note>
     * <p>
     * To prevent a new item from replacing an existing item, use a conditional expression that contains the
     * <code>attribute_not_exists</code> function with the name of the attribute being used as the partition key for the
     * table. Since every record must contain that attribute, the <code>attribute_not_exists</code> function will only
     * succeed if no matching item exists.
     * </p>
     * </note>
     * <p>
     * For more information about <code>PutItem</code>, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithItems.html">Working with
     * Items</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutItemRequest.Builder} avoiding the need to create
     * one manually via {@link PutItemRequest#builder()}
     * </p>
     *
     * @param putItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.PutItemRequest.Builder} to create a request.
     *        Represents the input of a <code>PutItem</code> operation.
     * @return A Java Future containing the result of the PutItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConditionalCheckFailedException A condition specified in the operation failed to be evaluated.</li>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>ItemCollectionSizeLimitExceededException An item collection is too large. This exception is only
     *         returned for tables that have one or more local secondary indexes.</li>
     *         <li>TransactionConflictException Operation was rejected because there is an ongoing transaction for the
     *         item.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ReplicatedWriteConflictException The request was rejected because one or more items in the request
     *         are being modified by a request in another Region.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.PutItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/PutItem" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_PutItem_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<PutItemResponse> putItem(Consumer<PutItemRequest.Builder> putItemRequest) {
        return putItem(PutItemRequest.builder().applyMutation(putItemRequest).build());
    }

    /**
     * <p>
     * Attaches a resource-based policy document to the resource, which can be a table or stream. When you attach a
     * resource-based policy using this API, the policy application is <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html">
     * <i>eventually consistent</i> </a>.
     * </p>
     * <p>
     * <code>PutResourcePolicy</code> is an idempotent operation; running it multiple times on the same resource using
     * the same policy document will return the same revision ID. If you specify an <code>ExpectedRevisionId</code> that
     * doesn't match the current policy's <code>RevisionId</code>, the <code>PolicyNotFoundException</code> will be
     * returned.
     * </p>
     * <note>
     * <p>
     * <code>PutResourcePolicy</code> is an asynchronous operation. If you issue a <code>GetResourcePolicy</code>
     * request immediately after a <code>PutResourcePolicy</code> request, DynamoDB might return your previous policy,
     * if there was one, or return the <code>PolicyNotFoundException</code>. This is because
     * <code>GetResourcePolicy</code> uses an eventually consistent query, and the metadata for your policy or table
     * might not be available at that moment. Wait for a few seconds, and then try the <code>GetResourcePolicy</code>
     * request again.
     * </p>
     * </note>
     *
     * @param putResourcePolicyRequest
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>PolicyNotFoundException The operation tried to access a nonexistent resource-based policy.</p>
     *         <p>
     *         If you specified an <code>ExpectedRevisionId</code>, it's possible that a policy is present for the
     *         resource but its revision ID didn't match the expected value.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/PutResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a resource-based policy document to the resource, which can be a table or stream. When you attach a
     * resource-based policy using this API, the policy application is <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html">
     * <i>eventually consistent</i> </a>.
     * </p>
     * <p>
     * <code>PutResourcePolicy</code> is an idempotent operation; running it multiple times on the same resource using
     * the same policy document will return the same revision ID. If you specify an <code>ExpectedRevisionId</code> that
     * doesn't match the current policy's <code>RevisionId</code>, the <code>PolicyNotFoundException</code> will be
     * returned.
     * </p>
     * <note>
     * <p>
     * <code>PutResourcePolicy</code> is an asynchronous operation. If you issue a <code>GetResourcePolicy</code>
     * request immediately after a <code>PutResourcePolicy</code> request, DynamoDB might return your previous policy,
     * if there was one, or return the <code>PolicyNotFoundException</code>. This is because
     * <code>GetResourcePolicy</code> uses an eventually consistent query, and the metadata for your policy or table
     * might not be available at that moment. Wait for a few seconds, and then try the <code>GetResourcePolicy</code>
     * request again.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.PutResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>PolicyNotFoundException The operation tried to access a nonexistent resource-based policy.</p>
     *         <p>
     *         If you specified an <code>ExpectedRevisionId</code>, it's possible that a policy is present for the
     *         resource but its revision ID didn't match the expected value.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/PutResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(
            Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest) {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * You must provide the name of the partition key attribute and a single value for that attribute.
     * <code>Query</code> returns all items with that partition key value. Optionally, you can provide a sort key
     * attribute and use a comparison operator to refine the search results.
     * </p>
     * <p>
     * Use the <code>KeyConditionExpression</code> parameter to provide a specific value for the partition key. The
     * <code>Query</code> operation will return all of the items from the table or index with that partition key value.
     * You can optionally narrow the scope of the <code>Query</code> operation by specifying a sort key value and a
     * comparison operator in <code>KeyConditionExpression</code>. To further refine the <code>Query</code> results, you
     * can optionally provide a <code>FilterExpression</code>. A <code>FilterExpression</code> determines which items
     * within the results should be returned to you. All of the other results are discarded.
     * </p>
     * <p>
     * A <code>Query</code> operation always returns a result set. If no matching items are found, the result set will
     * be empty. Queries that do not return results consume the minimum number of read capacity units for that type of
     * read operation.
     * </p>
     * <note>
     * <p>
     * DynamoDB calculates the number of read capacity units consumed based on item size, not on the amount of data that
     * is returned to an application. The number of capacity units consumed will be the same whether you request all of
     * the attributes (the default behavior) or just some of them (using a projection expression). The number will also
     * be the same whether or not you use a <code>FilterExpression</code>.
     * </p>
     * </note>
     * <p>
     * <code>Query</code> results are always sorted by the sort key value. If the data type of the sort key is Number,
     * the results are returned in numeric order; otherwise, the results are returned in order of UTF-8 bytes. By
     * default, the sort order is ascending. To reverse the order, set the <code>ScanIndexForward</code> parameter to
     * false.
     * </p>
     * <p>
     * A single <code>Query</code> operation will read up to the maximum number of items set (if using the
     * <code>Limit</code> parameter) or a maximum of 1 MB of data and then apply any filtering to the results using
     * <code>FilterExpression</code>. If <code>LastEvaluatedKey</code> is present in the response, you will need to
     * paginate the result set. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Query.html#Query.Pagination">Paginating
     * the Results</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * <code>FilterExpression</code> is applied after a <code>Query</code> finishes, but before the results are
     * returned. A <code>FilterExpression</code> cannot contain partition key or sort key attributes. You need to
     * specify those attributes in the <code>KeyConditionExpression</code>.
     * </p>
     * <note>
     * <p>
     * A <code>Query</code> operation can return an empty result set and a <code>LastEvaluatedKey</code> if all the
     * items read for the page of results are filtered out.
     * </p>
     * </note>
     * <p>
     * You can query a table, a local secondary index, or a global secondary index. For a query on a table or on a local
     * secondary index, you can set the <code>ConsistentRead</code> parameter to <code>true</code> and obtain a strongly
     * consistent result. Global secondary indexes support eventually consistent reads only, so do not specify
     * <code>ConsistentRead</code> when querying a global secondary index.
     * </p>
     *
     * @param queryRequest
     *        Represents the input of a <code>Query</code> operation.
     * @return A Java Future containing the result of the Query operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.Query
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Query" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Query_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<QueryResponse> query(QueryRequest queryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You must provide the name of the partition key attribute and a single value for that attribute.
     * <code>Query</code> returns all items with that partition key value. Optionally, you can provide a sort key
     * attribute and use a comparison operator to refine the search results.
     * </p>
     * <p>
     * Use the <code>KeyConditionExpression</code> parameter to provide a specific value for the partition key. The
     * <code>Query</code> operation will return all of the items from the table or index with that partition key value.
     * You can optionally narrow the scope of the <code>Query</code> operation by specifying a sort key value and a
     * comparison operator in <code>KeyConditionExpression</code>. To further refine the <code>Query</code> results, you
     * can optionally provide a <code>FilterExpression</code>. A <code>FilterExpression</code> determines which items
     * within the results should be returned to you. All of the other results are discarded.
     * </p>
     * <p>
     * A <code>Query</code> operation always returns a result set. If no matching items are found, the result set will
     * be empty. Queries that do not return results consume the minimum number of read capacity units for that type of
     * read operation.
     * </p>
     * <note>
     * <p>
     * DynamoDB calculates the number of read capacity units consumed based on item size, not on the amount of data that
     * is returned to an application. The number of capacity units consumed will be the same whether you request all of
     * the attributes (the default behavior) or just some of them (using a projection expression). The number will also
     * be the same whether or not you use a <code>FilterExpression</code>.
     * </p>
     * </note>
     * <p>
     * <code>Query</code> results are always sorted by the sort key value. If the data type of the sort key is Number,
     * the results are returned in numeric order; otherwise, the results are returned in order of UTF-8 bytes. By
     * default, the sort order is ascending. To reverse the order, set the <code>ScanIndexForward</code> parameter to
     * false.
     * </p>
     * <p>
     * A single <code>Query</code> operation will read up to the maximum number of items set (if using the
     * <code>Limit</code> parameter) or a maximum of 1 MB of data and then apply any filtering to the results using
     * <code>FilterExpression</code>. If <code>LastEvaluatedKey</code> is present in the response, you will need to
     * paginate the result set. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Query.html#Query.Pagination">Paginating
     * the Results</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * <code>FilterExpression</code> is applied after a <code>Query</code> finishes, but before the results are
     * returned. A <code>FilterExpression</code> cannot contain partition key or sort key attributes. You need to
     * specify those attributes in the <code>KeyConditionExpression</code>.
     * </p>
     * <note>
     * <p>
     * A <code>Query</code> operation can return an empty result set and a <code>LastEvaluatedKey</code> if all the
     * items read for the page of results are filtered out.
     * </p>
     * </note>
     * <p>
     * You can query a table, a local secondary index, or a global secondary index. For a query on a table or on a local
     * secondary index, you can set the <code>ConsistentRead</code> parameter to <code>true</code> and obtain a strongly
     * consistent result. Global secondary indexes support eventually consistent reads only, so do not specify
     * <code>ConsistentRead</code> when querying a global secondary index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryRequest.Builder} avoiding the need to create
     * one manually via {@link QueryRequest#builder()}
     * </p>
     *
     * @param queryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.QueryRequest.Builder} to create a request.
     *        Represents the input of a <code>Query</code> operation.
     * @return A Java Future containing the result of the Query operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.Query
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Query" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Query_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<QueryResponse> query(Consumer<QueryRequest.Builder> queryRequest) {
        return query(QueryRequest.builder().applyMutation(queryRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #query(software.amazon.awssdk.services.dynamodb.model.QueryRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.QueryPublisher publisher = client.queryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.QueryPublisher publisher = client.queryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.dynamodb.model.QueryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.dynamodb.model.QueryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #query(software.amazon.awssdk.services.dynamodb.model.QueryRequest)} operation.</b>
     * </p>
     *
     * @param queryRequest
     *        Represents the input of a <code>Query</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.Query
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Query" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Query_section.html"
     *      target="_top">Code Example</a>
     */
    default QueryPublisher queryPaginator(QueryRequest queryRequest) {
        return new QueryPublisher(this, queryRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #query(software.amazon.awssdk.services.dynamodb.model.QueryRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.QueryPublisher publisher = client.queryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.QueryPublisher publisher = client.queryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.dynamodb.model.QueryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.dynamodb.model.QueryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #query(software.amazon.awssdk.services.dynamodb.model.QueryRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryRequest.Builder} avoiding the need to create
     * one manually via {@link QueryRequest#builder()}
     * </p>
     *
     * @param queryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.QueryRequest.Builder} to create a request.
     *        Represents the input of a <code>Query</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.Query
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Query" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Query_section.html"
     *      target="_top">Code Example</a>
     */
    default QueryPublisher queryPaginator(Consumer<QueryRequest.Builder> queryRequest) {
        return queryPaginator(QueryRequest.builder().applyMutation(queryRequest).build());
    }

    /**
     * <p>
     * Creates a new table from an existing backup. Any number of users can execute up to 50 concurrent restores (any
     * type of restore) in a given account.
     * </p>
     * <p>
     * You can call <code>RestoreTableFromBackup</code> at a maximum rate of 10 times per second.
     * </p>
     * <p>
     * You must manually set up the following on the restored table:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Auto scaling policies
     * </p>
     * </li>
     * <li>
     * <p>
     * IAM policies
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon CloudWatch metrics and alarms
     * </p>
     * </li>
     * <li>
     * <p>
     * Tags
     * </p>
     * </li>
     * <li>
     * <p>
     * Stream settings
     * </p>
     * </li>
     * <li>
     * <p>
     * Time to Live (TTL) settings
     * </p>
     * </li>
     * </ul>
     *
     * @param restoreTableFromBackupRequest
     * @return A Java Future containing the result of the RestoreTableFromBackup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TableAlreadyExistsException A target table with the specified name already exists.</li>
     *         <li>TableInUseException A target table with the specified name is either being created or deleted.</li>
     *         <li>BackupNotFoundException Backup not found for the given BackupARN.</li>
     *         <li>BackupInUseException There is another ongoing conflicting backup control plane operation on the
     *         table. The backup is either being created, deleted or restored to a table.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.RestoreTableFromBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/RestoreTableFromBackup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreTableFromBackupResponse> restoreTableFromBackup(
            RestoreTableFromBackupRequest restoreTableFromBackupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new table from an existing backup. Any number of users can execute up to 50 concurrent restores (any
     * type of restore) in a given account.
     * </p>
     * <p>
     * You can call <code>RestoreTableFromBackup</code> at a maximum rate of 10 times per second.
     * </p>
     * <p>
     * You must manually set up the following on the restored table:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Auto scaling policies
     * </p>
     * </li>
     * <li>
     * <p>
     * IAM policies
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon CloudWatch metrics and alarms
     * </p>
     * </li>
     * <li>
     * <p>
     * Tags
     * </p>
     * </li>
     * <li>
     * <p>
     * Stream settings
     * </p>
     * </li>
     * <li>
     * <p>
     * Time to Live (TTL) settings
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreTableFromBackupRequest.Builder} avoiding the
     * need to create one manually via {@link RestoreTableFromBackupRequest#builder()}
     * </p>
     *
     * @param restoreTableFromBackupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RestoreTableFromBackup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TableAlreadyExistsException A target table with the specified name already exists.</li>
     *         <li>TableInUseException A target table with the specified name is either being created or deleted.</li>
     *         <li>BackupNotFoundException Backup not found for the given BackupARN.</li>
     *         <li>BackupInUseException There is another ongoing conflicting backup control plane operation on the
     *         table. The backup is either being created, deleted or restored to a table.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.RestoreTableFromBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/RestoreTableFromBackup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreTableFromBackupResponse> restoreTableFromBackup(
            Consumer<RestoreTableFromBackupRequest.Builder> restoreTableFromBackupRequest) {
        return restoreTableFromBackup(RestoreTableFromBackupRequest.builder().applyMutation(restoreTableFromBackupRequest)
                .build());
    }

    /**
     * <p>
     * Restores the specified table to the specified point in time within <code>EarliestRestorableDateTime</code> and
     * <code>LatestRestorableDateTime</code>. You can restore your table to any point in time in the last 35 days. You
     * can set the recovery period to any value between 1 and 35 days. Any number of users can execute up to 50
     * concurrent restores (any type of restore) in a given account.
     * </p>
     * <p>
     * When you restore using point in time recovery, DynamoDB restores your table data to the state based on the
     * selected date and time (day:hour:minute:second) to a new table.
     * </p>
     * <p>
     * Along with data, the following are also included on the new restored table using point in time recovery:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Global secondary indexes (GSIs)
     * </p>
     * </li>
     * <li>
     * <p>
     * Local secondary indexes (LSIs)
     * </p>
     * </li>
     * <li>
     * <p>
     * Provisioned read and write capacity
     * </p>
     * </li>
     * <li>
     * <p>
     * Encryption settings
     * </p>
     * <important>
     * <p>
     * All these settings come from the current settings of the source table at the time of restore.
     * </p>
     * </important></li>
     * </ul>
     * <p>
     * You must manually set up the following on the restored table:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Auto scaling policies
     * </p>
     * </li>
     * <li>
     * <p>
     * IAM policies
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon CloudWatch metrics and alarms
     * </p>
     * </li>
     * <li>
     * <p>
     * Tags
     * </p>
     * </li>
     * <li>
     * <p>
     * Stream settings
     * </p>
     * </li>
     * <li>
     * <p>
     * Time to Live (TTL) settings
     * </p>
     * </li>
     * <li>
     * <p>
     * Point in time recovery settings
     * </p>
     * </li>
     * </ul>
     *
     * @param restoreTableToPointInTimeRequest
     * @return A Java Future containing the result of the RestoreTableToPointInTime operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TableAlreadyExistsException A target table with the specified name already exists.</li>
     *         <li>TableNotFoundException A source table with the name <code>TableName</code> does not currently exist
     *         within the subscriber's account or the subscriber is operating in the wrong Amazon Web Services Region.</li>
     *         <li>TableInUseException A target table with the specified name is either being created or deleted.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InvalidRestoreTimeException An invalid restore time was specified. RestoreDateTime must be between
     *         EarliestRestorableDateTime and LatestRestorableDateTime.</li>
     *         <li>PointInTimeRecoveryUnavailableException Point in time recovery has not yet been enabled for this
     *         source table.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.RestoreTableToPointInTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/RestoreTableToPointInTime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreTableToPointInTimeResponse> restoreTableToPointInTime(
            RestoreTableToPointInTimeRequest restoreTableToPointInTimeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores the specified table to the specified point in time within <code>EarliestRestorableDateTime</code> and
     * <code>LatestRestorableDateTime</code>. You can restore your table to any point in time in the last 35 days. You
     * can set the recovery period to any value between 1 and 35 days. Any number of users can execute up to 50
     * concurrent restores (any type of restore) in a given account.
     * </p>
     * <p>
     * When you restore using point in time recovery, DynamoDB restores your table data to the state based on the
     * selected date and time (day:hour:minute:second) to a new table.
     * </p>
     * <p>
     * Along with data, the following are also included on the new restored table using point in time recovery:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Global secondary indexes (GSIs)
     * </p>
     * </li>
     * <li>
     * <p>
     * Local secondary indexes (LSIs)
     * </p>
     * </li>
     * <li>
     * <p>
     * Provisioned read and write capacity
     * </p>
     * </li>
     * <li>
     * <p>
     * Encryption settings
     * </p>
     * <important>
     * <p>
     * All these settings come from the current settings of the source table at the time of restore.
     * </p>
     * </important></li>
     * </ul>
     * <p>
     * You must manually set up the following on the restored table:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Auto scaling policies
     * </p>
     * </li>
     * <li>
     * <p>
     * IAM policies
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon CloudWatch metrics and alarms
     * </p>
     * </li>
     * <li>
     * <p>
     * Tags
     * </p>
     * </li>
     * <li>
     * <p>
     * Stream settings
     * </p>
     * </li>
     * <li>
     * <p>
     * Time to Live (TTL) settings
     * </p>
     * </li>
     * <li>
     * <p>
     * Point in time recovery settings
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreTableToPointInTimeRequest.Builder} avoiding
     * the need to create one manually via {@link RestoreTableToPointInTimeRequest#builder()}
     * </p>
     *
     * @param restoreTableToPointInTimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RestoreTableToPointInTime operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TableAlreadyExistsException A target table with the specified name already exists.</li>
     *         <li>TableNotFoundException A source table with the name <code>TableName</code> does not currently exist
     *         within the subscriber's account or the subscriber is operating in the wrong Amazon Web Services Region.</li>
     *         <li>TableInUseException A target table with the specified name is either being created or deleted.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InvalidRestoreTimeException An invalid restore time was specified. RestoreDateTime must be between
     *         EarliestRestorableDateTime and LatestRestorableDateTime.</li>
     *         <li>PointInTimeRecoveryUnavailableException Point in time recovery has not yet been enabled for this
     *         source table.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.RestoreTableToPointInTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/RestoreTableToPointInTime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreTableToPointInTimeResponse> restoreTableToPointInTime(
            Consumer<RestoreTableToPointInTimeRequest.Builder> restoreTableToPointInTimeRequest) {
        return restoreTableToPointInTime(RestoreTableToPointInTimeRequest.builder()
                .applyMutation(restoreTableToPointInTimeRequest).build());
    }

    /**
     * <p>
     * The <code>Scan</code> operation returns one or more items and item attributes by accessing every item in a table
     * or a secondary index. To have DynamoDB return fewer items, you can provide a <code>FilterExpression</code>
     * operation.
     * </p>
     * <p>
     * If the total size of scanned items exceeds the maximum dataset size limit of 1 MB, the scan completes and results
     * are returned to the user. The <code>LastEvaluatedKey</code> value is also returned and the requestor can use the
     * <code>LastEvaluatedKey</code> to continue the scan in a subsequent operation. Each scan response also includes
     * number of items that were scanned (ScannedCount) as part of the request. If using a <code>FilterExpression</code>
     * , a scan result can result in no items meeting the criteria and the <code>Count</code> will result in zero. If
     * you did not use a <code>FilterExpression</code> in the scan request, then <code>Count</code> is the same as
     * <code>ScannedCount</code>.
     * </p>
     * <note>
     * <p>
     * <code>Count</code> and <code>ScannedCount</code> only return the count of items specific to a single scan request
     * and, unless the table is less than 1MB, do not represent the total number of items in the table.
     * </p>
     * </note>
     * <p>
     * A single <code>Scan</code> operation first reads up to the maximum number of items set (if using the
     * <code>Limit</code> parameter) or a maximum of 1 MB of data and then applies any filtering to the results if a
     * <code>FilterExpression</code> is provided. If <code>LastEvaluatedKey</code> is present in the response,
     * pagination is required to complete the full table scan. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Scan.html#Scan.Pagination">Paginating the
     * Results</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * <code>Scan</code> operations proceed sequentially; however, for faster performance on a large table or secondary
     * index, applications can request a parallel <code>Scan</code> operation by providing the <code>Segment</code> and
     * <code>TotalSegments</code> parameters. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Scan.html#Scan.ParallelScan">Parallel
     * Scan</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * By default, a <code>Scan</code> uses eventually consistent reads when accessing the items in a table. Therefore,
     * the results from an eventually consistent <code>Scan</code> may not include the latest item changes at the time
     * the scan iterates through each item in the table. If you require a strongly consistent read of each item as the
     * scan iterates through the items in the table, you can set the <code>ConsistentRead</code> parameter to true.
     * Strong consistency only relates to the consistency of the read at the item level.
     * </p>
     * <note>
     * <p>
     * DynamoDB does not provide snapshot isolation for a scan operation when the <code>ConsistentRead</code> parameter
     * is set to true. Thus, a DynamoDB scan operation does not guarantee that all reads in a scan see a consistent
     * snapshot of the table when the scan operation was requested.
     * </p>
     * </note>
     *
     * @param scanRequest
     *        Represents the input of a <code>Scan</code> operation.
     * @return A Java Future containing the result of the Scan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.Scan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Scan" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scan_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<ScanResponse> scan(ScanRequest scanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>Scan</code> operation returns one or more items and item attributes by accessing every item in a table
     * or a secondary index. To have DynamoDB return fewer items, you can provide a <code>FilterExpression</code>
     * operation.
     * </p>
     * <p>
     * If the total size of scanned items exceeds the maximum dataset size limit of 1 MB, the scan completes and results
     * are returned to the user. The <code>LastEvaluatedKey</code> value is also returned and the requestor can use the
     * <code>LastEvaluatedKey</code> to continue the scan in a subsequent operation. Each scan response also includes
     * number of items that were scanned (ScannedCount) as part of the request. If using a <code>FilterExpression</code>
     * , a scan result can result in no items meeting the criteria and the <code>Count</code> will result in zero. If
     * you did not use a <code>FilterExpression</code> in the scan request, then <code>Count</code> is the same as
     * <code>ScannedCount</code>.
     * </p>
     * <note>
     * <p>
     * <code>Count</code> and <code>ScannedCount</code> only return the count of items specific to a single scan request
     * and, unless the table is less than 1MB, do not represent the total number of items in the table.
     * </p>
     * </note>
     * <p>
     * A single <code>Scan</code> operation first reads up to the maximum number of items set (if using the
     * <code>Limit</code> parameter) or a maximum of 1 MB of data and then applies any filtering to the results if a
     * <code>FilterExpression</code> is provided. If <code>LastEvaluatedKey</code> is present in the response,
     * pagination is required to complete the full table scan. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Scan.html#Scan.Pagination">Paginating the
     * Results</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * <code>Scan</code> operations proceed sequentially; however, for faster performance on a large table or secondary
     * index, applications can request a parallel <code>Scan</code> operation by providing the <code>Segment</code> and
     * <code>TotalSegments</code> parameters. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Scan.html#Scan.ParallelScan">Parallel
     * Scan</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * By default, a <code>Scan</code> uses eventually consistent reads when accessing the items in a table. Therefore,
     * the results from an eventually consistent <code>Scan</code> may not include the latest item changes at the time
     * the scan iterates through each item in the table. If you require a strongly consistent read of each item as the
     * scan iterates through the items in the table, you can set the <code>ConsistentRead</code> parameter to true.
     * Strong consistency only relates to the consistency of the read at the item level.
     * </p>
     * <note>
     * <p>
     * DynamoDB does not provide snapshot isolation for a scan operation when the <code>ConsistentRead</code> parameter
     * is set to true. Thus, a DynamoDB scan operation does not guarantee that all reads in a scan see a consistent
     * snapshot of the table when the scan operation was requested.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ScanRequest.Builder} avoiding the need to create
     * one manually via {@link ScanRequest#builder()}
     * </p>
     *
     * @param scanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.ScanRequest.Builder} to create a request. Represents
     *        the input of a <code>Scan</code> operation.
     * @return A Java Future containing the result of the Scan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.Scan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Scan" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scan_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<ScanResponse> scan(Consumer<ScanRequest.Builder> scanRequest) {
        return scan(ScanRequest.builder().applyMutation(scanRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #scan(software.amazon.awssdk.services.dynamodb.model.ScanRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ScanPublisher publisher = client.scanPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ScanPublisher publisher = client.scanPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.dynamodb.model.ScanResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.dynamodb.model.ScanResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #scan(software.amazon.awssdk.services.dynamodb.model.ScanRequest)} operation.</b>
     * </p>
     *
     * @param scanRequest
     *        Represents the input of a <code>Scan</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.Scan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Scan" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scan_section.html"
     *      target="_top">Code Example</a>
     */
    default ScanPublisher scanPaginator(ScanRequest scanRequest) {
        return new ScanPublisher(this, scanRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #scan(software.amazon.awssdk.services.dynamodb.model.ScanRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ScanPublisher publisher = client.scanPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.dynamodb.paginators.ScanPublisher publisher = client.scanPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.dynamodb.model.ScanResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.dynamodb.model.ScanResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #scan(software.amazon.awssdk.services.dynamodb.model.ScanRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ScanRequest.Builder} avoiding the need to create
     * one manually via {@link ScanRequest#builder()}
     * </p>
     *
     * @param scanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.ScanRequest.Builder} to create a request. Represents
     *        the input of a <code>Scan</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.Scan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Scan" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scan_section.html"
     *      target="_top">Code Example</a>
     */
    default ScanPublisher scanPaginator(Consumer<ScanRequest.Builder> scanRequest) {
        return scanPaginator(ScanRequest.builder().applyMutation(scanRequest).build());
    }

    /**
     * <p>
     * Associate a set of tags with an Amazon DynamoDB resource. You can then activate these user-defined tags so that
     * they appear on the Billing and Cost Management console for cost allocation tracking. You can call TagResource up
     * to five times per second, per account.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TagResource</code> is an asynchronous operation. If you issue a <a>ListTagsOfResource</a> request
     * immediately after a <code>TagResource</code> request, DynamoDB might return your previous tag set, if there was
     * one, or an empty tag set. This is because <code>ListTagsOfResource</code> uses an eventually consistent query,
     * and the metadata for your tags or table might not be available at that moment. Wait for a few seconds, and then
     * try the <code>ListTagsOfResource</code> request again.
     * </p>
     * </li>
     * <li>
     * <p>
     * The application or removal of tags using <code>TagResource</code> and <code>UntagResource</code> APIs is
     * eventually consistent. <code>ListTagsOfResource</code> API will only reflect the changes after a few seconds.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For an overview on tagging DynamoDB resources, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate a set of tags with an Amazon DynamoDB resource. You can then activate these user-defined tags so that
     * they appear on the Billing and Cost Management console for cost allocation tracking. You can call TagResource up
     * to five times per second, per account.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TagResource</code> is an asynchronous operation. If you issue a <a>ListTagsOfResource</a> request
     * immediately after a <code>TagResource</code> request, DynamoDB might return your previous tag set, if there was
     * one, or an empty tag set. This is because <code>ListTagsOfResource</code> uses an eventually consistent query,
     * and the metadata for your tags or table might not be available at that moment. Wait for a few seconds, and then
     * try the <code>ListTagsOfResource</code> request again.
     * </p>
     * </li>
     * <li>
     * <p>
     * The application or removal of tags using <code>TagResource</code> and <code>UntagResource</code> APIs is
     * eventually consistent. <code>ListTagsOfResource</code> API will only reflect the changes after a few seconds.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For an overview on tagging DynamoDB resources, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * <code>TransactGetItems</code> is a synchronous operation that atomically retrieves multiple items from one or
     * more tables (but not from indexes) in a single account and Region. A <code>TransactGetItems</code> call can
     * contain up to 100 <code>TransactGetItem</code> objects, each of which contains a <code>Get</code> structure that
     * specifies an item to retrieve from a table in the account and Region. A call to <code>TransactGetItems</code>
     * cannot retrieve items from tables in more than one Amazon Web Services account or Region. The aggregate size of
     * the items in the transaction cannot exceed 4 MB.
     * </p>
     * <p>
     * DynamoDB rejects the entire <code>TransactGetItems</code> request if any of the following is true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A conflicting operation is in the process of updating an item to be read.
     * </p>
     * </li>
     * <li>
     * <p>
     * There is insufficient provisioned capacity for the transaction to be completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * There is a user error, such as an invalid data format.
     * </p>
     * </li>
     * <li>
     * <p>
     * The aggregate size of the items in the transaction exceeded 4 MB.
     * </p>
     * </li>
     * </ul>
     *
     * @param transactGetItemsRequest
     * @return A Java Future containing the result of the TransactGetItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>TransactionCanceledException The entire transaction request was canceled.</p>
     *         <p>
     *         DynamoDB cancels a <code>TransactWriteItems</code> request under the following circumstances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A condition in one of the condition expressions is not met.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A table in the <code>TransactWriteItems</code> request is in a different account or region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         More than one action in the <code>TransactWriteItems</code> operation targets the same item.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is insufficient provisioned capacity for the transaction to be completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An item size becomes too large (larger than 400 KB), or a local secondary index (LSI) becomes too large,
     *         or a similar validation error occurs because of changes made by the transaction.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a user error, such as an invalid data format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is an ongoing <code>TransactWriteItems</code> operation that conflicts with a concurrent
     *         <code>TransactWriteItems</code> request. In this case the <code>TransactWriteItems</code> operation fails
     *         with a <code>TransactionCanceledException</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         DynamoDB cancels a <code>TransactGetItems</code> request under the following circumstances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There is an ongoing <code>TransactGetItems</code> operation that conflicts with a concurrent
     *         <code>PutItem</code>, <code>UpdateItem</code>, <code>DeleteItem</code> or <code>TransactWriteItems</code>
     *         request. In this case the <code>TransactGetItems</code> operation fails with a
     *         <code>TransactionCanceledException</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A table in the <code>TransactGetItems</code> request is in a different account or region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is insufficient provisioned capacity for the transaction to be completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a user error, such as an invalid data format.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         DynamoDB lists the cancellation reasons on the <code>CancellationReasons</code> property. Transaction
     *         cancellation reasons are ordered in the order of requested items, if an item has no error it will have
     *         <code>None</code> code and <code>Null</code> message.
     *         </p>
     *         </note>
     *         <p>
     *         Cancellation reason codes and possible error messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No Errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>None</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: <code>null</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Conditional Check Failed:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ConditionalCheckFailed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: The conditional request failed.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Item Collection Size Limit Exceeded:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ItemCollectionSizeLimitExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: Collection size exceeded.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Transaction Conflict:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>TransactionConflict</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: Transaction is ongoing for the item.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned Throughput Exceeded:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The level of configured provisioned throughput for the table was exceeded. Consider increasing your
     *         provisioning level with the UpdateTable API.
     *         </p>
     *         <note>
     *         <p>
     *         This Message is received when provisioned throughput is exceeded is on a provisioned DynamoDB table.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         The level of configured provisioned throughput for one or more global secondary indexes of the table was
     *         exceeded. Consider increasing your provisioning level for the under-provisioned global secondary indexes
     *         with the UpdateTable API.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when provisioned throughput is exceeded is on a provisioned GSI.
     *         </p>
     *         </note></li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Throttling Error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ThrottlingError</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Throughput exceeds the current capacity of your table or index. DynamoDB is automatically scaling your
     *         table or index so please try again shortly. If exceptions persist, check if you have a hot key:
     *         https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/bp-partition-key-design.html.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when writes get throttled on an On-Demand table as DynamoDB is automatically
     *         scaling the table.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         Throughput exceeds the current capacity for one or more global secondary indexes. DynamoDB is
     *         automatically scaling your index so please try again shortly.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when writes get throttled on an On-Demand GSI as DynamoDB is automatically
     *         scaling the GSI.
     *         </p>
     *         </note></li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Validation Error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ValidationError</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         One or more parameter values were invalid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The update expression attempted to update the secondary index key beyond allowed size limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The update expression attempted to update the secondary index key to unsupported type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An operand in the update expression has an incorrect data type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Item size to update has exceeded the maximum allowed size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Number overflow. Attempting to store a number with magnitude larger than supported range.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type mismatch for attribute to update.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Nesting Levels have exceeded supported limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The document path provided in the update expression is invalid for update.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The provided expression refers to an attribute that does not exist in the item.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.TransactGetItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TransactGetItems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TransactGetItemsResponse> transactGetItems(TransactGetItemsRequest transactGetItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <code>TransactGetItems</code> is a synchronous operation that atomically retrieves multiple items from one or
     * more tables (but not from indexes) in a single account and Region. A <code>TransactGetItems</code> call can
     * contain up to 100 <code>TransactGetItem</code> objects, each of which contains a <code>Get</code> structure that
     * specifies an item to retrieve from a table in the account and Region. A call to <code>TransactGetItems</code>
     * cannot retrieve items from tables in more than one Amazon Web Services account or Region. The aggregate size of
     * the items in the transaction cannot exceed 4 MB.
     * </p>
     * <p>
     * DynamoDB rejects the entire <code>TransactGetItems</code> request if any of the following is true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A conflicting operation is in the process of updating an item to be read.
     * </p>
     * </li>
     * <li>
     * <p>
     * There is insufficient provisioned capacity for the transaction to be completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * There is a user error, such as an invalid data format.
     * </p>
     * </li>
     * <li>
     * <p>
     * The aggregate size of the items in the transaction exceeded 4 MB.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TransactGetItemsRequest.Builder} avoiding the need
     * to create one manually via {@link TransactGetItemsRequest#builder()}
     * </p>
     *
     * @param transactGetItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TransactGetItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>TransactionCanceledException The entire transaction request was canceled.</p>
     *         <p>
     *         DynamoDB cancels a <code>TransactWriteItems</code> request under the following circumstances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A condition in one of the condition expressions is not met.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A table in the <code>TransactWriteItems</code> request is in a different account or region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         More than one action in the <code>TransactWriteItems</code> operation targets the same item.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is insufficient provisioned capacity for the transaction to be completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An item size becomes too large (larger than 400 KB), or a local secondary index (LSI) becomes too large,
     *         or a similar validation error occurs because of changes made by the transaction.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a user error, such as an invalid data format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is an ongoing <code>TransactWriteItems</code> operation that conflicts with a concurrent
     *         <code>TransactWriteItems</code> request. In this case the <code>TransactWriteItems</code> operation fails
     *         with a <code>TransactionCanceledException</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         DynamoDB cancels a <code>TransactGetItems</code> request under the following circumstances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There is an ongoing <code>TransactGetItems</code> operation that conflicts with a concurrent
     *         <code>PutItem</code>, <code>UpdateItem</code>, <code>DeleteItem</code> or <code>TransactWriteItems</code>
     *         request. In this case the <code>TransactGetItems</code> operation fails with a
     *         <code>TransactionCanceledException</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A table in the <code>TransactGetItems</code> request is in a different account or region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is insufficient provisioned capacity for the transaction to be completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a user error, such as an invalid data format.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         DynamoDB lists the cancellation reasons on the <code>CancellationReasons</code> property. Transaction
     *         cancellation reasons are ordered in the order of requested items, if an item has no error it will have
     *         <code>None</code> code and <code>Null</code> message.
     *         </p>
     *         </note>
     *         <p>
     *         Cancellation reason codes and possible error messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No Errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>None</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: <code>null</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Conditional Check Failed:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ConditionalCheckFailed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: The conditional request failed.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Item Collection Size Limit Exceeded:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ItemCollectionSizeLimitExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: Collection size exceeded.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Transaction Conflict:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>TransactionConflict</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: Transaction is ongoing for the item.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned Throughput Exceeded:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The level of configured provisioned throughput for the table was exceeded. Consider increasing your
     *         provisioning level with the UpdateTable API.
     *         </p>
     *         <note>
     *         <p>
     *         This Message is received when provisioned throughput is exceeded is on a provisioned DynamoDB table.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         The level of configured provisioned throughput for one or more global secondary indexes of the table was
     *         exceeded. Consider increasing your provisioning level for the under-provisioned global secondary indexes
     *         with the UpdateTable API.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when provisioned throughput is exceeded is on a provisioned GSI.
     *         </p>
     *         </note></li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Throttling Error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ThrottlingError</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Throughput exceeds the current capacity of your table or index. DynamoDB is automatically scaling your
     *         table or index so please try again shortly. If exceptions persist, check if you have a hot key:
     *         https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/bp-partition-key-design.html.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when writes get throttled on an On-Demand table as DynamoDB is automatically
     *         scaling the table.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         Throughput exceeds the current capacity for one or more global secondary indexes. DynamoDB is
     *         automatically scaling your index so please try again shortly.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when writes get throttled on an On-Demand GSI as DynamoDB is automatically
     *         scaling the GSI.
     *         </p>
     *         </note></li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Validation Error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ValidationError</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         One or more parameter values were invalid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The update expression attempted to update the secondary index key beyond allowed size limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The update expression attempted to update the secondary index key to unsupported type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An operand in the update expression has an incorrect data type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Item size to update has exceeded the maximum allowed size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Number overflow. Attempting to store a number with magnitude larger than supported range.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type mismatch for attribute to update.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Nesting Levels have exceeded supported limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The document path provided in the update expression is invalid for update.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The provided expression refers to an attribute that does not exist in the item.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.TransactGetItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TransactGetItems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TransactGetItemsResponse> transactGetItems(
            Consumer<TransactGetItemsRequest.Builder> transactGetItemsRequest) {
        return transactGetItems(TransactGetItemsRequest.builder().applyMutation(transactGetItemsRequest).build());
    }

    /**
     * <p>
     * <code>TransactWriteItems</code> is a synchronous write operation that groups up to 100 action requests. These
     * actions can target items in different tables, but not in different Amazon Web Services accounts or Regions, and
     * no two actions can target the same item. For example, you cannot both <code>ConditionCheck</code> and
     * <code>Update</code> the same item. The aggregate size of the items in the transaction cannot exceed 4 MB.
     * </p>
     * <p>
     * The actions are completed atomically so that either all of them succeed, or all of them fail. They are defined by
     * the following objects:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Put</code>  —   Initiates a <code>PutItem</code> operation to write a new item. This structure specifies
     * the primary key of the item to be written, the name of the table to write it in, an optional condition expression
     * that must be satisfied for the write to succeed, a list of the item's attributes, and a field indicating whether
     * to retrieve the item's attributes if the condition is not met.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Update</code>  —   Initiates an <code>UpdateItem</code> operation to update an existing item. This
     * structure specifies the primary key of the item to be updated, the name of the table where it resides, an
     * optional condition expression that must be satisfied for the update to succeed, an expression that defines one or
     * more attributes to be updated, and a field indicating whether to retrieve the item's attributes if the condition
     * is not met.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Delete</code>  —   Initiates a <code>DeleteItem</code> operation to delete an existing item. This structure
     * specifies the primary key of the item to be deleted, the name of the table where it resides, an optional
     * condition expression that must be satisfied for the deletion to succeed, and a field indicating whether to
     * retrieve the item's attributes if the condition is not met.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ConditionCheck</code>  —   Applies a condition to an item that is not being modified by the transaction.
     * This structure specifies the primary key of the item to be checked, the name of the table where it resides, a
     * condition expression that must be satisfied for the transaction to succeed, and a field indicating whether to
     * retrieve the item's attributes if the condition is not met.
     * </p>
     * </li>
     * </ul>
     * <p>
     * DynamoDB rejects the entire <code>TransactWriteItems</code> request if any of the following is true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A condition in one of the condition expressions is not met.
     * </p>
     * </li>
     * <li>
     * <p>
     * An ongoing operation is in the process of updating the same item.
     * </p>
     * </li>
     * <li>
     * <p>
     * There is insufficient provisioned capacity for the transaction to be completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * An item size becomes too large (bigger than 400 KB), a local secondary index (LSI) becomes too large, or a
     * similar validation error occurs because of changes made by the transaction.
     * </p>
     * </li>
     * <li>
     * <p>
     * The aggregate size of the items in the transaction exceeds 4 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * There is a user error, such as an invalid data format.
     * </p>
     * </li>
     * </ul>
     *
     * @param transactWriteItemsRequest
     * @return A Java Future containing the result of the TransactWriteItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>TransactionCanceledException The entire transaction request was canceled.</p>
     *         <p>
     *         DynamoDB cancels a <code>TransactWriteItems</code> request under the following circumstances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A condition in one of the condition expressions is not met.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A table in the <code>TransactWriteItems</code> request is in a different account or region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         More than one action in the <code>TransactWriteItems</code> operation targets the same item.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is insufficient provisioned capacity for the transaction to be completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An item size becomes too large (larger than 400 KB), or a local secondary index (LSI) becomes too large,
     *         or a similar validation error occurs because of changes made by the transaction.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a user error, such as an invalid data format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is an ongoing <code>TransactWriteItems</code> operation that conflicts with a concurrent
     *         <code>TransactWriteItems</code> request. In this case the <code>TransactWriteItems</code> operation fails
     *         with a <code>TransactionCanceledException</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         DynamoDB cancels a <code>TransactGetItems</code> request under the following circumstances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There is an ongoing <code>TransactGetItems</code> operation that conflicts with a concurrent
     *         <code>PutItem</code>, <code>UpdateItem</code>, <code>DeleteItem</code> or <code>TransactWriteItems</code>
     *         request. In this case the <code>TransactGetItems</code> operation fails with a
     *         <code>TransactionCanceledException</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A table in the <code>TransactGetItems</code> request is in a different account or region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is insufficient provisioned capacity for the transaction to be completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a user error, such as an invalid data format.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         DynamoDB lists the cancellation reasons on the <code>CancellationReasons</code> property. Transaction
     *         cancellation reasons are ordered in the order of requested items, if an item has no error it will have
     *         <code>None</code> code and <code>Null</code> message.
     *         </p>
     *         </note>
     *         <p>
     *         Cancellation reason codes and possible error messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No Errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>None</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: <code>null</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Conditional Check Failed:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ConditionalCheckFailed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: The conditional request failed.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Item Collection Size Limit Exceeded:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ItemCollectionSizeLimitExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: Collection size exceeded.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Transaction Conflict:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>TransactionConflict</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: Transaction is ongoing for the item.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned Throughput Exceeded:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The level of configured provisioned throughput for the table was exceeded. Consider increasing your
     *         provisioning level with the UpdateTable API.
     *         </p>
     *         <note>
     *         <p>
     *         This Message is received when provisioned throughput is exceeded is on a provisioned DynamoDB table.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         The level of configured provisioned throughput for one or more global secondary indexes of the table was
     *         exceeded. Consider increasing your provisioning level for the under-provisioned global secondary indexes
     *         with the UpdateTable API.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when provisioned throughput is exceeded is on a provisioned GSI.
     *         </p>
     *         </note></li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Throttling Error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ThrottlingError</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Throughput exceeds the current capacity of your table or index. DynamoDB is automatically scaling your
     *         table or index so please try again shortly. If exceptions persist, check if you have a hot key:
     *         https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/bp-partition-key-design.html.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when writes get throttled on an On-Demand table as DynamoDB is automatically
     *         scaling the table.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         Throughput exceeds the current capacity for one or more global secondary indexes. DynamoDB is
     *         automatically scaling your index so please try again shortly.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when writes get throttled on an On-Demand GSI as DynamoDB is automatically
     *         scaling the GSI.
     *         </p>
     *         </note></li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Validation Error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ValidationError</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         One or more parameter values were invalid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The update expression attempted to update the secondary index key beyond allowed size limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The update expression attempted to update the secondary index key to unsupported type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An operand in the update expression has an incorrect data type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Item size to update has exceeded the maximum allowed size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Number overflow. Attempting to store a number with magnitude larger than supported range.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type mismatch for attribute to update.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Nesting Levels have exceeded supported limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The document path provided in the update expression is invalid for update.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The provided expression refers to an attribute that does not exist in the item.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>TransactionInProgressException The transaction with the given request token is already in
     *         progress.</p>
     *         <p>
     *         Recommended Settings
     *         </p>
     *         <note>
     *         <p>
     *         This is a general recommendation for handling the <code>TransactionInProgressException</code>. These
     *         settings help ensure that the client retries will trigger completion of the ongoing
     *         <code>TransactWriteItems</code> request.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         Set <code>clientExecutionTimeout</code> to a value that allows at least one retry to be processed after 5
     *         seconds have elapsed since the first attempt for the <code>TransactWriteItems</code> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set <code>socketTimeout</code> to a value a little lower than the <code>requestTimeout</code> setting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requestTimeout</code> should be set based on the time taken for the individual retries of a single
     *         HTTP request for your use case, but setting it to 1 second or higher should work well to reduce chances
     *         of retries and <code>TransactionInProgressException</code> errors.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use exponential backoff when retrying and tune backoff if needed.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Assuming <a href=
     *         "https://github.com/aws/aws-sdk-java/blob/fd409dee8ae23fb8953e0bb4dbde65536a7e0514/aws-java-sdk-core/src/main/java/com/amazonaws/retry/PredefinedRetryPolicies.java#L97"
     *         >default retry policy</a>, example timeout settings based on the guidelines above are as follows:
     *         </p>
     *         <p>
     *         Example timeline:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         0-1000 first attempt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1000-1500 first sleep/delay (default retry policy uses 500 ms as base delay for 4xx errors)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1500-2500 second attempt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2500-3500 second sleep/delay (500 * 2, exponential backoff)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3500-4500 third attempt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         4500-6500 third sleep/delay (500 * 2^2)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         6500-7500 fourth attempt (this can trigger inline recovery since 5 seconds have elapsed since the first
     *         attempt reached TC)
     *         </p>
     *         </li></li>
     *         <li>IdempotentParameterMismatchException DynamoDB rejected the request because you retried a request with
     *         a different payload but with an idempotent token that was already used.</li>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.TransactWriteItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TransactWriteItems" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TransactWriteItemsResponse> transactWriteItems(TransactWriteItemsRequest transactWriteItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <code>TransactWriteItems</code> is a synchronous write operation that groups up to 100 action requests. These
     * actions can target items in different tables, but not in different Amazon Web Services accounts or Regions, and
     * no two actions can target the same item. For example, you cannot both <code>ConditionCheck</code> and
     * <code>Update</code> the same item. The aggregate size of the items in the transaction cannot exceed 4 MB.
     * </p>
     * <p>
     * The actions are completed atomically so that either all of them succeed, or all of them fail. They are defined by
     * the following objects:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Put</code>  —   Initiates a <code>PutItem</code> operation to write a new item. This structure specifies
     * the primary key of the item to be written, the name of the table to write it in, an optional condition expression
     * that must be satisfied for the write to succeed, a list of the item's attributes, and a field indicating whether
     * to retrieve the item's attributes if the condition is not met.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Update</code>  —   Initiates an <code>UpdateItem</code> operation to update an existing item. This
     * structure specifies the primary key of the item to be updated, the name of the table where it resides, an
     * optional condition expression that must be satisfied for the update to succeed, an expression that defines one or
     * more attributes to be updated, and a field indicating whether to retrieve the item's attributes if the condition
     * is not met.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Delete</code>  —   Initiates a <code>DeleteItem</code> operation to delete an existing item. This structure
     * specifies the primary key of the item to be deleted, the name of the table where it resides, an optional
     * condition expression that must be satisfied for the deletion to succeed, and a field indicating whether to
     * retrieve the item's attributes if the condition is not met.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ConditionCheck</code>  —   Applies a condition to an item that is not being modified by the transaction.
     * This structure specifies the primary key of the item to be checked, the name of the table where it resides, a
     * condition expression that must be satisfied for the transaction to succeed, and a field indicating whether to
     * retrieve the item's attributes if the condition is not met.
     * </p>
     * </li>
     * </ul>
     * <p>
     * DynamoDB rejects the entire <code>TransactWriteItems</code> request if any of the following is true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A condition in one of the condition expressions is not met.
     * </p>
     * </li>
     * <li>
     * <p>
     * An ongoing operation is in the process of updating the same item.
     * </p>
     * </li>
     * <li>
     * <p>
     * There is insufficient provisioned capacity for the transaction to be completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * An item size becomes too large (bigger than 400 KB), a local secondary index (LSI) becomes too large, or a
     * similar validation error occurs because of changes made by the transaction.
     * </p>
     * </li>
     * <li>
     * <p>
     * The aggregate size of the items in the transaction exceeds 4 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * There is a user error, such as an invalid data format.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TransactWriteItemsRequest.Builder} avoiding the
     * need to create one manually via {@link TransactWriteItemsRequest#builder()}
     * </p>
     *
     * @param transactWriteItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TransactWriteItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>TransactionCanceledException The entire transaction request was canceled.</p>
     *         <p>
     *         DynamoDB cancels a <code>TransactWriteItems</code> request under the following circumstances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A condition in one of the condition expressions is not met.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A table in the <code>TransactWriteItems</code> request is in a different account or region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         More than one action in the <code>TransactWriteItems</code> operation targets the same item.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is insufficient provisioned capacity for the transaction to be completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An item size becomes too large (larger than 400 KB), or a local secondary index (LSI) becomes too large,
     *         or a similar validation error occurs because of changes made by the transaction.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a user error, such as an invalid data format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is an ongoing <code>TransactWriteItems</code> operation that conflicts with a concurrent
     *         <code>TransactWriteItems</code> request. In this case the <code>TransactWriteItems</code> operation fails
     *         with a <code>TransactionCanceledException</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         DynamoDB cancels a <code>TransactGetItems</code> request under the following circumstances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There is an ongoing <code>TransactGetItems</code> operation that conflicts with a concurrent
     *         <code>PutItem</code>, <code>UpdateItem</code>, <code>DeleteItem</code> or <code>TransactWriteItems</code>
     *         request. In this case the <code>TransactGetItems</code> operation fails with a
     *         <code>TransactionCanceledException</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A table in the <code>TransactGetItems</code> request is in a different account or region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is insufficient provisioned capacity for the transaction to be completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a user error, such as an invalid data format.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         DynamoDB lists the cancellation reasons on the <code>CancellationReasons</code> property. Transaction
     *         cancellation reasons are ordered in the order of requested items, if an item has no error it will have
     *         <code>None</code> code and <code>Null</code> message.
     *         </p>
     *         </note>
     *         <p>
     *         Cancellation reason codes and possible error messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No Errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>None</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: <code>null</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Conditional Check Failed:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ConditionalCheckFailed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: The conditional request failed.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Item Collection Size Limit Exceeded:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ItemCollectionSizeLimitExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: Collection size exceeded.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Transaction Conflict:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>TransactionConflict</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: Transaction is ongoing for the item.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned Throughput Exceeded:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The level of configured provisioned throughput for the table was exceeded. Consider increasing your
     *         provisioning level with the UpdateTable API.
     *         </p>
     *         <note>
     *         <p>
     *         This Message is received when provisioned throughput is exceeded is on a provisioned DynamoDB table.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         The level of configured provisioned throughput for one or more global secondary indexes of the table was
     *         exceeded. Consider increasing your provisioning level for the under-provisioned global secondary indexes
     *         with the UpdateTable API.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when provisioned throughput is exceeded is on a provisioned GSI.
     *         </p>
     *         </note></li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Throttling Error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ThrottlingError</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Throughput exceeds the current capacity of your table or index. DynamoDB is automatically scaling your
     *         table or index so please try again shortly. If exceptions persist, check if you have a hot key:
     *         https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/bp-partition-key-design.html.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when writes get throttled on an On-Demand table as DynamoDB is automatically
     *         scaling the table.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         Throughput exceeds the current capacity for one or more global secondary indexes. DynamoDB is
     *         automatically scaling your index so please try again shortly.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when writes get throttled on an On-Demand GSI as DynamoDB is automatically
     *         scaling the GSI.
     *         </p>
     *         </note></li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Validation Error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ValidationError</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         One or more parameter values were invalid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The update expression attempted to update the secondary index key beyond allowed size limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The update expression attempted to update the secondary index key to unsupported type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An operand in the update expression has an incorrect data type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Item size to update has exceeded the maximum allowed size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Number overflow. Attempting to store a number with magnitude larger than supported range.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type mismatch for attribute to update.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Nesting Levels have exceeded supported limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The document path provided in the update expression is invalid for update.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The provided expression refers to an attribute that does not exist in the item.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>TransactionInProgressException The transaction with the given request token is already in
     *         progress.</p>
     *         <p>
     *         Recommended Settings
     *         </p>
     *         <note>
     *         <p>
     *         This is a general recommendation for handling the <code>TransactionInProgressException</code>. These
     *         settings help ensure that the client retries will trigger completion of the ongoing
     *         <code>TransactWriteItems</code> request.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         Set <code>clientExecutionTimeout</code> to a value that allows at least one retry to be processed after 5
     *         seconds have elapsed since the first attempt for the <code>TransactWriteItems</code> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set <code>socketTimeout</code> to a value a little lower than the <code>requestTimeout</code> setting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requestTimeout</code> should be set based on the time taken for the individual retries of a single
     *         HTTP request for your use case, but setting it to 1 second or higher should work well to reduce chances
     *         of retries and <code>TransactionInProgressException</code> errors.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use exponential backoff when retrying and tune backoff if needed.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Assuming <a href=
     *         "https://github.com/aws/aws-sdk-java/blob/fd409dee8ae23fb8953e0bb4dbde65536a7e0514/aws-java-sdk-core/src/main/java/com/amazonaws/retry/PredefinedRetryPolicies.java#L97"
     *         >default retry policy</a>, example timeout settings based on the guidelines above are as follows:
     *         </p>
     *         <p>
     *         Example timeline:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         0-1000 first attempt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1000-1500 first sleep/delay (default retry policy uses 500 ms as base delay for 4xx errors)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1500-2500 second attempt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2500-3500 second sleep/delay (500 * 2, exponential backoff)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3500-4500 third attempt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         4500-6500 third sleep/delay (500 * 2^2)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         6500-7500 fourth attempt (this can trigger inline recovery since 5 seconds have elapsed since the first
     *         attempt reached TC)
     *         </p>
     *         </li></li>
     *         <li>IdempotentParameterMismatchException DynamoDB rejected the request because you retried a request with
     *         a different payload but with an idempotent token that was already used.</li>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.TransactWriteItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TransactWriteItems" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TransactWriteItemsResponse> transactWriteItems(
            Consumer<TransactWriteItemsRequest.Builder> transactWriteItemsRequest) {
        return transactWriteItems(TransactWriteItemsRequest.builder().applyMutation(transactWriteItemsRequest).build());
    }

    /**
     * <p>
     * Removes the association of tags from an Amazon DynamoDB resource. You can call <code>UntagResource</code> up to
     * five times per second, per account.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>UntagResource</code> is an asynchronous operation. If you issue a <a>ListTagsOfResource</a> request
     * immediately after an <code>UntagResource</code> request, DynamoDB might return your previous tag set, if there
     * was one, or an empty tag set. This is because <code>ListTagsOfResource</code> uses an eventually consistent
     * query, and the metadata for your tags or table might not be available at that moment. Wait for a few seconds, and
     * then try the <code>ListTagsOfResource</code> request again.
     * </p>
     * </li>
     * <li>
     * <p>
     * The application or removal of tags using <code>TagResource</code> and <code>UntagResource</code> APIs is
     * eventually consistent. <code>ListTagsOfResource</code> API will only reflect the changes after a few seconds.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For an overview on tagging DynamoDB resources, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association of tags from an Amazon DynamoDB resource. You can call <code>UntagResource</code> up to
     * five times per second, per account.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>UntagResource</code> is an asynchronous operation. If you issue a <a>ListTagsOfResource</a> request
     * immediately after an <code>UntagResource</code> request, DynamoDB might return your previous tag set, if there
     * was one, or an empty tag set. This is because <code>ListTagsOfResource</code> uses an eventually consistent
     * query, and the metadata for your tags or table might not be available at that moment. Wait for a few seconds, and
     * then try the <code>ListTagsOfResource</code> request again.
     * </p>
     * </li>
     * <li>
     * <p>
     * The application or removal of tags using <code>TagResource</code> and <code>UntagResource</code> APIs is
     * eventually consistent. <code>ListTagsOfResource</code> API will only reflect the changes after a few seconds.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For an overview on tagging DynamoDB resources, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * <code>UpdateContinuousBackups</code> enables or disables point in time recovery for the specified table. A
     * successful <code>UpdateContinuousBackups</code> call returns the current
     * <code>ContinuousBackupsDescription</code>. Continuous backups are <code>ENABLED</code> on all tables at table
     * creation. If point in time recovery is enabled, <code>PointInTimeRecoveryStatus</code> will be set to ENABLED.
     * </p>
     * <p>
     * Once continuous backups and point in time recovery are enabled, you can restore to any point in time within
     * <code>EarliestRestorableDateTime</code> and <code>LatestRestorableDateTime</code>.
     * </p>
     * <p>
     * <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. You can restore your table
     * to any point in time in the last 35 days. You can set the <code>RecoveryPeriodInDays</code> to any value between
     * 1 and 35 days.
     * </p>
     *
     * @param updateContinuousBackupsRequest
     * @return A Java Future containing the result of the UpdateContinuousBackups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TableNotFoundException A source table with the name <code>TableName</code> does not currently exist
     *         within the subscriber's account or the subscriber is operating in the wrong Amazon Web Services Region.</li>
     *         <li>ContinuousBackupsUnavailableException Backups have not yet been enabled for this table.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UpdateContinuousBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateContinuousBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateContinuousBackupsResponse> updateContinuousBackups(
            UpdateContinuousBackupsRequest updateContinuousBackupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <code>UpdateContinuousBackups</code> enables or disables point in time recovery for the specified table. A
     * successful <code>UpdateContinuousBackups</code> call returns the current
     * <code>ContinuousBackupsDescription</code>. Continuous backups are <code>ENABLED</code> on all tables at table
     * creation. If point in time recovery is enabled, <code>PointInTimeRecoveryStatus</code> will be set to ENABLED.
     * </p>
     * <p>
     * Once continuous backups and point in time recovery are enabled, you can restore to any point in time within
     * <code>EarliestRestorableDateTime</code> and <code>LatestRestorableDateTime</code>.
     * </p>
     * <p>
     * <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. You can restore your table
     * to any point in time in the last 35 days. You can set the <code>RecoveryPeriodInDays</code> to any value between
     * 1 and 35 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContinuousBackupsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateContinuousBackupsRequest#builder()}
     * </p>
     *
     * @param updateContinuousBackupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateContinuousBackups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TableNotFoundException A source table with the name <code>TableName</code> does not currently exist
     *         within the subscriber's account or the subscriber is operating in the wrong Amazon Web Services Region.</li>
     *         <li>ContinuousBackupsUnavailableException Backups have not yet been enabled for this table.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UpdateContinuousBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateContinuousBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateContinuousBackupsResponse> updateContinuousBackups(
            Consumer<UpdateContinuousBackupsRequest.Builder> updateContinuousBackupsRequest) {
        return updateContinuousBackups(UpdateContinuousBackupsRequest.builder().applyMutation(updateContinuousBackupsRequest)
                .build());
    }

    /**
     * <p>
     * Updates the status for contributor insights for a specific table or index. CloudWatch Contributor Insights for
     * DynamoDB graphs display the partition key and (if applicable) sort key of frequently accessed items and
     * frequently throttled items in plaintext. If you require the use of Amazon Web Services Key Management Service
     * (KMS) to encrypt this table’s partition key and sort key data with an Amazon Web Services managed key or customer
     * managed key, you should not enable CloudWatch Contributor Insights for DynamoDB for this table.
     * </p>
     *
     * @param updateContributorInsightsRequest
     * @return A Java Future containing the result of the UpdateContributorInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UpdateContributorInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateContributorInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateContributorInsightsResponse> updateContributorInsights(
            UpdateContributorInsightsRequest updateContributorInsightsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the status for contributor insights for a specific table or index. CloudWatch Contributor Insights for
     * DynamoDB graphs display the partition key and (if applicable) sort key of frequently accessed items and
     * frequently throttled items in plaintext. If you require the use of Amazon Web Services Key Management Service
     * (KMS) to encrypt this table’s partition key and sort key data with an Amazon Web Services managed key or customer
     * managed key, you should not enable CloudWatch Contributor Insights for DynamoDB for this table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContributorInsightsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateContributorInsightsRequest#builder()}
     * </p>
     *
     * @param updateContributorInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateContributorInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UpdateContributorInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateContributorInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateContributorInsightsResponse> updateContributorInsights(
            Consumer<UpdateContributorInsightsRequest.Builder> updateContributorInsightsRequest) {
        return updateContributorInsights(UpdateContributorInsightsRequest.builder()
                .applyMutation(updateContributorInsightsRequest).build());
    }

    /**
     * <p>
     * Adds or removes replicas in the specified global table. The global table must already exist to be able to use
     * this operation. Any replica to be added must be empty, have the same name as the global table, have the same key
     * schema, have DynamoDB Streams enabled, and have the same provisioned and maximum write capacity units.
     * </p>
     * <important>
     * <p>
     * This documentation is for version 2017.11.29 (Legacy) of global tables, which should be avoided for new global
     * tables. Customers should use <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">Global Tables version
     * 2019.11.21 (Current)</a> when possible, because it provides greater flexibility, higher efficiency, and consumes
     * less write capacity than 2017.11.29 (Legacy).
     * </p>
     * <p>
     * To determine which version you're using, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.DetermineVersion.html"
     * >Determining the global table version you are using</a>. To update existing global tables from version 2017.11.29
     * (Legacy) to version 2019.11.21 (Current), see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/V2globaltables_upgrade.html">Upgrading
     * global tables</a>.
     * </p>
     * </important> <note>
     * <p>
     * If you are using global tables <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">Version 2019.11.21</a>
     * (Current) you can use <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateTable.html">UpdateTable</a>
     * instead.
     * </p>
     * <p>
     * Although you can use <code>UpdateGlobalTable</code> to add replicas and remove replicas in a single request, for
     * simplicity we recommend that you issue separate requests for adding or removing replicas.
     * </p>
     * </note>
     * <p>
     * If global secondary indexes are specified, then the following conditions must also be met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The global secondary indexes must have the same name.
     * </p>
     * </li>
     * <li>
     * <p>
     * The global secondary indexes must have the same hash key and sort key (if present).
     * </p>
     * </li>
     * <li>
     * <p>
     * The global secondary indexes must have the same provisioned and maximum write capacity units.
     * </p>
     * </li>
     * </ul>
     *
     * @param updateGlobalTableRequest
     * @return A Java Future containing the result of the UpdateGlobalTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>GlobalTableNotFoundException The specified global table does not exist.</li>
     *         <li>ReplicaAlreadyExistsException The specified replica is already part of the global table.</li>
     *         <li>ReplicaNotFoundException The specified replica is no longer part of the global table.</li>
     *         <li>TableNotFoundException A source table with the name <code>TableName</code> does not currently exist
     *         within the subscriber's account or the subscriber is operating in the wrong Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UpdateGlobalTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateGlobalTable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateGlobalTableResponse> updateGlobalTable(UpdateGlobalTableRequest updateGlobalTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or removes replicas in the specified global table. The global table must already exist to be able to use
     * this operation. Any replica to be added must be empty, have the same name as the global table, have the same key
     * schema, have DynamoDB Streams enabled, and have the same provisioned and maximum write capacity units.
     * </p>
     * <important>
     * <p>
     * This documentation is for version 2017.11.29 (Legacy) of global tables, which should be avoided for new global
     * tables. Customers should use <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">Global Tables version
     * 2019.11.21 (Current)</a> when possible, because it provides greater flexibility, higher efficiency, and consumes
     * less write capacity than 2017.11.29 (Legacy).
     * </p>
     * <p>
     * To determine which version you're using, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.DetermineVersion.html"
     * >Determining the global table version you are using</a>. To update existing global tables from version 2017.11.29
     * (Legacy) to version 2019.11.21 (Current), see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/V2globaltables_upgrade.html">Upgrading
     * global tables</a>.
     * </p>
     * </important> <note>
     * <p>
     * If you are using global tables <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">Version 2019.11.21</a>
     * (Current) you can use <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateTable.html">UpdateTable</a>
     * instead.
     * </p>
     * <p>
     * Although you can use <code>UpdateGlobalTable</code> to add replicas and remove replicas in a single request, for
     * simplicity we recommend that you issue separate requests for adding or removing replicas.
     * </p>
     * </note>
     * <p>
     * If global secondary indexes are specified, then the following conditions must also be met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The global secondary indexes must have the same name.
     * </p>
     * </li>
     * <li>
     * <p>
     * The global secondary indexes must have the same hash key and sort key (if present).
     * </p>
     * </li>
     * <li>
     * <p>
     * The global secondary indexes must have the same provisioned and maximum write capacity units.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGlobalTableRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateGlobalTableRequest#builder()}
     * </p>
     *
     * @param updateGlobalTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateGlobalTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>GlobalTableNotFoundException The specified global table does not exist.</li>
     *         <li>ReplicaAlreadyExistsException The specified replica is already part of the global table.</li>
     *         <li>ReplicaNotFoundException The specified replica is no longer part of the global table.</li>
     *         <li>TableNotFoundException A source table with the name <code>TableName</code> does not currently exist
     *         within the subscriber's account or the subscriber is operating in the wrong Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UpdateGlobalTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateGlobalTable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateGlobalTableResponse> updateGlobalTable(
            Consumer<UpdateGlobalTableRequest.Builder> updateGlobalTableRequest) {
        return updateGlobalTable(UpdateGlobalTableRequest.builder().applyMutation(updateGlobalTableRequest).build());
    }

    /**
     * <p>
     * Updates settings for a global table.
     * </p>
     * <important>
     * <p>
     * This documentation is for version 2017.11.29 (Legacy) of global tables, which should be avoided for new global
     * tables. Customers should use <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">Global Tables version
     * 2019.11.21 (Current)</a> when possible, because it provides greater flexibility, higher efficiency, and consumes
     * less write capacity than 2017.11.29 (Legacy).
     * </p>
     * <p>
     * To determine which version you're using, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.DetermineVersion.html"
     * >Determining the global table version you are using</a>. To update existing global tables from version 2017.11.29
     * (Legacy) to version 2019.11.21 (Current), see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/V2globaltables_upgrade.html">Upgrading
     * global tables</a>.
     * </p>
     * </important>
     *
     * @param updateGlobalTableSettingsRequest
     * @return A Java Future containing the result of the UpdateGlobalTableSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GlobalTableNotFoundException The specified global table does not exist.</li>
     *         <li>ReplicaNotFoundException The specified replica is no longer part of the global table.</li>
     *         <li>IndexNotFoundException The operation tried to access a nonexistent index.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UpdateGlobalTableSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateGlobalTableSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGlobalTableSettingsResponse> updateGlobalTableSettings(
            UpdateGlobalTableSettingsRequest updateGlobalTableSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates settings for a global table.
     * </p>
     * <important>
     * <p>
     * This documentation is for version 2017.11.29 (Legacy) of global tables, which should be avoided for new global
     * tables. Customers should use <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">Global Tables version
     * 2019.11.21 (Current)</a> when possible, because it provides greater flexibility, higher efficiency, and consumes
     * less write capacity than 2017.11.29 (Legacy).
     * </p>
     * <p>
     * To determine which version you're using, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.DetermineVersion.html"
     * >Determining the global table version you are using</a>. To update existing global tables from version 2017.11.29
     * (Legacy) to version 2019.11.21 (Current), see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/V2globaltables_upgrade.html">Upgrading
     * global tables</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGlobalTableSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateGlobalTableSettingsRequest#builder()}
     * </p>
     *
     * @param updateGlobalTableSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateGlobalTableSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GlobalTableNotFoundException The specified global table does not exist.</li>
     *         <li>ReplicaNotFoundException The specified replica is no longer part of the global table.</li>
     *         <li>IndexNotFoundException The operation tried to access a nonexistent index.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UpdateGlobalTableSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateGlobalTableSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGlobalTableSettingsResponse> updateGlobalTableSettings(
            Consumer<UpdateGlobalTableSettingsRequest.Builder> updateGlobalTableSettingsRequest) {
        return updateGlobalTableSettings(UpdateGlobalTableSettingsRequest.builder()
                .applyMutation(updateGlobalTableSettingsRequest).build());
    }

    /**
     * <p>
     * Edits an existing item's attributes, or adds a new item to the table if it does not already exist. You can put,
     * delete, or add attribute values. You can also perform a conditional update on an existing item (insert a new
     * attribute name-value pair if it doesn't exist, or replace an existing name-value pair if it has certain expected
     * attribute values).
     * </p>
     * <p>
     * You can also return the item's attribute values in the same <code>UpdateItem</code> operation using the
     * <code>ReturnValues</code> parameter.
     * </p>
     *
     * @param updateItemRequest
     *        Represents the input of an <code>UpdateItem</code> operation.
     * @return A Java Future containing the result of the UpdateItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConditionalCheckFailedException A condition specified in the operation failed to be evaluated.</li>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>ItemCollectionSizeLimitExceededException An item collection is too large. This exception is only
     *         returned for tables that have one or more local secondary indexes.</li>
     *         <li>TransactionConflictException Operation was rejected because there is an ongoing transaction for the
     *         item.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ReplicatedWriteConflictException The request was rejected because one or more items in the request
     *         are being modified by a request in another Region.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UpdateItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateItem" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_UpdateItem_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<UpdateItemResponse> updateItem(UpdateItemRequest updateItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Edits an existing item's attributes, or adds a new item to the table if it does not already exist. You can put,
     * delete, or add attribute values. You can also perform a conditional update on an existing item (insert a new
     * attribute name-value pair if it doesn't exist, or replace an existing name-value pair if it has certain expected
     * attribute values).
     * </p>
     * <p>
     * You can also return the item's attribute values in the same <code>UpdateItem</code> operation using the
     * <code>ReturnValues</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateItemRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateItemRequest#builder()}
     * </p>
     *
     * @param updateItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest.Builder} to create a request.
     *        Represents the input of an <code>UpdateItem</code> operation.
     * @return A Java Future containing the result of the UpdateItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConditionalCheckFailedException A condition specified in the operation failed to be evaluated.</li>
     *         <li>ProvisionedThroughputExceededException The request was denied due to request throttling. For detailed
     *         information about why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception. The Amazon Web Services SDKs for DynamoDB
     *         automatically retry requests that receive this exception. Your request is eventually successful, unless
     *         your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff.
     *         For more information, go to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>ItemCollectionSizeLimitExceededException An item collection is too large. This exception is only
     *         returned for tables that have one or more local secondary indexes.</li>
     *         <li>TransactionConflictException Operation was rejected because there is an ongoing transaction for the
     *         item.</li>
     *         <li>RequestLimitExceededException Throughput exceeds the current throughput quota for your account. For
     *         detailed information about why the request was throttled and the ARN of the impacted resource, find the
     *         <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     *         ThrottlingReason</a> field in the returned exception. Contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ReplicatedWriteConflictException The request was rejected because one or more items in the request
     *         are being modified by a request in another Region.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. For detailed information about
     *         why the request was throttled and the ARN of the impacted resource, find the <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> field in the returned exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UpdateItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateItem" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_UpdateItem_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<UpdateItemResponse> updateItem(Consumer<UpdateItemRequest.Builder> updateItemRequest) {
        return updateItem(UpdateItemRequest.builder().applyMutation(updateItemRequest).build());
    }

    /**
     * <p>
     * The command to update the Kinesis stream destination.
     * </p>
     *
     * @param updateKinesisStreamingDestinationRequest
     * @return A Java Future containing the result of the UpdateKinesisStreamingDestination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UpdateKinesisStreamingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateKinesisStreamingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateKinesisStreamingDestinationResponse> updateKinesisStreamingDestination(
            UpdateKinesisStreamingDestinationRequest updateKinesisStreamingDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The command to update the Kinesis stream destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateKinesisStreamingDestinationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateKinesisStreamingDestinationRequest#builder()}
     * </p>
     *
     * @param updateKinesisStreamingDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingDestinationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateKinesisStreamingDestination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UpdateKinesisStreamingDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateKinesisStreamingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateKinesisStreamingDestinationResponse> updateKinesisStreamingDestination(
            Consumer<UpdateKinesisStreamingDestinationRequest.Builder> updateKinesisStreamingDestinationRequest) {
        return updateKinesisStreamingDestination(UpdateKinesisStreamingDestinationRequest.builder()
                .applyMutation(updateKinesisStreamingDestinationRequest).build());
    }

    /**
     * <p>
     * Modifies the provisioned throughput settings, global secondary indexes, or DynamoDB Streams settings for a given
     * table.
     * </p>
     * <p>
     * You can only perform one of the following operations at once:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Modify the provisioned throughput settings of the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * Remove a global secondary index from the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create a new global secondary index on the table. After the index begins backfilling, you can use
     * <code>UpdateTable</code> to perform other operations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>UpdateTable</code> is an asynchronous operation; while it's executing, the table status changes from
     * <code>ACTIVE</code> to <code>UPDATING</code>. While it's <code>UPDATING</code>, you can't issue another
     * <code>UpdateTable</code> request. When the table returns to the <code>ACTIVE</code> state, the
     * <code>UpdateTable</code> operation is complete.
     * </p>
     *
     * @param updateTableRequest
     *        Represents the input of an <code>UpdateTable</code> operation.
     * @return A Java Future containing the result of the UpdateTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UpdateTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTableResponse> updateTable(UpdateTableRequest updateTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the provisioned throughput settings, global secondary indexes, or DynamoDB Streams settings for a given
     * table.
     * </p>
     * <p>
     * You can only perform one of the following operations at once:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Modify the provisioned throughput settings of the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * Remove a global secondary index from the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create a new global secondary index on the table. After the index begins backfilling, you can use
     * <code>UpdateTable</code> to perform other operations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>UpdateTable</code> is an asynchronous operation; while it's executing, the table status changes from
     * <code>ACTIVE</code> to <code>UPDATING</code>. While it's <code>UPDATING</code>, you can't issue another
     * <code>UpdateTable</code> request. When the table returns to the <code>ACTIVE</code> state, the
     * <code>UpdateTable</code> operation is complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTableRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTableRequest#builder()}
     * </p>
     *
     * @param updateTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest.Builder} to create a request.
     *        Represents the input of an <code>UpdateTable</code> operation.
     * @return A Java Future containing the result of the UpdateTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UpdateTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTableResponse> updateTable(Consumer<UpdateTableRequest.Builder> updateTableRequest) {
        return updateTable(UpdateTableRequest.builder().applyMutation(updateTableRequest).build());
    }

    /**
     * <p>
     * Updates auto scaling settings on your global tables at once.
     * </p>
     *
     * @param updateTableReplicaAutoScalingRequest
     * @return A Java Future containing the result of the UpdateTableReplicaAutoScaling operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UpdateTableReplicaAutoScaling
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTableReplicaAutoScaling"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTableReplicaAutoScalingResponse> updateTableReplicaAutoScaling(
            UpdateTableReplicaAutoScalingRequest updateTableReplicaAutoScalingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates auto scaling settings on your global tables at once.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTableReplicaAutoScalingRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateTableReplicaAutoScalingRequest#builder()}
     * </p>
     *
     * @param updateTableReplicaAutoScalingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateTableReplicaAutoScaling operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UpdateTableReplicaAutoScaling
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTableReplicaAutoScaling"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTableReplicaAutoScalingResponse> updateTableReplicaAutoScaling(
            Consumer<UpdateTableReplicaAutoScalingRequest.Builder> updateTableReplicaAutoScalingRequest) {
        return updateTableReplicaAutoScaling(UpdateTableReplicaAutoScalingRequest.builder()
                .applyMutation(updateTableReplicaAutoScalingRequest).build());
    }

    /**
     * <p>
     * The <code>UpdateTimeToLive</code> method enables or disables Time to Live (TTL) for the specified table. A
     * successful <code>UpdateTimeToLive</code> call returns the current <code>TimeToLiveSpecification</code>. It can
     * take up to one hour for the change to fully process. Any additional <code>UpdateTimeToLive</code> calls for the
     * same table during this one hour duration result in a <code>ValidationException</code>.
     * </p>
     * <p>
     * TTL compares the current time in epoch time format to the time stored in the TTL attribute of an item. If the
     * epoch time value stored in the attribute is less than the current time, the item is marked as expired and
     * subsequently deleted.
     * </p>
     * <note>
     * <p>
     * The epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.
     * </p>
     * </note>
     * <p>
     * DynamoDB deletes expired items on a best-effort basis to ensure availability of throughput for other data
     * operations.
     * </p>
     * <important>
     * <p>
     * DynamoDB typically deletes expired items within two days of expiration. The exact duration within which an item
     * gets deleted after expiration is specific to the nature of the workload. Items that have expired and not been
     * deleted will still show up in reads, queries, and scans.
     * </p>
     * </important>
     * <p>
     * As items are deleted, they are removed from any local secondary index and global secondary index immediately in
     * the same eventually consistent way as a standard delete operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/TTL.html">Time To Live</a> in the Amazon
     * DynamoDB Developer Guide.
     * </p>
     *
     * @param updateTimeToLiveRequest
     *        Represents the input of an <code>UpdateTimeToLive</code> operation.
     * @return A Java Future containing the result of the UpdateTimeToLive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UpdateTimeToLive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTimeToLive" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_UpdateTimeToLive_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<UpdateTimeToLiveResponse> updateTimeToLive(UpdateTimeToLiveRequest updateTimeToLiveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>UpdateTimeToLive</code> method enables or disables Time to Live (TTL) for the specified table. A
     * successful <code>UpdateTimeToLive</code> call returns the current <code>TimeToLiveSpecification</code>. It can
     * take up to one hour for the change to fully process. Any additional <code>UpdateTimeToLive</code> calls for the
     * same table during this one hour duration result in a <code>ValidationException</code>.
     * </p>
     * <p>
     * TTL compares the current time in epoch time format to the time stored in the TTL attribute of an item. If the
     * epoch time value stored in the attribute is less than the current time, the item is marked as expired and
     * subsequently deleted.
     * </p>
     * <note>
     * <p>
     * The epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.
     * </p>
     * </note>
     * <p>
     * DynamoDB deletes expired items on a best-effort basis to ensure availability of throughput for other data
     * operations.
     * </p>
     * <important>
     * <p>
     * DynamoDB typically deletes expired items within two days of expiration. The exact duration within which an item
     * gets deleted after expiration is specific to the nature of the workload. Items that have expired and not been
     * deleted will still show up in reads, queries, and scans.
     * </p>
     * </important>
     * <p>
     * As items are deleted, they are removed from any local secondary index and global secondary index immediately in
     * the same eventually consistent way as a standard delete operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/TTL.html">Time To Live</a> in the Amazon
     * DynamoDB Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTimeToLiveRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateTimeToLiveRequest#builder()}
     * </p>
     *
     * @param updateTimeToLiveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest.Builder} to create a
     *        request. Represents the input of an <code>UpdateTimeToLive</code> operation.
     * @return A Java Future containing the result of the UpdateTimeToLive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You attempted to recreate an existing table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to delete a table currently in the <code>CREATING</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a resource that was already being updated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When appropriate, wait for the ongoing update to complete and attempt the request again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a nonexistent table or index. The resource
     *         might not be specified correctly, or its status might not be <code>ACTIVE</code>.</li>
     *         <li>LimitExceededException There is no limit to the number of daily on-demand backups that can be taken.
     *         </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DynamoDbException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DynamoDbAsyncClient.UpdateTimeToLive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTimeToLive" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_UpdateTimeToLive_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<UpdateTimeToLiveResponse> updateTimeToLive(
            Consumer<UpdateTimeToLiveRequest.Builder> updateTimeToLiveRequest) {
        return updateTimeToLive(UpdateTimeToLiveRequest.builder().applyMutation(updateTimeToLiveRequest).build());
    }

    /**
     * Create an instance of {@link DynamoDbAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link DynamoDbAsyncWaiter}
     */
    default DynamoDbAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default DynamoDbServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link DynamoDbAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DynamoDbAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DynamoDbAsyncClient}.
     */
    static DynamoDbAsyncClientBuilder builder() {
        return new DefaultDynamoDbAsyncClientBuilder();
    }
}
