/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>CreateTable</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTableRequest extends DynamoDbRequest implements
        ToCopyableBuilder<CreateTableRequest.Builder, CreateTableRequest> {
    private static final SdkField<List<AttributeDefinition>> ATTRIBUTE_DEFINITIONS_FIELD = SdkField
            .<List<AttributeDefinition>> builder(MarshallingType.LIST)
            .memberName("AttributeDefinitions")
            .getter(getter(CreateTableRequest::attributeDefinitions))
            .setter(setter(Builder::attributeDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(CreateTableRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<List<KeySchemaElement>> KEY_SCHEMA_FIELD = SdkField
            .<List<KeySchemaElement>> builder(MarshallingType.LIST)
            .memberName("KeySchema")
            .getter(getter(CreateTableRequest::keySchema))
            .setter(setter(Builder::keySchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySchema").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeySchemaElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeySchemaElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LocalSecondaryIndex>> LOCAL_SECONDARY_INDEXES_FIELD = SdkField
            .<List<LocalSecondaryIndex>> builder(MarshallingType.LIST)
            .memberName("LocalSecondaryIndexes")
            .getter(getter(CreateTableRequest::localSecondaryIndexes))
            .setter(setter(Builder::localSecondaryIndexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalSecondaryIndexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocalSecondaryIndex> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocalSecondaryIndex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GlobalSecondaryIndex>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField
            .<List<GlobalSecondaryIndex>> builder(MarshallingType.LIST)
            .memberName("GlobalSecondaryIndexes")
            .getter(getter(CreateTableRequest::globalSecondaryIndexes))
            .setter(setter(Builder::globalSecondaryIndexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlobalSecondaryIndex> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlobalSecondaryIndex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BILLING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingMode").getter(getter(CreateTableRequest::billingModeAsString))
            .setter(setter(Builder::billingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingMode").build()).build();

    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField
            .<ProvisionedThroughput> builder(MarshallingType.SDK_POJO).memberName("ProvisionedThroughput")
            .getter(getter(CreateTableRequest::provisionedThroughput)).setter(setter(Builder::provisionedThroughput))
            .constructor(ProvisionedThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughput").build())
            .build();

    private static final SdkField<StreamSpecification> STREAM_SPECIFICATION_FIELD = SdkField
            .<StreamSpecification> builder(MarshallingType.SDK_POJO).memberName("StreamSpecification")
            .getter(getter(CreateTableRequest::streamSpecification)).setter(setter(Builder::streamSpecification))
            .constructor(StreamSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamSpecification").build())
            .build();

    private static final SdkField<SSESpecification> SSE_SPECIFICATION_FIELD = SdkField
            .<SSESpecification> builder(MarshallingType.SDK_POJO).memberName("SSESpecification")
            .getter(getter(CreateTableRequest::sseSpecification)).setter(setter(Builder::sseSpecification))
            .constructor(SSESpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSESpecification").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateTableRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TABLE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableClass").getter(getter(CreateTableRequest::tableClassAsString)).setter(setter(Builder::tableClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableClass").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DeletionProtectionEnabled")
            .getter(getter(CreateTableRequest::deletionProtectionEnabled)).setter(setter(Builder::deletionProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtectionEnabled").build())
            .build();

    private static final SdkField<WarmThroughput> WARM_THROUGHPUT_FIELD = SdkField
            .<WarmThroughput> builder(MarshallingType.SDK_POJO).memberName("WarmThroughput")
            .getter(getter(CreateTableRequest::warmThroughput)).setter(setter(Builder::warmThroughput))
            .constructor(WarmThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmThroughput").build()).build();

    private static final SdkField<String> RESOURCE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourcePolicy").getter(getter(CreateTableRequest::resourcePolicy))
            .setter(setter(Builder::resourcePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePolicy").build()).build();

    private static final SdkField<OnDemandThroughput> ON_DEMAND_THROUGHPUT_FIELD = SdkField
            .<OnDemandThroughput> builder(MarshallingType.SDK_POJO).memberName("OnDemandThroughput")
            .getter(getter(CreateTableRequest::onDemandThroughput)).setter(setter(Builder::onDemandThroughput))
            .constructor(OnDemandThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandThroughput").build())
            .build();

    private static final SdkField<String> GLOBAL_TABLE_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalTableSourceArn").getter(getter(CreateTableRequest::globalTableSourceArn))
            .setter(setter(Builder::globalTableSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableSourceArn").build())
            .build();

    private static final SdkField<String> GLOBAL_TABLE_SETTINGS_REPLICATION_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GlobalTableSettingsReplicationMode")
            .getter(getter(CreateTableRequest::globalTableSettingsReplicationModeAsString))
            .setter(setter(Builder::globalTableSettingsReplicationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableSettingsReplicationMode")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_DEFINITIONS_FIELD,
            TABLE_NAME_FIELD, KEY_SCHEMA_FIELD, LOCAL_SECONDARY_INDEXES_FIELD, GLOBAL_SECONDARY_INDEXES_FIELD,
            BILLING_MODE_FIELD, PROVISIONED_THROUGHPUT_FIELD, STREAM_SPECIFICATION_FIELD, SSE_SPECIFICATION_FIELD, TAGS_FIELD,
            TABLE_CLASS_FIELD, DELETION_PROTECTION_ENABLED_FIELD, WARM_THROUGHPUT_FIELD, RESOURCE_POLICY_FIELD,
            ON_DEMAND_THROUGHPUT_FIELD, GLOBAL_TABLE_SOURCE_ARN_FIELD, GLOBAL_TABLE_SETTINGS_REPLICATION_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AttributeDefinition> attributeDefinitions;

    private final String tableName;

    private final List<KeySchemaElement> keySchema;

    private final List<LocalSecondaryIndex> localSecondaryIndexes;

    private final List<GlobalSecondaryIndex> globalSecondaryIndexes;

    private final String billingMode;

    private final ProvisionedThroughput provisionedThroughput;

    private final StreamSpecification streamSpecification;

    private final SSESpecification sseSpecification;

    private final List<Tag> tags;

    private final String tableClass;

    private final Boolean deletionProtectionEnabled;

    private final WarmThroughput warmThroughput;

    private final String resourcePolicy;

    private final OnDemandThroughput onDemandThroughput;

    private final String globalTableSourceArn;

    private final String globalTableSettingsReplicationMode;

    private CreateTableRequest(BuilderImpl builder) {
        super(builder);
        this.attributeDefinitions = builder.attributeDefinitions;
        this.tableName = builder.tableName;
        this.keySchema = builder.keySchema;
        this.localSecondaryIndexes = builder.localSecondaryIndexes;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.billingMode = builder.billingMode;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.streamSpecification = builder.streamSpecification;
        this.sseSpecification = builder.sseSpecification;
        this.tags = builder.tags;
        this.tableClass = builder.tableClass;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
        this.warmThroughput = builder.warmThroughput;
        this.resourcePolicy = builder.resourcePolicy;
        this.onDemandThroughput = builder.onDemandThroughput;
        this.globalTableSourceArn = builder.globalTableSourceArn;
        this.globalTableSettingsReplicationMode = builder.globalTableSettingsReplicationMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeDefinitions() {
        return attributeDefinitions != null && !(attributeDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of attributes that describe the key schema for the table and indexes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeDefinitions} method.
     * </p>
     * 
     * @return An array of attributes that describe the key schema for the table and indexes.
     */
    public final List<AttributeDefinition> attributeDefinitions() {
        return attributeDefinitions;
    }

    /**
     * <p>
     * The name of the table to create. You can also provide the Amazon Resource Name (ARN) of the table in this
     * parameter.
     * </p>
     * 
     * @return The name of the table to create. You can also provide the Amazon Resource Name (ARN) of the table in this
     *         parameter.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeySchema property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasKeySchema() {
        return keySchema != null && !(keySchema instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the attributes that make up the primary key for a table or an index. The attributes in
     * <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more information,
     * see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Each <code>KeySchemaElement</code> in the array is composed of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AttributeName</code> - The name of this key attribute.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KeyType</code> - The role that the key attribute will assume:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HASH</code> - partition key
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RANGE</code> - sort key
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from
     * the DynamoDB usage of an internal hash function to evenly distribute data items across partitions, based on their
     * partition key values.
     * </p>
     * <p>
     * The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the
     * way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key
     * value.
     * </p>
     * </note>
     * <p>
     * For a simple primary key (partition key), you must provide exactly one element with a <code>KeyType</code> of
     * <code>HASH</code>.
     * </p>
     * <p>
     * For a composite primary key (partition key and sort key), you must provide exactly two elements, in this order:
     * The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second element must have a
     * <code>KeyType</code> of <code>RANGE</code>.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
     * >Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeySchema} method.
     * </p>
     * 
     * @return Specifies the attributes that make up the primary key for a table or an index. The attributes in
     *         <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in
     *         the <i>Amazon DynamoDB Developer Guide</i>.</p>
     *         <p>
     *         Each <code>KeySchemaElement</code> in the array is composed of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AttributeName</code> - The name of this key attribute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KeyType</code> - The role that the key attribute will assume:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HASH</code> - partition key
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RANGE</code> - sort key
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute"
     *         derives from the DynamoDB usage of an internal hash function to evenly distribute data items across
     *         partitions, based on their partition key values.
     *         </p>
     *         <p>
     *         The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives
     *         from the way DynamoDB stores items with the same partition key physically close together, in sorted order
     *         by the sort key value.
     *         </p>
     *         </note>
     *         <p>
     *         For a simple primary key (partition key), you must provide exactly one element with a
     *         <code>KeyType</code> of <code>HASH</code>.
     *         </p>
     *         <p>
     *         For a composite primary key (partition key and sort key), you must provide exactly two elements, in this
     *         order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second element
     *         must have a <code>KeyType</code> of <code>RANGE</code>.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
     *         >Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public final List<KeySchemaElement> keySchema() {
        return keySchema;
    }

    /**
     * For responses, this returns true if the service returned a value for the LocalSecondaryIndexes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLocalSecondaryIndexes() {
        return localSecondaryIndexes != null && !(localSecondaryIndexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is scoped to a
     * given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a local
     * secondary index is unconstrained.
     * </p>
     * <p>
     * Each local secondary index in the array includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
     * </p>
     * <p/></li>
     * <li>
     * <p>
     * <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must begin with
     * the same partition key as the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These
     * are in addition to the primary key attributes and index key attributes, which are automatically projected. Each
     * attribute specification is composed of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ProjectionType</code> - One of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected
     * attributes is in <code>NonKeyAttributes</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code> - All of the table attributes are projected into the index.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
     * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of
     * the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this
     * counts as two distinct attributes when determining the total. This limit only applies when you specify the
     * ProjectionType of <code>INCLUDE</code>. You still can specify the ProjectionType of <code>ALL</code> to project
     * all attributes from the source table, even if the table has more than 100 attributes.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocalSecondaryIndexes} method.
     * </p>
     * 
     * @return One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is scoped
     *         to a given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size
     *         of a local secondary index is unconstrained.</p>
     *         <p>
     *         Each local secondary index in the array includes the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
     *         </p>
     *         <p/></li>
     *         <li>
     *         <p>
     *         <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must
     *         begin with the same partition key as the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
     *         These are in addition to the primary key attributes and index key attributes, which are automatically
     *         projected. Each attribute specification is composed of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ProjectionType</code> - One of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
     *         projected attributes is in <code>NonKeyAttributes</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code> - All of the table attributes are projected into the index.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
     *         secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across
     *         all of the secondary indexes, must not exceed 100. If you project the same attribute into two different
     *         indexes, this counts as two distinct attributes when determining the total. This limit only applies when
     *         you specify the ProjectionType of <code>INCLUDE</code>. You still can specify the ProjectionType of
     *         <code>ALL</code> to project all attributes from the source table, even if the table has more than 100
     *         attributes.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final List<LocalSecondaryIndex> localSecondaryIndexes() {
        return localSecondaryIndexes;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlobalSecondaryIndexes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGlobalSecondaryIndexes() {
        return globalSecondaryIndexes != null && !(globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more global secondary indexes (the maximum is 20) to be created on the table. Each global secondary index
     * in the array includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
     * </p>
     * <p/></li>
     * <li>
     * <p>
     * <code>KeySchema</code> - Specifies the key schema for the global secondary index. Each global secondary index
     * supports up to 4 partition keys and up to 4 sort keys.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These
     * are in addition to the primary key attributes and index key attributes, which are automatically projected. Each
     * attribute specification is composed of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ProjectionType</code> - One of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected
     * attributes is in <code>NonKeyAttributes</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code> - All of the table attributes are projected into the index.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
     * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of
     * the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this
     * counts as two distinct attributes when determining the total. This limit only applies when you specify the
     * ProjectionType of <code>INCLUDE</code>. You still can specify the ProjectionType of <code>ALL</code> to project
     * all attributes from the source table, even if the table has more than 100 attributes.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
     * consisting of read and write capacity units.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlobalSecondaryIndexes} method.
     * </p>
     * 
     * @return One or more global secondary indexes (the maximum is 20) to be created on the table. Each global
     *         secondary index in the array includes the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
     *         </p>
     *         <p/></li>
     *         <li>
     *         <p>
     *         <code>KeySchema</code> - Specifies the key schema for the global secondary index. Each global secondary
     *         index supports up to 4 partition keys and up to 4 sort keys.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
     *         These are in addition to the primary key attributes and index key attributes, which are automatically
     *         projected. Each attribute specification is composed of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ProjectionType</code> - One of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
     *         projected attributes is in <code>NonKeyAttributes</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code> - All of the table attributes are projected into the index.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
     *         secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across
     *         all of the secondary indexes, must not exceed 100. If you project the same attribute into two different
     *         indexes, this counts as two distinct attributes when determining the total. This limit only applies when
     *         you specify the ProjectionType of <code>INCLUDE</code>. You still can specify the ProjectionType of
     *         <code>ALL</code> to project all attributes from the source table, even if the table has more than 100
     *         attributes.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
     *         consisting of read and write capacity units.
     *         </p>
     *         </li>
     */
    public final List<GlobalSecondaryIndex> globalSecondaryIndexes() {
        return globalSecondaryIndexes;
    }

    /**
     * <p>
     * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be
     * changed later.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for most DynamoDB workloads.
     * <code>PAY_PER_REQUEST</code> sets the billing mode to <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html">On-demand
     * capacity mode</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for steady workloads with predictable
     * growth where capacity requirements can be reliably forecasted. <code>PROVISIONED</code> sets the billing mode to
     * <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html">
     * Provisioned capacity mode</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMode} will
     * return {@link BillingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingModeAsString}.
     * </p>
     * 
     * @return Controls how you are charged for read and write throughput and how you manage capacity. This setting can
     *         be changed later.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for most DynamoDB
     *         workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html"
     *         >On-demand capacity mode</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for steady workloads with
     *         predictable growth where capacity requirements can be reliably forecasted. <code>PROVISIONED</code> sets
     *         the billing mode to <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html"
     *         >Provisioned capacity mode</a>.
     *         </p>
     *         </li>
     * @see BillingMode
     */
    public final BillingMode billingMode() {
        return BillingMode.fromValue(billingMode);
    }

    /**
     * <p>
     * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be
     * changed later.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for most DynamoDB workloads.
     * <code>PAY_PER_REQUEST</code> sets the billing mode to <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html">On-demand
     * capacity mode</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for steady workloads with predictable
     * growth where capacity requirements can be reliably forecasted. <code>PROVISIONED</code> sets the billing mode to
     * <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html">
     * Provisioned capacity mode</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMode} will
     * return {@link BillingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingModeAsString}.
     * </p>
     * 
     * @return Controls how you are charged for read and write throughput and how you manage capacity. This setting can
     *         be changed later.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for most DynamoDB
     *         workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html"
     *         >On-demand capacity mode</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for steady workloads with
     *         predictable growth where capacity requirements can be reliably forecasted. <code>PROVISIONED</code> sets
     *         the billing mode to <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html"
     *         >Provisioned capacity mode</a>.
     *         </p>
     *         </li>
     * @see BillingMode
     */
    public final String billingModeAsString() {
        return billingMode;
    }

    /**
     * <p>
     * Represents the provisioned throughput settings for a specified table or index. The settings can be modified using
     * the <code>UpdateTable</code> operation.
     * </p>
     * <p>
     * If you set BillingMode as <code>PROVISIONED</code>, you must specify this property. If you set BillingMode as
     * <code>PAY_PER_REQUEST</code>, you cannot specify this property.
     * </p>
     * <p>
     * For current minimum and maximum provisioned throughput values, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table
     * Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return Represents the provisioned throughput settings for a specified table or index. The settings can be
     *         modified using the <code>UpdateTable</code> operation.</p>
     *         <p>
     *         If you set BillingMode as <code>PROVISIONED</code>, you must specify this property. If you set
     *         BillingMode as <code>PAY_PER_REQUEST</code>, you cannot specify this property.
     *         </p>
     *         <p>
     *         For current minimum and maximum provisioned throughput values, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and
     *         Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public final ProvisionedThroughput provisionedThroughput() {
        return provisionedThroughput;
    }

    /**
     * <p>
     * The settings for DynamoDB Streams on the table. These settings consist of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled (true) or disabled (false).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code> determines what
     * information is written to the table's stream. Valid values for <code>StreamViewType</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return The settings for DynamoDB Streams on the table. These settings consist of:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled (true) or disabled
     *         (false).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code>
     *         determines what information is written to the table's stream. Valid values for
     *         <code>StreamViewType</code> are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the
     *         stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the
     *         stream.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final StreamSpecification streamSpecification() {
        return streamSpecification;
    }

    /**
     * <p>
     * Represents the settings used to enable server-side encryption.
     * </p>
     * 
     * @return Represents the settings used to enable server-side encryption.
     */
    public final SSESpecification sseSpecification() {
        return sseSpecification;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs to label the table. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs to label the table. For more information, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for
     *         DynamoDB</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The table class of the new table. Valid values are <code>STANDARD</code> and
     * <code>STANDARD_INFREQUENT_ACCESS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tableClass} will
     * return {@link TableClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tableClassAsString}.
     * </p>
     * 
     * @return The table class of the new table. Valid values are <code>STANDARD</code> and
     *         <code>STANDARD_INFREQUENT_ACCESS</code>.
     * @see TableClass
     */
    public final TableClass tableClass() {
        return TableClass.fromValue(tableClass);
    }

    /**
     * <p>
     * The table class of the new table. Valid values are <code>STANDARD</code> and
     * <code>STANDARD_INFREQUENT_ACCESS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tableClass} will
     * return {@link TableClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tableClassAsString}.
     * </p>
     * 
     * @return The table class of the new table. Valid values are <code>STANDARD</code> and
     *         <code>STANDARD_INFREQUENT_ACCESS</code>.
     * @see TableClass
     */
    public final String tableClassAsString() {
        return tableClass;
    }

    /**
     * <p>
     * Indicates whether deletion protection is to be enabled (true) or disabled (false) on the table.
     * </p>
     * 
     * @return Indicates whether deletion protection is to be enabled (true) or disabled (false) on the table.
     */
    public final Boolean deletionProtectionEnabled() {
        return deletionProtectionEnabled;
    }

    /**
     * <p>
     * Represents the warm throughput (in read units per second and write units per second) for creating a table.
     * </p>
     * 
     * @return Represents the warm throughput (in read units per second and write units per second) for creating a
     *         table.
     */
    public final WarmThroughput warmThroughput() {
        return warmThroughput;
    }

    /**
     * <p>
     * An Amazon Web Services resource-based policy document in JSON format that will be attached to the table.
     * </p>
     * <p>
     * When you attach a resource-based policy while creating a table, the policy application is <i>strongly
     * consistent</i>.
     * </p>
     * <p>
     * The maximum size supported for a resource-based policy document is 20 KB. DynamoDB counts whitespaces when
     * calculating the size of a policy against this limit. For a full list of all considerations that apply for
     * resource-based policies, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-considerations.html">Resource-based
     * policy considerations</a>.
     * </p>
     * <note>
     * <p>
     * You need to specify the <code>CreateTable</code> and <code>PutResourcePolicy</code> IAM actions for authorizing a
     * user to create a table with a resource-based policy.
     * </p>
     * </note>
     * 
     * @return An Amazon Web Services resource-based policy document in JSON format that will be attached to the
     *         table.</p>
     *         <p>
     *         When you attach a resource-based policy while creating a table, the policy application is <i>strongly
     *         consistent</i>.
     *         </p>
     *         <p>
     *         The maximum size supported for a resource-based policy document is 20 KB. DynamoDB counts whitespaces
     *         when calculating the size of a policy against this limit. For a full list of all considerations that
     *         apply for resource-based policies, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-considerations.html"
     *         >Resource-based policy considerations</a>.
     *         </p>
     *         <note>
     *         <p>
     *         You need to specify the <code>CreateTable</code> and <code>PutResourcePolicy</code> IAM actions for
     *         authorizing a user to create a table with a resource-based policy.
     *         </p>
     */
    public final String resourcePolicy() {
        return resourcePolicy;
    }

    /**
     * <p>
     * Sets the maximum number of read and write units for the specified table in on-demand capacity mode. If you use
     * this parameter, you must specify <code>MaxReadRequestUnits</code>, <code>MaxWriteRequestUnits</code>, or both.
     * </p>
     * 
     * @return Sets the maximum number of read and write units for the specified table in on-demand capacity mode. If
     *         you use this parameter, you must specify <code>MaxReadRequestUnits</code>,
     *         <code>MaxWriteRequestUnits</code>, or both.
     */
    public final OnDemandThroughput onDemandThroughput() {
        return onDemandThroughput;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source table used for the creation of a multi-account global table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source table used for the creation of a multi-account global table.
     */
    public final String globalTableSourceArn() {
        return globalTableSourceArn;
    }

    /**
     * <p>
     * Controls the settings synchronization mode for the global table. For multi-account global tables, this parameter
     * is required and the only supported value is ENABLED. For same-account global tables, this parameter is set to
     * ENABLED_WITH_OVERRIDES.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #globalTableSettingsReplicationMode} will return
     * {@link GlobalTableSettingsReplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #globalTableSettingsReplicationModeAsString}.
     * </p>
     * 
     * @return Controls the settings synchronization mode for the global table. For multi-account global tables, this
     *         parameter is required and the only supported value is ENABLED. For same-account global tables, this
     *         parameter is set to ENABLED_WITH_OVERRIDES.
     * @see GlobalTableSettingsReplicationMode
     */
    public final GlobalTableSettingsReplicationMode globalTableSettingsReplicationMode() {
        return GlobalTableSettingsReplicationMode.fromValue(globalTableSettingsReplicationMode);
    }

    /**
     * <p>
     * Controls the settings synchronization mode for the global table. For multi-account global tables, this parameter
     * is required and the only supported value is ENABLED. For same-account global tables, this parameter is set to
     * ENABLED_WITH_OVERRIDES.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #globalTableSettingsReplicationMode} will return
     * {@link GlobalTableSettingsReplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #globalTableSettingsReplicationModeAsString}.
     * </p>
     * 
     * @return Controls the settings synchronization mode for the global table. For multi-account global tables, this
     *         parameter is required and the only supported value is ENABLED. For same-account global tables, this
     *         parameter is set to ENABLED_WITH_OVERRIDES.
     * @see GlobalTableSettingsReplicationMode
     */
    public final String globalTableSettingsReplicationModeAsString() {
        return globalTableSettingsReplicationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeDefinitions() ? attributeDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeySchema() ? keySchema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLocalSecondaryIndexes() ? localSecondaryIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalSecondaryIndexes() ? globalSecondaryIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(billingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(streamSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(sseSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tableClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(warmThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(resourcePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(globalTableSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(globalTableSettingsReplicationModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTableRequest)) {
            return false;
        }
        CreateTableRequest other = (CreateTableRequest) obj;
        return hasAttributeDefinitions() == other.hasAttributeDefinitions()
                && Objects.equals(attributeDefinitions(), other.attributeDefinitions())
                && Objects.equals(tableName(), other.tableName())
                && hasKeySchema() == other.hasKeySchema()
                && Objects.equals(keySchema(), other.keySchema())
                && hasLocalSecondaryIndexes() == other.hasLocalSecondaryIndexes()
                && Objects.equals(localSecondaryIndexes(), other.localSecondaryIndexes())
                && hasGlobalSecondaryIndexes() == other.hasGlobalSecondaryIndexes()
                && Objects.equals(globalSecondaryIndexes(), other.globalSecondaryIndexes())
                && Objects.equals(billingModeAsString(), other.billingModeAsString())
                && Objects.equals(provisionedThroughput(), other.provisionedThroughput())
                && Objects.equals(streamSpecification(), other.streamSpecification())
                && Objects.equals(sseSpecification(), other.sseSpecification())
                && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(tableClassAsString(), other.tableClassAsString())
                && Objects.equals(deletionProtectionEnabled(), other.deletionProtectionEnabled())
                && Objects.equals(warmThroughput(), other.warmThroughput())
                && Objects.equals(resourcePolicy(), other.resourcePolicy())
                && Objects.equals(onDemandThroughput(), other.onDemandThroughput())
                && Objects.equals(globalTableSourceArn(), other.globalTableSourceArn())
                && Objects.equals(globalTableSettingsReplicationModeAsString(),
                        other.globalTableSettingsReplicationModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTableRequest")
                .add("AttributeDefinitions", hasAttributeDefinitions() ? attributeDefinitions() : null)
                .add("TableName", tableName()).add("KeySchema", hasKeySchema() ? keySchema() : null)
                .add("LocalSecondaryIndexes", hasLocalSecondaryIndexes() ? localSecondaryIndexes() : null)
                .add("GlobalSecondaryIndexes", hasGlobalSecondaryIndexes() ? globalSecondaryIndexes() : null)
                .add("BillingMode", billingModeAsString()).add("ProvisionedThroughput", provisionedThroughput())
                .add("StreamSpecification", streamSpecification()).add("SSESpecification", sseSpecification())
                .add("Tags", hasTags() ? tags() : null).add("TableClass", tableClassAsString())
                .add("DeletionProtectionEnabled", deletionProtectionEnabled()).add("WarmThroughput", warmThroughput())
                .add("ResourcePolicy", resourcePolicy()).add("OnDemandThroughput", onDemandThroughput())
                .add("GlobalTableSourceArn", globalTableSourceArn())
                .add("GlobalTableSettingsReplicationMode", globalTableSettingsReplicationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeDefinitions":
            return Optional.ofNullable(clazz.cast(attributeDefinitions()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "KeySchema":
            return Optional.ofNullable(clazz.cast(keySchema()));
        case "LocalSecondaryIndexes":
            return Optional.ofNullable(clazz.cast(localSecondaryIndexes()));
        case "GlobalSecondaryIndexes":
            return Optional.ofNullable(clazz.cast(globalSecondaryIndexes()));
        case "BillingMode":
            return Optional.ofNullable(clazz.cast(billingModeAsString()));
        case "ProvisionedThroughput":
            return Optional.ofNullable(clazz.cast(provisionedThroughput()));
        case "StreamSpecification":
            return Optional.ofNullable(clazz.cast(streamSpecification()));
        case "SSESpecification":
            return Optional.ofNullable(clazz.cast(sseSpecification()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TableClass":
            return Optional.ofNullable(clazz.cast(tableClassAsString()));
        case "DeletionProtectionEnabled":
            return Optional.ofNullable(clazz.cast(deletionProtectionEnabled()));
        case "WarmThroughput":
            return Optional.ofNullable(clazz.cast(warmThroughput()));
        case "ResourcePolicy":
            return Optional.ofNullable(clazz.cast(resourcePolicy()));
        case "OnDemandThroughput":
            return Optional.ofNullable(clazz.cast(onDemandThroughput()));
        case "GlobalTableSourceArn":
            return Optional.ofNullable(clazz.cast(globalTableSourceArn()));
        case "GlobalTableSettingsReplicationMode":
            return Optional.ofNullable(clazz.cast(globalTableSettingsReplicationModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttributeDefinitions", ATTRIBUTE_DEFINITIONS_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("KeySchema", KEY_SCHEMA_FIELD);
        map.put("LocalSecondaryIndexes", LOCAL_SECONDARY_INDEXES_FIELD);
        map.put("GlobalSecondaryIndexes", GLOBAL_SECONDARY_INDEXES_FIELD);
        map.put("BillingMode", BILLING_MODE_FIELD);
        map.put("ProvisionedThroughput", PROVISIONED_THROUGHPUT_FIELD);
        map.put("StreamSpecification", STREAM_SPECIFICATION_FIELD);
        map.put("SSESpecification", SSE_SPECIFICATION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("TableClass", TABLE_CLASS_FIELD);
        map.put("DeletionProtectionEnabled", DELETION_PROTECTION_ENABLED_FIELD);
        map.put("WarmThroughput", WARM_THROUGHPUT_FIELD);
        map.put("ResourcePolicy", RESOURCE_POLICY_FIELD);
        map.put("OnDemandThroughput", ON_DEMAND_THROUGHPUT_FIELD);
        map.put("GlobalTableSourceArn", GLOBAL_TABLE_SOURCE_ARN_FIELD);
        map.put("GlobalTableSettingsReplicationMode", GLOBAL_TABLE_SETTINGS_REPLICATION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTableRequest, T> g) {
        return obj -> g.apply((CreateTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTableRequest> {
        /**
         * <p>
         * An array of attributes that describe the key schema for the table and indexes.
         * </p>
         * 
         * @param attributeDefinitions
         *        An array of attributes that describe the key schema for the table and indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions);

        /**
         * <p>
         * An array of attributes that describe the key schema for the table and indexes.
         * </p>
         * 
         * @param attributeDefinitions
         *        An array of attributes that describe the key schema for the table and indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDefinitions(AttributeDefinition... attributeDefinitions);

        /**
         * <p>
         * An array of attributes that describe the key schema for the table and indexes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dynamodb.model.AttributeDefinition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.dynamodb.model.AttributeDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dynamodb.model.AttributeDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #attributeDefinitions(List<AttributeDefinition>)}.
         * 
         * @param attributeDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dynamodb.model.AttributeDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeDefinitions(java.util.Collection<AttributeDefinition>)
         */
        Builder attributeDefinitions(Consumer<AttributeDefinition.Builder>... attributeDefinitions);

        /**
         * <p>
         * The name of the table to create. You can also provide the Amazon Resource Name (ARN) of the table in this
         * parameter.
         * </p>
         * 
         * @param tableName
         *        The name of the table to create. You can also provide the Amazon Resource Name (ARN) of the table in
         *        this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * Specifies the attributes that make up the primary key for a table or an index. The attributes in
         * <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in the
         * <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * <p>
         * Each <code>KeySchemaElement</code> in the array is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AttributeName</code> - The name of this key attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeyType</code> - The role that the key attribute will assume:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HASH</code> - partition key
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RANGE</code> - sort key
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives
         * from the DynamoDB usage of an internal hash function to evenly distribute data items across partitions, based
         * on their partition key values.
         * </p>
         * <p>
         * The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from
         * the way DynamoDB stores items with the same partition key physically close together, in sorted order by the
         * sort key value.
         * </p>
         * </note>
         * <p>
         * For a simple primary key (partition key), you must provide exactly one element with a <code>KeyType</code> of
         * <code>HASH</code>.
         * </p>
         * <p>
         * For a composite primary key (partition key and sort key), you must provide exactly two elements, in this
         * order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second element must
         * have a <code>KeyType</code> of <code>RANGE</code>.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
         * >Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param keySchema
         *        Specifies the attributes that make up the primary key for a table or an index. The attributes in
         *        <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a>
         *        in the <i>Amazon DynamoDB Developer Guide</i>.</p>
         *        <p>
         *        Each <code>KeySchemaElement</code> in the array is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AttributeName</code> - The name of this key attribute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KeyType</code> - The role that the key attribute will assume:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HASH</code> - partition key
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RANGE</code> - sort key
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute"
         *        derives from the DynamoDB usage of an internal hash function to evenly distribute data items across
         *        partitions, based on their partition key values.
         *        </p>
         *        <p>
         *        The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute"
         *        derives from the way DynamoDB stores items with the same partition key physically close together, in
         *        sorted order by the sort key value.
         *        </p>
         *        </note>
         *        <p>
         *        For a simple primary key (partition key), you must provide exactly one element with a
         *        <code>KeyType</code> of <code>HASH</code>.
         *        </p>
         *        <p>
         *        For a composite primary key (partition key and sort key), you must provide exactly two elements, in
         *        this order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second
         *        element must have a <code>KeyType</code> of <code>RANGE</code>.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
         *        >Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(Collection<KeySchemaElement> keySchema);

        /**
         * <p>
         * Specifies the attributes that make up the primary key for a table or an index. The attributes in
         * <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in the
         * <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * <p>
         * Each <code>KeySchemaElement</code> in the array is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AttributeName</code> - The name of this key attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeyType</code> - The role that the key attribute will assume:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HASH</code> - partition key
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RANGE</code> - sort key
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives
         * from the DynamoDB usage of an internal hash function to evenly distribute data items across partitions, based
         * on their partition key values.
         * </p>
         * <p>
         * The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from
         * the way DynamoDB stores items with the same partition key physically close together, in sorted order by the
         * sort key value.
         * </p>
         * </note>
         * <p>
         * For a simple primary key (partition key), you must provide exactly one element with a <code>KeyType</code> of
         * <code>HASH</code>.
         * </p>
         * <p>
         * For a composite primary key (partition key and sort key), you must provide exactly two elements, in this
         * order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second element must
         * have a <code>KeyType</code> of <code>RANGE</code>.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
         * >Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param keySchema
         *        Specifies the attributes that make up the primary key for a table or an index. The attributes in
         *        <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a>
         *        in the <i>Amazon DynamoDB Developer Guide</i>.</p>
         *        <p>
         *        Each <code>KeySchemaElement</code> in the array is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AttributeName</code> - The name of this key attribute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KeyType</code> - The role that the key attribute will assume:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HASH</code> - partition key
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RANGE</code> - sort key
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute"
         *        derives from the DynamoDB usage of an internal hash function to evenly distribute data items across
         *        partitions, based on their partition key values.
         *        </p>
         *        <p>
         *        The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute"
         *        derives from the way DynamoDB stores items with the same partition key physically close together, in
         *        sorted order by the sort key value.
         *        </p>
         *        </note>
         *        <p>
         *        For a simple primary key (partition key), you must provide exactly one element with a
         *        <code>KeyType</code> of <code>HASH</code>.
         *        </p>
         *        <p>
         *        For a composite primary key (partition key and sort key), you must provide exactly two elements, in
         *        this order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second
         *        element must have a <code>KeyType</code> of <code>RANGE</code>.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
         *        >Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(KeySchemaElement... keySchema);

        /**
         * <p>
         * Specifies the attributes that make up the primary key for a table or an index. The attributes in
         * <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in the
         * <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * <p>
         * Each <code>KeySchemaElement</code> in the array is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AttributeName</code> - The name of this key attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeyType</code> - The role that the key attribute will assume:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HASH</code> - partition key
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RANGE</code> - sort key
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives
         * from the DynamoDB usage of an internal hash function to evenly distribute data items across partitions, based
         * on their partition key values.
         * </p>
         * <p>
         * The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from
         * the way DynamoDB stores items with the same partition key physically close together, in sorted order by the
         * sort key value.
         * </p>
         * </note>
         * <p>
         * For a simple primary key (partition key), you must provide exactly one element with a <code>KeyType</code> of
         * <code>HASH</code>.
         * </p>
         * <p>
         * For a composite primary key (partition key and sort key), you must provide exactly two elements, in this
         * order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second element must
         * have a <code>KeyType</code> of <code>RANGE</code>.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
         * >Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dynamodb.model.KeySchemaElement.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.dynamodb.model.KeySchemaElement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dynamodb.model.KeySchemaElement.Builder#build()} is called immediately
         * and its result is passed to {@link #keySchema(List<KeySchemaElement>)}.
         * 
         * @param keySchema
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dynamodb.model.KeySchemaElement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keySchema(java.util.Collection<KeySchemaElement>)
         */
        Builder keySchema(Consumer<KeySchemaElement.Builder>... keySchema);

        /**
         * <p>
         * One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is scoped to a
         * given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a
         * local secondary index is unconstrained.
         * </p>
         * <p>
         * Each local secondary index in the array includes the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
         * </p>
         * <p/></li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must begin
         * with the same partition key as the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         * projected attributes is in <code>NonKeyAttributes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total. This limit only applies when you specify
         * the ProjectionType of <code>INCLUDE</code>. You still can specify the ProjectionType of <code>ALL</code> to
         * project all attributes from the source table, even if the table has more than 100 attributes.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param localSecondaryIndexes
         *        One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is
         *        scoped to a given partition key value. There is a 10 GB size limit per partition key value; otherwise,
         *        the size of a local secondary index is unconstrained.</p>
         *        <p>
         *        Each local secondary index in the array includes the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
         *        </p>
         *        <p/></li>
         *        <li>
         *        <p>
         *        <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must
         *        begin with the same partition key as the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the
         *        index. These are in addition to the primary key attributes and index key attributes, which are
         *        automatically projected. Each attribute specification is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ProjectionType</code> - One of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         *        projected attributes is in <code>NonKeyAttributes</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - All of the table attributes are projected into the index.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into
         *        the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed
         *        across all of the secondary indexes, must not exceed 100. If you project the same attribute into two
         *        different indexes, this counts as two distinct attributes when determining the total. This limit only
         *        applies when you specify the ProjectionType of <code>INCLUDE</code>. You still can specify the
         *        ProjectionType of <code>ALL</code> to project all attributes from the source table, even if the table
         *        has more than 100 attributes.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSecondaryIndexes(Collection<LocalSecondaryIndex> localSecondaryIndexes);

        /**
         * <p>
         * One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is scoped to a
         * given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a
         * local secondary index is unconstrained.
         * </p>
         * <p>
         * Each local secondary index in the array includes the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
         * </p>
         * <p/></li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must begin
         * with the same partition key as the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         * projected attributes is in <code>NonKeyAttributes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total. This limit only applies when you specify
         * the ProjectionType of <code>INCLUDE</code>. You still can specify the ProjectionType of <code>ALL</code> to
         * project all attributes from the source table, even if the table has more than 100 attributes.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param localSecondaryIndexes
         *        One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is
         *        scoped to a given partition key value. There is a 10 GB size limit per partition key value; otherwise,
         *        the size of a local secondary index is unconstrained.</p>
         *        <p>
         *        Each local secondary index in the array includes the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
         *        </p>
         *        <p/></li>
         *        <li>
         *        <p>
         *        <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must
         *        begin with the same partition key as the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the
         *        index. These are in addition to the primary key attributes and index key attributes, which are
         *        automatically projected. Each attribute specification is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ProjectionType</code> - One of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         *        projected attributes is in <code>NonKeyAttributes</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - All of the table attributes are projected into the index.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into
         *        the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed
         *        across all of the secondary indexes, must not exceed 100. If you project the same attribute into two
         *        different indexes, this counts as two distinct attributes when determining the total. This limit only
         *        applies when you specify the ProjectionType of <code>INCLUDE</code>. You still can specify the
         *        ProjectionType of <code>ALL</code> to project all attributes from the source table, even if the table
         *        has more than 100 attributes.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSecondaryIndexes(LocalSecondaryIndex... localSecondaryIndexes);

        /**
         * <p>
         * One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is scoped to a
         * given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a
         * local secondary index is unconstrained.
         * </p>
         * <p>
         * Each local secondary index in the array includes the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
         * </p>
         * <p/></li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must begin
         * with the same partition key as the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         * projected attributes is in <code>NonKeyAttributes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total. This limit only applies when you specify
         * the ProjectionType of <code>INCLUDE</code>. You still can specify the ProjectionType of <code>ALL</code> to
         * project all attributes from the source table, even if the table has more than 100 attributes.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex.Builder#build()} is called
         * immediately and its result is passed to {@link #localSecondaryIndexes(List<LocalSecondaryIndex>)}.
         * 
         * @param localSecondaryIndexes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localSecondaryIndexes(java.util.Collection<LocalSecondaryIndex>)
         */
        Builder localSecondaryIndexes(Consumer<LocalSecondaryIndex.Builder>... localSecondaryIndexes);

        /**
         * <p>
         * One or more global secondary indexes (the maximum is 20) to be created on the table. Each global secondary
         * index in the array includes the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
         * </p>
         * <p/></li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the key schema for the global secondary index. Each global secondary index
         * supports up to 4 partition keys and up to 4 sort keys.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         * projected attributes is in <code>NonKeyAttributes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total. This limit only applies when you specify
         * the ProjectionType of <code>INCLUDE</code>. You still can specify the ProjectionType of <code>ALL</code> to
         * project all attributes from the source table, even if the table has more than 100 attributes.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
         * consisting of read and write capacity units.
         * </p>
         * </li>
         * </ul>
         * 
         * @param globalSecondaryIndexes
         *        One or more global secondary indexes (the maximum is 20) to be created on the table. Each global
         *        secondary index in the array includes the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
         *        </p>
         *        <p/></li>
         *        <li>
         *        <p>
         *        <code>KeySchema</code> - Specifies the key schema for the global secondary index. Each global
         *        secondary index supports up to 4 partition keys and up to 4 sort keys.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the
         *        index. These are in addition to the primary key attributes and index key attributes, which are
         *        automatically projected. Each attribute specification is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ProjectionType</code> - One of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         *        projected attributes is in <code>NonKeyAttributes</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - All of the table attributes are projected into the index.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into
         *        the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed
         *        across all of the secondary indexes, must not exceed 100. If you project the same attribute into two
         *        different indexes, this counts as two distinct attributes when determining the total. This limit only
         *        applies when you specify the ProjectionType of <code>INCLUDE</code>. You still can specify the
         *        ProjectionType of <code>ALL</code> to project all attributes from the source table, even if the table
         *        has more than 100 attributes.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary
         *        index, consisting of read and write capacity units.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndex> globalSecondaryIndexes);

        /**
         * <p>
         * One or more global secondary indexes (the maximum is 20) to be created on the table. Each global secondary
         * index in the array includes the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
         * </p>
         * <p/></li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the key schema for the global secondary index. Each global secondary index
         * supports up to 4 partition keys and up to 4 sort keys.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         * projected attributes is in <code>NonKeyAttributes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total. This limit only applies when you specify
         * the ProjectionType of <code>INCLUDE</code>. You still can specify the ProjectionType of <code>ALL</code> to
         * project all attributes from the source table, even if the table has more than 100 attributes.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
         * consisting of read and write capacity units.
         * </p>
         * </li>
         * </ul>
         * 
         * @param globalSecondaryIndexes
         *        One or more global secondary indexes (the maximum is 20) to be created on the table. Each global
         *        secondary index in the array includes the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
         *        </p>
         *        <p/></li>
         *        <li>
         *        <p>
         *        <code>KeySchema</code> - Specifies the key schema for the global secondary index. Each global
         *        secondary index supports up to 4 partition keys and up to 4 sort keys.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the
         *        index. These are in addition to the primary key attributes and index key attributes, which are
         *        automatically projected. Each attribute specification is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ProjectionType</code> - One of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         *        projected attributes is in <code>NonKeyAttributes</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - All of the table attributes are projected into the index.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into
         *        the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed
         *        across all of the secondary indexes, must not exceed 100. If you project the same attribute into two
         *        different indexes, this counts as two distinct attributes when determining the total. This limit only
         *        applies when you specify the ProjectionType of <code>INCLUDE</code>. You still can specify the
         *        ProjectionType of <code>ALL</code> to project all attributes from the source table, even if the table
         *        has more than 100 attributes.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary
         *        index, consisting of read and write capacity units.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(GlobalSecondaryIndex... globalSecondaryIndexes);

        /**
         * <p>
         * One or more global secondary indexes (the maximum is 20) to be created on the table. Each global secondary
         * index in the array includes the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
         * </p>
         * <p/></li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the key schema for the global secondary index. Each global secondary index
         * supports up to 4 partition keys and up to 4 sort keys.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         * projected attributes is in <code>NonKeyAttributes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total. This limit only applies when you specify
         * the ProjectionType of <code>INCLUDE</code>. You still can specify the ProjectionType of <code>ALL</code> to
         * project all attributes from the source table, even if the table has more than 100 attributes.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
         * consisting of read and write capacity units.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex.Builder#build()} is called
         * immediately and its result is passed to {@link #globalSecondaryIndexes(List<GlobalSecondaryIndex>)}.
         * 
         * @param globalSecondaryIndexes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalSecondaryIndexes(java.util.Collection<GlobalSecondaryIndex>)
         */
        Builder globalSecondaryIndexes(Consumer<GlobalSecondaryIndex.Builder>... globalSecondaryIndexes);

        /**
         * <p>
         * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be
         * changed later.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for most DynamoDB workloads.
         * <code>PAY_PER_REQUEST</code> sets the billing mode to <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html"
         * >On-demand capacity mode</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for steady workloads with predictable
         * growth where capacity requirements can be reliably forecasted. <code>PROVISIONED</code> sets the billing mode
         * to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html">
         * Provisioned capacity mode</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param billingMode
         *        Controls how you are charged for read and write throughput and how you manage capacity. This setting
         *        can be changed later.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for most DynamoDB
         *        workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html"
         *        >On-demand capacity mode</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for steady workloads with
         *        predictable growth where capacity requirements can be reliably forecasted. <code>PROVISIONED</code>
         *        sets the billing mode to <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html"
         *        >Provisioned capacity mode</a>.
         *        </p>
         *        </li>
         * @see BillingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMode
         */
        Builder billingMode(String billingMode);

        /**
         * <p>
         * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be
         * changed later.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for most DynamoDB workloads.
         * <code>PAY_PER_REQUEST</code> sets the billing mode to <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html"
         * >On-demand capacity mode</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for steady workloads with predictable
         * growth where capacity requirements can be reliably forecasted. <code>PROVISIONED</code> sets the billing mode
         * to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html">
         * Provisioned capacity mode</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param billingMode
         *        Controls how you are charged for read and write throughput and how you manage capacity. This setting
         *        can be changed later.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for most DynamoDB
         *        workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html"
         *        >On-demand capacity mode</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for steady workloads with
         *        predictable growth where capacity requirements can be reliably forecasted. <code>PROVISIONED</code>
         *        sets the billing mode to <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html"
         *        >Provisioned capacity mode</a>.
         *        </p>
         *        </li>
         * @see BillingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMode
         */
        Builder billingMode(BillingMode billingMode);

        /**
         * <p>
         * Represents the provisioned throughput settings for a specified table or index. The settings can be modified
         * using the <code>UpdateTable</code> operation.
         * </p>
         * <p>
         * If you set BillingMode as <code>PROVISIONED</code>, you must specify this property. If you set BillingMode as
         * <code>PAY_PER_REQUEST</code>, you cannot specify this property.
         * </p>
         * <p>
         * For current minimum and maximum provisioned throughput values, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and
         * Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param provisionedThroughput
         *        Represents the provisioned throughput settings for a specified table or index. The settings can be
         *        modified using the <code>UpdateTable</code> operation.</p>
         *        <p>
         *        If you set BillingMode as <code>PROVISIONED</code>, you must specify this property. If you set
         *        BillingMode as <code>PAY_PER_REQUEST</code>, you cannot specify this property.
         *        </p>
         *        <p>
         *        For current minimum and maximum provisioned throughput values, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account,
         *        and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput);

        /**
         * <p>
         * Represents the provisioned throughput settings for a specified table or index. The settings can be modified
         * using the <code>UpdateTable</code> operation.
         * </p>
         * <p>
         * If you set BillingMode as <code>PROVISIONED</code>, you must specify this property. If you set BillingMode as
         * <code>PAY_PER_REQUEST</code>, you cannot specify this property.
         * </p>
         * <p>
         * For current minimum and maximum provisioned throughput values, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and
         * Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisionedThroughput.Builder} avoiding
         * the need to create one manually via {@link ProvisionedThroughput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisionedThroughput.Builder#build()} is called immediately and
         * its result is passed to {@link #provisionedThroughput(ProvisionedThroughput)}.
         * 
         * @param provisionedThroughput
         *        a consumer that will call methods on {@link ProvisionedThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughput(ProvisionedThroughput)
         */
        default Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return provisionedThroughput(ProvisionedThroughput.builder().applyMutation(provisionedThroughput).build());
        }

        /**
         * <p>
         * The settings for DynamoDB Streams on the table. These settings consist of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled (true) or disabled (false).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code> determines
         * what information is written to the table's stream. Valid values for <code>StreamViewType</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param streamSpecification
         *        The settings for DynamoDB Streams on the table. These settings consist of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled (true) or disabled
         *        (false).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code>
         *        determines what information is written to the table's stream. Valid values for
         *        <code>StreamViewType</code> are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the
         *        stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the
         *        stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the
         *        stream.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamSpecification(StreamSpecification streamSpecification);

        /**
         * <p>
         * The settings for DynamoDB Streams on the table. These settings consist of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled (true) or disabled (false).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code> determines
         * what information is written to the table's stream. Valid values for <code>StreamViewType</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link StreamSpecification.Builder} avoiding the
         * need to create one manually via {@link StreamSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #streamSpecification(StreamSpecification)}.
         * 
         * @param streamSpecification
         *        a consumer that will call methods on {@link StreamSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamSpecification(StreamSpecification)
         */
        default Builder streamSpecification(Consumer<StreamSpecification.Builder> streamSpecification) {
            return streamSpecification(StreamSpecification.builder().applyMutation(streamSpecification).build());
        }

        /**
         * <p>
         * Represents the settings used to enable server-side encryption.
         * </p>
         * 
         * @param sseSpecification
         *        Represents the settings used to enable server-side encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseSpecification(SSESpecification sseSpecification);

        /**
         * <p>
         * Represents the settings used to enable server-side encryption.
         * </p>
         * This is a convenience method that creates an instance of the {@link SSESpecification.Builder} avoiding the
         * need to create one manually via {@link SSESpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SSESpecification.Builder#build()} is called immediately and its
         * result is passed to {@link #sseSpecification(SSESpecification)}.
         * 
         * @param sseSpecification
         *        a consumer that will call methods on {@link SSESpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseSpecification(SSESpecification)
         */
        default Builder sseSpecification(Consumer<SSESpecification.Builder> sseSpecification) {
            return sseSpecification(SSESpecification.builder().applyMutation(sseSpecification).build());
        }

        /**
         * <p>
         * A list of key-value pairs to label the table. For more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for
         * DynamoDB</a>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to label the table. For more information, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for
         *        DynamoDB</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs to label the table. For more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for
         * DynamoDB</a>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to label the table. For more information, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for
         *        DynamoDB</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs to label the table. For more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for
         * DynamoDB</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dynamodb.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.dynamodb.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dynamodb.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dynamodb.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The table class of the new table. Valid values are <code>STANDARD</code> and
         * <code>STANDARD_INFREQUENT_ACCESS</code>.
         * </p>
         * 
         * @param tableClass
         *        The table class of the new table. Valid values are <code>STANDARD</code> and
         *        <code>STANDARD_INFREQUENT_ACCESS</code>.
         * @see TableClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableClass
         */
        Builder tableClass(String tableClass);

        /**
         * <p>
         * The table class of the new table. Valid values are <code>STANDARD</code> and
         * <code>STANDARD_INFREQUENT_ACCESS</code>.
         * </p>
         * 
         * @param tableClass
         *        The table class of the new table. Valid values are <code>STANDARD</code> and
         *        <code>STANDARD_INFREQUENT_ACCESS</code>.
         * @see TableClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableClass
         */
        Builder tableClass(TableClass tableClass);

        /**
         * <p>
         * Indicates whether deletion protection is to be enabled (true) or disabled (false) on the table.
         * </p>
         * 
         * @param deletionProtectionEnabled
         *        Indicates whether deletion protection is to be enabled (true) or disabled (false) on the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled);

        /**
         * <p>
         * Represents the warm throughput (in read units per second and write units per second) for creating a table.
         * </p>
         * 
         * @param warmThroughput
         *        Represents the warm throughput (in read units per second and write units per second) for creating a
         *        table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmThroughput(WarmThroughput warmThroughput);

        /**
         * <p>
         * Represents the warm throughput (in read units per second and write units per second) for creating a table.
         * </p>
         * This is a convenience method that creates an instance of the {@link WarmThroughput.Builder} avoiding the need
         * to create one manually via {@link WarmThroughput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WarmThroughput.Builder#build()} is called immediately and its
         * result is passed to {@link #warmThroughput(WarmThroughput)}.
         * 
         * @param warmThroughput
         *        a consumer that will call methods on {@link WarmThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warmThroughput(WarmThroughput)
         */
        default Builder warmThroughput(Consumer<WarmThroughput.Builder> warmThroughput) {
            return warmThroughput(WarmThroughput.builder().applyMutation(warmThroughput).build());
        }

        /**
         * <p>
         * An Amazon Web Services resource-based policy document in JSON format that will be attached to the table.
         * </p>
         * <p>
         * When you attach a resource-based policy while creating a table, the policy application is <i>strongly
         * consistent</i>.
         * </p>
         * <p>
         * The maximum size supported for a resource-based policy document is 20 KB. DynamoDB counts whitespaces when
         * calculating the size of a policy against this limit. For a full list of all considerations that apply for
         * resource-based policies, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-considerations.html"
         * >Resource-based policy considerations</a>.
         * </p>
         * <note>
         * <p>
         * You need to specify the <code>CreateTable</code> and <code>PutResourcePolicy</code> IAM actions for
         * authorizing a user to create a table with a resource-based policy.
         * </p>
         * </note>
         * 
         * @param resourcePolicy
         *        An Amazon Web Services resource-based policy document in JSON format that will be attached to the
         *        table.</p>
         *        <p>
         *        When you attach a resource-based policy while creating a table, the policy application is <i>strongly
         *        consistent</i>.
         *        </p>
         *        <p>
         *        The maximum size supported for a resource-based policy document is 20 KB. DynamoDB counts whitespaces
         *        when calculating the size of a policy against this limit. For a full list of all considerations that
         *        apply for resource-based policies, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-considerations.html"
         *        >Resource-based policy considerations</a>.
         *        </p>
         *        <note>
         *        <p>
         *        You need to specify the <code>CreateTable</code> and <code>PutResourcePolicy</code> IAM actions for
         *        authorizing a user to create a table with a resource-based policy.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePolicy(String resourcePolicy);

        /**
         * <p>
         * Sets the maximum number of read and write units for the specified table in on-demand capacity mode. If you
         * use this parameter, you must specify <code>MaxReadRequestUnits</code>, <code>MaxWriteRequestUnits</code>, or
         * both.
         * </p>
         * 
         * @param onDemandThroughput
         *        Sets the maximum number of read and write units for the specified table in on-demand capacity mode. If
         *        you use this parameter, you must specify <code>MaxReadRequestUnits</code>,
         *        <code>MaxWriteRequestUnits</code>, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandThroughput(OnDemandThroughput onDemandThroughput);

        /**
         * <p>
         * Sets the maximum number of read and write units for the specified table in on-demand capacity mode. If you
         * use this parameter, you must specify <code>MaxReadRequestUnits</code>, <code>MaxWriteRequestUnits</code>, or
         * both.
         * </p>
         * This is a convenience method that creates an instance of the {@link OnDemandThroughput.Builder} avoiding the
         * need to create one manually via {@link OnDemandThroughput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnDemandThroughput.Builder#build()} is called immediately and its
         * result is passed to {@link #onDemandThroughput(OnDemandThroughput)}.
         * 
         * @param onDemandThroughput
         *        a consumer that will call methods on {@link OnDemandThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onDemandThroughput(OnDemandThroughput)
         */
        default Builder onDemandThroughput(Consumer<OnDemandThroughput.Builder> onDemandThroughput) {
            return onDemandThroughput(OnDemandThroughput.builder().applyMutation(onDemandThroughput).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source table used for the creation of a multi-account global table.
         * </p>
         * 
         * @param globalTableSourceArn
         *        The Amazon Resource Name (ARN) of the source table used for the creation of a multi-account global
         *        table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTableSourceArn(String globalTableSourceArn);

        /**
         * <p>
         * Controls the settings synchronization mode for the global table. For multi-account global tables, this
         * parameter is required and the only supported value is ENABLED. For same-account global tables, this parameter
         * is set to ENABLED_WITH_OVERRIDES.
         * </p>
         * 
         * @param globalTableSettingsReplicationMode
         *        Controls the settings synchronization mode for the global table. For multi-account global tables, this
         *        parameter is required and the only supported value is ENABLED. For same-account global tables, this
         *        parameter is set to ENABLED_WITH_OVERRIDES.
         * @see GlobalTableSettingsReplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalTableSettingsReplicationMode
         */
        Builder globalTableSettingsReplicationMode(String globalTableSettingsReplicationMode);

        /**
         * <p>
         * Controls the settings synchronization mode for the global table. For multi-account global tables, this
         * parameter is required and the only supported value is ENABLED. For same-account global tables, this parameter
         * is set to ENABLED_WITH_OVERRIDES.
         * </p>
         * 
         * @param globalTableSettingsReplicationMode
         *        Controls the settings synchronization mode for the global table. For multi-account global tables, this
         *        parameter is required and the only supported value is ENABLED. For same-account global tables, this
         *        parameter is set to ENABLED_WITH_OVERRIDES.
         * @see GlobalTableSettingsReplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalTableSettingsReplicationMode
         */
        Builder globalTableSettingsReplicationMode(GlobalTableSettingsReplicationMode globalTableSettingsReplicationMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private List<AttributeDefinition> attributeDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String tableName;

        private List<KeySchemaElement> keySchema = DefaultSdkAutoConstructList.getInstance();

        private List<LocalSecondaryIndex> localSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();

        private List<GlobalSecondaryIndex> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();

        private String billingMode;

        private ProvisionedThroughput provisionedThroughput;

        private StreamSpecification streamSpecification;

        private SSESpecification sseSpecification;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String tableClass;

        private Boolean deletionProtectionEnabled;

        private WarmThroughput warmThroughput;

        private String resourcePolicy;

        private OnDemandThroughput onDemandThroughput;

        private String globalTableSourceArn;

        private String globalTableSettingsReplicationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTableRequest model) {
            super(model);
            attributeDefinitions(model.attributeDefinitions);
            tableName(model.tableName);
            keySchema(model.keySchema);
            localSecondaryIndexes(model.localSecondaryIndexes);
            globalSecondaryIndexes(model.globalSecondaryIndexes);
            billingMode(model.billingMode);
            provisionedThroughput(model.provisionedThroughput);
            streamSpecification(model.streamSpecification);
            sseSpecification(model.sseSpecification);
            tags(model.tags);
            tableClass(model.tableClass);
            deletionProtectionEnabled(model.deletionProtectionEnabled);
            warmThroughput(model.warmThroughput);
            resourcePolicy(model.resourcePolicy);
            onDemandThroughput(model.onDemandThroughput);
            globalTableSourceArn(model.globalTableSourceArn);
            globalTableSettingsReplicationMode(model.globalTableSettingsReplicationMode);
        }

        public final List<AttributeDefinition.Builder> getAttributeDefinitions() {
            List<AttributeDefinition.Builder> result = AttributeDefinitionsCopier.copyToBuilder(this.attributeDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeDefinitions(Collection<AttributeDefinition.BuilderImpl> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copyFromBuilder(attributeDefinitions);
        }

        @Override
        public final Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(AttributeDefinition... attributeDefinitions) {
            attributeDefinitions(Arrays.asList(attributeDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(Consumer<AttributeDefinition.Builder>... attributeDefinitions) {
            attributeDefinitions(Stream.of(attributeDefinitions).map(c -> AttributeDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final List<KeySchemaElement.Builder> getKeySchema() {
            List<KeySchemaElement.Builder> result = KeySchemaCopier.copyToBuilder(this.keySchema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeySchema(Collection<KeySchemaElement.BuilderImpl> keySchema) {
            this.keySchema = KeySchemaCopier.copyFromBuilder(keySchema);
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement... keySchema) {
            keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(Consumer<KeySchemaElement.Builder>... keySchema) {
            keySchema(Stream.of(keySchema).map(c -> KeySchemaElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<LocalSecondaryIndex.Builder> getLocalSecondaryIndexes() {
            List<LocalSecondaryIndex.Builder> result = LocalSecondaryIndexListCopier.copyToBuilder(this.localSecondaryIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocalSecondaryIndexes(Collection<LocalSecondaryIndex.BuilderImpl> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexListCopier.copyFromBuilder(localSecondaryIndexes);
        }

        @Override
        public final Builder localSecondaryIndexes(Collection<LocalSecondaryIndex> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexListCopier.copy(localSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexes(LocalSecondaryIndex... localSecondaryIndexes) {
            localSecondaryIndexes(Arrays.asList(localSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexes(Consumer<LocalSecondaryIndex.Builder>... localSecondaryIndexes) {
            localSecondaryIndexes(Stream.of(localSecondaryIndexes)
                    .map(c -> LocalSecondaryIndex.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GlobalSecondaryIndex.Builder> getGlobalSecondaryIndexes() {
            List<GlobalSecondaryIndex.Builder> result = GlobalSecondaryIndexListCopier.copyToBuilder(this.globalSecondaryIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalSecondaryIndexes(Collection<GlobalSecondaryIndex.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexListCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndex> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(GlobalSecondaryIndex... globalSecondaryIndexes) {
            globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(Consumer<GlobalSecondaryIndex.Builder>... globalSecondaryIndexes) {
            globalSecondaryIndexes(Stream.of(globalSecondaryIndexes)
                    .map(c -> GlobalSecondaryIndex.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getBillingMode() {
            return billingMode;
        }

        public final void setBillingMode(String billingMode) {
            this.billingMode = billingMode;
        }

        @Override
        public final Builder billingMode(String billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        @Override
        public final Builder billingMode(BillingMode billingMode) {
            this.billingMode(billingMode == null ? null : billingMode.toString());
            return this;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return provisionedThroughput != null ? provisionedThroughput.toBuilder() : null;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final StreamSpecification.Builder getStreamSpecification() {
            return streamSpecification != null ? streamSpecification.toBuilder() : null;
        }

        public final void setStreamSpecification(StreamSpecification.BuilderImpl streamSpecification) {
            this.streamSpecification = streamSpecification != null ? streamSpecification.build() : null;
        }

        @Override
        public final Builder streamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        public final SSESpecification.Builder getSseSpecification() {
            return sseSpecification != null ? sseSpecification.toBuilder() : null;
        }

        public final void setSseSpecification(SSESpecification.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        @Override
        public final Builder sseSpecification(SSESpecification sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTableClass() {
            return tableClass;
        }

        public final void setTableClass(String tableClass) {
            this.tableClass = tableClass;
        }

        @Override
        public final Builder tableClass(String tableClass) {
            this.tableClass = tableClass;
            return this;
        }

        @Override
        public final Builder tableClass(TableClass tableClass) {
            this.tableClass(tableClass == null ? null : tableClass.toString());
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        public final WarmThroughput.Builder getWarmThroughput() {
            return warmThroughput != null ? warmThroughput.toBuilder() : null;
        }

        public final void setWarmThroughput(WarmThroughput.BuilderImpl warmThroughput) {
            this.warmThroughput = warmThroughput != null ? warmThroughput.build() : null;
        }

        @Override
        public final Builder warmThroughput(WarmThroughput warmThroughput) {
            this.warmThroughput = warmThroughput;
            return this;
        }

        public final String getResourcePolicy() {
            return resourcePolicy;
        }

        public final void setResourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
        }

        @Override
        public final Builder resourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        public final OnDemandThroughput.Builder getOnDemandThroughput() {
            return onDemandThroughput != null ? onDemandThroughput.toBuilder() : null;
        }

        public final void setOnDemandThroughput(OnDemandThroughput.BuilderImpl onDemandThroughput) {
            this.onDemandThroughput = onDemandThroughput != null ? onDemandThroughput.build() : null;
        }

        @Override
        public final Builder onDemandThroughput(OnDemandThroughput onDemandThroughput) {
            this.onDemandThroughput = onDemandThroughput;
            return this;
        }

        public final String getGlobalTableSourceArn() {
            return globalTableSourceArn;
        }

        public final void setGlobalTableSourceArn(String globalTableSourceArn) {
            this.globalTableSourceArn = globalTableSourceArn;
        }

        @Override
        public final Builder globalTableSourceArn(String globalTableSourceArn) {
            this.globalTableSourceArn = globalTableSourceArn;
            return this;
        }

        public final String getGlobalTableSettingsReplicationMode() {
            return globalTableSettingsReplicationMode;
        }

        public final void setGlobalTableSettingsReplicationMode(String globalTableSettingsReplicationMode) {
            this.globalTableSettingsReplicationMode = globalTableSettingsReplicationMode;
        }

        @Override
        public final Builder globalTableSettingsReplicationMode(String globalTableSettingsReplicationMode) {
            this.globalTableSettingsReplicationMode = globalTableSettingsReplicationMode;
            return this;
        }

        @Override
        public final Builder globalTableSettingsReplicationMode(
                GlobalTableSettingsReplicationMode globalTableSettingsReplicationMode) {
            this.globalTableSettingsReplicationMode(globalTableSettingsReplicationMode == null ? null
                    : globalTableSettingsReplicationMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTableRequest build() {
            return new CreateTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
