/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsUpdate;
import software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate;
import software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdateListCopier;
import software.amazon.awssdk.services.dynamodb.model.TableClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicaSettingsUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicaSettingsUpdate> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(ReplicaSettingsUpdate.getter(ReplicaSettingsUpdate::regionName)).setter(ReplicaSettingsUpdate.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()}).build();
    private static final SdkField<Long> REPLICA_PROVISIONED_READ_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ReplicaProvisionedReadCapacityUnits").getter(ReplicaSettingsUpdate.getter(ReplicaSettingsUpdate::replicaProvisionedReadCapacityUnits)).setter(ReplicaSettingsUpdate.setter(Builder::replicaProvisionedReadCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaProvisionedReadCapacityUnits").build()}).build();
    private static final SdkField<AutoScalingSettingsUpdate> REPLICA_PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate").getter(ReplicaSettingsUpdate.getter(ReplicaSettingsUpdate::replicaProvisionedReadCapacityAutoScalingSettingsUpdate)).setter(ReplicaSettingsUpdate.setter(Builder::replicaProvisionedReadCapacityAutoScalingSettingsUpdate)).constructor(AutoScalingSettingsUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate").build()}).build();
    private static final SdkField<List<ReplicaGlobalSecondaryIndexSettingsUpdate>> REPLICA_GLOBAL_SECONDARY_INDEX_SETTINGS_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicaGlobalSecondaryIndexSettingsUpdate").getter(ReplicaSettingsUpdate.getter(ReplicaSettingsUpdate::replicaGlobalSecondaryIndexSettingsUpdate)).setter(ReplicaSettingsUpdate.setter(Builder::replicaGlobalSecondaryIndexSettingsUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaGlobalSecondaryIndexSettingsUpdate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicaGlobalSecondaryIndexSettingsUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REPLICA_TABLE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicaTableClass").getter(ReplicaSettingsUpdate.getter(ReplicaSettingsUpdate::replicaTableClassAsString)).setter(ReplicaSettingsUpdate.setter(Builder::replicaTableClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaTableClass").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD, REPLICA_PROVISIONED_READ_CAPACITY_UNITS_FIELD, REPLICA_PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_UPDATE_FIELD, REPLICA_GLOBAL_SECONDARY_INDEX_SETTINGS_UPDATE_FIELD, REPLICA_TABLE_CLASS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReplicaSettingsUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String regionName;
    private final Long replicaProvisionedReadCapacityUnits;
    private final AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingSettingsUpdate;
    private final List<ReplicaGlobalSecondaryIndexSettingsUpdate> replicaGlobalSecondaryIndexSettingsUpdate;
    private final String replicaTableClass;

    private ReplicaSettingsUpdate(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.replicaProvisionedReadCapacityUnits = builder.replicaProvisionedReadCapacityUnits;
        this.replicaProvisionedReadCapacityAutoScalingSettingsUpdate = builder.replicaProvisionedReadCapacityAutoScalingSettingsUpdate;
        this.replicaGlobalSecondaryIndexSettingsUpdate = builder.replicaGlobalSecondaryIndexSettingsUpdate;
        this.replicaTableClass = builder.replicaTableClass;
    }

    public final String regionName() {
        return this.regionName;
    }

    public final Long replicaProvisionedReadCapacityUnits() {
        return this.replicaProvisionedReadCapacityUnits;
    }

    public final AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingSettingsUpdate() {
        return this.replicaProvisionedReadCapacityAutoScalingSettingsUpdate;
    }

    public final boolean hasReplicaGlobalSecondaryIndexSettingsUpdate() {
        return this.replicaGlobalSecondaryIndexSettingsUpdate != null && !(this.replicaGlobalSecondaryIndexSettingsUpdate instanceof SdkAutoConstructList);
    }

    public final List<ReplicaGlobalSecondaryIndexSettingsUpdate> replicaGlobalSecondaryIndexSettingsUpdate() {
        return this.replicaGlobalSecondaryIndexSettingsUpdate;
    }

    public final TableClass replicaTableClass() {
        return TableClass.fromValue(this.replicaTableClass);
    }

    public final String replicaTableClassAsString() {
        return this.replicaTableClass;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaProvisionedReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaProvisionedReadCapacityAutoScalingSettingsUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicaGlobalSecondaryIndexSettingsUpdate() ? this.replicaGlobalSecondaryIndexSettingsUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaTableClassAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaSettingsUpdate)) {
            return false;
        }
        ReplicaSettingsUpdate other = (ReplicaSettingsUpdate)obj;
        return Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.replicaProvisionedReadCapacityUnits(), other.replicaProvisionedReadCapacityUnits()) && Objects.equals(this.replicaProvisionedReadCapacityAutoScalingSettingsUpdate(), other.replicaProvisionedReadCapacityAutoScalingSettingsUpdate()) && this.hasReplicaGlobalSecondaryIndexSettingsUpdate() == other.hasReplicaGlobalSecondaryIndexSettingsUpdate() && Objects.equals(this.replicaGlobalSecondaryIndexSettingsUpdate(), other.replicaGlobalSecondaryIndexSettingsUpdate()) && Objects.equals(this.replicaTableClassAsString(), other.replicaTableClassAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicaSettingsUpdate").add("RegionName", (Object)this.regionName()).add("ReplicaProvisionedReadCapacityUnits", (Object)this.replicaProvisionedReadCapacityUnits()).add("ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate", (Object)this.replicaProvisionedReadCapacityAutoScalingSettingsUpdate()).add("ReplicaGlobalSecondaryIndexSettingsUpdate", this.hasReplicaGlobalSecondaryIndexSettingsUpdate() ? this.replicaGlobalSecondaryIndexSettingsUpdate() : null).add("ReplicaTableClass", (Object)this.replicaTableClassAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "ReplicaProvisionedReadCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.replicaProvisionedReadCapacityUnits()));
            }
            case "ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate": {
                return Optional.ofNullable(clazz.cast(this.replicaProvisionedReadCapacityAutoScalingSettingsUpdate()));
            }
            case "ReplicaGlobalSecondaryIndexSettingsUpdate": {
                return Optional.ofNullable(clazz.cast(this.replicaGlobalSecondaryIndexSettingsUpdate()));
            }
            case "ReplicaTableClass": {
                return Optional.ofNullable(clazz.cast(this.replicaTableClassAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RegionName", REGION_NAME_FIELD);
        map.put("ReplicaProvisionedReadCapacityUnits", REPLICA_PROVISIONED_READ_CAPACITY_UNITS_FIELD);
        map.put("ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate", REPLICA_PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_UPDATE_FIELD);
        map.put("ReplicaGlobalSecondaryIndexSettingsUpdate", REPLICA_GLOBAL_SECONDARY_INDEX_SETTINGS_UPDATE_FIELD);
        map.put("ReplicaTableClass", REPLICA_TABLE_CLASS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicaSettingsUpdate, T> g) {
        return obj -> g.apply((ReplicaSettingsUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String regionName;
        private Long replicaProvisionedReadCapacityUnits;
        private AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingSettingsUpdate;
        private List<ReplicaGlobalSecondaryIndexSettingsUpdate> replicaGlobalSecondaryIndexSettingsUpdate = DefaultSdkAutoConstructList.getInstance();
        private String replicaTableClass;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaSettingsUpdate model) {
            this.regionName(model.regionName);
            this.replicaProvisionedReadCapacityUnits(model.replicaProvisionedReadCapacityUnits);
            this.replicaProvisionedReadCapacityAutoScalingSettingsUpdate(model.replicaProvisionedReadCapacityAutoScalingSettingsUpdate);
            this.replicaGlobalSecondaryIndexSettingsUpdate(model.replicaGlobalSecondaryIndexSettingsUpdate);
            this.replicaTableClass(model.replicaTableClass);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final Long getReplicaProvisionedReadCapacityUnits() {
            return this.replicaProvisionedReadCapacityUnits;
        }

        public final void setReplicaProvisionedReadCapacityUnits(Long replicaProvisionedReadCapacityUnits) {
            this.replicaProvisionedReadCapacityUnits = replicaProvisionedReadCapacityUnits;
        }

        @Override
        public final Builder replicaProvisionedReadCapacityUnits(Long replicaProvisionedReadCapacityUnits) {
            this.replicaProvisionedReadCapacityUnits = replicaProvisionedReadCapacityUnits;
            return this;
        }

        public final AutoScalingSettingsUpdate.Builder getReplicaProvisionedReadCapacityAutoScalingSettingsUpdate() {
            return this.replicaProvisionedReadCapacityAutoScalingSettingsUpdate != null ? this.replicaProvisionedReadCapacityAutoScalingSettingsUpdate.toBuilder() : null;
        }

        public final void setReplicaProvisionedReadCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate.BuilderImpl replicaProvisionedReadCapacityAutoScalingSettingsUpdate) {
            this.replicaProvisionedReadCapacityAutoScalingSettingsUpdate = replicaProvisionedReadCapacityAutoScalingSettingsUpdate != null ? replicaProvisionedReadCapacityAutoScalingSettingsUpdate.build() : null;
        }

        @Override
        public final Builder replicaProvisionedReadCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingSettingsUpdate) {
            this.replicaProvisionedReadCapacityAutoScalingSettingsUpdate = replicaProvisionedReadCapacityAutoScalingSettingsUpdate;
            return this;
        }

        public final List<ReplicaGlobalSecondaryIndexSettingsUpdate.Builder> getReplicaGlobalSecondaryIndexSettingsUpdate() {
            List<ReplicaGlobalSecondaryIndexSettingsUpdate.Builder> result = ReplicaGlobalSecondaryIndexSettingsUpdateListCopier.copyToBuilder(this.replicaGlobalSecondaryIndexSettingsUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicaGlobalSecondaryIndexSettingsUpdate(Collection<ReplicaGlobalSecondaryIndexSettingsUpdate.BuilderImpl> replicaGlobalSecondaryIndexSettingsUpdate) {
            this.replicaGlobalSecondaryIndexSettingsUpdate = ReplicaGlobalSecondaryIndexSettingsUpdateListCopier.copyFromBuilder(replicaGlobalSecondaryIndexSettingsUpdate);
        }

        @Override
        public final Builder replicaGlobalSecondaryIndexSettingsUpdate(Collection<ReplicaGlobalSecondaryIndexSettingsUpdate> replicaGlobalSecondaryIndexSettingsUpdate) {
            this.replicaGlobalSecondaryIndexSettingsUpdate = ReplicaGlobalSecondaryIndexSettingsUpdateListCopier.copy(replicaGlobalSecondaryIndexSettingsUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaGlobalSecondaryIndexSettingsUpdate(ReplicaGlobalSecondaryIndexSettingsUpdate ... replicaGlobalSecondaryIndexSettingsUpdate) {
            this.replicaGlobalSecondaryIndexSettingsUpdate(Arrays.asList(replicaGlobalSecondaryIndexSettingsUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaGlobalSecondaryIndexSettingsUpdate(Consumer<ReplicaGlobalSecondaryIndexSettingsUpdate.Builder> ... replicaGlobalSecondaryIndexSettingsUpdate) {
            this.replicaGlobalSecondaryIndexSettingsUpdate(Stream.of(replicaGlobalSecondaryIndexSettingsUpdate).map(c -> (ReplicaGlobalSecondaryIndexSettingsUpdate)((ReplicaGlobalSecondaryIndexSettingsUpdate.Builder)ReplicaGlobalSecondaryIndexSettingsUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReplicaTableClass() {
            return this.replicaTableClass;
        }

        public final void setReplicaTableClass(String replicaTableClass) {
            this.replicaTableClass = replicaTableClass;
        }

        @Override
        public final Builder replicaTableClass(String replicaTableClass) {
            this.replicaTableClass = replicaTableClass;
            return this;
        }

        @Override
        public final Builder replicaTableClass(TableClass replicaTableClass) {
            this.replicaTableClass(replicaTableClass == null ? null : replicaTableClass.toString());
            return this;
        }

        public ReplicaSettingsUpdate build() {
            return new ReplicaSettingsUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicaSettingsUpdate> {
        public Builder regionName(String var1);

        public Builder replicaProvisionedReadCapacityUnits(Long var1);

        public Builder replicaProvisionedReadCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate var1);

        default public Builder replicaProvisionedReadCapacityAutoScalingSettingsUpdate(Consumer<AutoScalingSettingsUpdate.Builder> replicaProvisionedReadCapacityAutoScalingSettingsUpdate) {
            return this.replicaProvisionedReadCapacityAutoScalingSettingsUpdate((AutoScalingSettingsUpdate)((AutoScalingSettingsUpdate.Builder)AutoScalingSettingsUpdate.builder().applyMutation(replicaProvisionedReadCapacityAutoScalingSettingsUpdate)).build());
        }

        public Builder replicaGlobalSecondaryIndexSettingsUpdate(Collection<ReplicaGlobalSecondaryIndexSettingsUpdate> var1);

        public Builder replicaGlobalSecondaryIndexSettingsUpdate(ReplicaGlobalSecondaryIndexSettingsUpdate ... var1);

        public Builder replicaGlobalSecondaryIndexSettingsUpdate(Consumer<ReplicaGlobalSecondaryIndexSettingsUpdate.Builder> ... var1);

        public Builder replicaTableClass(String var1);

        public Builder replicaTableClass(TableClass var1);
    }
}

