/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for the table created as part of the import operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableCreationParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<TableCreationParameters.Builder, TableCreationParameters> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(TableCreationParameters::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<List<AttributeDefinition>> ATTRIBUTE_DEFINITIONS_FIELD = SdkField
            .<List<AttributeDefinition>> builder(MarshallingType.LIST)
            .memberName("AttributeDefinitions")
            .getter(getter(TableCreationParameters::attributeDefinitions))
            .setter(setter(Builder::attributeDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<KeySchemaElement>> KEY_SCHEMA_FIELD = SdkField
            .<List<KeySchemaElement>> builder(MarshallingType.LIST)
            .memberName("KeySchema")
            .getter(getter(TableCreationParameters::keySchema))
            .setter(setter(Builder::keySchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySchema").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeySchemaElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeySchemaElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BILLING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingMode").getter(getter(TableCreationParameters::billingModeAsString))
            .setter(setter(Builder::billingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingMode").build()).build();

    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField
            .<ProvisionedThroughput> builder(MarshallingType.SDK_POJO).memberName("ProvisionedThroughput")
            .getter(getter(TableCreationParameters::provisionedThroughput)).setter(setter(Builder::provisionedThroughput))
            .constructor(ProvisionedThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughput").build())
            .build();

    private static final SdkField<OnDemandThroughput> ON_DEMAND_THROUGHPUT_FIELD = SdkField
            .<OnDemandThroughput> builder(MarshallingType.SDK_POJO).memberName("OnDemandThroughput")
            .getter(getter(TableCreationParameters::onDemandThroughput)).setter(setter(Builder::onDemandThroughput))
            .constructor(OnDemandThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandThroughput").build())
            .build();

    private static final SdkField<SSESpecification> SSE_SPECIFICATION_FIELD = SdkField
            .<SSESpecification> builder(MarshallingType.SDK_POJO).memberName("SSESpecification")
            .getter(getter(TableCreationParameters::sseSpecification)).setter(setter(Builder::sseSpecification))
            .constructor(SSESpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSESpecification").build()).build();

    private static final SdkField<List<GlobalSecondaryIndex>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField
            .<List<GlobalSecondaryIndex>> builder(MarshallingType.LIST)
            .memberName("GlobalSecondaryIndexes")
            .getter(getter(TableCreationParameters::globalSecondaryIndexes))
            .setter(setter(Builder::globalSecondaryIndexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlobalSecondaryIndex> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlobalSecondaryIndex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD,
            ATTRIBUTE_DEFINITIONS_FIELD, KEY_SCHEMA_FIELD, BILLING_MODE_FIELD, PROVISIONED_THROUGHPUT_FIELD,
            ON_DEMAND_THROUGHPUT_FIELD, SSE_SPECIFICATION_FIELD, GLOBAL_SECONDARY_INDEXES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TableName", TABLE_NAME_FIELD);
                    put("AttributeDefinitions", ATTRIBUTE_DEFINITIONS_FIELD);
                    put("KeySchema", KEY_SCHEMA_FIELD);
                    put("BillingMode", BILLING_MODE_FIELD);
                    put("ProvisionedThroughput", PROVISIONED_THROUGHPUT_FIELD);
                    put("OnDemandThroughput", ON_DEMAND_THROUGHPUT_FIELD);
                    put("SSESpecification", SSE_SPECIFICATION_FIELD);
                    put("GlobalSecondaryIndexes", GLOBAL_SECONDARY_INDEXES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String tableName;

    private final List<AttributeDefinition> attributeDefinitions;

    private final List<KeySchemaElement> keySchema;

    private final String billingMode;

    private final ProvisionedThroughput provisionedThroughput;

    private final OnDemandThroughput onDemandThroughput;

    private final SSESpecification sseSpecification;

    private final List<GlobalSecondaryIndex> globalSecondaryIndexes;

    private TableCreationParameters(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.attributeDefinitions = builder.attributeDefinitions;
        this.keySchema = builder.keySchema;
        this.billingMode = builder.billingMode;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.onDemandThroughput = builder.onDemandThroughput;
        this.sseSpecification = builder.sseSpecification;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
    }

    /**
     * <p>
     * The name of the table created as part of the import operation.
     * </p>
     * 
     * @return The name of the table created as part of the import operation.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeDefinitions() {
        return attributeDefinitions != null && !(attributeDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes of the table created as part of the import operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeDefinitions} method.
     * </p>
     * 
     * @return The attributes of the table created as part of the import operation.
     */
    public final List<AttributeDefinition> attributeDefinitions() {
        return attributeDefinitions;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeySchema property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasKeySchema() {
        return keySchema != null && !(keySchema instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The primary key and option sort key of the table created as part of the import operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeySchema} method.
     * </p>
     * 
     * @return The primary key and option sort key of the table created as part of the import operation.
     */
    public final List<KeySchemaElement> keySchema() {
        return keySchema;
    }

    /**
     * <p>
     * The billing mode for provisioning the table created as part of the import operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMode} will
     * return {@link BillingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingModeAsString}.
     * </p>
     * 
     * @return The billing mode for provisioning the table created as part of the import operation.
     * @see BillingMode
     */
    public final BillingMode billingMode() {
        return BillingMode.fromValue(billingMode);
    }

    /**
     * <p>
     * The billing mode for provisioning the table created as part of the import operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMode} will
     * return {@link BillingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingModeAsString}.
     * </p>
     * 
     * @return The billing mode for provisioning the table created as part of the import operation.
     * @see BillingMode
     */
    public final String billingModeAsString() {
        return billingMode;
    }

    /**
     * Returns the value of the ProvisionedThroughput property for this object.
     * 
     * @return The value of the ProvisionedThroughput property for this object.
     */
    public final ProvisionedThroughput provisionedThroughput() {
        return provisionedThroughput;
    }

    /**
     * Returns the value of the OnDemandThroughput property for this object.
     * 
     * @return The value of the OnDemandThroughput property for this object.
     */
    public final OnDemandThroughput onDemandThroughput() {
        return onDemandThroughput;
    }

    /**
     * Returns the value of the SSESpecification property for this object.
     * 
     * @return The value of the SSESpecification property for this object.
     */
    public final SSESpecification sseSpecification() {
        return sseSpecification;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlobalSecondaryIndexes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGlobalSecondaryIndexes() {
        return globalSecondaryIndexes != null && !(globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Global Secondary Indexes (GSI) of the table to be created as part of the import operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlobalSecondaryIndexes} method.
     * </p>
     * 
     * @return The Global Secondary Indexes (GSI) of the table to be created as part of the import operation.
     */
    public final List<GlobalSecondaryIndex> globalSecondaryIndexes() {
        return globalSecondaryIndexes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeDefinitions() ? attributeDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasKeySchema() ? keySchema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(billingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(sseSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalSecondaryIndexes() ? globalSecondaryIndexes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableCreationParameters)) {
            return false;
        }
        TableCreationParameters other = (TableCreationParameters) obj;
        return Objects.equals(tableName(), other.tableName()) && hasAttributeDefinitions() == other.hasAttributeDefinitions()
                && Objects.equals(attributeDefinitions(), other.attributeDefinitions()) && hasKeySchema() == other.hasKeySchema()
                && Objects.equals(keySchema(), other.keySchema())
                && Objects.equals(billingModeAsString(), other.billingModeAsString())
                && Objects.equals(provisionedThroughput(), other.provisionedThroughput())
                && Objects.equals(onDemandThroughput(), other.onDemandThroughput())
                && Objects.equals(sseSpecification(), other.sseSpecification())
                && hasGlobalSecondaryIndexes() == other.hasGlobalSecondaryIndexes()
                && Objects.equals(globalSecondaryIndexes(), other.globalSecondaryIndexes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableCreationParameters").add("TableName", tableName())
                .add("AttributeDefinitions", hasAttributeDefinitions() ? attributeDefinitions() : null)
                .add("KeySchema", hasKeySchema() ? keySchema() : null).add("BillingMode", billingModeAsString())
                .add("ProvisionedThroughput", provisionedThroughput()).add("OnDemandThroughput", onDemandThroughput())
                .add("SSESpecification", sseSpecification())
                .add("GlobalSecondaryIndexes", hasGlobalSecondaryIndexes() ? globalSecondaryIndexes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "AttributeDefinitions":
            return Optional.ofNullable(clazz.cast(attributeDefinitions()));
        case "KeySchema":
            return Optional.ofNullable(clazz.cast(keySchema()));
        case "BillingMode":
            return Optional.ofNullable(clazz.cast(billingModeAsString()));
        case "ProvisionedThroughput":
            return Optional.ofNullable(clazz.cast(provisionedThroughput()));
        case "OnDemandThroughput":
            return Optional.ofNullable(clazz.cast(onDemandThroughput()));
        case "SSESpecification":
            return Optional.ofNullable(clazz.cast(sseSpecification()));
        case "GlobalSecondaryIndexes":
            return Optional.ofNullable(clazz.cast(globalSecondaryIndexes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TableCreationParameters, T> g) {
        return obj -> g.apply((TableCreationParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableCreationParameters> {
        /**
         * <p>
         * The name of the table created as part of the import operation.
         * </p>
         * 
         * @param tableName
         *        The name of the table created as part of the import operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The attributes of the table created as part of the import operation.
         * </p>
         * 
         * @param attributeDefinitions
         *        The attributes of the table created as part of the import operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions);

        /**
         * <p>
         * The attributes of the table created as part of the import operation.
         * </p>
         * 
         * @param attributeDefinitions
         *        The attributes of the table created as part of the import operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDefinitions(AttributeDefinition... attributeDefinitions);

        /**
         * <p>
         * The attributes of the table created as part of the import operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dynamodb.model.AttributeDefinition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.dynamodb.model.AttributeDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dynamodb.model.AttributeDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #attributeDefinitions(List<AttributeDefinition>)}.
         * 
         * @param attributeDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dynamodb.model.AttributeDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeDefinitions(java.util.Collection<AttributeDefinition>)
         */
        Builder attributeDefinitions(Consumer<AttributeDefinition.Builder>... attributeDefinitions);

        /**
         * <p>
         * The primary key and option sort key of the table created as part of the import operation.
         * </p>
         * 
         * @param keySchema
         *        The primary key and option sort key of the table created as part of the import operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(Collection<KeySchemaElement> keySchema);

        /**
         * <p>
         * The primary key and option sort key of the table created as part of the import operation.
         * </p>
         * 
         * @param keySchema
         *        The primary key and option sort key of the table created as part of the import operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(KeySchemaElement... keySchema);

        /**
         * <p>
         * The primary key and option sort key of the table created as part of the import operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dynamodb.model.KeySchemaElement.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.dynamodb.model.KeySchemaElement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dynamodb.model.KeySchemaElement.Builder#build()} is called immediately
         * and its result is passed to {@link #keySchema(List<KeySchemaElement>)}.
         * 
         * @param keySchema
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dynamodb.model.KeySchemaElement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keySchema(java.util.Collection<KeySchemaElement>)
         */
        Builder keySchema(Consumer<KeySchemaElement.Builder>... keySchema);

        /**
         * <p>
         * The billing mode for provisioning the table created as part of the import operation.
         * </p>
         * 
         * @param billingMode
         *        The billing mode for provisioning the table created as part of the import operation.
         * @see BillingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMode
         */
        Builder billingMode(String billingMode);

        /**
         * <p>
         * The billing mode for provisioning the table created as part of the import operation.
         * </p>
         * 
         * @param billingMode
         *        The billing mode for provisioning the table created as part of the import operation.
         * @see BillingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMode
         */
        Builder billingMode(BillingMode billingMode);

        /**
         * Sets the value of the ProvisionedThroughput property for this object.
         *
         * @param provisionedThroughput
         *        The new value for the ProvisionedThroughput property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput);

        /**
         * Sets the value of the ProvisionedThroughput property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ProvisionedThroughput.Builder} avoiding
         * the need to create one manually via {@link ProvisionedThroughput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisionedThroughput.Builder#build()} is called immediately and
         * its result is passed to {@link #provisionedThroughput(ProvisionedThroughput)}.
         * 
         * @param provisionedThroughput
         *        a consumer that will call methods on {@link ProvisionedThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughput(ProvisionedThroughput)
         */
        default Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return provisionedThroughput(ProvisionedThroughput.builder().applyMutation(provisionedThroughput).build());
        }

        /**
         * Sets the value of the OnDemandThroughput property for this object.
         *
         * @param onDemandThroughput
         *        The new value for the OnDemandThroughput property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandThroughput(OnDemandThroughput onDemandThroughput);

        /**
         * Sets the value of the OnDemandThroughput property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OnDemandThroughput.Builder} avoiding the
         * need to create one manually via {@link OnDemandThroughput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnDemandThroughput.Builder#build()} is called immediately and its
         * result is passed to {@link #onDemandThroughput(OnDemandThroughput)}.
         * 
         * @param onDemandThroughput
         *        a consumer that will call methods on {@link OnDemandThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onDemandThroughput(OnDemandThroughput)
         */
        default Builder onDemandThroughput(Consumer<OnDemandThroughput.Builder> onDemandThroughput) {
            return onDemandThroughput(OnDemandThroughput.builder().applyMutation(onDemandThroughput).build());
        }

        /**
         * Sets the value of the SSESpecification property for this object.
         *
         * @param sseSpecification
         *        The new value for the SSESpecification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseSpecification(SSESpecification sseSpecification);

        /**
         * Sets the value of the SSESpecification property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SSESpecification.Builder} avoiding the
         * need to create one manually via {@link SSESpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SSESpecification.Builder#build()} is called immediately and its
         * result is passed to {@link #sseSpecification(SSESpecification)}.
         * 
         * @param sseSpecification
         *        a consumer that will call methods on {@link SSESpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseSpecification(SSESpecification)
         */
        default Builder sseSpecification(Consumer<SSESpecification.Builder> sseSpecification) {
            return sseSpecification(SSESpecification.builder().applyMutation(sseSpecification).build());
        }

        /**
         * <p>
         * The Global Secondary Indexes (GSI) of the table to be created as part of the import operation.
         * </p>
         * 
         * @param globalSecondaryIndexes
         *        The Global Secondary Indexes (GSI) of the table to be created as part of the import operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndex> globalSecondaryIndexes);

        /**
         * <p>
         * The Global Secondary Indexes (GSI) of the table to be created as part of the import operation.
         * </p>
         * 
         * @param globalSecondaryIndexes
         *        The Global Secondary Indexes (GSI) of the table to be created as part of the import operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(GlobalSecondaryIndex... globalSecondaryIndexes);

        /**
         * <p>
         * The Global Secondary Indexes (GSI) of the table to be created as part of the import operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex.Builder#build()} is called
         * immediately and its result is passed to {@link #globalSecondaryIndexes(List<GlobalSecondaryIndex>)}.
         * 
         * @param globalSecondaryIndexes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalSecondaryIndexes(java.util.Collection<GlobalSecondaryIndex>)
         */
        Builder globalSecondaryIndexes(Consumer<GlobalSecondaryIndex.Builder>... globalSecondaryIndexes);
    }

    static final class BuilderImpl implements Builder {
        private String tableName;

        private List<AttributeDefinition> attributeDefinitions = DefaultSdkAutoConstructList.getInstance();

        private List<KeySchemaElement> keySchema = DefaultSdkAutoConstructList.getInstance();

        private String billingMode;

        private ProvisionedThroughput provisionedThroughput;

        private OnDemandThroughput onDemandThroughput;

        private SSESpecification sseSpecification;

        private List<GlobalSecondaryIndex> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TableCreationParameters model) {
            tableName(model.tableName);
            attributeDefinitions(model.attributeDefinitions);
            keySchema(model.keySchema);
            billingMode(model.billingMode);
            provisionedThroughput(model.provisionedThroughput);
            onDemandThroughput(model.onDemandThroughput);
            sseSpecification(model.sseSpecification);
            globalSecondaryIndexes(model.globalSecondaryIndexes);
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final List<AttributeDefinition.Builder> getAttributeDefinitions() {
            List<AttributeDefinition.Builder> result = AttributeDefinitionsCopier.copyToBuilder(this.attributeDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeDefinitions(Collection<AttributeDefinition.BuilderImpl> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copyFromBuilder(attributeDefinitions);
        }

        @Override
        public final Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(AttributeDefinition... attributeDefinitions) {
            attributeDefinitions(Arrays.asList(attributeDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(Consumer<AttributeDefinition.Builder>... attributeDefinitions) {
            attributeDefinitions(Stream.of(attributeDefinitions).map(c -> AttributeDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<KeySchemaElement.Builder> getKeySchema() {
            List<KeySchemaElement.Builder> result = KeySchemaCopier.copyToBuilder(this.keySchema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeySchema(Collection<KeySchemaElement.BuilderImpl> keySchema) {
            this.keySchema = KeySchemaCopier.copyFromBuilder(keySchema);
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement... keySchema) {
            keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(Consumer<KeySchemaElement.Builder>... keySchema) {
            keySchema(Stream.of(keySchema).map(c -> KeySchemaElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getBillingMode() {
            return billingMode;
        }

        public final void setBillingMode(String billingMode) {
            this.billingMode = billingMode;
        }

        @Override
        public final Builder billingMode(String billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        @Override
        public final Builder billingMode(BillingMode billingMode) {
            this.billingMode(billingMode == null ? null : billingMode.toString());
            return this;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return provisionedThroughput != null ? provisionedThroughput.toBuilder() : null;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final OnDemandThroughput.Builder getOnDemandThroughput() {
            return onDemandThroughput != null ? onDemandThroughput.toBuilder() : null;
        }

        public final void setOnDemandThroughput(OnDemandThroughput.BuilderImpl onDemandThroughput) {
            this.onDemandThroughput = onDemandThroughput != null ? onDemandThroughput.build() : null;
        }

        @Override
        public final Builder onDemandThroughput(OnDemandThroughput onDemandThroughput) {
            this.onDemandThroughput = onDemandThroughput;
            return this;
        }

        public final SSESpecification.Builder getSseSpecification() {
            return sseSpecification != null ? sseSpecification.toBuilder() : null;
        }

        public final void setSseSpecification(SSESpecification.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        @Override
        public final Builder sseSpecification(SSESpecification sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        public final List<GlobalSecondaryIndex.Builder> getGlobalSecondaryIndexes() {
            List<GlobalSecondaryIndex.Builder> result = GlobalSecondaryIndexListCopier.copyToBuilder(this.globalSecondaryIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalSecondaryIndexes(Collection<GlobalSecondaryIndex.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexListCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndex> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(GlobalSecondaryIndex... globalSecondaryIndexes) {
            globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(Consumer<GlobalSecondaryIndex.Builder>... globalSecondaryIndexes) {
            globalSecondaryIndexes(Stream.of(globalSecondaryIndexes)
                    .map(c -> GlobalSecondaryIndex.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TableCreationParameters build() {
            return new TableCreationParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
