/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetItem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetItemResponse extends DynamoDbResponse implements
        ToCopyableBuilder<GetItemResponse.Builder, GetItemResponse> {
    private static final SdkField<Map<String, AttributeValue>> ITEM_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .memberName("Item")
            .getter(getter(GetItemResponse::item))
            .setter(setter(Builder::item))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ConsumedCapacity> CONSUMED_CAPACITY_FIELD = SdkField
            .<ConsumedCapacity> builder(MarshallingType.SDK_POJO).memberName("ConsumedCapacity")
            .getter(getter(GetItemResponse::consumedCapacity)).setter(setter(Builder::consumedCapacity))
            .constructor(ConsumedCapacity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD,
            CONSUMED_CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Item", ITEM_FIELD);
                    put("ConsumedCapacity", CONSUMED_CAPACITY_FIELD);
                }
            });

    private final Map<String, AttributeValue> item;

    private final ConsumedCapacity consumedCapacity;

    private GetItemResponse(BuilderImpl builder) {
        super(builder);
        this.item = builder.item;
        this.consumedCapacity = builder.consumedCapacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Item property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItem() {
        return item != null && !(item instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of attribute names to <code>AttributeValue</code> objects, as specified by
     * <code>ProjectionExpression</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItem} method.
     * </p>
     * 
     * @return A map of attribute names to <code>AttributeValue</code> objects, as specified by
     *         <code>ProjectionExpression</code>.
     */
    public final Map<String, AttributeValue> item() {
        return item;
    }

    /**
     * <p>
     * The capacity units consumed by the <code>GetItem</code> operation. The data returned includes the total
     * provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation.
     * <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code> parameter was
     * specified. For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/read-write-operations.html#read-operation-consumption"
     * >Capacity unit consumption for read operations</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The capacity units consumed by the <code>GetItem</code> operation. The data returned includes the total
     *         provisioned throughput consumed, along with statistics for the table and any indexes involved in the
     *         operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
     *         parameter was specified. For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/read-write-operations.html#read-operation-consumption"
     *         >Capacity unit consumption for read operations</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public final ConsumedCapacity consumedCapacity() {
        return consumedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasItem() ? item() : null);
        hashCode = 31 * hashCode + Objects.hashCode(consumedCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetItemResponse)) {
            return false;
        }
        GetItemResponse other = (GetItemResponse) obj;
        return hasItem() == other.hasItem() && Objects.equals(item(), other.item())
                && Objects.equals(consumedCapacity(), other.consumedCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetItemResponse").add("Item", hasItem() ? item() : null)
                .add("ConsumedCapacity", consumedCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Item":
            return Optional.ofNullable(clazz.cast(item()));
        case "ConsumedCapacity":
            return Optional.ofNullable(clazz.cast(consumedCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetItemResponse, T> g) {
        return obj -> g.apply((GetItemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetItemResponse> {
        /**
         * <p>
         * A map of attribute names to <code>AttributeValue</code> objects, as specified by
         * <code>ProjectionExpression</code>.
         * </p>
         * 
         * @param item
         *        A map of attribute names to <code>AttributeValue</code> objects, as specified by
         *        <code>ProjectionExpression</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(Map<String, AttributeValue> item);

        /**
         * <p>
         * The capacity units consumed by the <code>GetItem</code> operation. The data returned includes the total
         * provisioned throughput consumed, along with statistics for the table and any indexes involved in the
         * operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
         * parameter was specified. For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/read-write-operations.html#read-operation-consumption"
         * >Capacity unit consumption for read operations</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param consumedCapacity
         *        The capacity units consumed by the <code>GetItem</code> operation. The data returned includes the
         *        total provisioned throughput consumed, along with statistics for the table and any indexes involved in
         *        the operation. <code>ConsumedCapacity</code> is only returned if the
         *        <code>ReturnConsumedCapacity</code> parameter was specified. For more information, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/read-write-operations.html#read-operation-consumption"
         *        >Capacity unit consumption for read operations</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(ConsumedCapacity consumedCapacity);

        /**
         * <p>
         * The capacity units consumed by the <code>GetItem</code> operation. The data returned includes the total
         * provisioned throughput consumed, along with statistics for the table and any indexes involved in the
         * operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
         * parameter was specified. For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/read-write-operations.html#read-operation-consumption"
         * >Capacity unit consumption for read operations</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConsumedCapacity.Builder} avoiding the
         * need to create one manually via {@link ConsumedCapacity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConsumedCapacity.Builder#build()} is called immediately and its
         * result is passed to {@link #consumedCapacity(ConsumedCapacity)}.
         * 
         * @param consumedCapacity
         *        a consumer that will call methods on {@link ConsumedCapacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumedCapacity(ConsumedCapacity)
         */
        default Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> consumedCapacity) {
            return consumedCapacity(ConsumedCapacity.builder().applyMutation(consumedCapacity).build());
        }
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private Map<String, AttributeValue> item = DefaultSdkAutoConstructMap.getInstance();

        private ConsumedCapacity consumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(GetItemResponse model) {
            super(model);
            item(model.item);
            consumedCapacity(model.consumedCapacity);
        }

        public final Map<String, AttributeValue.Builder> getItem() {
            Map<String, AttributeValue.Builder> result = AttributeMapCopier.copyToBuilder(this.item);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setItem(Map<String, AttributeValue.BuilderImpl> item) {
            this.item = AttributeMapCopier.copyFromBuilder(item);
        }

        @Override
        public final Builder item(Map<String, AttributeValue> item) {
            this.item = AttributeMapCopier.copy(item);
            return this;
        }

        public final ConsumedCapacity.Builder getConsumedCapacity() {
            return consumedCapacity != null ? consumedCapacity.toBuilder() : null;
        }

        public final void setConsumedCapacity(ConsumedCapacity.BuilderImpl consumedCapacity) {
            this.consumedCapacity = consumedCapacity != null ? consumedCapacity.build() : null;
        }

        @Override
        public final Builder consumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        @Override
        public GetItemResponse build() {
            return new GetItemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
