/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.ExportFormat;
import software.amazon.awssdk.services.dynamodb.model.S3SseAlgorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportTableToPointInTimeRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, ExportTableToPointInTimeRequest> {
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableArn").getter(ExportTableToPointInTimeRequest.getter(ExportTableToPointInTimeRequest::tableArn)).setter(ExportTableToPointInTimeRequest.setter(Builder::tableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").build()}).build();
    private static final SdkField<Instant> EXPORT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExportTime").getter(ExportTableToPointInTimeRequest.getter(ExportTableToPointInTimeRequest::exportTime)).setter(ExportTableToPointInTimeRequest.setter(Builder::exportTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportTime").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ExportTableToPointInTimeRequest.getter(ExportTableToPointInTimeRequest::clientToken)).setter(ExportTableToPointInTimeRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Bucket").getter(ExportTableToPointInTimeRequest.getter(ExportTableToPointInTimeRequest::s3Bucket)).setter(ExportTableToPointInTimeRequest.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()}).build();
    private static final SdkField<String> S3_BUCKET_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketOwner").getter(ExportTableToPointInTimeRequest.getter(ExportTableToPointInTimeRequest::s3BucketOwner)).setter(ExportTableToPointInTimeRequest.setter(Builder::s3BucketOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketOwner").build()}).build();
    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Prefix").getter(ExportTableToPointInTimeRequest.getter(ExportTableToPointInTimeRequest::s3Prefix)).setter(ExportTableToPointInTimeRequest.setter(Builder::s3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()}).build();
    private static final SdkField<String> S3_SSE_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3SseAlgorithm").getter(ExportTableToPointInTimeRequest.getter(ExportTableToPointInTimeRequest::s3SseAlgorithmAsString)).setter(ExportTableToPointInTimeRequest.setter(Builder::s3SseAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3SseAlgorithm").build()}).build();
    private static final SdkField<String> S3_SSE_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3SseKmsKeyId").getter(ExportTableToPointInTimeRequest.getter(ExportTableToPointInTimeRequest::s3SseKmsKeyId)).setter(ExportTableToPointInTimeRequest.setter(Builder::s3SseKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3SseKmsKeyId").build()}).build();
    private static final SdkField<String> EXPORT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportFormat").getter(ExportTableToPointInTimeRequest.getter(ExportTableToPointInTimeRequest::exportFormatAsString)).setter(ExportTableToPointInTimeRequest.setter(Builder::exportFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_ARN_FIELD, EXPORT_TIME_FIELD, CLIENT_TOKEN_FIELD, S3_BUCKET_FIELD, S3_BUCKET_OWNER_FIELD, S3_PREFIX_FIELD, S3_SSE_ALGORITHM_FIELD, S3_SSE_KMS_KEY_ID_FIELD, EXPORT_FORMAT_FIELD));
    private final String tableArn;
    private final Instant exportTime;
    private final String clientToken;
    private final String s3Bucket;
    private final String s3BucketOwner;
    private final String s3Prefix;
    private final String s3SseAlgorithm;
    private final String s3SseKmsKeyId;
    private final String exportFormat;

    private ExportTableToPointInTimeRequest(BuilderImpl builder) {
        super(builder);
        this.tableArn = builder.tableArn;
        this.exportTime = builder.exportTime;
        this.clientToken = builder.clientToken;
        this.s3Bucket = builder.s3Bucket;
        this.s3BucketOwner = builder.s3BucketOwner;
        this.s3Prefix = builder.s3Prefix;
        this.s3SseAlgorithm = builder.s3SseAlgorithm;
        this.s3SseKmsKeyId = builder.s3SseKmsKeyId;
        this.exportFormat = builder.exportFormat;
    }

    public final String tableArn() {
        return this.tableArn;
    }

    public final Instant exportTime() {
        return this.exportTime;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final String s3BucketOwner() {
        return this.s3BucketOwner;
    }

    public final String s3Prefix() {
        return this.s3Prefix;
    }

    public final S3SseAlgorithm s3SseAlgorithm() {
        return S3SseAlgorithm.fromValue(this.s3SseAlgorithm);
    }

    public final String s3SseAlgorithmAsString() {
        return this.s3SseAlgorithm;
    }

    public final String s3SseKmsKeyId() {
        return this.s3SseKmsKeyId;
    }

    public final ExportFormat exportFormat() {
        return ExportFormat.fromValue(this.exportFormat);
    }

    public final String exportFormatAsString() {
        return this.exportFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3SseAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3SseKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTableToPointInTimeRequest)) {
            return false;
        }
        ExportTableToPointInTimeRequest other = (ExportTableToPointInTimeRequest)((Object)obj);
        return Objects.equals(this.tableArn(), other.tableArn()) && Objects.equals(this.exportTime(), other.exportTime()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3BucketOwner(), other.s3BucketOwner()) && Objects.equals(this.s3Prefix(), other.s3Prefix()) && Objects.equals(this.s3SseAlgorithmAsString(), other.s3SseAlgorithmAsString()) && Objects.equals(this.s3SseKmsKeyId(), other.s3SseKmsKeyId()) && Objects.equals(this.exportFormatAsString(), other.exportFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExportTableToPointInTimeRequest").add("TableArn", (Object)this.tableArn()).add("ExportTime", (Object)this.exportTime()).add("ClientToken", (Object)this.clientToken()).add("S3Bucket", (Object)this.s3Bucket()).add("S3BucketOwner", (Object)this.s3BucketOwner()).add("S3Prefix", (Object)this.s3Prefix()).add("S3SseAlgorithm", (Object)this.s3SseAlgorithmAsString()).add("S3SseKmsKeyId", (Object)this.s3SseKmsKeyId()).add("ExportFormat", (Object)this.exportFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableArn": {
                return Optional.ofNullable(clazz.cast(this.tableArn()));
            }
            case "ExportTime": {
                return Optional.ofNullable(clazz.cast(this.exportTime()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "S3BucketOwner": {
                return Optional.ofNullable(clazz.cast(this.s3BucketOwner()));
            }
            case "S3Prefix": {
                return Optional.ofNullable(clazz.cast(this.s3Prefix()));
            }
            case "S3SseAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.s3SseAlgorithmAsString()));
            }
            case "S3SseKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.s3SseKmsKeyId()));
            }
            case "ExportFormat": {
                return Optional.ofNullable(clazz.cast(this.exportFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportTableToPointInTimeRequest, T> g) {
        return obj -> g.apply((ExportTableToPointInTimeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String tableArn;
        private Instant exportTime;
        private String clientToken;
        private String s3Bucket;
        private String s3BucketOwner;
        private String s3Prefix;
        private String s3SseAlgorithm;
        private String s3SseKmsKeyId;
        private String exportFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTableToPointInTimeRequest model) {
            super(model);
            this.tableArn(model.tableArn);
            this.exportTime(model.exportTime);
            this.clientToken(model.clientToken);
            this.s3Bucket(model.s3Bucket);
            this.s3BucketOwner(model.s3BucketOwner);
            this.s3Prefix(model.s3Prefix);
            this.s3SseAlgorithm(model.s3SseAlgorithm);
            this.s3SseKmsKeyId(model.s3SseKmsKeyId);
            this.exportFormat(model.exportFormat);
        }

        public final String getTableArn() {
            return this.tableArn;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        @Override
        @Transient
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final Instant getExportTime() {
            return this.exportTime;
        }

        public final void setExportTime(Instant exportTime) {
            this.exportTime = exportTime;
        }

        @Override
        @Transient
        public final Builder exportTime(Instant exportTime) {
            this.exportTime = exportTime;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        @Transient
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3BucketOwner() {
            return this.s3BucketOwner;
        }

        public final void setS3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
        }

        @Override
        @Transient
        public final Builder s3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
            return this;
        }

        public final String getS3Prefix() {
            return this.s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        @Transient
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final String getS3SseAlgorithm() {
            return this.s3SseAlgorithm;
        }

        public final void setS3SseAlgorithm(String s3SseAlgorithm) {
            this.s3SseAlgorithm = s3SseAlgorithm;
        }

        @Override
        @Transient
        public final Builder s3SseAlgorithm(String s3SseAlgorithm) {
            this.s3SseAlgorithm = s3SseAlgorithm;
            return this;
        }

        @Override
        @Transient
        public final Builder s3SseAlgorithm(S3SseAlgorithm s3SseAlgorithm) {
            this.s3SseAlgorithm(s3SseAlgorithm == null ? null : s3SseAlgorithm.toString());
            return this;
        }

        public final String getS3SseKmsKeyId() {
            return this.s3SseKmsKeyId;
        }

        public final void setS3SseKmsKeyId(String s3SseKmsKeyId) {
            this.s3SseKmsKeyId = s3SseKmsKeyId;
        }

        @Override
        @Transient
        public final Builder s3SseKmsKeyId(String s3SseKmsKeyId) {
            this.s3SseKmsKeyId = s3SseKmsKeyId;
            return this;
        }

        public final String getExportFormat() {
            return this.exportFormat;
        }

        public final void setExportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
        }

        @Override
        @Transient
        public final Builder exportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder exportFormat(ExportFormat exportFormat) {
            this.exportFormat(exportFormat == null ? null : exportFormat.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportTableToPointInTimeRequest build() {
            return new ExportTableToPointInTimeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportTableToPointInTimeRequest> {
        public Builder tableArn(String var1);

        public Builder exportTime(Instant var1);

        public Builder clientToken(String var1);

        public Builder s3Bucket(String var1);

        public Builder s3BucketOwner(String var1);

        public Builder s3Prefix(String var1);

        public Builder s3SseAlgorithm(String var1);

        public Builder s3SseAlgorithm(S3SseAlgorithm var1);

        public Builder s3SseKmsKeyId(String var1);

        public Builder exportFormat(String var1);

        public Builder exportFormat(ExportFormat var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

