/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbStreamsResponse;
import software.amazon.awssdk.services.dynamodb.model.Record;
import software.amazon.awssdk.services.dynamodb.model.RecordListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRecordsResponse
extends DynamoDbStreamsResponse
implements ToCopyableBuilder<Builder, GetRecordsResponse> {
    private static final SdkField<List<Record>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Records").getter(GetRecordsResponse.getter(GetRecordsResponse::records)).setter(GetRecordsResponse.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Record::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_SHARD_ITERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextShardIterator").getter(GetRecordsResponse.getter(GetRecordsResponse::nextShardIterator)).setter(GetRecordsResponse.setter(Builder::nextShardIterator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextShardIterator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD, NEXT_SHARD_ITERATOR_FIELD));
    private final List<Record> records;
    private final String nextShardIterator;

    private GetRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.records = builder.records;
        this.nextShardIterator = builder.nextShardIterator;
    }

    public final boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public final List<Record> records() {
        return this.records;
    }

    public final String nextShardIterator() {
        return this.nextShardIterator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecords() ? this.records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextShardIterator());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordsResponse)) {
            return false;
        }
        GetRecordsResponse other = (GetRecordsResponse)((Object)obj);
        return this.hasRecords() == other.hasRecords() && Objects.equals(this.records(), other.records()) && Objects.equals(this.nextShardIterator(), other.nextShardIterator());
    }

    public final String toString() {
        return ToString.builder((String)"GetRecordsResponse").add("Records", this.hasRecords() ? this.records() : null).add("NextShardIterator", (Object)this.nextShardIterator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
            case "NextShardIterator": {
                return Optional.ofNullable(clazz.cast(this.nextShardIterator()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecordsResponse, T> g) {
        return obj -> g.apply((GetRecordsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbStreamsResponse.BuilderImpl
    implements Builder {
        private List<Record> records = DefaultSdkAutoConstructList.getInstance();
        private String nextShardIterator;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecordsResponse model) {
            super(model);
            this.records(model.records);
            this.nextShardIterator(model.nextShardIterator);
        }

        public final List<Record.Builder> getRecords() {
            List<Record.Builder> result = RecordListCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordListCopier.copyFromBuilder(records);
        }

        @Override
        @Transient
        public final Builder records(Collection<Record> records) {
            this.records = RecordListCopier.copy(records);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder records(Record ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder records(Consumer<Record.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (Record)((Record.Builder)Record.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextShardIterator() {
            return this.nextShardIterator;
        }

        public final void setNextShardIterator(String nextShardIterator) {
            this.nextShardIterator = nextShardIterator;
        }

        @Override
        @Transient
        public final Builder nextShardIterator(String nextShardIterator) {
            this.nextShardIterator = nextShardIterator;
            return this;
        }

        @Override
        public GetRecordsResponse build() {
            return new GetRecordsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbStreamsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRecordsResponse> {
        public Builder records(Collection<Record> var1);

        public Builder records(Record ... var1);

        public Builder records(Consumer<Record.Builder> ... var1);

        public Builder nextShardIterator(String var1);
    }
}

