/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateItemResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, UpdateItemResponse> {
    private static final SdkField<Map<String, AttributeValue>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(UpdateItemResponse.getter(UpdateItemResponse::attributes)).setter(UpdateItemResponse.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ConsumedCapacity> CONSUMED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConsumedCapacity").getter(UpdateItemResponse.getter(UpdateItemResponse::consumedCapacity)).setter(UpdateItemResponse.setter(Builder::consumedCapacity)).constructor(ConsumedCapacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedCapacity").build()}).build();
    private static final SdkField<ItemCollectionMetrics> ITEM_COLLECTION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ItemCollectionMetrics").getter(UpdateItemResponse.getter(UpdateItemResponse::itemCollectionMetrics)).setter(UpdateItemResponse.setter(Builder::itemCollectionMetrics)).constructor(ItemCollectionMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCollectionMetrics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, CONSUMED_CAPACITY_FIELD, ITEM_COLLECTION_METRICS_FIELD));
    private final Map<String, AttributeValue> attributes;
    private final ConsumedCapacity consumedCapacity;
    private final ItemCollectionMetrics itemCollectionMetrics;

    private UpdateItemResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
        this.consumedCapacity = builder.consumedCapacity;
        this.itemCollectionMetrics = builder.itemCollectionMetrics;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> attributes() {
        return this.attributes;
    }

    public final ConsumedCapacity consumedCapacity() {
        return this.consumedCapacity;
    }

    public final ItemCollectionMetrics itemCollectionMetrics() {
        return this.itemCollectionMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCollectionMetrics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateItemResponse)) {
            return false;
        }
        UpdateItemResponse other = (UpdateItemResponse)((Object)obj);
        return this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.consumedCapacity(), other.consumedCapacity()) && Objects.equals(this.itemCollectionMetrics(), other.itemCollectionMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateItemResponse").add("Attributes", this.hasAttributes() ? this.attributes() : null).add("ConsumedCapacity", (Object)this.consumedCapacity()).add("ItemCollectionMetrics", (Object)this.itemCollectionMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "ConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.consumedCapacity()));
            }
            case "ItemCollectionMetrics": {
                return Optional.ofNullable(clazz.cast(this.itemCollectionMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateItemResponse, T> g) {
        return obj -> g.apply((UpdateItemResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private Map<String, AttributeValue> attributes = DefaultSdkAutoConstructMap.getInstance();
        private ConsumedCapacity consumedCapacity;
        private ItemCollectionMetrics itemCollectionMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateItemResponse model) {
            super(model);
            this.attributes(model.attributes);
            this.consumedCapacity(model.consumedCapacity);
            this.itemCollectionMetrics(model.itemCollectionMetrics);
        }

        public final Map<String, AttributeValue.Builder> getAttributes() {
            Map<String, AttributeValue.Builder> result = AttributeMapCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Map<String, AttributeValue.BuilderImpl> attributes) {
            this.attributes = AttributeMapCopier.copyFromBuilder(attributes);
        }

        @Override
        @Transient
        public final Builder attributes(Map<String, AttributeValue> attributes) {
            this.attributes = AttributeMapCopier.copy(attributes);
            return this;
        }

        public final ConsumedCapacity.Builder getConsumedCapacity() {
            return this.consumedCapacity != null ? this.consumedCapacity.toBuilder() : null;
        }

        public final void setConsumedCapacity(ConsumedCapacity.BuilderImpl consumedCapacity) {
            this.consumedCapacity = consumedCapacity != null ? consumedCapacity.build() : null;
        }

        @Override
        @Transient
        public final Builder consumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        public final ItemCollectionMetrics.Builder getItemCollectionMetrics() {
            return this.itemCollectionMetrics != null ? this.itemCollectionMetrics.toBuilder() : null;
        }

        public final void setItemCollectionMetrics(ItemCollectionMetrics.BuilderImpl itemCollectionMetrics) {
            this.itemCollectionMetrics = itemCollectionMetrics != null ? itemCollectionMetrics.build() : null;
        }

        @Override
        @Transient
        public final Builder itemCollectionMetrics(ItemCollectionMetrics itemCollectionMetrics) {
            this.itemCollectionMetrics = itemCollectionMetrics;
            return this;
        }

        @Override
        public UpdateItemResponse build() {
            return new UpdateItemResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateItemResponse> {
        public Builder attributes(Map<String, AttributeValue> var1);

        public Builder consumedCapacity(ConsumedCapacity var1);

        default public Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> consumedCapacity) {
            return this.consumedCapacity((ConsumedCapacity)((ConsumedCapacity.Builder)ConsumedCapacity.builder().applyMutation(consumedCapacity)).build());
        }

        public Builder itemCollectionMetrics(ItemCollectionMetrics var1);

        default public Builder itemCollectionMetrics(Consumer<ItemCollectionMetrics.Builder> itemCollectionMetrics) {
            return this.itemCollectionMetrics((ItemCollectionMetrics)((ItemCollectionMetrics.Builder)ItemCollectionMetrics.builder().applyMutation(itemCollectionMetrics)).build());
        }
    }
}

