/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the properties of a table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<TableDescription.Builder, TableDescription> {
    private static final SdkField<List<AttributeDefinition>> ATTRIBUTE_DEFINITIONS_FIELD = SdkField
            .<List<AttributeDefinition>> builder(MarshallingType.LIST)
            .memberName("AttributeDefinitions")
            .getter(getter(TableDescription::attributeDefinitions))
            .setter(setter(Builder::attributeDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(TableDescription::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<List<KeySchemaElement>> KEY_SCHEMA_FIELD = SdkField
            .<List<KeySchemaElement>> builder(MarshallingType.LIST)
            .memberName("KeySchema")
            .getter(getter(TableDescription::keySchema))
            .setter(setter(Builder::keySchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySchema").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeySchemaElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeySchemaElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TABLE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableStatus").getter(getter(TableDescription::tableStatusAsString)).setter(setter(Builder::tableStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableStatus").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDateTime").getter(getter(TableDescription::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDateTime").build()).build();

    private static final SdkField<ProvisionedThroughputDescription> PROVISIONED_THROUGHPUT_FIELD = SdkField
            .<ProvisionedThroughputDescription> builder(MarshallingType.SDK_POJO).memberName("ProvisionedThroughput")
            .getter(getter(TableDescription::provisionedThroughput)).setter(setter(Builder::provisionedThroughput))
            .constructor(ProvisionedThroughputDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughput").build())
            .build();

    private static final SdkField<Long> TABLE_SIZE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TableSizeBytes").getter(getter(TableDescription::tableSizeBytes))
            .setter(setter(Builder::tableSizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableSizeBytes").build()).build();

    private static final SdkField<Long> ITEM_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("ItemCount")
            .getter(getter(TableDescription::itemCount)).setter(setter(Builder::itemCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()).build();

    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableArn").getter(getter(TableDescription::tableArn)).setter(setter(Builder::tableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").build()).build();

    private static final SdkField<String> TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableId").getter(getter(TableDescription::tableId)).setter(setter(Builder::tableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableId").build()).build();

    private static final SdkField<BillingModeSummary> BILLING_MODE_SUMMARY_FIELD = SdkField
            .<BillingModeSummary> builder(MarshallingType.SDK_POJO).memberName("BillingModeSummary")
            .getter(getter(TableDescription::billingModeSummary)).setter(setter(Builder::billingModeSummary))
            .constructor(BillingModeSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingModeSummary").build())
            .build();

    private static final SdkField<List<LocalSecondaryIndexDescription>> LOCAL_SECONDARY_INDEXES_FIELD = SdkField
            .<List<LocalSecondaryIndexDescription>> builder(MarshallingType.LIST)
            .memberName("LocalSecondaryIndexes")
            .getter(getter(TableDescription::localSecondaryIndexes))
            .setter(setter(Builder::localSecondaryIndexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalSecondaryIndexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocalSecondaryIndexDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocalSecondaryIndexDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GlobalSecondaryIndexDescription>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField
            .<List<GlobalSecondaryIndexDescription>> builder(MarshallingType.LIST)
            .memberName("GlobalSecondaryIndexes")
            .getter(getter(TableDescription::globalSecondaryIndexes))
            .setter(setter(Builder::globalSecondaryIndexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlobalSecondaryIndexDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlobalSecondaryIndexDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StreamSpecification> STREAM_SPECIFICATION_FIELD = SdkField
            .<StreamSpecification> builder(MarshallingType.SDK_POJO).memberName("StreamSpecification")
            .getter(getter(TableDescription::streamSpecification)).setter(setter(Builder::streamSpecification))
            .constructor(StreamSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamSpecification").build())
            .build();

    private static final SdkField<String> LATEST_STREAM_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestStreamLabel").getter(getter(TableDescription::latestStreamLabel))
            .setter(setter(Builder::latestStreamLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestStreamLabel").build()).build();

    private static final SdkField<String> LATEST_STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestStreamArn").getter(getter(TableDescription::latestStreamArn))
            .setter(setter(Builder::latestStreamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestStreamArn").build()).build();

    private static final SdkField<String> GLOBAL_TABLE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalTableVersion").getter(getter(TableDescription::globalTableVersion))
            .setter(setter(Builder::globalTableVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableVersion").build())
            .build();

    private static final SdkField<List<ReplicaDescription>> REPLICAS_FIELD = SdkField
            .<List<ReplicaDescription>> builder(MarshallingType.LIST)
            .memberName("Replicas")
            .getter(getter(TableDescription::replicas))
            .setter(setter(Builder::replicas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replicas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicaDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicaDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RestoreSummary> RESTORE_SUMMARY_FIELD = SdkField
            .<RestoreSummary> builder(MarshallingType.SDK_POJO).memberName("RestoreSummary")
            .getter(getter(TableDescription::restoreSummary)).setter(setter(Builder::restoreSummary))
            .constructor(RestoreSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreSummary").build()).build();

    private static final SdkField<SSEDescription> SSE_DESCRIPTION_FIELD = SdkField
            .<SSEDescription> builder(MarshallingType.SDK_POJO).memberName("SSEDescription")
            .getter(getter(TableDescription::sseDescription)).setter(setter(Builder::sseDescription))
            .constructor(SSEDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSEDescription").build()).build();

    private static final SdkField<ArchivalSummary> ARCHIVAL_SUMMARY_FIELD = SdkField
            .<ArchivalSummary> builder(MarshallingType.SDK_POJO).memberName("ArchivalSummary")
            .getter(getter(TableDescription::archivalSummary)).setter(setter(Builder::archivalSummary))
            .constructor(ArchivalSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchivalSummary").build()).build();

    private static final SdkField<TableClassSummary> TABLE_CLASS_SUMMARY_FIELD = SdkField
            .<TableClassSummary> builder(MarshallingType.SDK_POJO).memberName("TableClassSummary")
            .getter(getter(TableDescription::tableClassSummary)).setter(setter(Builder::tableClassSummary))
            .constructor(TableClassSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableClassSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_DEFINITIONS_FIELD,
            TABLE_NAME_FIELD, KEY_SCHEMA_FIELD, TABLE_STATUS_FIELD, CREATION_DATE_TIME_FIELD, PROVISIONED_THROUGHPUT_FIELD,
            TABLE_SIZE_BYTES_FIELD, ITEM_COUNT_FIELD, TABLE_ARN_FIELD, TABLE_ID_FIELD, BILLING_MODE_SUMMARY_FIELD,
            LOCAL_SECONDARY_INDEXES_FIELD, GLOBAL_SECONDARY_INDEXES_FIELD, STREAM_SPECIFICATION_FIELD, LATEST_STREAM_LABEL_FIELD,
            LATEST_STREAM_ARN_FIELD, GLOBAL_TABLE_VERSION_FIELD, REPLICAS_FIELD, RESTORE_SUMMARY_FIELD, SSE_DESCRIPTION_FIELD,
            ARCHIVAL_SUMMARY_FIELD, TABLE_CLASS_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AttributeDefinition> attributeDefinitions;

    private final String tableName;

    private final List<KeySchemaElement> keySchema;

    private final String tableStatus;

    private final Instant creationDateTime;

    private final ProvisionedThroughputDescription provisionedThroughput;

    private final Long tableSizeBytes;

    private final Long itemCount;

    private final String tableArn;

    private final String tableId;

    private final BillingModeSummary billingModeSummary;

    private final List<LocalSecondaryIndexDescription> localSecondaryIndexes;

    private final List<GlobalSecondaryIndexDescription> globalSecondaryIndexes;

    private final StreamSpecification streamSpecification;

    private final String latestStreamLabel;

    private final String latestStreamArn;

    private final String globalTableVersion;

    private final List<ReplicaDescription> replicas;

    private final RestoreSummary restoreSummary;

    private final SSEDescription sseDescription;

    private final ArchivalSummary archivalSummary;

    private final TableClassSummary tableClassSummary;

    private TableDescription(BuilderImpl builder) {
        this.attributeDefinitions = builder.attributeDefinitions;
        this.tableName = builder.tableName;
        this.keySchema = builder.keySchema;
        this.tableStatus = builder.tableStatus;
        this.creationDateTime = builder.creationDateTime;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.tableSizeBytes = builder.tableSizeBytes;
        this.itemCount = builder.itemCount;
        this.tableArn = builder.tableArn;
        this.tableId = builder.tableId;
        this.billingModeSummary = builder.billingModeSummary;
        this.localSecondaryIndexes = builder.localSecondaryIndexes;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.streamSpecification = builder.streamSpecification;
        this.latestStreamLabel = builder.latestStreamLabel;
        this.latestStreamArn = builder.latestStreamArn;
        this.globalTableVersion = builder.globalTableVersion;
        this.replicas = builder.replicas;
        this.restoreSummary = builder.restoreSummary;
        this.sseDescription = builder.sseDescription;
        this.archivalSummary = builder.archivalSummary;
        this.tableClassSummary = builder.tableClassSummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeDefinitions() {
        return attributeDefinitions != null && !(attributeDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>AttributeDefinition</code> objects. Each of these objects describes one attribute in the table
     * and index key schema.
     * </p>
     * <p>
     * Each <code>AttributeDefinition</code> object in this array is composed of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AttributeName</code> - The name of the attribute.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AttributeType</code> - The data type for the attribute.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeDefinitions} method.
     * </p>
     * 
     * @return An array of <code>AttributeDefinition</code> objects. Each of these objects describes one attribute in
     *         the table and index key schema.</p>
     *         <p>
     *         Each <code>AttributeDefinition</code> object in this array is composed of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AttributeName</code> - The name of the attribute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AttributeType</code> - The data type for the attribute.
     *         </p>
     *         </li>
     */
    public final List<AttributeDefinition> attributeDefinitions() {
        return attributeDefinitions;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeySchema property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasKeySchema() {
        return keySchema != null && !(keySchema instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The primary key structure for the table. Each <code>KeySchemaElement</code> consists of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AttributeName</code> - The name of the attribute.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KeyType</code> - The role of the attribute:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HASH</code> - partition key
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RANGE</code> - sort key
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from
     * DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their
     * partition key values.
     * </p>
     * <p>
     * The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the
     * way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key
     * value.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * For more information about primary keys, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey"
     * >Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeySchema} method.
     * </p>
     * 
     * @return The primary key structure for the table. Each <code>KeySchemaElement</code> consists of:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AttributeName</code> - The name of the attribute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KeyType</code> - The role of the attribute:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HASH</code> - partition key
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RANGE</code> - sort key
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute"
     *         derives from DynamoDB's usage of an internal hash function to evenly distribute data items across
     *         partitions, based on their partition key values.
     *         </p>
     *         <p>
     *         The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives
     *         from the way DynamoDB stores items with the same partition key physically close together, in sorted order
     *         by the sort key value.
     *         </p>
     *         </note></li>
     *         </ul>
     *         <p>
     *         For more information about primary keys, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey"
     *         >Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public final List<KeySchemaElement> keySchema() {
        return keySchema;
    }

    /**
     * <p>
     * The current state of the table:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The table is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - The table is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The table is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The table is ready for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The KMS key used to encrypt the table in inaccessible. Table
     * operations may fail due to failure to use the KMS key. DynamoDB will initiate the table archival process when a
     * table's KMS key remains inaccessible for more than seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARCHIVING</code> - The table is being archived. Operations are not allowed until archival is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARCHIVED</code> - The table has been archived. See the ArchivalReason for more information.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tableStatus} will
     * return {@link TableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tableStatusAsString}.
     * </p>
     * 
     * @return The current state of the table:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The table is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - The table is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The table is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The table is ready for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The KMS key used to encrypt the table in inaccessible.
     *         Table operations may fail due to failure to use the KMS key. DynamoDB will initiate the table archival
     *         process when a table's KMS key remains inaccessible for more than seven days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARCHIVING</code> - The table is being archived. Operations are not allowed until archival is
     *         complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARCHIVED</code> - The table has been archived. See the ArchivalReason for more information.
     *         </p>
     *         </li>
     * @see TableStatus
     */
    public final TableStatus tableStatus() {
        return TableStatus.fromValue(tableStatus);
    }

    /**
     * <p>
     * The current state of the table:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The table is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - The table is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The table is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The table is ready for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The KMS key used to encrypt the table in inaccessible. Table
     * operations may fail due to failure to use the KMS key. DynamoDB will initiate the table archival process when a
     * table's KMS key remains inaccessible for more than seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARCHIVING</code> - The table is being archived. Operations are not allowed until archival is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARCHIVED</code> - The table has been archived. See the ArchivalReason for more information.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tableStatus} will
     * return {@link TableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tableStatusAsString}.
     * </p>
     * 
     * @return The current state of the table:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The table is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - The table is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The table is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The table is ready for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The KMS key used to encrypt the table in inaccessible.
     *         Table operations may fail due to failure to use the KMS key. DynamoDB will initiate the table archival
     *         process when a table's KMS key remains inaccessible for more than seven days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARCHIVING</code> - The table is being archived. Operations are not allowed until archival is
     *         complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARCHIVED</code> - The table has been archived. See the ArchivalReason for more information.
     *         </p>
     *         </li>
     * @see TableStatus
     */
    public final String tableStatusAsString() {
        return tableStatus;
    }

    /**
     * <p>
     * The date and time when the table was created, in <a href="http://www.epochconverter.com/">UNIX epoch time</a>
     * format.
     * </p>
     * 
     * @return The date and time when the table was created, in <a href="http://www.epochconverter.com/">UNIX epoch
     *         time</a> format.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The provisioned throughput settings for the table, consisting of read and write capacity units, along with data
     * about increases and decreases.
     * </p>
     * 
     * @return The provisioned throughput settings for the table, consisting of read and write capacity units, along
     *         with data about increases and decreases.
     */
    public final ProvisionedThroughputDescription provisionedThroughput() {
        return provisionedThroughput;
    }

    /**
     * <p>
     * The total size of the specified table, in bytes. DynamoDB updates this value approximately every six hours.
     * Recent changes might not be reflected in this value.
     * </p>
     * 
     * @return The total size of the specified table, in bytes. DynamoDB updates this value approximately every six
     *         hours. Recent changes might not be reflected in this value.
     */
    public final Long tableSizeBytes() {
        return tableSizeBytes;
    }

    /**
     * <p>
     * The number of items in the specified table. DynamoDB updates this value approximately every six hours. Recent
     * changes might not be reflected in this value.
     * </p>
     * 
     * @return The number of items in the specified table. DynamoDB updates this value approximately every six hours.
     *         Recent changes might not be reflected in this value.
     */
    public final Long itemCount() {
        return itemCount;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that uniquely identifies the table.
     */
    public final String tableArn() {
        return tableArn;
    }

    /**
     * <p>
     * Unique identifier for the table for which the backup was created.
     * </p>
     * 
     * @return Unique identifier for the table for which the backup was created.
     */
    public final String tableId() {
        return tableId;
    }

    /**
     * <p>
     * Contains the details for the read/write capacity mode.
     * </p>
     * 
     * @return Contains the details for the read/write capacity mode.
     */
    public final BillingModeSummary billingModeSummary() {
        return billingModeSummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the LocalSecondaryIndexes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLocalSecondaryIndexes() {
        return localSecondaryIndexes != null && !(localSecondaryIndexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents one or more local secondary indexes on the table. Each index is scoped to a given partition key value.
     * Tables with one or more local secondary indexes are subject to an item collection size limit, where the amount of
     * data within a given item collection cannot exceed 10 GB. Each element is composed of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IndexName</code> - The name of the local secondary index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema must be
     * between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These
     * are in addition to the primary key attributes and index key attributes, which are automatically projected. Each
     * attribute specification is composed of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ProjectionType</code> - One of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected
     * attributes is in <code>NonKeyAttributes</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code> - All of the table attributes are projected into the index.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
     * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of
     * the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes, this
     * counts as two distinct attributes when determining the total.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>IndexSizeBytes</code> - Represents the total size of the index, in bytes. DynamoDB updates this value
     * approximately every six hours. Recent changes might not be reflected in this value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ItemCount</code> - Represents the number of items in the index. DynamoDB updates this value approximately
     * every six hours. Recent changes might not be reflected in this value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the table is in the <code>DELETING</code> state, no information about indexes will be returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocalSecondaryIndexes} method.
     * </p>
     * 
     * @return Represents one or more local secondary indexes on the table. Each index is scoped to a given partition
     *         key value. Tables with one or more local secondary indexes are subject to an item collection size limit,
     *         where the amount of data within a given item collection cannot exceed 10 GB. Each element is composed
     *         of:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IndexName</code> - The name of the local secondary index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema
     *         must be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key
     *         as the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
     *         These are in addition to the primary key attributes and index key attributes, which are automatically
     *         projected. Each attribute specification is composed of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ProjectionType</code> - One of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
     *         projected attributes is in <code>NonKeyAttributes</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code> - All of the table attributes are projected into the index.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
     *         secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across
     *         all of the secondary indexes, must not exceed 20. If you project the same attribute into two different
     *         indexes, this counts as two distinct attributes when determining the total.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IndexSizeBytes</code> - Represents the total size of the index, in bytes. DynamoDB updates this
     *         value approximately every six hours. Recent changes might not be reflected in this value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ItemCount</code> - Represents the number of items in the index. DynamoDB updates this value
     *         approximately every six hours. Recent changes might not be reflected in this value.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the table is in the <code>DELETING</code> state, no information about indexes will be returned.
     */
    public final List<LocalSecondaryIndexDescription> localSecondaryIndexes() {
        return localSecondaryIndexes;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlobalSecondaryIndexes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGlobalSecondaryIndexes() {
        return globalSecondaryIndexes != null && !(globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The global secondary indexes, if any, on the table. Each index is scoped to a given partition key value. Each
     * element is composed of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Backfilling</code> - If true, then the index is currently in the backfilling phase. Backfilling occurs only
     * when a new global secondary index is added to the table. It is the process by which DynamoDB populates the new
     * index with data from the table. (This attribute does not appear for indexes that were created during a
     * <code>CreateTable</code> operation.)
     * </p>
     * <p>
     * You can delete an index that is being created during the <code>Backfilling</code> phase when
     * <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is true. You can't delete the index that
     * is being created when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is false. (This
     * attribute does not appear for indexes that were created during a <code>CreateTable</code> operation.)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IndexName</code> - The name of the global secondary index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IndexSizeBytes</code> - The total size of the global secondary index, in bytes. DynamoDB updates this value
     * approximately every six hours. Recent changes might not be reflected in this value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IndexStatus</code> - The current status of the global secondary index:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The index is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - The index is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The index is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The index is ready for use.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ItemCount</code> - The number of items in the global secondary index. DynamoDB updates this value
     * approximately every six hours. Recent changes might not be reflected in this value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema must be
     * between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These
     * are in addition to the primary key attributes and index key attributes, which are automatically projected. Each
     * attribute specification is composed of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ProjectionType</code> - One of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code>, the secondary index
     * will include other non-key attributes that you specify.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code> - All of the table attributes are projected into the index.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
     * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of
     * the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes, this
     * counts as two distinct attributes when determining the total.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
     * consisting of read and write capacity units, along with data about increases and decreases.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the table is in the <code>DELETING</code> state, no information about indexes will be returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlobalSecondaryIndexes} method.
     * </p>
     * 
     * @return The global secondary indexes, if any, on the table. Each index is scoped to a given partition key value.
     *         Each element is composed of:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Backfilling</code> - If true, then the index is currently in the backfilling phase. Backfilling
     *         occurs only when a new global secondary index is added to the table. It is the process by which DynamoDB
     *         populates the new index with data from the table. (This attribute does not appear for indexes that were
     *         created during a <code>CreateTable</code> operation.)
     *         </p>
     *         <p>
     *         You can delete an index that is being created during the <code>Backfilling</code> phase when
     *         <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is true. You can't delete the
     *         index that is being created when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code>
     *         is false. (This attribute does not appear for indexes that were created during a <code>CreateTable</code>
     *         operation.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IndexName</code> - The name of the global secondary index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IndexSizeBytes</code> - The total size of the global secondary index, in bytes. DynamoDB updates
     *         this value approximately every six hours. Recent changes might not be reflected in this value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IndexStatus</code> - The current status of the global secondary index:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The index is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - The index is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The index is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The index is ready for use.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ItemCount</code> - The number of items in the global secondary index. DynamoDB updates this value
     *         approximately every six hours. Recent changes might not be reflected in this value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema
     *         must be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key
     *         as the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
     *         These are in addition to the primary key attributes and index key attributes, which are automatically
     *         projected. Each attribute specification is composed of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ProjectionType</code> - One of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code>, the secondary
     *         index will include other non-key attributes that you specify.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code> - All of the table attributes are projected into the index.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
     *         secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across
     *         all of the secondary indexes, must not exceed 20. If you project the same attribute into two different
     *         indexes, this counts as two distinct attributes when determining the total.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
     *         consisting of read and write capacity units, along with data about increases and decreases.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the table is in the <code>DELETING</code> state, no information about indexes will be returned.
     */
    public final List<GlobalSecondaryIndexDescription> globalSecondaryIndexes() {
        return globalSecondaryIndexes;
    }

    /**
     * <p>
     * The current DynamoDB Streams configuration for the table.
     * </p>
     * 
     * @return The current DynamoDB Streams configuration for the table.
     */
    public final StreamSpecification streamSpecification() {
        return streamSpecification;
    }

    /**
     * <p>
     * A timestamp, in ISO 8601 format, for this stream.
     * </p>
     * <p>
     * Note that <code>LatestStreamLabel</code> is not a unique identifier for the stream, because it is possible that a
     * stream from another table might have the same timestamp. However, the combination of the following three elements
     * is guaranteed to be unique:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Web Services customer ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Table name
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StreamLabel</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return A timestamp, in ISO 8601 format, for this stream.</p>
     *         <p>
     *         Note that <code>LatestStreamLabel</code> is not a unique identifier for the stream, because it is
     *         possible that a stream from another table might have the same timestamp. However, the combination of the
     *         following three elements is guaranteed to be unique:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Amazon Web Services customer ID
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Table name
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>StreamLabel</code>
     *         </p>
     *         </li>
     */
    public final String latestStreamLabel() {
        return latestStreamLabel;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the latest stream for this table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that uniquely identifies the latest stream for this table.
     */
    public final String latestStreamArn() {
        return latestStreamArn;
    }

    /**
     * <p>
     * Represents the version of <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">global tables</a> in
     * use, if the table is replicated across Amazon Web Services Regions.
     * </p>
     * 
     * @return Represents the version of <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">global
     *         tables</a> in use, if the table is replicated across Amazon Web Services Regions.
     */
    public final String globalTableVersion() {
        return globalTableVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Replicas property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReplicas() {
        return replicas != null && !(replicas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents replicas of the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicas} method.
     * </p>
     * 
     * @return Represents replicas of the table.
     */
    public final List<ReplicaDescription> replicas() {
        return replicas;
    }

    /**
     * <p>
     * Contains details for the restore.
     * </p>
     * 
     * @return Contains details for the restore.
     */
    public final RestoreSummary restoreSummary() {
        return restoreSummary;
    }

    /**
     * <p>
     * The description of the server-side encryption status on the specified table.
     * </p>
     * 
     * @return The description of the server-side encryption status on the specified table.
     */
    public final SSEDescription sseDescription() {
        return sseDescription;
    }

    /**
     * <p>
     * Contains information about the table archive.
     * </p>
     * 
     * @return Contains information about the table archive.
     */
    public final ArchivalSummary archivalSummary() {
        return archivalSummary;
    }

    /**
     * <p>
     * Contains details of the table class.
     * </p>
     * 
     * @return Contains details of the table class.
     */
    public final TableClassSummary tableClassSummary() {
        return tableClassSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeDefinitions() ? attributeDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeySchema() ? keySchema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tableStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(tableSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(tableId());
        hashCode = 31 * hashCode + Objects.hashCode(billingModeSummary());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocalSecondaryIndexes() ? localSecondaryIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalSecondaryIndexes() ? globalSecondaryIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(streamSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(latestStreamLabel());
        hashCode = 31 * hashCode + Objects.hashCode(latestStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(globalTableVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicas() ? replicas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(restoreSummary());
        hashCode = 31 * hashCode + Objects.hashCode(sseDescription());
        hashCode = 31 * hashCode + Objects.hashCode(archivalSummary());
        hashCode = 31 * hashCode + Objects.hashCode(tableClassSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableDescription)) {
            return false;
        }
        TableDescription other = (TableDescription) obj;
        return hasAttributeDefinitions() == other.hasAttributeDefinitions()
                && Objects.equals(attributeDefinitions(), other.attributeDefinitions())
                && Objects.equals(tableName(), other.tableName()) && hasKeySchema() == other.hasKeySchema()
                && Objects.equals(keySchema(), other.keySchema())
                && Objects.equals(tableStatusAsString(), other.tableStatusAsString())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(provisionedThroughput(), other.provisionedThroughput())
                && Objects.equals(tableSizeBytes(), other.tableSizeBytes()) && Objects.equals(itemCount(), other.itemCount())
                && Objects.equals(tableArn(), other.tableArn()) && Objects.equals(tableId(), other.tableId())
                && Objects.equals(billingModeSummary(), other.billingModeSummary())
                && hasLocalSecondaryIndexes() == other.hasLocalSecondaryIndexes()
                && Objects.equals(localSecondaryIndexes(), other.localSecondaryIndexes())
                && hasGlobalSecondaryIndexes() == other.hasGlobalSecondaryIndexes()
                && Objects.equals(globalSecondaryIndexes(), other.globalSecondaryIndexes())
                && Objects.equals(streamSpecification(), other.streamSpecification())
                && Objects.equals(latestStreamLabel(), other.latestStreamLabel())
                && Objects.equals(latestStreamArn(), other.latestStreamArn())
                && Objects.equals(globalTableVersion(), other.globalTableVersion()) && hasReplicas() == other.hasReplicas()
                && Objects.equals(replicas(), other.replicas()) && Objects.equals(restoreSummary(), other.restoreSummary())
                && Objects.equals(sseDescription(), other.sseDescription())
                && Objects.equals(archivalSummary(), other.archivalSummary())
                && Objects.equals(tableClassSummary(), other.tableClassSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableDescription")
                .add("AttributeDefinitions", hasAttributeDefinitions() ? attributeDefinitions() : null)
                .add("TableName", tableName()).add("KeySchema", hasKeySchema() ? keySchema() : null)
                .add("TableStatus", tableStatusAsString()).add("CreationDateTime", creationDateTime())
                .add("ProvisionedThroughput", provisionedThroughput()).add("TableSizeBytes", tableSizeBytes())
                .add("ItemCount", itemCount()).add("TableArn", tableArn()).add("TableId", tableId())
                .add("BillingModeSummary", billingModeSummary())
                .add("LocalSecondaryIndexes", hasLocalSecondaryIndexes() ? localSecondaryIndexes() : null)
                .add("GlobalSecondaryIndexes", hasGlobalSecondaryIndexes() ? globalSecondaryIndexes() : null)
                .add("StreamSpecification", streamSpecification()).add("LatestStreamLabel", latestStreamLabel())
                .add("LatestStreamArn", latestStreamArn()).add("GlobalTableVersion", globalTableVersion())
                .add("Replicas", hasReplicas() ? replicas() : null).add("RestoreSummary", restoreSummary())
                .add("SSEDescription", sseDescription()).add("ArchivalSummary", archivalSummary())
                .add("TableClassSummary", tableClassSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeDefinitions":
            return Optional.ofNullable(clazz.cast(attributeDefinitions()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "KeySchema":
            return Optional.ofNullable(clazz.cast(keySchema()));
        case "TableStatus":
            return Optional.ofNullable(clazz.cast(tableStatusAsString()));
        case "CreationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "ProvisionedThroughput":
            return Optional.ofNullable(clazz.cast(provisionedThroughput()));
        case "TableSizeBytes":
            return Optional.ofNullable(clazz.cast(tableSizeBytes()));
        case "ItemCount":
            return Optional.ofNullable(clazz.cast(itemCount()));
        case "TableArn":
            return Optional.ofNullable(clazz.cast(tableArn()));
        case "TableId":
            return Optional.ofNullable(clazz.cast(tableId()));
        case "BillingModeSummary":
            return Optional.ofNullable(clazz.cast(billingModeSummary()));
        case "LocalSecondaryIndexes":
            return Optional.ofNullable(clazz.cast(localSecondaryIndexes()));
        case "GlobalSecondaryIndexes":
            return Optional.ofNullable(clazz.cast(globalSecondaryIndexes()));
        case "StreamSpecification":
            return Optional.ofNullable(clazz.cast(streamSpecification()));
        case "LatestStreamLabel":
            return Optional.ofNullable(clazz.cast(latestStreamLabel()));
        case "LatestStreamArn":
            return Optional.ofNullable(clazz.cast(latestStreamArn()));
        case "GlobalTableVersion":
            return Optional.ofNullable(clazz.cast(globalTableVersion()));
        case "Replicas":
            return Optional.ofNullable(clazz.cast(replicas()));
        case "RestoreSummary":
            return Optional.ofNullable(clazz.cast(restoreSummary()));
        case "SSEDescription":
            return Optional.ofNullable(clazz.cast(sseDescription()));
        case "ArchivalSummary":
            return Optional.ofNullable(clazz.cast(archivalSummary()));
        case "TableClassSummary":
            return Optional.ofNullable(clazz.cast(tableClassSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableDescription, T> g) {
        return obj -> g.apply((TableDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableDescription> {
        /**
         * <p>
         * An array of <code>AttributeDefinition</code> objects. Each of these objects describes one attribute in the
         * table and index key schema.
         * </p>
         * <p>
         * Each <code>AttributeDefinition</code> object in this array is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AttributeName</code> - The name of the attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AttributeType</code> - The data type for the attribute.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributeDefinitions
         *        An array of <code>AttributeDefinition</code> objects. Each of these objects describes one attribute in
         *        the table and index key schema.</p>
         *        <p>
         *        Each <code>AttributeDefinition</code> object in this array is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AttributeName</code> - The name of the attribute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AttributeType</code> - The data type for the attribute.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions);

        /**
         * <p>
         * An array of <code>AttributeDefinition</code> objects. Each of these objects describes one attribute in the
         * table and index key schema.
         * </p>
         * <p>
         * Each <code>AttributeDefinition</code> object in this array is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AttributeName</code> - The name of the attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AttributeType</code> - The data type for the attribute.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributeDefinitions
         *        An array of <code>AttributeDefinition</code> objects. Each of these objects describes one attribute in
         *        the table and index key schema.</p>
         *        <p>
         *        Each <code>AttributeDefinition</code> object in this array is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AttributeName</code> - The name of the attribute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AttributeType</code> - The data type for the attribute.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDefinitions(AttributeDefinition... attributeDefinitions);

        /**
         * <p>
         * An array of <code>AttributeDefinition</code> objects. Each of these objects describes one attribute in the
         * table and index key schema.
         * </p>
         * <p>
         * Each <code>AttributeDefinition</code> object in this array is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AttributeName</code> - The name of the attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AttributeType</code> - The data type for the attribute.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<AttributeDefinition>.Builder} avoiding the
         * need to create one manually via {@link List<AttributeDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeDefinition>.Builder#build()} is called immediately
         * and its result is passed to {@link #attributeDefinitions(List<AttributeDefinition>)}.
         * 
         * @param attributeDefinitions
         *        a consumer that will call methods on {@link List<AttributeDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeDefinitions(List<AttributeDefinition>)
         */
        Builder attributeDefinitions(Consumer<AttributeDefinition.Builder>... attributeDefinitions);

        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param tableName
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The primary key structure for the table. Each <code>KeySchemaElement</code> consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AttributeName</code> - The name of the attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeyType</code> - The role of the attribute:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HASH</code> - partition key
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RANGE</code> - sort key
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives
         * from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based
         * on their partition key values.
         * </p>
         * <p>
         * The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from
         * the way DynamoDB stores items with the same partition key physically close together, in sorted order by the
         * sort key value.
         * </p>
         * </note></li>
         * </ul>
         * <p>
         * For more information about primary keys, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey"
         * >Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param keySchema
         *        The primary key structure for the table. Each <code>KeySchemaElement</code> consists of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AttributeName</code> - The name of the attribute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KeyType</code> - The role of the attribute:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HASH</code> - partition key
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RANGE</code> - sort key
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute"
         *        derives from DynamoDB's usage of an internal hash function to evenly distribute data items across
         *        partitions, based on their partition key values.
         *        </p>
         *        <p>
         *        The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute"
         *        derives from the way DynamoDB stores items with the same partition key physically close together, in
         *        sorted order by the sort key value.
         *        </p>
         *        </note></li>
         *        </ul>
         *        <p>
         *        For more information about primary keys, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey"
         *        >Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(Collection<KeySchemaElement> keySchema);

        /**
         * <p>
         * The primary key structure for the table. Each <code>KeySchemaElement</code> consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AttributeName</code> - The name of the attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeyType</code> - The role of the attribute:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HASH</code> - partition key
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RANGE</code> - sort key
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives
         * from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based
         * on their partition key values.
         * </p>
         * <p>
         * The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from
         * the way DynamoDB stores items with the same partition key physically close together, in sorted order by the
         * sort key value.
         * </p>
         * </note></li>
         * </ul>
         * <p>
         * For more information about primary keys, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey"
         * >Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param keySchema
         *        The primary key structure for the table. Each <code>KeySchemaElement</code> consists of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AttributeName</code> - The name of the attribute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KeyType</code> - The role of the attribute:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HASH</code> - partition key
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RANGE</code> - sort key
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute"
         *        derives from DynamoDB's usage of an internal hash function to evenly distribute data items across
         *        partitions, based on their partition key values.
         *        </p>
         *        <p>
         *        The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute"
         *        derives from the way DynamoDB stores items with the same partition key physically close together, in
         *        sorted order by the sort key value.
         *        </p>
         *        </note></li>
         *        </ul>
         *        <p>
         *        For more information about primary keys, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey"
         *        >Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(KeySchemaElement... keySchema);

        /**
         * <p>
         * The primary key structure for the table. Each <code>KeySchemaElement</code> consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AttributeName</code> - The name of the attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeyType</code> - The role of the attribute:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HASH</code> - partition key
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RANGE</code> - sort key
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives
         * from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based
         * on their partition key values.
         * </p>
         * <p>
         * The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from
         * the way DynamoDB stores items with the same partition key physically close together, in sorted order by the
         * sort key value.
         * </p>
         * </note></li>
         * </ul>
         * <p>
         * For more information about primary keys, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey"
         * >Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<KeySchemaElement>.Builder} avoiding the
         * need to create one manually via {@link List<KeySchemaElement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KeySchemaElement>.Builder#build()} is called immediately and
         * its result is passed to {@link #keySchema(List<KeySchemaElement>)}.
         * 
         * @param keySchema
         *        a consumer that will call methods on {@link List<KeySchemaElement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keySchema(List<KeySchemaElement>)
         */
        Builder keySchema(Consumer<KeySchemaElement.Builder>... keySchema);

        /**
         * <p>
         * The current state of the table:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The table is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The table is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The table is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The table is ready for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The KMS key used to encrypt the table in inaccessible.
         * Table operations may fail due to failure to use the KMS key. DynamoDB will initiate the table archival
         * process when a table's KMS key remains inaccessible for more than seven days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARCHIVING</code> - The table is being archived. Operations are not allowed until archival is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARCHIVED</code> - The table has been archived. See the ArchivalReason for more information.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tableStatus
         *        The current state of the table:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The table is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The table is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The table is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The table is ready for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The KMS key used to encrypt the table in
         *        inaccessible. Table operations may fail due to failure to use the KMS key. DynamoDB will initiate the
         *        table archival process when a table's KMS key remains inaccessible for more than seven days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARCHIVING</code> - The table is being archived. Operations are not allowed until archival is
         *        complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARCHIVED</code> - The table has been archived. See the ArchivalReason for more information.
         *        </p>
         *        </li>
         * @see TableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableStatus
         */
        Builder tableStatus(String tableStatus);

        /**
         * <p>
         * The current state of the table:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The table is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The table is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The table is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The table is ready for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The KMS key used to encrypt the table in inaccessible.
         * Table operations may fail due to failure to use the KMS key. DynamoDB will initiate the table archival
         * process when a table's KMS key remains inaccessible for more than seven days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARCHIVING</code> - The table is being archived. Operations are not allowed until archival is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARCHIVED</code> - The table has been archived. See the ArchivalReason for more information.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tableStatus
         *        The current state of the table:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The table is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The table is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The table is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The table is ready for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The KMS key used to encrypt the table in
         *        inaccessible. Table operations may fail due to failure to use the KMS key. DynamoDB will initiate the
         *        table archival process when a table's KMS key remains inaccessible for more than seven days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARCHIVING</code> - The table is being archived. Operations are not allowed until archival is
         *        complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARCHIVED</code> - The table has been archived. See the ArchivalReason for more information.
         *        </p>
         *        </li>
         * @see TableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableStatus
         */
        Builder tableStatus(TableStatus tableStatus);

        /**
         * <p>
         * The date and time when the table was created, in <a href="http://www.epochconverter.com/">UNIX epoch time</a>
         * format.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time when the table was created, in <a href="http://www.epochconverter.com/">UNIX epoch
         *        time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The provisioned throughput settings for the table, consisting of read and write capacity units, along with
         * data about increases and decreases.
         * </p>
         * 
         * @param provisionedThroughput
         *        The provisioned throughput settings for the table, consisting of read and write capacity units, along
         *        with data about increases and decreases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughput(ProvisionedThroughputDescription provisionedThroughput);

        /**
         * <p>
         * The provisioned throughput settings for the table, consisting of read and write capacity units, along with
         * data about increases and decreases.
         * </p>
         * This is a convenience that creates an instance of the {@link ProvisionedThroughputDescription.Builder}
         * avoiding the need to create one manually via {@link ProvisionedThroughputDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisionedThroughputDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #provisionedThroughput(ProvisionedThroughputDescription)}.
         * 
         * @param provisionedThroughput
         *        a consumer that will call methods on {@link ProvisionedThroughputDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughput(ProvisionedThroughputDescription)
         */
        default Builder provisionedThroughput(Consumer<ProvisionedThroughputDescription.Builder> provisionedThroughput) {
            return provisionedThroughput(ProvisionedThroughputDescription.builder().applyMutation(provisionedThroughput).build());
        }

        /**
         * <p>
         * The total size of the specified table, in bytes. DynamoDB updates this value approximately every six hours.
         * Recent changes might not be reflected in this value.
         * </p>
         * 
         * @param tableSizeBytes
         *        The total size of the specified table, in bytes. DynamoDB updates this value approximately every six
         *        hours. Recent changes might not be reflected in this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableSizeBytes(Long tableSizeBytes);

        /**
         * <p>
         * The number of items in the specified table. DynamoDB updates this value approximately every six hours. Recent
         * changes might not be reflected in this value.
         * </p>
         * 
         * @param itemCount
         *        The number of items in the specified table. DynamoDB updates this value approximately every six hours.
         *        Recent changes might not be reflected in this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemCount(Long itemCount);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the table.
         * </p>
         * 
         * @param tableArn
         *        The Amazon Resource Name (ARN) that uniquely identifies the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableArn(String tableArn);

        /**
         * <p>
         * Unique identifier for the table for which the backup was created.
         * </p>
         * 
         * @param tableId
         *        Unique identifier for the table for which the backup was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableId(String tableId);

        /**
         * <p>
         * Contains the details for the read/write capacity mode.
         * </p>
         * 
         * @param billingModeSummary
         *        Contains the details for the read/write capacity mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingModeSummary(BillingModeSummary billingModeSummary);

        /**
         * <p>
         * Contains the details for the read/write capacity mode.
         * </p>
         * This is a convenience that creates an instance of the {@link BillingModeSummary.Builder} avoiding the need to
         * create one manually via {@link BillingModeSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link BillingModeSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #billingModeSummary(BillingModeSummary)}.
         * 
         * @param billingModeSummary
         *        a consumer that will call methods on {@link BillingModeSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingModeSummary(BillingModeSummary)
         */
        default Builder billingModeSummary(Consumer<BillingModeSummary.Builder> billingModeSummary) {
            return billingModeSummary(BillingModeSummary.builder().applyMutation(billingModeSummary).build());
        }

        /**
         * <p>
         * Represents one or more local secondary indexes on the table. Each index is scoped to a given partition key
         * value. Tables with one or more local secondary indexes are subject to an item collection size limit, where
         * the amount of data within a given item collection cannot exceed 10 GB. Each element is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the local secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema must
         * be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the
         * table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         * projected attributes is in <code>NonKeyAttributes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>IndexSizeBytes</code> - Represents the total size of the index, in bytes. DynamoDB updates this value
         * approximately every six hours. Recent changes might not be reflected in this value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ItemCount</code> - Represents the number of items in the index. DynamoDB updates this value
         * approximately every six hours. Recent changes might not be reflected in this value.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the table is in the <code>DELETING</code> state, no information about indexes will be returned.
         * </p>
         * 
         * @param localSecondaryIndexes
         *        Represents one or more local secondary indexes on the table. Each index is scoped to a given partition
         *        key value. Tables with one or more local secondary indexes are subject to an item collection size
         *        limit, where the amount of data within a given item collection cannot exceed 10 GB. Each element is
         *        composed of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IndexName</code> - The name of the local secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key
         *        schema must be between 1 and 255 characters (inclusive). The key schema must begin with the same
         *        partition key as the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the
         *        index. These are in addition to the primary key attributes and index key attributes, which are
         *        automatically projected. Each attribute specification is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ProjectionType</code> - One of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         *        projected attributes is in <code>NonKeyAttributes</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - All of the table attributes are projected into the index.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into
         *        the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed
         *        across all of the secondary indexes, must not exceed 20. If you project the same attribute into two
         *        different indexes, this counts as two distinct attributes when determining the total.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IndexSizeBytes</code> - Represents the total size of the index, in bytes. DynamoDB updates this
         *        value approximately every six hours. Recent changes might not be reflected in this value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ItemCount</code> - Represents the number of items in the index. DynamoDB updates this value
         *        approximately every six hours. Recent changes might not be reflected in this value.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the table is in the <code>DELETING</code> state, no information about indexes will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSecondaryIndexes(Collection<LocalSecondaryIndexDescription> localSecondaryIndexes);

        /**
         * <p>
         * Represents one or more local secondary indexes on the table. Each index is scoped to a given partition key
         * value. Tables with one or more local secondary indexes are subject to an item collection size limit, where
         * the amount of data within a given item collection cannot exceed 10 GB. Each element is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the local secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema must
         * be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the
         * table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         * projected attributes is in <code>NonKeyAttributes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>IndexSizeBytes</code> - Represents the total size of the index, in bytes. DynamoDB updates this value
         * approximately every six hours. Recent changes might not be reflected in this value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ItemCount</code> - Represents the number of items in the index. DynamoDB updates this value
         * approximately every six hours. Recent changes might not be reflected in this value.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the table is in the <code>DELETING</code> state, no information about indexes will be returned.
         * </p>
         * 
         * @param localSecondaryIndexes
         *        Represents one or more local secondary indexes on the table. Each index is scoped to a given partition
         *        key value. Tables with one or more local secondary indexes are subject to an item collection size
         *        limit, where the amount of data within a given item collection cannot exceed 10 GB. Each element is
         *        composed of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IndexName</code> - The name of the local secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key
         *        schema must be between 1 and 255 characters (inclusive). The key schema must begin with the same
         *        partition key as the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the
         *        index. These are in addition to the primary key attributes and index key attributes, which are
         *        automatically projected. Each attribute specification is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ProjectionType</code> - One of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         *        projected attributes is in <code>NonKeyAttributes</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - All of the table attributes are projected into the index.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into
         *        the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed
         *        across all of the secondary indexes, must not exceed 20. If you project the same attribute into two
         *        different indexes, this counts as two distinct attributes when determining the total.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IndexSizeBytes</code> - Represents the total size of the index, in bytes. DynamoDB updates this
         *        value approximately every six hours. Recent changes might not be reflected in this value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ItemCount</code> - Represents the number of items in the index. DynamoDB updates this value
         *        approximately every six hours. Recent changes might not be reflected in this value.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the table is in the <code>DELETING</code> state, no information about indexes will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSecondaryIndexes(LocalSecondaryIndexDescription... localSecondaryIndexes);

        /**
         * <p>
         * Represents one or more local secondary indexes on the table. Each index is scoped to a given partition key
         * value. Tables with one or more local secondary indexes are subject to an item collection size limit, where
         * the amount of data within a given item collection cannot exceed 10 GB. Each element is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the local secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema must
         * be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the
         * table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         * projected attributes is in <code>NonKeyAttributes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>IndexSizeBytes</code> - Represents the total size of the index, in bytes. DynamoDB updates this value
         * approximately every six hours. Recent changes might not be reflected in this value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ItemCount</code> - Represents the number of items in the index. DynamoDB updates this value
         * approximately every six hours. Recent changes might not be reflected in this value.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the table is in the <code>DELETING</code> state, no information about indexes will be returned.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LocalSecondaryIndexDescription>.Builder}
         * avoiding the need to create one manually via {@link List<LocalSecondaryIndexDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LocalSecondaryIndexDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #localSecondaryIndexes(List<LocalSecondaryIndexDescription>)}.
         * 
         * @param localSecondaryIndexes
         *        a consumer that will call methods on {@link List<LocalSecondaryIndexDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localSecondaryIndexes(List<LocalSecondaryIndexDescription>)
         */
        Builder localSecondaryIndexes(Consumer<LocalSecondaryIndexDescription.Builder>... localSecondaryIndexes);

        /**
         * <p>
         * The global secondary indexes, if any, on the table. Each index is scoped to a given partition key value. Each
         * element is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Backfilling</code> - If true, then the index is currently in the backfilling phase. Backfilling occurs
         * only when a new global secondary index is added to the table. It is the process by which DynamoDB populates
         * the new index with data from the table. (This attribute does not appear for indexes that were created during
         * a <code>CreateTable</code> operation.)
         * </p>
         * <p>
         * You can delete an index that is being created during the <code>Backfilling</code> phase when
         * <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is true. You can't delete the index
         * that is being created when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is false.
         * (This attribute does not appear for indexes that were created during a <code>CreateTable</code> operation.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the global secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IndexSizeBytes</code> - The total size of the global secondary index, in bytes. DynamoDB updates this
         * value approximately every six hours. Recent changes might not be reflected in this value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IndexStatus</code> - The current status of the global secondary index:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The index is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The index is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The index is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The index is ready for use.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ItemCount</code> - The number of items in the global secondary index. DynamoDB updates this value
         * approximately every six hours. Recent changes might not be reflected in this value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema must
         * be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the
         * table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code>, the secondary index
         * will include other non-key attributes that you specify.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
         * consisting of read and write capacity units, along with data about increases and decreases.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the table is in the <code>DELETING</code> state, no information about indexes will be returned.
         * </p>
         * 
         * @param globalSecondaryIndexes
         *        The global secondary indexes, if any, on the table. Each index is scoped to a given partition key
         *        value. Each element is composed of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Backfilling</code> - If true, then the index is currently in the backfilling phase. Backfilling
         *        occurs only when a new global secondary index is added to the table. It is the process by which
         *        DynamoDB populates the new index with data from the table. (This attribute does not appear for indexes
         *        that were created during a <code>CreateTable</code> operation.)
         *        </p>
         *        <p>
         *        You can delete an index that is being created during the <code>Backfilling</code> phase when
         *        <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is true. You can't delete the
         *        index that is being created when <code>IndexStatus</code> is set to CREATING and
         *        <code>Backfilling</code> is false. (This attribute does not appear for indexes that were created
         *        during a <code>CreateTable</code> operation.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IndexName</code> - The name of the global secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IndexSizeBytes</code> - The total size of the global secondary index, in bytes. DynamoDB updates
         *        this value approximately every six hours. Recent changes might not be reflected in this value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IndexStatus</code> - The current status of the global secondary index:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The index is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The index is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The index is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The index is ready for use.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ItemCount</code> - The number of items in the global secondary index. DynamoDB updates this
         *        value approximately every six hours. Recent changes might not be reflected in this value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key
         *        schema must be between 1 and 255 characters (inclusive). The key schema must begin with the same
         *        partition key as the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the
         *        index. These are in addition to the primary key attributes and index key attributes, which are
         *        automatically projected. Each attribute specification is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ProjectionType</code> - One of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code>, the
         *        secondary index will include other non-key attributes that you specify.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - All of the table attributes are projected into the index.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into
         *        the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed
         *        across all of the secondary indexes, must not exceed 20. If you project the same attribute into two
         *        different indexes, this counts as two distinct attributes when determining the total.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary
         *        index, consisting of read and write capacity units, along with data about increases and decreases.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the table is in the <code>DELETING</code> state, no information about indexes will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndexDescription> globalSecondaryIndexes);

        /**
         * <p>
         * The global secondary indexes, if any, on the table. Each index is scoped to a given partition key value. Each
         * element is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Backfilling</code> - If true, then the index is currently in the backfilling phase. Backfilling occurs
         * only when a new global secondary index is added to the table. It is the process by which DynamoDB populates
         * the new index with data from the table. (This attribute does not appear for indexes that were created during
         * a <code>CreateTable</code> operation.)
         * </p>
         * <p>
         * You can delete an index that is being created during the <code>Backfilling</code> phase when
         * <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is true. You can't delete the index
         * that is being created when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is false.
         * (This attribute does not appear for indexes that were created during a <code>CreateTable</code> operation.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the global secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IndexSizeBytes</code> - The total size of the global secondary index, in bytes. DynamoDB updates this
         * value approximately every six hours. Recent changes might not be reflected in this value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IndexStatus</code> - The current status of the global secondary index:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The index is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The index is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The index is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The index is ready for use.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ItemCount</code> - The number of items in the global secondary index. DynamoDB updates this value
         * approximately every six hours. Recent changes might not be reflected in this value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema must
         * be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the
         * table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code>, the secondary index
         * will include other non-key attributes that you specify.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
         * consisting of read and write capacity units, along with data about increases and decreases.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the table is in the <code>DELETING</code> state, no information about indexes will be returned.
         * </p>
         * 
         * @param globalSecondaryIndexes
         *        The global secondary indexes, if any, on the table. Each index is scoped to a given partition key
         *        value. Each element is composed of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Backfilling</code> - If true, then the index is currently in the backfilling phase. Backfilling
         *        occurs only when a new global secondary index is added to the table. It is the process by which
         *        DynamoDB populates the new index with data from the table. (This attribute does not appear for indexes
         *        that were created during a <code>CreateTable</code> operation.)
         *        </p>
         *        <p>
         *        You can delete an index that is being created during the <code>Backfilling</code> phase when
         *        <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is true. You can't delete the
         *        index that is being created when <code>IndexStatus</code> is set to CREATING and
         *        <code>Backfilling</code> is false. (This attribute does not appear for indexes that were created
         *        during a <code>CreateTable</code> operation.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IndexName</code> - The name of the global secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IndexSizeBytes</code> - The total size of the global secondary index, in bytes. DynamoDB updates
         *        this value approximately every six hours. Recent changes might not be reflected in this value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IndexStatus</code> - The current status of the global secondary index:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The index is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The index is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The index is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The index is ready for use.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ItemCount</code> - The number of items in the global secondary index. DynamoDB updates this
         *        value approximately every six hours. Recent changes might not be reflected in this value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key
         *        schema must be between 1 and 255 characters (inclusive). The key schema must begin with the same
         *        partition key as the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the
         *        index. These are in addition to the primary key attributes and index key attributes, which are
         *        automatically projected. Each attribute specification is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ProjectionType</code> - One of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code>, the
         *        secondary index will include other non-key attributes that you specify.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - All of the table attributes are projected into the index.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into
         *        the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed
         *        across all of the secondary indexes, must not exceed 20. If you project the same attribute into two
         *        different indexes, this counts as two distinct attributes when determining the total.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary
         *        index, consisting of read and write capacity units, along with data about increases and decreases.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the table is in the <code>DELETING</code> state, no information about indexes will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(GlobalSecondaryIndexDescription... globalSecondaryIndexes);

        /**
         * <p>
         * The global secondary indexes, if any, on the table. Each index is scoped to a given partition key value. Each
         * element is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Backfilling</code> - If true, then the index is currently in the backfilling phase. Backfilling occurs
         * only when a new global secondary index is added to the table. It is the process by which DynamoDB populates
         * the new index with data from the table. (This attribute does not appear for indexes that were created during
         * a <code>CreateTable</code> operation.)
         * </p>
         * <p>
         * You can delete an index that is being created during the <code>Backfilling</code> phase when
         * <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is true. You can't delete the index
         * that is being created when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is false.
         * (This attribute does not appear for indexes that were created during a <code>CreateTable</code> operation.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the global secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IndexSizeBytes</code> - The total size of the global secondary index, in bytes. DynamoDB updates this
         * value approximately every six hours. Recent changes might not be reflected in this value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IndexStatus</code> - The current status of the global secondary index:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The index is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The index is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The index is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The index is ready for use.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ItemCount</code> - The number of items in the global secondary index. DynamoDB updates this value
         * approximately every six hours. Recent changes might not be reflected in this value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema must
         * be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the
         * table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code>, the secondary index
         * will include other non-key attributes that you specify.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
         * consisting of read and write capacity units, along with data about increases and decreases.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the table is in the <code>DELETING</code> state, no information about indexes will be returned.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GlobalSecondaryIndexDescription>.Builder}
         * avoiding the need to create one manually via {@link List<GlobalSecondaryIndexDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GlobalSecondaryIndexDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #globalSecondaryIndexes(List<GlobalSecondaryIndexDescription>)}.
         * 
         * @param globalSecondaryIndexes
         *        a consumer that will call methods on {@link List<GlobalSecondaryIndexDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalSecondaryIndexes(List<GlobalSecondaryIndexDescription>)
         */
        Builder globalSecondaryIndexes(Consumer<GlobalSecondaryIndexDescription.Builder>... globalSecondaryIndexes);

        /**
         * <p>
         * The current DynamoDB Streams configuration for the table.
         * </p>
         * 
         * @param streamSpecification
         *        The current DynamoDB Streams configuration for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamSpecification(StreamSpecification streamSpecification);

        /**
         * <p>
         * The current DynamoDB Streams configuration for the table.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamSpecification.Builder} avoiding the need
         * to create one manually via {@link StreamSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #streamSpecification(StreamSpecification)}.
         * 
         * @param streamSpecification
         *        a consumer that will call methods on {@link StreamSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamSpecification(StreamSpecification)
         */
        default Builder streamSpecification(Consumer<StreamSpecification.Builder> streamSpecification) {
            return streamSpecification(StreamSpecification.builder().applyMutation(streamSpecification).build());
        }

        /**
         * <p>
         * A timestamp, in ISO 8601 format, for this stream.
         * </p>
         * <p>
         * Note that <code>LatestStreamLabel</code> is not a unique identifier for the stream, because it is possible
         * that a stream from another table might have the same timestamp. However, the combination of the following
         * three elements is guaranteed to be unique:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Amazon Web Services customer ID
         * </p>
         * </li>
         * <li>
         * <p>
         * Table name
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>StreamLabel</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param latestStreamLabel
         *        A timestamp, in ISO 8601 format, for this stream.</p>
         *        <p>
         *        Note that <code>LatestStreamLabel</code> is not a unique identifier for the stream, because it is
         *        possible that a stream from another table might have the same timestamp. However, the combination of
         *        the following three elements is guaranteed to be unique:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Amazon Web Services customer ID
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Table name
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>StreamLabel</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestStreamLabel(String latestStreamLabel);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the latest stream for this table.
         * </p>
         * 
         * @param latestStreamArn
         *        The Amazon Resource Name (ARN) that uniquely identifies the latest stream for this table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestStreamArn(String latestStreamArn);

        /**
         * <p>
         * Represents the version of <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">global tables</a>
         * in use, if the table is replicated across Amazon Web Services Regions.
         * </p>
         * 
         * @param globalTableVersion
         *        Represents the version of <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">global
         *        tables</a> in use, if the table is replicated across Amazon Web Services Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTableVersion(String globalTableVersion);

        /**
         * <p>
         * Represents replicas of the table.
         * </p>
         * 
         * @param replicas
         *        Represents replicas of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicas(Collection<ReplicaDescription> replicas);

        /**
         * <p>
         * Represents replicas of the table.
         * </p>
         * 
         * @param replicas
         *        Represents replicas of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicas(ReplicaDescription... replicas);

        /**
         * <p>
         * Represents replicas of the table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReplicaDescription>.Builder} avoiding the
         * need to create one manually via {@link List<ReplicaDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicaDescription>.Builder#build()} is called immediately
         * and its result is passed to {@link #replicas(List<ReplicaDescription>)}.
         * 
         * @param replicas
         *        a consumer that will call methods on {@link List<ReplicaDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicas(List<ReplicaDescription>)
         */
        Builder replicas(Consumer<ReplicaDescription.Builder>... replicas);

        /**
         * <p>
         * Contains details for the restore.
         * </p>
         * 
         * @param restoreSummary
         *        Contains details for the restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreSummary(RestoreSummary restoreSummary);

        /**
         * <p>
         * Contains details for the restore.
         * </p>
         * This is a convenience that creates an instance of the {@link RestoreSummary.Builder} avoiding the need to
         * create one manually via {@link RestoreSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link RestoreSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #restoreSummary(RestoreSummary)}.
         * 
         * @param restoreSummary
         *        a consumer that will call methods on {@link RestoreSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restoreSummary(RestoreSummary)
         */
        default Builder restoreSummary(Consumer<RestoreSummary.Builder> restoreSummary) {
            return restoreSummary(RestoreSummary.builder().applyMutation(restoreSummary).build());
        }

        /**
         * <p>
         * The description of the server-side encryption status on the specified table.
         * </p>
         * 
         * @param sseDescription
         *        The description of the server-side encryption status on the specified table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseDescription(SSEDescription sseDescription);

        /**
         * <p>
         * The description of the server-side encryption status on the specified table.
         * </p>
         * This is a convenience that creates an instance of the {@link SSEDescription.Builder} avoiding the need to
         * create one manually via {@link SSEDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link SSEDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #sseDescription(SSEDescription)}.
         * 
         * @param sseDescription
         *        a consumer that will call methods on {@link SSEDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseDescription(SSEDescription)
         */
        default Builder sseDescription(Consumer<SSEDescription.Builder> sseDescription) {
            return sseDescription(SSEDescription.builder().applyMutation(sseDescription).build());
        }

        /**
         * <p>
         * Contains information about the table archive.
         * </p>
         * 
         * @param archivalSummary
         *        Contains information about the table archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archivalSummary(ArchivalSummary archivalSummary);

        /**
         * <p>
         * Contains information about the table archive.
         * </p>
         * This is a convenience that creates an instance of the {@link ArchivalSummary.Builder} avoiding the need to
         * create one manually via {@link ArchivalSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ArchivalSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #archivalSummary(ArchivalSummary)}.
         * 
         * @param archivalSummary
         *        a consumer that will call methods on {@link ArchivalSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #archivalSummary(ArchivalSummary)
         */
        default Builder archivalSummary(Consumer<ArchivalSummary.Builder> archivalSummary) {
            return archivalSummary(ArchivalSummary.builder().applyMutation(archivalSummary).build());
        }

        /**
         * <p>
         * Contains details of the table class.
         * </p>
         * 
         * @param tableClassSummary
         *        Contains details of the table class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableClassSummary(TableClassSummary tableClassSummary);

        /**
         * <p>
         * Contains details of the table class.
         * </p>
         * This is a convenience that creates an instance of the {@link TableClassSummary.Builder} avoiding the need to
         * create one manually via {@link TableClassSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link TableClassSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #tableClassSummary(TableClassSummary)}.
         * 
         * @param tableClassSummary
         *        a consumer that will call methods on {@link TableClassSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableClassSummary(TableClassSummary)
         */
        default Builder tableClassSummary(Consumer<TableClassSummary.Builder> tableClassSummary) {
            return tableClassSummary(TableClassSummary.builder().applyMutation(tableClassSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<AttributeDefinition> attributeDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String tableName;

        private List<KeySchemaElement> keySchema = DefaultSdkAutoConstructList.getInstance();

        private String tableStatus;

        private Instant creationDateTime;

        private ProvisionedThroughputDescription provisionedThroughput;

        private Long tableSizeBytes;

        private Long itemCount;

        private String tableArn;

        private String tableId;

        private BillingModeSummary billingModeSummary;

        private List<LocalSecondaryIndexDescription> localSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();

        private List<GlobalSecondaryIndexDescription> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();

        private StreamSpecification streamSpecification;

        private String latestStreamLabel;

        private String latestStreamArn;

        private String globalTableVersion;

        private List<ReplicaDescription> replicas = DefaultSdkAutoConstructList.getInstance();

        private RestoreSummary restoreSummary;

        private SSEDescription sseDescription;

        private ArchivalSummary archivalSummary;

        private TableClassSummary tableClassSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(TableDescription model) {
            attributeDefinitions(model.attributeDefinitions);
            tableName(model.tableName);
            keySchema(model.keySchema);
            tableStatus(model.tableStatus);
            creationDateTime(model.creationDateTime);
            provisionedThroughput(model.provisionedThroughput);
            tableSizeBytes(model.tableSizeBytes);
            itemCount(model.itemCount);
            tableArn(model.tableArn);
            tableId(model.tableId);
            billingModeSummary(model.billingModeSummary);
            localSecondaryIndexes(model.localSecondaryIndexes);
            globalSecondaryIndexes(model.globalSecondaryIndexes);
            streamSpecification(model.streamSpecification);
            latestStreamLabel(model.latestStreamLabel);
            latestStreamArn(model.latestStreamArn);
            globalTableVersion(model.globalTableVersion);
            replicas(model.replicas);
            restoreSummary(model.restoreSummary);
            sseDescription(model.sseDescription);
            archivalSummary(model.archivalSummary);
            tableClassSummary(model.tableClassSummary);
        }

        public final List<AttributeDefinition.Builder> getAttributeDefinitions() {
            List<AttributeDefinition.Builder> result = AttributeDefinitionsCopier.copyToBuilder(this.attributeDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeDefinitions(Collection<AttributeDefinition.BuilderImpl> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copyFromBuilder(attributeDefinitions);
        }

        @Override
        @Transient
        public final Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributeDefinitions(AttributeDefinition... attributeDefinitions) {
            attributeDefinitions(Arrays.asList(attributeDefinitions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributeDefinitions(Consumer<AttributeDefinition.Builder>... attributeDefinitions) {
            attributeDefinitions(Stream.of(attributeDefinitions).map(c -> AttributeDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        @Transient
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final List<KeySchemaElement.Builder> getKeySchema() {
            List<KeySchemaElement.Builder> result = KeySchemaCopier.copyToBuilder(this.keySchema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeySchema(Collection<KeySchemaElement.BuilderImpl> keySchema) {
            this.keySchema = KeySchemaCopier.copyFromBuilder(keySchema);
        }

        @Override
        @Transient
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement... keySchema) {
            keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder keySchema(Consumer<KeySchemaElement.Builder>... keySchema) {
            keySchema(Stream.of(keySchema).map(c -> KeySchemaElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTableStatus() {
            return tableStatus;
        }

        public final void setTableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
        }

        @Override
        @Transient
        public final Builder tableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder tableStatus(TableStatus tableStatus) {
            this.tableStatus(tableStatus == null ? null : tableStatus.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        @Transient
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final ProvisionedThroughputDescription.Builder getProvisionedThroughput() {
            return provisionedThroughput != null ? provisionedThroughput.toBuilder() : null;
        }

        public final void setProvisionedThroughput(ProvisionedThroughputDescription.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        @Override
        @Transient
        public final Builder provisionedThroughput(ProvisionedThroughputDescription provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final Long getTableSizeBytes() {
            return tableSizeBytes;
        }

        public final void setTableSizeBytes(Long tableSizeBytes) {
            this.tableSizeBytes = tableSizeBytes;
        }

        @Override
        @Transient
        public final Builder tableSizeBytes(Long tableSizeBytes) {
            this.tableSizeBytes = tableSizeBytes;
            return this;
        }

        public final Long getItemCount() {
            return itemCount;
        }

        public final void setItemCount(Long itemCount) {
            this.itemCount = itemCount;
        }

        @Override
        @Transient
        public final Builder itemCount(Long itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final String getTableArn() {
            return tableArn;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        @Override
        @Transient
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final String getTableId() {
            return tableId;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        @Override
        @Transient
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final BillingModeSummary.Builder getBillingModeSummary() {
            return billingModeSummary != null ? billingModeSummary.toBuilder() : null;
        }

        public final void setBillingModeSummary(BillingModeSummary.BuilderImpl billingModeSummary) {
            this.billingModeSummary = billingModeSummary != null ? billingModeSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder billingModeSummary(BillingModeSummary billingModeSummary) {
            this.billingModeSummary = billingModeSummary;
            return this;
        }

        public final List<LocalSecondaryIndexDescription.Builder> getLocalSecondaryIndexes() {
            List<LocalSecondaryIndexDescription.Builder> result = LocalSecondaryIndexDescriptionListCopier
                    .copyToBuilder(this.localSecondaryIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocalSecondaryIndexes(Collection<LocalSecondaryIndexDescription.BuilderImpl> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexDescriptionListCopier.copyFromBuilder(localSecondaryIndexes);
        }

        @Override
        @Transient
        public final Builder localSecondaryIndexes(Collection<LocalSecondaryIndexDescription> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexDescriptionListCopier.copy(localSecondaryIndexes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder localSecondaryIndexes(LocalSecondaryIndexDescription... localSecondaryIndexes) {
            localSecondaryIndexes(Arrays.asList(localSecondaryIndexes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder localSecondaryIndexes(Consumer<LocalSecondaryIndexDescription.Builder>... localSecondaryIndexes) {
            localSecondaryIndexes(Stream.of(localSecondaryIndexes)
                    .map(c -> LocalSecondaryIndexDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GlobalSecondaryIndexDescription.Builder> getGlobalSecondaryIndexes() {
            List<GlobalSecondaryIndexDescription.Builder> result = GlobalSecondaryIndexDescriptionListCopier
                    .copyToBuilder(this.globalSecondaryIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalSecondaryIndexes(Collection<GlobalSecondaryIndexDescription.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexDescriptionListCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        @Override
        @Transient
        public final Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndexDescription> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexDescriptionListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder globalSecondaryIndexes(GlobalSecondaryIndexDescription... globalSecondaryIndexes) {
            globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder globalSecondaryIndexes(Consumer<GlobalSecondaryIndexDescription.Builder>... globalSecondaryIndexes) {
            globalSecondaryIndexes(Stream.of(globalSecondaryIndexes)
                    .map(c -> GlobalSecondaryIndexDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final StreamSpecification.Builder getStreamSpecification() {
            return streamSpecification != null ? streamSpecification.toBuilder() : null;
        }

        public final void setStreamSpecification(StreamSpecification.BuilderImpl streamSpecification) {
            this.streamSpecification = streamSpecification != null ? streamSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder streamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        public final String getLatestStreamLabel() {
            return latestStreamLabel;
        }

        public final void setLatestStreamLabel(String latestStreamLabel) {
            this.latestStreamLabel = latestStreamLabel;
        }

        @Override
        @Transient
        public final Builder latestStreamLabel(String latestStreamLabel) {
            this.latestStreamLabel = latestStreamLabel;
            return this;
        }

        public final String getLatestStreamArn() {
            return latestStreamArn;
        }

        public final void setLatestStreamArn(String latestStreamArn) {
            this.latestStreamArn = latestStreamArn;
        }

        @Override
        @Transient
        public final Builder latestStreamArn(String latestStreamArn) {
            this.latestStreamArn = latestStreamArn;
            return this;
        }

        public final String getGlobalTableVersion() {
            return globalTableVersion;
        }

        public final void setGlobalTableVersion(String globalTableVersion) {
            this.globalTableVersion = globalTableVersion;
        }

        @Override
        @Transient
        public final Builder globalTableVersion(String globalTableVersion) {
            this.globalTableVersion = globalTableVersion;
            return this;
        }

        public final List<ReplicaDescription.Builder> getReplicas() {
            List<ReplicaDescription.Builder> result = ReplicaDescriptionListCopier.copyToBuilder(this.replicas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicas(Collection<ReplicaDescription.BuilderImpl> replicas) {
            this.replicas = ReplicaDescriptionListCopier.copyFromBuilder(replicas);
        }

        @Override
        @Transient
        public final Builder replicas(Collection<ReplicaDescription> replicas) {
            this.replicas = ReplicaDescriptionListCopier.copy(replicas);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicas(ReplicaDescription... replicas) {
            replicas(Arrays.asList(replicas));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicas(Consumer<ReplicaDescription.Builder>... replicas) {
            replicas(Stream.of(replicas).map(c -> ReplicaDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final RestoreSummary.Builder getRestoreSummary() {
            return restoreSummary != null ? restoreSummary.toBuilder() : null;
        }

        public final void setRestoreSummary(RestoreSummary.BuilderImpl restoreSummary) {
            this.restoreSummary = restoreSummary != null ? restoreSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder restoreSummary(RestoreSummary restoreSummary) {
            this.restoreSummary = restoreSummary;
            return this;
        }

        public final SSEDescription.Builder getSseDescription() {
            return sseDescription != null ? sseDescription.toBuilder() : null;
        }

        public final void setSseDescription(SSEDescription.BuilderImpl sseDescription) {
            this.sseDescription = sseDescription != null ? sseDescription.build() : null;
        }

        @Override
        @Transient
        public final Builder sseDescription(SSEDescription sseDescription) {
            this.sseDescription = sseDescription;
            return this;
        }

        public final ArchivalSummary.Builder getArchivalSummary() {
            return archivalSummary != null ? archivalSummary.toBuilder() : null;
        }

        public final void setArchivalSummary(ArchivalSummary.BuilderImpl archivalSummary) {
            this.archivalSummary = archivalSummary != null ? archivalSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder archivalSummary(ArchivalSummary archivalSummary) {
            this.archivalSummary = archivalSummary;
            return this;
        }

        public final TableClassSummary.Builder getTableClassSummary() {
            return tableClassSummary != null ? tableClassSummary.toBuilder() : null;
        }

        public final void setTableClassSummary(TableClassSummary.BuilderImpl tableClassSummary) {
            this.tableClassSummary = tableClassSummary != null ? tableClassSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder tableClassSummary(TableClassSummary tableClassSummary) {
            this.tableClassSummary = tableClassSummary;
            return this;
        }

        @Override
        public TableDescription build() {
            return new TableDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
