/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description of the server-side encryption status on the specified table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SSEDescription implements SdkPojo, Serializable, ToCopyableBuilder<SSEDescription.Builder, SSEDescription> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SSEDescription::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SSE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SSEType").getter(getter(SSEDescription::sseTypeAsString)).setter(setter(Builder::sseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSEType").build()).build();

    private static final SdkField<String> KMS_MASTER_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSMasterKeyArn").getter(getter(SSEDescription::kmsMasterKeyArn))
            .setter(setter(Builder::kmsMasterKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSMasterKeyArn").build()).build();

    private static final SdkField<Instant> INACCESSIBLE_ENCRYPTION_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("InaccessibleEncryptionDateTime")
            .getter(getter(SSEDescription::inaccessibleEncryptionDateTime))
            .setter(setter(Builder::inaccessibleEncryptionDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InaccessibleEncryptionDateTime")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, SSE_TYPE_FIELD,
            KMS_MASTER_KEY_ARN_FIELD, INACCESSIBLE_ENCRYPTION_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String sseType;

    private final String kmsMasterKeyArn;

    private final Instant inaccessibleEncryptionDateTime;

    private SSEDescription(BuilderImpl builder) {
        this.status = builder.status;
        this.sseType = builder.sseType;
        this.kmsMasterKeyArn = builder.kmsMasterKeyArn;
        this.inaccessibleEncryptionDateTime = builder.inaccessibleEncryptionDateTime;
    }

    /**
     * <p>
     * Represents the current state of server-side encryption. The only supported values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> - Server-side encryption is enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - Server-side encryption is being updated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SSEStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Represents the current state of server-side encryption. The only supported values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - Server-side encryption is enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - Server-side encryption is being updated.
     *         </p>
     *         </li>
     * @see SSEStatus
     */
    public final SSEStatus status() {
        return SSEStatus.fromValue(status);
    }

    /**
     * <p>
     * Represents the current state of server-side encryption. The only supported values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> - Server-side encryption is enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - Server-side encryption is being updated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SSEStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Represents the current state of server-side encryption. The only supported values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - Server-side encryption is enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - Server-side encryption is being updated.
     *         </p>
     *         </li>
     * @see SSEStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Server-side encryption type. The only supported value is:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KMS</code> - Server-side encryption that uses Key Management Service. The key is stored in your account and
     * is managed by KMS (KMS charges apply).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sseType} will
     * return {@link SSEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sseTypeAsString}.
     * </p>
     * 
     * @return Server-side encryption type. The only supported value is:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KMS</code> - Server-side encryption that uses Key Management Service. The key is stored in your
     *         account and is managed by KMS (KMS charges apply).
     *         </p>
     *         </li>
     * @see SSEType
     */
    public final SSEType sseType() {
        return SSEType.fromValue(sseType);
    }

    /**
     * <p>
     * Server-side encryption type. The only supported value is:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KMS</code> - Server-side encryption that uses Key Management Service. The key is stored in your account and
     * is managed by KMS (KMS charges apply).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sseType} will
     * return {@link SSEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sseTypeAsString}.
     * </p>
     * 
     * @return Server-side encryption type. The only supported value is:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KMS</code> - Server-side encryption that uses Key Management Service. The key is stored in your
     *         account and is managed by KMS (KMS charges apply).
     *         </p>
     *         </li>
     * @see SSEType
     */
    public final String sseTypeAsString() {
        return sseType;
    }

    /**
     * <p>
     * The KMS key ARN used for the KMS encryption.
     * </p>
     * 
     * @return The KMS key ARN used for the KMS encryption.
     */
    public final String kmsMasterKeyArn() {
        return kmsMasterKeyArn;
    }

    /**
     * <p>
     * Indicates the time, in UNIX epoch date format, when DynamoDB detected that the table's KMS key was inaccessible.
     * This attribute will automatically be cleared when DynamoDB detects that the table's KMS key is accessible again.
     * DynamoDB will initiate the table archival process when table's KMS key remains inaccessible for more than seven
     * days from this date.
     * </p>
     * 
     * @return Indicates the time, in UNIX epoch date format, when DynamoDB detected that the table's KMS key was
     *         inaccessible. This attribute will automatically be cleared when DynamoDB detects that the table's KMS key
     *         is accessible again. DynamoDB will initiate the table archival process when table's KMS key remains
     *         inaccessible for more than seven days from this date.
     */
    public final Instant inaccessibleEncryptionDateTime() {
        return inaccessibleEncryptionDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsMasterKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(inaccessibleEncryptionDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SSEDescription)) {
            return false;
        }
        SSEDescription other = (SSEDescription) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(sseTypeAsString(), other.sseTypeAsString())
                && Objects.equals(kmsMasterKeyArn(), other.kmsMasterKeyArn())
                && Objects.equals(inaccessibleEncryptionDateTime(), other.inaccessibleEncryptionDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SSEDescription").add("Status", statusAsString()).add("SSEType", sseTypeAsString())
                .add("KMSMasterKeyArn", kmsMasterKeyArn())
                .add("InaccessibleEncryptionDateTime", inaccessibleEncryptionDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SSEType":
            return Optional.ofNullable(clazz.cast(sseTypeAsString()));
        case "KMSMasterKeyArn":
            return Optional.ofNullable(clazz.cast(kmsMasterKeyArn()));
        case "InaccessibleEncryptionDateTime":
            return Optional.ofNullable(clazz.cast(inaccessibleEncryptionDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SSEDescription, T> g) {
        return obj -> g.apply((SSEDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SSEDescription> {
        /**
         * <p>
         * Represents the current state of server-side encryption. The only supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> - Server-side encryption is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - Server-side encryption is being updated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Represents the current state of server-side encryption. The only supported values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - Server-side encryption is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - Server-side encryption is being updated.
         *        </p>
         *        </li>
         * @see SSEStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSEStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Represents the current state of server-side encryption. The only supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> - Server-side encryption is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - Server-side encryption is being updated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Represents the current state of server-side encryption. The only supported values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - Server-side encryption is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - Server-side encryption is being updated.
         *        </p>
         *        </li>
         * @see SSEStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSEStatus
         */
        Builder status(SSEStatus status);

        /**
         * <p>
         * Server-side encryption type. The only supported value is:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KMS</code> - Server-side encryption that uses Key Management Service. The key is stored in your account
         * and is managed by KMS (KMS charges apply).
         * </p>
         * </li>
         * </ul>
         * 
         * @param sseType
         *        Server-side encryption type. The only supported value is:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KMS</code> - Server-side encryption that uses Key Management Service. The key is stored in your
         *        account and is managed by KMS (KMS charges apply).
         *        </p>
         *        </li>
         * @see SSEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSEType
         */
        Builder sseType(String sseType);

        /**
         * <p>
         * Server-side encryption type. The only supported value is:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KMS</code> - Server-side encryption that uses Key Management Service. The key is stored in your account
         * and is managed by KMS (KMS charges apply).
         * </p>
         * </li>
         * </ul>
         * 
         * @param sseType
         *        Server-side encryption type. The only supported value is:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KMS</code> - Server-side encryption that uses Key Management Service. The key is stored in your
         *        account and is managed by KMS (KMS charges apply).
         *        </p>
         *        </li>
         * @see SSEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSEType
         */
        Builder sseType(SSEType sseType);

        /**
         * <p>
         * The KMS key ARN used for the KMS encryption.
         * </p>
         * 
         * @param kmsMasterKeyArn
         *        The KMS key ARN used for the KMS encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsMasterKeyArn(String kmsMasterKeyArn);

        /**
         * <p>
         * Indicates the time, in UNIX epoch date format, when DynamoDB detected that the table's KMS key was
         * inaccessible. This attribute will automatically be cleared when DynamoDB detects that the table's KMS key is
         * accessible again. DynamoDB will initiate the table archival process when table's KMS key remains inaccessible
         * for more than seven days from this date.
         * </p>
         * 
         * @param inaccessibleEncryptionDateTime
         *        Indicates the time, in UNIX epoch date format, when DynamoDB detected that the table's KMS key was
         *        inaccessible. This attribute will automatically be cleared when DynamoDB detects that the table's KMS
         *        key is accessible again. DynamoDB will initiate the table archival process when table's KMS key
         *        remains inaccessible for more than seven days from this date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inaccessibleEncryptionDateTime(Instant inaccessibleEncryptionDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String sseType;

        private String kmsMasterKeyArn;

        private Instant inaccessibleEncryptionDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SSEDescription model) {
            status(model.status);
            sseType(model.sseType);
            kmsMasterKeyArn(model.kmsMasterKeyArn);
            inaccessibleEncryptionDateTime(model.inaccessibleEncryptionDateTime);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(SSEStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSseType() {
            return sseType;
        }

        public final void setSseType(String sseType) {
            this.sseType = sseType;
        }

        @Override
        @Transient
        public final Builder sseType(String sseType) {
            this.sseType = sseType;
            return this;
        }

        @Override
        @Transient
        public final Builder sseType(SSEType sseType) {
            this.sseType(sseType == null ? null : sseType.toString());
            return this;
        }

        public final String getKmsMasterKeyArn() {
            return kmsMasterKeyArn;
        }

        public final void setKmsMasterKeyArn(String kmsMasterKeyArn) {
            this.kmsMasterKeyArn = kmsMasterKeyArn;
        }

        @Override
        @Transient
        public final Builder kmsMasterKeyArn(String kmsMasterKeyArn) {
            this.kmsMasterKeyArn = kmsMasterKeyArn;
            return this;
        }

        public final Instant getInaccessibleEncryptionDateTime() {
            return inaccessibleEncryptionDateTime;
        }

        public final void setInaccessibleEncryptionDateTime(Instant inaccessibleEncryptionDateTime) {
            this.inaccessibleEncryptionDateTime = inaccessibleEncryptionDateTime;
        }

        @Override
        @Transient
        public final Builder inaccessibleEncryptionDateTime(Instant inaccessibleEncryptionDateTime) {
            this.inaccessibleEncryptionDateTime = inaccessibleEncryptionDateTime;
            return this;
        }

        @Override
        public SSEDescription build() {
            return new SSEDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
