/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Stream
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Stream> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamArn").getter(Stream.getter(Stream::streamArn)).setter(Stream.setter(Builder::streamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(Stream.getter(Stream::tableName)).setter(Stream.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> STREAM_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamLabel").getter(Stream.getter(Stream::streamLabel)).setter(Stream.setter(Builder::streamLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamLabel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD, TABLE_NAME_FIELD, STREAM_LABEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String streamArn;
    private final String tableName;
    private final String streamLabel;

    private Stream(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.tableName = builder.tableName;
        this.streamLabel = builder.streamLabel;
    }

    public final String streamArn() {
        return this.streamArn;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String streamLabel() {
        return this.streamLabel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamLabel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stream)) {
            return false;
        }
        Stream other = (Stream)obj;
        return Objects.equals(this.streamArn(), other.streamArn()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.streamLabel(), other.streamLabel());
    }

    public final String toString() {
        return ToString.builder((String)"Stream").add("StreamArn", (Object)this.streamArn()).add("TableName", (Object)this.tableName()).add("StreamLabel", (Object)this.streamLabel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamArn": {
                return Optional.ofNullable(clazz.cast(this.streamArn()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "StreamLabel": {
                return Optional.ofNullable(clazz.cast(this.streamLabel()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Stream, T> g) {
        return obj -> g.apply((Stream)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamArn;
        private String tableName;
        private String streamLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(Stream model) {
            this.streamArn(model.streamArn);
            this.tableName(model.tableName);
            this.streamLabel(model.streamLabel);
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getStreamLabel() {
            return this.streamLabel;
        }

        @Override
        public final Builder streamLabel(String streamLabel) {
            this.streamLabel = streamLabel;
            return this;
        }

        public final void setStreamLabel(String streamLabel) {
            this.streamLabel = streamLabel;
        }

        public Stream build() {
            return new Stream(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Stream> {
        public Builder streamArn(String var1);

        public Builder tableName(String var1);

        public Builder streamLabel(String var1);
    }
}

