/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.Identity;
import software.amazon.awssdk.services.dynamodb.model.OperationType;
import software.amazon.awssdk.services.dynamodb.model.StreamRecord;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Record
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Record> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventID").getter(Record.getter(Record::eventID)).setter(Record.setter(Builder::eventID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventID").build()}).build();
    private static final SdkField<String> EVENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventName").getter(Record.getter(Record::eventNameAsString)).setter(Record.setter(Builder::eventName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventName").build()}).build();
    private static final SdkField<String> EVENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventVersion").getter(Record.getter(Record::eventVersion)).setter(Record.setter(Builder::eventVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventVersion").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventSource").getter(Record.getter(Record::eventSource)).setter(Record.setter(Builder::eventSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventSource").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsRegion").getter(Record.getter(Record::awsRegion)).setter(Record.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsRegion").build()}).build();
    private static final SdkField<StreamRecord> DYNAMODB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dynamodb").getter(Record.getter(Record::dynamodb)).setter(Record.setter(Builder::dynamodb)).constructor(StreamRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamodb").build()}).build();
    private static final SdkField<Identity> USER_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("userIdentity").getter(Record.getter(Record::userIdentity)).setter(Record.setter(Builder::userIdentity)).constructor(Identity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userIdentity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, EVENT_NAME_FIELD, EVENT_VERSION_FIELD, EVENT_SOURCE_FIELD, AWS_REGION_FIELD, DYNAMODB_FIELD, USER_IDENTITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eventID;
    private final String eventName;
    private final String eventVersion;
    private final String eventSource;
    private final String awsRegion;
    private final StreamRecord dynamodb;
    private final Identity userIdentity;

    private Record(BuilderImpl builder) {
        this.eventID = builder.eventID;
        this.eventName = builder.eventName;
        this.eventVersion = builder.eventVersion;
        this.eventSource = builder.eventSource;
        this.awsRegion = builder.awsRegion;
        this.dynamodb = builder.dynamodb;
        this.userIdentity = builder.userIdentity;
    }

    public String eventID() {
        return this.eventID;
    }

    public OperationType eventName() {
        return OperationType.fromValue(this.eventName);
    }

    public String eventNameAsString() {
        return this.eventName;
    }

    public String eventVersion() {
        return this.eventVersion;
    }

    public String eventSource() {
        return this.eventSource;
    }

    public String awsRegion() {
        return this.awsRegion;
    }

    public StreamRecord dynamodb() {
        return this.dynamodb;
    }

    public Identity userIdentity() {
        return this.userIdentity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventID());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamodb());
        hashCode = 31 * hashCode + Objects.hashCode(this.userIdentity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record)obj;
        return Objects.equals(this.eventID(), other.eventID()) && Objects.equals(this.eventNameAsString(), other.eventNameAsString()) && Objects.equals(this.eventVersion(), other.eventVersion()) && Objects.equals(this.eventSource(), other.eventSource()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.dynamodb(), other.dynamodb()) && Objects.equals(this.userIdentity(), other.userIdentity());
    }

    public String toString() {
        return ToString.builder((String)"Record").add("EventID", (Object)this.eventID()).add("EventName", (Object)this.eventNameAsString()).add("EventVersion", (Object)this.eventVersion()).add("EventSource", (Object)this.eventSource()).add("AwsRegion", (Object)this.awsRegion()).add("Dynamodb", (Object)this.dynamodb()).add("UserIdentity", (Object)this.userIdentity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventID": {
                return Optional.ofNullable(clazz.cast(this.eventID()));
            }
            case "eventName": {
                return Optional.ofNullable(clazz.cast(this.eventNameAsString()));
            }
            case "eventVersion": {
                return Optional.ofNullable(clazz.cast(this.eventVersion()));
            }
            case "eventSource": {
                return Optional.ofNullable(clazz.cast(this.eventSource()));
            }
            case "awsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
            case "dynamodb": {
                return Optional.ofNullable(clazz.cast(this.dynamodb()));
            }
            case "userIdentity": {
                return Optional.ofNullable(clazz.cast(this.userIdentity()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Record, T> g) {
        return obj -> g.apply((Record)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventID;
        private String eventName;
        private String eventVersion;
        private String eventSource;
        private String awsRegion;
        private StreamRecord dynamodb;
        private Identity userIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(Record model) {
            this.eventID(model.eventID);
            this.eventName(model.eventName);
            this.eventVersion(model.eventVersion);
            this.eventSource(model.eventSource);
            this.awsRegion(model.awsRegion);
            this.dynamodb(model.dynamodb);
            this.userIdentity(model.userIdentity);
        }

        public final String getEventID() {
            return this.eventID;
        }

        @Override
        public final Builder eventID(String eventID) {
            this.eventID = eventID;
            return this;
        }

        public final void setEventID(String eventID) {
            this.eventID = eventID;
        }

        public final String getEventName() {
            return this.eventName;
        }

        @Override
        public final Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        @Override
        public final Builder eventName(OperationType eventName) {
            this.eventName(eventName == null ? null : eventName.toString());
            return this;
        }

        public final void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public final String getEventVersion() {
            return this.eventVersion;
        }

        @Override
        public final Builder eventVersion(String eventVersion) {
            this.eventVersion = eventVersion;
            return this;
        }

        public final void setEventVersion(String eventVersion) {
            this.eventVersion = eventVersion;
        }

        public final String getEventSource() {
            return this.eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final StreamRecord.Builder getDynamodb() {
            return this.dynamodb != null ? this.dynamodb.toBuilder() : null;
        }

        @Override
        public final Builder dynamodb(StreamRecord dynamodb) {
            this.dynamodb = dynamodb;
            return this;
        }

        public final void setDynamodb(StreamRecord.BuilderImpl dynamodb) {
            this.dynamodb = dynamodb != null ? dynamodb.build() : null;
        }

        public final Identity.Builder getUserIdentity() {
            return this.userIdentity != null ? this.userIdentity.toBuilder() : null;
        }

        @Override
        public final Builder userIdentity(Identity userIdentity) {
            this.userIdentity = userIdentity;
            return this;
        }

        public final void setUserIdentity(Identity.BuilderImpl userIdentity) {
            this.userIdentity = userIdentity != null ? userIdentity.build() : null;
        }

        public Record build() {
            return new Record(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Record> {
        public Builder eventID(String var1);

        public Builder eventName(String var1);

        public Builder eventName(OperationType var1);

        public Builder eventVersion(String var1);

        public Builder eventSource(String var1);

        public Builder awsRegion(String var1);

        public Builder dynamodb(StreamRecord var1);

        default public Builder dynamodb(Consumer<StreamRecord.Builder> dynamodb) {
            return this.dynamodb((StreamRecord)((StreamRecord.Builder)StreamRecord.builder().applyMutation(dynamodb)).build());
        }

        public Builder userIdentity(Identity var1);

        default public Builder userIdentity(Consumer<Identity.Builder> userIdentity) {
            return this.userIdentity((Identity)((Identity.Builder)Identity.builder().applyMutation(userIdentity)).build());
        }
    }
}

