/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeNameListCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeNameMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeValueMapCopier;
import software.amazon.awssdk.services.dynamodb.model.FilterConditionMapCopier;
import software.amazon.awssdk.services.dynamodb.model.KeyConditionsCopier;
import software.amazon.awssdk.services.dynamodb.model.KeyCopier;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.Select;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, QueryRequest> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryRequest.getter(QueryRequest::tableName)).setter(QueryRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryRequest.getter(QueryRequest::indexName)).setter(QueryRequest.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<String> SELECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryRequest.getter(QueryRequest::selectAsString)).setter(QueryRequest.setter(Builder::select)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Select").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTES_TO_GET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(QueryRequest.getter(QueryRequest::attributesToGet)).setter(QueryRequest.setter(Builder::attributesToGet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToGet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(QueryRequest.getter(QueryRequest::limit)).setter(QueryRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<Boolean> CONSISTENT_READ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(QueryRequest.getter(QueryRequest::consistentRead)).setter(QueryRequest.setter(Builder::consistentRead)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsistentRead").build()}).build();
    private static final SdkField<Map<String, Condition>> KEY_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(QueryRequest.getter(QueryRequest::keyConditions)).setter(QueryRequest.setter(Builder::keyConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyConditions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Condition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Condition>> QUERY_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(QueryRequest.getter(QueryRequest::queryFilter)).setter(QueryRequest.setter(Builder::queryFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryFilter").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Condition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CONDITIONAL_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryRequest.getter(QueryRequest::conditionalOperatorAsString)).setter(QueryRequest.setter(Builder::conditionalOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionalOperator").build()}).build();
    private static final SdkField<Boolean> SCAN_INDEX_FORWARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(QueryRequest.getter(QueryRequest::scanIndexForward)).setter(QueryRequest.setter(Builder::scanIndexForward)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanIndexForward").build()}).build();
    private static final SdkField<Map<String, AttributeValue>> EXCLUSIVE_START_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(QueryRequest.getter(QueryRequest::exclusiveStartKey)).setter(QueryRequest.setter(Builder::exclusiveStartKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartKey").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RETURN_CONSUMED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryRequest.getter(QueryRequest::returnConsumedCapacityAsString)).setter(QueryRequest.setter(Builder::returnConsumedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnConsumedCapacity").build()}).build();
    private static final SdkField<String> PROJECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryRequest.getter(QueryRequest::projectionExpression)).setter(QueryRequest.setter(Builder::projectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectionExpression").build()}).build();
    private static final SdkField<String> FILTER_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryRequest.getter(QueryRequest::filterExpression)).setter(QueryRequest.setter(Builder::filterExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterExpression").build()}).build();
    private static final SdkField<String> KEY_CONDITION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryRequest.getter(QueryRequest::keyConditionExpression)).setter(QueryRequest.setter(Builder::keyConditionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyConditionExpression").build()}).build();
    private static final SdkField<Map<String, String>> EXPRESSION_ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(QueryRequest.getter(QueryRequest::expressionAttributeNames)).setter(QueryRequest.setter(Builder::expressionAttributeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeNames").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, AttributeValue>> EXPRESSION_ATTRIBUTE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(QueryRequest.getter(QueryRequest::expressionAttributeValues)).setter(QueryRequest.setter(Builder::expressionAttributeValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeValues").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, INDEX_NAME_FIELD, SELECT_FIELD, ATTRIBUTES_TO_GET_FIELD, LIMIT_FIELD, CONSISTENT_READ_FIELD, KEY_CONDITIONS_FIELD, QUERY_FILTER_FIELD, CONDITIONAL_OPERATOR_FIELD, SCAN_INDEX_FORWARD_FIELD, EXCLUSIVE_START_KEY_FIELD, RETURN_CONSUMED_CAPACITY_FIELD, PROJECTION_EXPRESSION_FIELD, FILTER_EXPRESSION_FIELD, KEY_CONDITION_EXPRESSION_FIELD, EXPRESSION_ATTRIBUTE_NAMES_FIELD, EXPRESSION_ATTRIBUTE_VALUES_FIELD));
    private final String tableName;
    private final String indexName;
    private final String select;
    private final List<String> attributesToGet;
    private final Integer limit;
    private final Boolean consistentRead;
    private final Map<String, Condition> keyConditions;
    private final Map<String, Condition> queryFilter;
    private final String conditionalOperator;
    private final Boolean scanIndexForward;
    private final Map<String, AttributeValue> exclusiveStartKey;
    private final String returnConsumedCapacity;
    private final String projectionExpression;
    private final String filterExpression;
    private final String keyConditionExpression;
    private final Map<String, String> expressionAttributeNames;
    private final Map<String, AttributeValue> expressionAttributeValues;

    private QueryRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.indexName = builder.indexName;
        this.select = builder.select;
        this.attributesToGet = builder.attributesToGet;
        this.limit = builder.limit;
        this.consistentRead = builder.consistentRead;
        this.keyConditions = builder.keyConditions;
        this.queryFilter = builder.queryFilter;
        this.conditionalOperator = builder.conditionalOperator;
        this.scanIndexForward = builder.scanIndexForward;
        this.exclusiveStartKey = builder.exclusiveStartKey;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.projectionExpression = builder.projectionExpression;
        this.filterExpression = builder.filterExpression;
        this.keyConditionExpression = builder.keyConditionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
    }

    public String tableName() {
        return this.tableName;
    }

    public String indexName() {
        return this.indexName;
    }

    public Select select() {
        return Select.fromValue(this.select);
    }

    public String selectAsString() {
        return this.select;
    }

    public boolean hasAttributesToGet() {
        return this.attributesToGet != null && !(this.attributesToGet instanceof SdkAutoConstructList);
    }

    public List<String> attributesToGet() {
        return this.attributesToGet;
    }

    public Integer limit() {
        return this.limit;
    }

    public Boolean consistentRead() {
        return this.consistentRead;
    }

    public boolean hasKeyConditions() {
        return this.keyConditions != null && !(this.keyConditions instanceof SdkAutoConstructMap);
    }

    public Map<String, Condition> keyConditions() {
        return this.keyConditions;
    }

    public boolean hasQueryFilter() {
        return this.queryFilter != null && !(this.queryFilter instanceof SdkAutoConstructMap);
    }

    public Map<String, Condition> queryFilter() {
        return this.queryFilter;
    }

    public ConditionalOperator conditionalOperator() {
        return ConditionalOperator.fromValue(this.conditionalOperator);
    }

    public String conditionalOperatorAsString() {
        return this.conditionalOperator;
    }

    public Boolean scanIndexForward() {
        return this.scanIndexForward;
    }

    public boolean hasExclusiveStartKey() {
        return this.exclusiveStartKey != null && !(this.exclusiveStartKey instanceof SdkAutoConstructMap);
    }

    public Map<String, AttributeValue> exclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(this.returnConsumedCapacity);
    }

    public String returnConsumedCapacityAsString() {
        return this.returnConsumedCapacity;
    }

    public String projectionExpression() {
        return this.projectionExpression;
    }

    public String filterExpression() {
        return this.filterExpression;
    }

    public String keyConditionExpression() {
        return this.keyConditionExpression;
    }

    public boolean hasExpressionAttributeNames() {
        return this.expressionAttributeNames != null && !(this.expressionAttributeNames instanceof SdkAutoConstructMap);
    }

    public Map<String, String> expressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public boolean hasExpressionAttributeValues() {
        return this.expressionAttributeValues != null && !(this.expressionAttributeValues instanceof SdkAutoConstructMap);
    }

    public Map<String, AttributeValue> expressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesToGet());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.consistentRead());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyConditions());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionalOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanIndexForward());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnConsumedCapacityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyConditionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionAttributeNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionAttributeValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRequest)) {
            return false;
        }
        QueryRequest other = (QueryRequest)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.selectAsString(), other.selectAsString()) && Objects.equals(this.attributesToGet(), other.attributesToGet()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.consistentRead(), other.consistentRead()) && Objects.equals(this.keyConditions(), other.keyConditions()) && Objects.equals(this.queryFilter(), other.queryFilter()) && Objects.equals(this.conditionalOperatorAsString(), other.conditionalOperatorAsString()) && Objects.equals(this.scanIndexForward(), other.scanIndexForward()) && Objects.equals(this.exclusiveStartKey(), other.exclusiveStartKey()) && Objects.equals(this.returnConsumedCapacityAsString(), other.returnConsumedCapacityAsString()) && Objects.equals(this.projectionExpression(), other.projectionExpression()) && Objects.equals(this.filterExpression(), other.filterExpression()) && Objects.equals(this.keyConditionExpression(), other.keyConditionExpression()) && Objects.equals(this.expressionAttributeNames(), other.expressionAttributeNames()) && Objects.equals(this.expressionAttributeValues(), other.expressionAttributeValues());
    }

    public String toString() {
        return ToString.builder((String)"QueryRequest").add("TableName", (Object)this.tableName()).add("IndexName", (Object)this.indexName()).add("Select", (Object)this.selectAsString()).add("AttributesToGet", this.attributesToGet()).add("Limit", (Object)this.limit()).add("ConsistentRead", (Object)this.consistentRead()).add("KeyConditions", this.keyConditions()).add("QueryFilter", this.queryFilter()).add("ConditionalOperator", (Object)this.conditionalOperatorAsString()).add("ScanIndexForward", (Object)this.scanIndexForward()).add("ExclusiveStartKey", this.exclusiveStartKey()).add("ReturnConsumedCapacity", (Object)this.returnConsumedCapacityAsString()).add("ProjectionExpression", (Object)this.projectionExpression()).add("FilterExpression", (Object)this.filterExpression()).add("KeyConditionExpression", (Object)this.keyConditionExpression()).add("ExpressionAttributeNames", this.expressionAttributeNames()).add("ExpressionAttributeValues", this.expressionAttributeValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "Select": {
                return Optional.ofNullable(clazz.cast(this.selectAsString()));
            }
            case "AttributesToGet": {
                return Optional.ofNullable(clazz.cast(this.attributesToGet()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "ConsistentRead": {
                return Optional.ofNullable(clazz.cast(this.consistentRead()));
            }
            case "KeyConditions": {
                return Optional.ofNullable(clazz.cast(this.keyConditions()));
            }
            case "QueryFilter": {
                return Optional.ofNullable(clazz.cast(this.queryFilter()));
            }
            case "ConditionalOperator": {
                return Optional.ofNullable(clazz.cast(this.conditionalOperatorAsString()));
            }
            case "ScanIndexForward": {
                return Optional.ofNullable(clazz.cast(this.scanIndexForward()));
            }
            case "ExclusiveStartKey": {
                return Optional.ofNullable(clazz.cast(this.exclusiveStartKey()));
            }
            case "ReturnConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.returnConsumedCapacityAsString()));
            }
            case "ProjectionExpression": {
                return Optional.ofNullable(clazz.cast(this.projectionExpression()));
            }
            case "FilterExpression": {
                return Optional.ofNullable(clazz.cast(this.filterExpression()));
            }
            case "KeyConditionExpression": {
                return Optional.ofNullable(clazz.cast(this.keyConditionExpression()));
            }
            case "ExpressionAttributeNames": {
                return Optional.ofNullable(clazz.cast(this.expressionAttributeNames()));
            }
            case "ExpressionAttributeValues": {
                return Optional.ofNullable(clazz.cast(this.expressionAttributeValues()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryRequest, T> g) {
        return obj -> g.apply((QueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String tableName;
        private String indexName;
        private String select;
        private List<String> attributesToGet = DefaultSdkAutoConstructList.getInstance();
        private Integer limit;
        private Boolean consistentRead;
        private Map<String, Condition> keyConditions = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Condition> queryFilter = DefaultSdkAutoConstructMap.getInstance();
        private String conditionalOperator;
        private Boolean scanIndexForward;
        private Map<String, AttributeValue> exclusiveStartKey = DefaultSdkAutoConstructMap.getInstance();
        private String returnConsumedCapacity;
        private String projectionExpression;
        private String filterExpression;
        private String keyConditionExpression;
        private Map<String, String> expressionAttributeNames = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, AttributeValue> expressionAttributeValues = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryRequest model) {
            super(model);
            this.tableName(model.tableName);
            this.indexName(model.indexName);
            this.select(model.select);
            this.attributesToGet(model.attributesToGet);
            this.limit(model.limit);
            this.consistentRead(model.consistentRead);
            this.keyConditions(model.keyConditions);
            this.queryFilter(model.queryFilter);
            this.conditionalOperator(model.conditionalOperator);
            this.scanIndexForward(model.scanIndexForward);
            this.exclusiveStartKey(model.exclusiveStartKey);
            this.returnConsumedCapacity(model.returnConsumedCapacity);
            this.projectionExpression(model.projectionExpression);
            this.filterExpression(model.filterExpression);
            this.keyConditionExpression(model.keyConditionExpression);
            this.expressionAttributeNames(model.expressionAttributeNames);
            this.expressionAttributeValues(model.expressionAttributeValues);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getSelectAsString() {
            return this.select;
        }

        @Override
        public final Builder select(String select) {
            this.select = select;
            return this;
        }

        @Override
        public final Builder select(Select select) {
            this.select(select == null ? null : select.toString());
            return this;
        }

        public final void setSelect(String select) {
            this.select = select;
        }

        public final Collection<String> getAttributesToGet() {
            return this.attributesToGet;
        }

        @Override
        public final Builder attributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(String ... attributesToGet) {
            this.attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final Boolean getConsistentRead() {
            return this.consistentRead;
        }

        @Override
        public final Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public final void setConsistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
        }

        public final Map<String, Condition.Builder> getKeyConditions() {
            return this.keyConditions != null ? CollectionUtils.mapValues(this.keyConditions, Condition::toBuilder) : null;
        }

        @Override
        public final Builder keyConditions(Map<String, Condition> keyConditions) {
            this.keyConditions = KeyConditionsCopier.copy(keyConditions);
            return this;
        }

        public final void setKeyConditions(Map<String, Condition.BuilderImpl> keyConditions) {
            this.keyConditions = KeyConditionsCopier.copyFromBuilder(keyConditions);
        }

        public final Map<String, Condition.Builder> getQueryFilter() {
            return this.queryFilter != null ? CollectionUtils.mapValues(this.queryFilter, Condition::toBuilder) : null;
        }

        @Override
        public final Builder queryFilter(Map<String, Condition> queryFilter) {
            this.queryFilter = FilterConditionMapCopier.copy(queryFilter);
            return this;
        }

        public final void setQueryFilter(Map<String, Condition.BuilderImpl> queryFilter) {
            this.queryFilter = FilterConditionMapCopier.copyFromBuilder(queryFilter);
        }

        public final String getConditionalOperatorAsString() {
            return this.conditionalOperator;
        }

        @Override
        public final Builder conditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
            return this;
        }

        @Override
        public final Builder conditionalOperator(ConditionalOperator conditionalOperator) {
            this.conditionalOperator(conditionalOperator == null ? null : conditionalOperator.toString());
            return this;
        }

        public final void setConditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
        }

        public final Boolean getScanIndexForward() {
            return this.scanIndexForward;
        }

        @Override
        public final Builder scanIndexForward(Boolean scanIndexForward) {
            this.scanIndexForward = scanIndexForward;
            return this;
        }

        public final void setScanIndexForward(Boolean scanIndexForward) {
            this.scanIndexForward = scanIndexForward;
        }

        public final Map<String, AttributeValue.Builder> getExclusiveStartKey() {
            return this.exclusiveStartKey != null ? CollectionUtils.mapValues(this.exclusiveStartKey, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder exclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
            this.exclusiveStartKey = KeyCopier.copy(exclusiveStartKey);
            return this;
        }

        public final void setExclusiveStartKey(Map<String, AttributeValue.BuilderImpl> exclusiveStartKey) {
            this.exclusiveStartKey = KeyCopier.copyFromBuilder(exclusiveStartKey);
        }

        public final String getReturnConsumedCapacityAsString() {
            return this.returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity == null ? null : returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final String getProjectionExpression() {
            return this.projectionExpression;
        }

        @Override
        public final Builder projectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
            return this;
        }

        public final void setProjectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
        }

        public final String getFilterExpression() {
            return this.filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        public final String getKeyConditionExpression() {
            return this.keyConditionExpression;
        }

        @Override
        public final Builder keyConditionExpression(String keyConditionExpression) {
            this.keyConditionExpression = keyConditionExpression;
            return this;
        }

        public final void setKeyConditionExpression(String keyConditionExpression) {
            this.keyConditionExpression = keyConditionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return this.expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public final Map<String, AttributeValue.Builder> getExpressionAttributeValues() {
            return this.expressionAttributeValues != null ? CollectionUtils.mapValues(this.expressionAttributeValues, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue.BuilderImpl> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copyFromBuilder(expressionAttributeValues);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QueryRequest build() {
            return new QueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, QueryRequest> {
        public Builder tableName(String var1);

        public Builder indexName(String var1);

        public Builder select(String var1);

        public Builder select(Select var1);

        public Builder attributesToGet(Collection<String> var1);

        public Builder attributesToGet(String ... var1);

        public Builder limit(Integer var1);

        public Builder consistentRead(Boolean var1);

        public Builder keyConditions(Map<String, Condition> var1);

        public Builder queryFilter(Map<String, Condition> var1);

        public Builder conditionalOperator(String var1);

        public Builder conditionalOperator(ConditionalOperator var1);

        public Builder scanIndexForward(Boolean var1);

        public Builder exclusiveStartKey(Map<String, AttributeValue> var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);

        public Builder projectionExpression(String var1);

        public Builder filterExpression(String var1);

        public Builder keyConditionExpression(String var1);

        public Builder expressionAttributeNames(Map<String, String> var1);

        public Builder expressionAttributeValues(Map<String, AttributeValue> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

