/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsDescription;
import software.amazon.awssdk.services.dynamodb.model.BillingModeSummary;
import software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription;
import software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescriptionListCopier;
import software.amazon.awssdk.services.dynamodb.model.ReplicaStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicaSettingsDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicaSettingsDescription> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplicaSettingsDescription.getter(ReplicaSettingsDescription::regionName)).setter(ReplicaSettingsDescription.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()}).build();
    private static final SdkField<String> REPLICA_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReplicaSettingsDescription.getter(ReplicaSettingsDescription::replicaStatusAsString)).setter(ReplicaSettingsDescription.setter(Builder::replicaStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaStatus").build()}).build();
    private static final SdkField<BillingModeSummary> REPLICA_BILLING_MODE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ReplicaSettingsDescription.getter(ReplicaSettingsDescription::replicaBillingModeSummary)).setter(ReplicaSettingsDescription.setter(Builder::replicaBillingModeSummary)).constructor(BillingModeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaBillingModeSummary").build()}).build();
    private static final SdkField<Long> REPLICA_PROVISIONED_READ_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(ReplicaSettingsDescription.getter(ReplicaSettingsDescription::replicaProvisionedReadCapacityUnits)).setter(ReplicaSettingsDescription.setter(Builder::replicaProvisionedReadCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaProvisionedReadCapacityUnits").build()}).build();
    private static final SdkField<AutoScalingSettingsDescription> REPLICA_PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ReplicaSettingsDescription.getter(ReplicaSettingsDescription::replicaProvisionedReadCapacityAutoScalingSettings)).setter(ReplicaSettingsDescription.setter(Builder::replicaProvisionedReadCapacityAutoScalingSettings)).constructor(AutoScalingSettingsDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaProvisionedReadCapacityAutoScalingSettings").build()}).build();
    private static final SdkField<Long> REPLICA_PROVISIONED_WRITE_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(ReplicaSettingsDescription.getter(ReplicaSettingsDescription::replicaProvisionedWriteCapacityUnits)).setter(ReplicaSettingsDescription.setter(Builder::replicaProvisionedWriteCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaProvisionedWriteCapacityUnits").build()}).build();
    private static final SdkField<AutoScalingSettingsDescription> REPLICA_PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ReplicaSettingsDescription.getter(ReplicaSettingsDescription::replicaProvisionedWriteCapacityAutoScalingSettings)).setter(ReplicaSettingsDescription.setter(Builder::replicaProvisionedWriteCapacityAutoScalingSettings)).constructor(AutoScalingSettingsDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaProvisionedWriteCapacityAutoScalingSettings").build()}).build();
    private static final SdkField<List<ReplicaGlobalSecondaryIndexSettingsDescription>> REPLICA_GLOBAL_SECONDARY_INDEX_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ReplicaSettingsDescription.getter(ReplicaSettingsDescription::replicaGlobalSecondaryIndexSettings)).setter(ReplicaSettingsDescription.setter(Builder::replicaGlobalSecondaryIndexSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaGlobalSecondaryIndexSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicaGlobalSecondaryIndexSettingsDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD, REPLICA_STATUS_FIELD, REPLICA_BILLING_MODE_SUMMARY_FIELD, REPLICA_PROVISIONED_READ_CAPACITY_UNITS_FIELD, REPLICA_PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_FIELD, REPLICA_PROVISIONED_WRITE_CAPACITY_UNITS_FIELD, REPLICA_PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_SETTINGS_FIELD, REPLICA_GLOBAL_SECONDARY_INDEX_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String regionName;
    private final String replicaStatus;
    private final BillingModeSummary replicaBillingModeSummary;
    private final Long replicaProvisionedReadCapacityUnits;
    private final AutoScalingSettingsDescription replicaProvisionedReadCapacityAutoScalingSettings;
    private final Long replicaProvisionedWriteCapacityUnits;
    private final AutoScalingSettingsDescription replicaProvisionedWriteCapacityAutoScalingSettings;
    private final List<ReplicaGlobalSecondaryIndexSettingsDescription> replicaGlobalSecondaryIndexSettings;

    private ReplicaSettingsDescription(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.replicaStatus = builder.replicaStatus;
        this.replicaBillingModeSummary = builder.replicaBillingModeSummary;
        this.replicaProvisionedReadCapacityUnits = builder.replicaProvisionedReadCapacityUnits;
        this.replicaProvisionedReadCapacityAutoScalingSettings = builder.replicaProvisionedReadCapacityAutoScalingSettings;
        this.replicaProvisionedWriteCapacityUnits = builder.replicaProvisionedWriteCapacityUnits;
        this.replicaProvisionedWriteCapacityAutoScalingSettings = builder.replicaProvisionedWriteCapacityAutoScalingSettings;
        this.replicaGlobalSecondaryIndexSettings = builder.replicaGlobalSecondaryIndexSettings;
    }

    public String regionName() {
        return this.regionName;
    }

    public ReplicaStatus replicaStatus() {
        return ReplicaStatus.fromValue(this.replicaStatus);
    }

    public String replicaStatusAsString() {
        return this.replicaStatus;
    }

    public BillingModeSummary replicaBillingModeSummary() {
        return this.replicaBillingModeSummary;
    }

    public Long replicaProvisionedReadCapacityUnits() {
        return this.replicaProvisionedReadCapacityUnits;
    }

    public AutoScalingSettingsDescription replicaProvisionedReadCapacityAutoScalingSettings() {
        return this.replicaProvisionedReadCapacityAutoScalingSettings;
    }

    public Long replicaProvisionedWriteCapacityUnits() {
        return this.replicaProvisionedWriteCapacityUnits;
    }

    public AutoScalingSettingsDescription replicaProvisionedWriteCapacityAutoScalingSettings() {
        return this.replicaProvisionedWriteCapacityAutoScalingSettings;
    }

    public boolean hasReplicaGlobalSecondaryIndexSettings() {
        return this.replicaGlobalSecondaryIndexSettings != null && !(this.replicaGlobalSecondaryIndexSettings instanceof SdkAutoConstructList);
    }

    public List<ReplicaGlobalSecondaryIndexSettingsDescription> replicaGlobalSecondaryIndexSettings() {
        return this.replicaGlobalSecondaryIndexSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaBillingModeSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaProvisionedReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaProvisionedReadCapacityAutoScalingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaProvisionedWriteCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaProvisionedWriteCapacityAutoScalingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaGlobalSecondaryIndexSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaSettingsDescription)) {
            return false;
        }
        ReplicaSettingsDescription other = (ReplicaSettingsDescription)obj;
        return Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.replicaStatusAsString(), other.replicaStatusAsString()) && Objects.equals(this.replicaBillingModeSummary(), other.replicaBillingModeSummary()) && Objects.equals(this.replicaProvisionedReadCapacityUnits(), other.replicaProvisionedReadCapacityUnits()) && Objects.equals(this.replicaProvisionedReadCapacityAutoScalingSettings(), other.replicaProvisionedReadCapacityAutoScalingSettings()) && Objects.equals(this.replicaProvisionedWriteCapacityUnits(), other.replicaProvisionedWriteCapacityUnits()) && Objects.equals(this.replicaProvisionedWriteCapacityAutoScalingSettings(), other.replicaProvisionedWriteCapacityAutoScalingSettings()) && Objects.equals(this.replicaGlobalSecondaryIndexSettings(), other.replicaGlobalSecondaryIndexSettings());
    }

    public String toString() {
        return ToString.builder((String)"ReplicaSettingsDescription").add("RegionName", (Object)this.regionName()).add("ReplicaStatus", (Object)this.replicaStatusAsString()).add("ReplicaBillingModeSummary", (Object)this.replicaBillingModeSummary()).add("ReplicaProvisionedReadCapacityUnits", (Object)this.replicaProvisionedReadCapacityUnits()).add("ReplicaProvisionedReadCapacityAutoScalingSettings", (Object)this.replicaProvisionedReadCapacityAutoScalingSettings()).add("ReplicaProvisionedWriteCapacityUnits", (Object)this.replicaProvisionedWriteCapacityUnits()).add("ReplicaProvisionedWriteCapacityAutoScalingSettings", (Object)this.replicaProvisionedWriteCapacityAutoScalingSettings()).add("ReplicaGlobalSecondaryIndexSettings", this.replicaGlobalSecondaryIndexSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "ReplicaStatus": {
                return Optional.ofNullable(clazz.cast(this.replicaStatusAsString()));
            }
            case "ReplicaBillingModeSummary": {
                return Optional.ofNullable(clazz.cast(this.replicaBillingModeSummary()));
            }
            case "ReplicaProvisionedReadCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.replicaProvisionedReadCapacityUnits()));
            }
            case "ReplicaProvisionedReadCapacityAutoScalingSettings": {
                return Optional.ofNullable(clazz.cast(this.replicaProvisionedReadCapacityAutoScalingSettings()));
            }
            case "ReplicaProvisionedWriteCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.replicaProvisionedWriteCapacityUnits()));
            }
            case "ReplicaProvisionedWriteCapacityAutoScalingSettings": {
                return Optional.ofNullable(clazz.cast(this.replicaProvisionedWriteCapacityAutoScalingSettings()));
            }
            case "ReplicaGlobalSecondaryIndexSettings": {
                return Optional.ofNullable(clazz.cast(this.replicaGlobalSecondaryIndexSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicaSettingsDescription, T> g) {
        return obj -> g.apply((ReplicaSettingsDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String regionName;
        private String replicaStatus;
        private BillingModeSummary replicaBillingModeSummary;
        private Long replicaProvisionedReadCapacityUnits;
        private AutoScalingSettingsDescription replicaProvisionedReadCapacityAutoScalingSettings;
        private Long replicaProvisionedWriteCapacityUnits;
        private AutoScalingSettingsDescription replicaProvisionedWriteCapacityAutoScalingSettings;
        private List<ReplicaGlobalSecondaryIndexSettingsDescription> replicaGlobalSecondaryIndexSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaSettingsDescription model) {
            this.regionName(model.regionName);
            this.replicaStatus(model.replicaStatus);
            this.replicaBillingModeSummary(model.replicaBillingModeSummary);
            this.replicaProvisionedReadCapacityUnits(model.replicaProvisionedReadCapacityUnits);
            this.replicaProvisionedReadCapacityAutoScalingSettings(model.replicaProvisionedReadCapacityAutoScalingSettings);
            this.replicaProvisionedWriteCapacityUnits(model.replicaProvisionedWriteCapacityUnits);
            this.replicaProvisionedWriteCapacityAutoScalingSettings(model.replicaProvisionedWriteCapacityAutoScalingSettings);
            this.replicaGlobalSecondaryIndexSettings(model.replicaGlobalSecondaryIndexSettings);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final String getReplicaStatusAsString() {
            return this.replicaStatus;
        }

        @Override
        public final Builder replicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
            return this;
        }

        @Override
        public final Builder replicaStatus(ReplicaStatus replicaStatus) {
            this.replicaStatus(replicaStatus == null ? null : replicaStatus.toString());
            return this;
        }

        public final void setReplicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
        }

        public final BillingModeSummary.Builder getReplicaBillingModeSummary() {
            return this.replicaBillingModeSummary != null ? this.replicaBillingModeSummary.toBuilder() : null;
        }

        @Override
        public final Builder replicaBillingModeSummary(BillingModeSummary replicaBillingModeSummary) {
            this.replicaBillingModeSummary = replicaBillingModeSummary;
            return this;
        }

        public final void setReplicaBillingModeSummary(BillingModeSummary.BuilderImpl replicaBillingModeSummary) {
            this.replicaBillingModeSummary = replicaBillingModeSummary != null ? replicaBillingModeSummary.build() : null;
        }

        public final Long getReplicaProvisionedReadCapacityUnits() {
            return this.replicaProvisionedReadCapacityUnits;
        }

        @Override
        public final Builder replicaProvisionedReadCapacityUnits(Long replicaProvisionedReadCapacityUnits) {
            this.replicaProvisionedReadCapacityUnits = replicaProvisionedReadCapacityUnits;
            return this;
        }

        public final void setReplicaProvisionedReadCapacityUnits(Long replicaProvisionedReadCapacityUnits) {
            this.replicaProvisionedReadCapacityUnits = replicaProvisionedReadCapacityUnits;
        }

        public final AutoScalingSettingsDescription.Builder getReplicaProvisionedReadCapacityAutoScalingSettings() {
            return this.replicaProvisionedReadCapacityAutoScalingSettings != null ? this.replicaProvisionedReadCapacityAutoScalingSettings.toBuilder() : null;
        }

        @Override
        public final Builder replicaProvisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescription replicaProvisionedReadCapacityAutoScalingSettings) {
            this.replicaProvisionedReadCapacityAutoScalingSettings = replicaProvisionedReadCapacityAutoScalingSettings;
            return this;
        }

        public final void setReplicaProvisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescription.BuilderImpl replicaProvisionedReadCapacityAutoScalingSettings) {
            this.replicaProvisionedReadCapacityAutoScalingSettings = replicaProvisionedReadCapacityAutoScalingSettings != null ? replicaProvisionedReadCapacityAutoScalingSettings.build() : null;
        }

        public final Long getReplicaProvisionedWriteCapacityUnits() {
            return this.replicaProvisionedWriteCapacityUnits;
        }

        @Override
        public final Builder replicaProvisionedWriteCapacityUnits(Long replicaProvisionedWriteCapacityUnits) {
            this.replicaProvisionedWriteCapacityUnits = replicaProvisionedWriteCapacityUnits;
            return this;
        }

        public final void setReplicaProvisionedWriteCapacityUnits(Long replicaProvisionedWriteCapacityUnits) {
            this.replicaProvisionedWriteCapacityUnits = replicaProvisionedWriteCapacityUnits;
        }

        public final AutoScalingSettingsDescription.Builder getReplicaProvisionedWriteCapacityAutoScalingSettings() {
            return this.replicaProvisionedWriteCapacityAutoScalingSettings != null ? this.replicaProvisionedWriteCapacityAutoScalingSettings.toBuilder() : null;
        }

        @Override
        public final Builder replicaProvisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescription replicaProvisionedWriteCapacityAutoScalingSettings) {
            this.replicaProvisionedWriteCapacityAutoScalingSettings = replicaProvisionedWriteCapacityAutoScalingSettings;
            return this;
        }

        public final void setReplicaProvisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescription.BuilderImpl replicaProvisionedWriteCapacityAutoScalingSettings) {
            this.replicaProvisionedWriteCapacityAutoScalingSettings = replicaProvisionedWriteCapacityAutoScalingSettings != null ? replicaProvisionedWriteCapacityAutoScalingSettings.build() : null;
        }

        public final Collection<ReplicaGlobalSecondaryIndexSettingsDescription.Builder> getReplicaGlobalSecondaryIndexSettings() {
            return this.replicaGlobalSecondaryIndexSettings != null ? (Collection)this.replicaGlobalSecondaryIndexSettings.stream().map(ReplicaGlobalSecondaryIndexSettingsDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicaGlobalSecondaryIndexSettings(Collection<ReplicaGlobalSecondaryIndexSettingsDescription> replicaGlobalSecondaryIndexSettings) {
            this.replicaGlobalSecondaryIndexSettings = ReplicaGlobalSecondaryIndexSettingsDescriptionListCopier.copy(replicaGlobalSecondaryIndexSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaGlobalSecondaryIndexSettings(ReplicaGlobalSecondaryIndexSettingsDescription ... replicaGlobalSecondaryIndexSettings) {
            this.replicaGlobalSecondaryIndexSettings(Arrays.asList(replicaGlobalSecondaryIndexSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaGlobalSecondaryIndexSettings(Consumer<ReplicaGlobalSecondaryIndexSettingsDescription.Builder> ... replicaGlobalSecondaryIndexSettings) {
            this.replicaGlobalSecondaryIndexSettings(Stream.of(replicaGlobalSecondaryIndexSettings).map(c -> (ReplicaGlobalSecondaryIndexSettingsDescription)((ReplicaGlobalSecondaryIndexSettingsDescription.Builder)ReplicaGlobalSecondaryIndexSettingsDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicaGlobalSecondaryIndexSettings(Collection<ReplicaGlobalSecondaryIndexSettingsDescription.BuilderImpl> replicaGlobalSecondaryIndexSettings) {
            this.replicaGlobalSecondaryIndexSettings = ReplicaGlobalSecondaryIndexSettingsDescriptionListCopier.copyFromBuilder(replicaGlobalSecondaryIndexSettings);
        }

        public ReplicaSettingsDescription build() {
            return new ReplicaSettingsDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicaSettingsDescription> {
        public Builder regionName(String var1);

        public Builder replicaStatus(String var1);

        public Builder replicaStatus(ReplicaStatus var1);

        public Builder replicaBillingModeSummary(BillingModeSummary var1);

        default public Builder replicaBillingModeSummary(Consumer<BillingModeSummary.Builder> replicaBillingModeSummary) {
            return this.replicaBillingModeSummary((BillingModeSummary)((BillingModeSummary.Builder)BillingModeSummary.builder().applyMutation(replicaBillingModeSummary)).build());
        }

        public Builder replicaProvisionedReadCapacityUnits(Long var1);

        public Builder replicaProvisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescription var1);

        default public Builder replicaProvisionedReadCapacityAutoScalingSettings(Consumer<AutoScalingSettingsDescription.Builder> replicaProvisionedReadCapacityAutoScalingSettings) {
            return this.replicaProvisionedReadCapacityAutoScalingSettings((AutoScalingSettingsDescription)((AutoScalingSettingsDescription.Builder)AutoScalingSettingsDescription.builder().applyMutation(replicaProvisionedReadCapacityAutoScalingSettings)).build());
        }

        public Builder replicaProvisionedWriteCapacityUnits(Long var1);

        public Builder replicaProvisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescription var1);

        default public Builder replicaProvisionedWriteCapacityAutoScalingSettings(Consumer<AutoScalingSettingsDescription.Builder> replicaProvisionedWriteCapacityAutoScalingSettings) {
            return this.replicaProvisionedWriteCapacityAutoScalingSettings((AutoScalingSettingsDescription)((AutoScalingSettingsDescription.Builder)AutoScalingSettingsDescription.builder().applyMutation(replicaProvisionedWriteCapacityAutoScalingSettings)).build());
        }

        public Builder replicaGlobalSecondaryIndexSettings(Collection<ReplicaGlobalSecondaryIndexSettingsDescription> var1);

        public Builder replicaGlobalSecondaryIndexSettings(ReplicaGlobalSecondaryIndexSettingsDescription ... var1);

        public Builder replicaGlobalSecondaryIndexSettings(Consumer<ReplicaGlobalSecondaryIndexSettingsDescription.Builder> ... var1);
    }
}

