/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the new provisioned throughput settings to be applied to a global secondary index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGlobalSecondaryIndexAction implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateGlobalSecondaryIndexAction.Builder, UpdateGlobalSecondaryIndexAction> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateGlobalSecondaryIndexAction::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField
            .<ProvisionedThroughput> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateGlobalSecondaryIndexAction::provisionedThroughput))
            .setter(setter(Builder::provisionedThroughput)).constructor(ProvisionedThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughput").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD,
            PROVISIONED_THROUGHPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String indexName;

    private final ProvisionedThroughput provisionedThroughput;

    private UpdateGlobalSecondaryIndexAction(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.provisionedThroughput = builder.provisionedThroughput;
    }

    /**
     * <p>
     * The name of the global secondary index to be updated.
     * </p>
     * 
     * @return The name of the global secondary index to be updated.
     */
    public String indexName() {
        return indexName;
    }

    /**
     * <p>
     * Represents the provisioned throughput settings for the specified global secondary index.
     * </p>
     * <p>
     * For current minimum and maximum provisioned throughput values, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the <i>Amazon
     * DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return Represents the provisioned throughput settings for the specified global secondary index.</p>
     *         <p>
     *         For current minimum and maximum provisioned throughput values, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
     *         <i>Amazon DynamoDB Developer Guide</i>.
     */
    public ProvisionedThroughput provisionedThroughput() {
        return provisionedThroughput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughput());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlobalSecondaryIndexAction)) {
            return false;
        }
        UpdateGlobalSecondaryIndexAction other = (UpdateGlobalSecondaryIndexAction) obj;
        return Objects.equals(indexName(), other.indexName())
                && Objects.equals(provisionedThroughput(), other.provisionedThroughput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateGlobalSecondaryIndexAction").add("IndexName", indexName())
                .add("ProvisionedThroughput", provisionedThroughput()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "ProvisionedThroughput":
            return Optional.ofNullable(clazz.cast(provisionedThroughput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGlobalSecondaryIndexAction, T> g) {
        return obj -> g.apply((UpdateGlobalSecondaryIndexAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateGlobalSecondaryIndexAction> {
        /**
         * <p>
         * The name of the global secondary index to be updated.
         * </p>
         * 
         * @param indexName
         *        The name of the global secondary index to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * Represents the provisioned throughput settings for the specified global secondary index.
         * </p>
         * <p>
         * For current minimum and maximum provisioned throughput values, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
         * <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param provisionedThroughput
         *        Represents the provisioned throughput settings for the specified global secondary index.</p>
         *        <p>
         *        For current minimum and maximum provisioned throughput values, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
         *        <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput);

        /**
         * <p>
         * Represents the provisioned throughput settings for the specified global secondary index.
         * </p>
         * <p>
         * For current minimum and maximum provisioned throughput values, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
         * <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link ProvisionedThroughput.Builder} avoiding the need
         * to create one manually via {@link ProvisionedThroughput#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisionedThroughput.Builder#build()} is called immediately and
         * its result is passed to {@link #provisionedThroughput(ProvisionedThroughput)}.
         * 
         * @param provisionedThroughput
         *        a consumer that will call methods on {@link ProvisionedThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughput(ProvisionedThroughput)
         */
        default Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return provisionedThroughput(ProvisionedThroughput.builder().applyMutation(provisionedThroughput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String indexName;

        private ProvisionedThroughput provisionedThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlobalSecondaryIndexAction model) {
            indexName(model.indexName);
            provisionedThroughput(model.provisionedThroughput);
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return provisionedThroughput != null ? provisionedThroughput.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        @Override
        public UpdateGlobalSecondaryIndexAction build() {
            return new UpdateGlobalSecondaryIndexAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
