/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeNameMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeValueMapCopier;
import software.amazon.awssdk.services.dynamodb.model.PutItemInputAttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ReturnValuesOnConditionCheckFailure;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Put
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Put> {
    private static final SdkField<Map<String, AttributeValue>> ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Put.getter(Put::item)).setter(Put.setter(Builder::item)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Put.getter(Put::tableName)).setter(Put.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> CONDITION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Put.getter(Put::conditionExpression)).setter(Put.setter(Builder::conditionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionExpression").build()}).build();
    private static final SdkField<Map<String, String>> EXPRESSION_ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Put.getter(Put::expressionAttributeNames)).setter(Put.setter(Builder::expressionAttributeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeNames").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, AttributeValue>> EXPRESSION_ATTRIBUTE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Put.getter(Put::expressionAttributeValues)).setter(Put.setter(Builder::expressionAttributeValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeValues").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RETURN_VALUES_ON_CONDITION_CHECK_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Put.getter(Put::returnValuesOnConditionCheckFailureAsString)).setter(Put.setter(Builder::returnValuesOnConditionCheckFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnValuesOnConditionCheckFailure").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD, TABLE_NAME_FIELD, CONDITION_EXPRESSION_FIELD, EXPRESSION_ATTRIBUTE_NAMES_FIELD, EXPRESSION_ATTRIBUTE_VALUES_FIELD, RETURN_VALUES_ON_CONDITION_CHECK_FAILURE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, AttributeValue> item;
    private final String tableName;
    private final String conditionExpression;
    private final Map<String, String> expressionAttributeNames;
    private final Map<String, AttributeValue> expressionAttributeValues;
    private final String returnValuesOnConditionCheckFailure;

    private Put(BuilderImpl builder) {
        this.item = builder.item;
        this.tableName = builder.tableName;
        this.conditionExpression = builder.conditionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
        this.returnValuesOnConditionCheckFailure = builder.returnValuesOnConditionCheckFailure;
    }

    public Map<String, AttributeValue> item() {
        return this.item;
    }

    public String tableName() {
        return this.tableName;
    }

    public String conditionExpression() {
        return this.conditionExpression;
    }

    public Map<String, String> expressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public Map<String, AttributeValue> expressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    public ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure() {
        return ReturnValuesOnConditionCheckFailure.fromValue(this.returnValuesOnConditionCheckFailure);
    }

    public String returnValuesOnConditionCheckFailureAsString() {
        return this.returnValuesOnConditionCheckFailure;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.item());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionAttributeNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionAttributeValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnValuesOnConditionCheckFailureAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Put)) {
            return false;
        }
        Put other = (Put)obj;
        return Objects.equals(this.item(), other.item()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.conditionExpression(), other.conditionExpression()) && Objects.equals(this.expressionAttributeNames(), other.expressionAttributeNames()) && Objects.equals(this.expressionAttributeValues(), other.expressionAttributeValues()) && Objects.equals(this.returnValuesOnConditionCheckFailureAsString(), other.returnValuesOnConditionCheckFailureAsString());
    }

    public String toString() {
        return ToString.builder((String)"Put").add("Item", this.item()).add("TableName", (Object)this.tableName()).add("ConditionExpression", (Object)this.conditionExpression()).add("ExpressionAttributeNames", this.expressionAttributeNames()).add("ExpressionAttributeValues", this.expressionAttributeValues()).add("ReturnValuesOnConditionCheckFailure", (Object)this.returnValuesOnConditionCheckFailureAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Item": {
                return Optional.ofNullable(clazz.cast(this.item()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "ConditionExpression": {
                return Optional.ofNullable(clazz.cast(this.conditionExpression()));
            }
            case "ExpressionAttributeNames": {
                return Optional.ofNullable(clazz.cast(this.expressionAttributeNames()));
            }
            case "ExpressionAttributeValues": {
                return Optional.ofNullable(clazz.cast(this.expressionAttributeValues()));
            }
            case "ReturnValuesOnConditionCheckFailure": {
                return Optional.ofNullable(clazz.cast(this.returnValuesOnConditionCheckFailureAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Put, T> g) {
        return obj -> g.apply((Put)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, AttributeValue> item = DefaultSdkAutoConstructMap.getInstance();
        private String tableName;
        private String conditionExpression;
        private Map<String, String> expressionAttributeNames = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, AttributeValue> expressionAttributeValues = DefaultSdkAutoConstructMap.getInstance();
        private String returnValuesOnConditionCheckFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(Put model) {
            this.item(model.item);
            this.tableName(model.tableName);
            this.conditionExpression(model.conditionExpression);
            this.expressionAttributeNames(model.expressionAttributeNames);
            this.expressionAttributeValues(model.expressionAttributeValues);
            this.returnValuesOnConditionCheckFailure(model.returnValuesOnConditionCheckFailure);
        }

        public final Map<String, AttributeValue.Builder> getItem() {
            return this.item != null ? CollectionUtils.mapValues(this.item, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder item(Map<String, AttributeValue> item) {
            this.item = PutItemInputAttributeMapCopier.copy(item);
            return this;
        }

        public final void setItem(Map<String, AttributeValue.BuilderImpl> item) {
            this.item = PutItemInputAttributeMapCopier.copyFromBuilder(item);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getConditionExpression() {
            return this.conditionExpression;
        }

        @Override
        public final Builder conditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public final void setConditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return this.expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public final Map<String, AttributeValue.Builder> getExpressionAttributeValues() {
            return this.expressionAttributeValues != null ? CollectionUtils.mapValues(this.expressionAttributeValues, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue.BuilderImpl> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copyFromBuilder(expressionAttributeValues);
        }

        public final String getReturnValuesOnConditionCheckFailure() {
            return this.returnValuesOnConditionCheckFailure;
        }

        @Override
        public final Builder returnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure;
            return this;
        }

        @Override
        public final Builder returnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure(returnValuesOnConditionCheckFailure.toString());
            return this;
        }

        public final void setReturnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure;
        }

        public Put build() {
            return new Put(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Put> {
        public Builder item(Map<String, AttributeValue> var1);

        public Builder tableName(String var1);

        public Builder conditionExpression(String var1);

        public Builder expressionAttributeNames(Map<String, String> var1);

        public Builder expressionAttributeValues(Map<String, AttributeValue> var1);

        public Builder returnValuesOnConditionCheckFailure(String var1);

        public Builder returnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure var1);
    }
}

