/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.BinarySetAttributeValueCopier;
import software.amazon.awssdk.services.dynamodb.model.ListAttributeValueCopier;
import software.amazon.awssdk.services.dynamodb.model.MapAttributeValueCopier;
import software.amazon.awssdk.services.dynamodb.model.NumberSetAttributeValueCopier;
import software.amazon.awssdk.services.dynamodb.model.StringSetAttributeValueCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttributeValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttributeValue> {
    private static final SdkField<String> S_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AttributeValue.getter(AttributeValue::s)).setter(AttributeValue.setter(Builder::s)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S").build()}).build();
    private static final SdkField<String> N_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AttributeValue.getter(AttributeValue::n)).setter(AttributeValue.setter(Builder::n)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("N").build()}).build();
    private static final SdkField<SdkBytes> B_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(AttributeValue.getter(AttributeValue::b)).setter(AttributeValue.setter(Builder::b)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("B").build()}).build();
    private static final SdkField<List<String>> SS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AttributeValue.getter(AttributeValue::ss)).setter(AttributeValue.setter(Builder::ss)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SS").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AttributeValue.getter(AttributeValue::ns)).setter(AttributeValue.setter(Builder::ns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NS").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SdkBytes>> BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AttributeValue.getter(AttributeValue::bs)).setter(AttributeValue.setter(Builder::bs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BS").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, AttributeValue>> M_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(AttributeValue.getter(AttributeValue::m)).setter(AttributeValue.setter(Builder::m)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("M").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<AttributeValue>> L_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AttributeValue.getter(AttributeValue::l)).setter(AttributeValue.setter(Builder::l)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("L").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> BOOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(AttributeValue.getter(AttributeValue::bool)).setter(AttributeValue.setter(Builder::bool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BOOL").build()}).build();
    private static final SdkField<Boolean> NUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(AttributeValue.getter(AttributeValue::nul)).setter(AttributeValue.setter(Builder::nul)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NULL").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S_FIELD, N_FIELD, B_FIELD, SS_FIELD, NS_FIELD, BS_FIELD, M_FIELD, L_FIELD, BOOL_FIELD, NUL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s;
    private final String n;
    private final SdkBytes b;
    private final List<String> ss;
    private final List<String> ns;
    private final List<SdkBytes> bs;
    private final Map<String, AttributeValue> m;
    private final List<AttributeValue> l;
    private final Boolean bool;
    private final Boolean nul;

    private AttributeValue(BuilderImpl builder) {
        this.s = builder.s;
        this.n = builder.n;
        this.b = builder.b;
        this.ss = builder.ss;
        this.ns = builder.ns;
        this.bs = builder.bs;
        this.m = builder.m;
        this.l = builder.l;
        this.bool = builder.bool;
        this.nul = builder.nul;
    }

    public String s() {
        return this.s;
    }

    public String n() {
        return this.n;
    }

    public SdkBytes b() {
        return this.b;
    }

    public List<String> ss() {
        return this.ss;
    }

    public List<String> ns() {
        return this.ns;
    }

    public List<SdkBytes> bs() {
        return this.bs;
    }

    public Map<String, AttributeValue> m() {
        return this.m;
    }

    public List<AttributeValue> l() {
        return this.l;
    }

    public Boolean bool() {
        return this.bool;
    }

    public Boolean nul() {
        return this.nul;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s());
        hashCode = 31 * hashCode + Objects.hashCode(this.n());
        hashCode = 31 * hashCode + Objects.hashCode(this.b());
        hashCode = 31 * hashCode + Objects.hashCode(this.ss());
        hashCode = 31 * hashCode + Objects.hashCode(this.ns());
        hashCode = 31 * hashCode + Objects.hashCode(this.bs());
        hashCode = 31 * hashCode + Objects.hashCode(this.m());
        hashCode = 31 * hashCode + Objects.hashCode(this.l());
        hashCode = 31 * hashCode + Objects.hashCode(this.bool());
        hashCode = 31 * hashCode + Objects.hashCode(this.nul());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValue)) {
            return false;
        }
        AttributeValue other = (AttributeValue)obj;
        return Objects.equals(this.s(), other.s()) && Objects.equals(this.n(), other.n()) && Objects.equals(this.b(), other.b()) && Objects.equals(this.ss(), other.ss()) && Objects.equals(this.ns(), other.ns()) && Objects.equals(this.bs(), other.bs()) && Objects.equals(this.m(), other.m()) && Objects.equals(this.l(), other.l()) && Objects.equals(this.bool(), other.bool()) && Objects.equals(this.nul(), other.nul());
    }

    public String toString() {
        return ToString.builder((String)"AttributeValue").add("S", (Object)this.s()).add("N", (Object)this.n()).add("B", (Object)this.b()).add("SS", this.ss()).add("NS", this.ns()).add("BS", this.bs()).add("M", this.m()).add("L", this.l()).add("BOOL", (Object)this.bool()).add("NUL", (Object)this.nul()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S": {
                return Optional.ofNullable(clazz.cast(this.s()));
            }
            case "N": {
                return Optional.ofNullable(clazz.cast(this.n()));
            }
            case "B": {
                return Optional.ofNullable(clazz.cast(this.b()));
            }
            case "SS": {
                return Optional.ofNullable(clazz.cast(this.ss()));
            }
            case "NS": {
                return Optional.ofNullable(clazz.cast(this.ns()));
            }
            case "BS": {
                return Optional.ofNullable(clazz.cast(this.bs()));
            }
            case "M": {
                return Optional.ofNullable(clazz.cast(this.m()));
            }
            case "L": {
                return Optional.ofNullable(clazz.cast(this.l()));
            }
            case "BOOL": {
                return Optional.ofNullable(clazz.cast(this.bool()));
            }
            case "NUL": {
                return Optional.ofNullable(clazz.cast(this.nul()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributeValue, T> g) {
        return obj -> g.apply((AttributeValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s;
        private String n;
        private SdkBytes b;
        private List<String> ss = DefaultSdkAutoConstructList.getInstance();
        private List<String> ns = DefaultSdkAutoConstructList.getInstance();
        private List<SdkBytes> bs = DefaultSdkAutoConstructList.getInstance();
        private Map<String, AttributeValue> m = DefaultSdkAutoConstructMap.getInstance();
        private List<AttributeValue> l = DefaultSdkAutoConstructList.getInstance();
        private Boolean bool;
        private Boolean nul;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeValue model) {
            this.s(model.s);
            this.n(model.n);
            this.b(model.b);
            this.ss(model.ss);
            this.ns(model.ns);
            this.bs(model.bs);
            this.m(model.m);
            this.l(model.l);
            this.bool(model.bool);
            this.nul(model.nul);
        }

        public final String getS() {
            return this.s;
        }

        @Override
        public final Builder s(String s) {
            this.s = s;
            return this;
        }

        public final void setS(String s) {
            this.s = s;
        }

        public final String getN() {
            return this.n;
        }

        @Override
        public final Builder n(String n) {
            this.n = n;
            return this;
        }

        public final void setN(String n) {
            this.n = n;
        }

        public final ByteBuffer getB() {
            return this.b == null ? null : this.b.asByteBuffer();
        }

        @Override
        public final Builder b(SdkBytes b) {
            this.b = StandardMemberCopier.copy((SdkBytes)b);
            return this;
        }

        public final void setB(ByteBuffer b) {
            this.b(b == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)b));
        }

        public final Collection<String> getSS() {
            return this.ss;
        }

        @Override
        public final Builder ss(Collection<String> ss) {
            this.ss = StringSetAttributeValueCopier.copy(ss);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ss(String ... ss) {
            this.ss(Arrays.asList(ss));
            return this;
        }

        public final void setSS(Collection<String> ss) {
            this.ss = StringSetAttributeValueCopier.copy(ss);
        }

        public final Collection<String> getNS() {
            return this.ns;
        }

        @Override
        public final Builder ns(Collection<String> ns) {
            this.ns = NumberSetAttributeValueCopier.copy(ns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ns(String ... ns) {
            this.ns(Arrays.asList(ns));
            return this;
        }

        public final void setNS(Collection<String> ns) {
            this.ns = NumberSetAttributeValueCopier.copy(ns);
        }

        public final List<ByteBuffer> getBS() {
            return this.bs == null ? null : this.bs.stream().map(rec$ -> ((SdkBytes)rec$).asByteBuffer()).collect(Collectors.toList());
        }

        @Override
        public final Builder bs(Collection<SdkBytes> bs) {
            this.bs = BinarySetAttributeValueCopier.copy(bs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bs(SdkBytes ... bs) {
            this.bs(Arrays.asList(bs));
            return this;
        }

        public final void setBS(Collection<ByteBuffer> bs) {
            this.bs(bs == null ? null : (Collection)bs.stream().map(SdkBytes::fromByteBuffer).collect(Collectors.toList()));
        }

        public final Map<String, Builder> getM() {
            return this.m != null ? CollectionUtils.mapValues(this.m, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder m(Map<String, AttributeValue> m) {
            this.m = MapAttributeValueCopier.copy(m);
            return this;
        }

        public final void setM(Map<String, BuilderImpl> m) {
            this.m = MapAttributeValueCopier.copyFromBuilder(m);
        }

        public final Collection<Builder> getL() {
            return this.l != null ? (Collection)this.l.stream().map(AttributeValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder l(Collection<AttributeValue> l) {
            this.l = ListAttributeValueCopier.copy(l);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder l(AttributeValue ... l) {
            this.l(Arrays.asList(l));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder l(Consumer<Builder> ... l) {
            this.l(Stream.of(l).map(c -> (AttributeValue)((Builder)AttributeValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setL(Collection<BuilderImpl> l) {
            this.l = ListAttributeValueCopier.copyFromBuilder(l);
        }

        public final Boolean getBOOL() {
            return this.bool;
        }

        @Override
        public final Builder bool(Boolean bool) {
            this.bool = bool;
            return this;
        }

        public final void setBOOL(Boolean bool) {
            this.bool = bool;
        }

        public final Boolean getNUL() {
            return this.nul;
        }

        @Override
        public final Builder nul(Boolean nul) {
            this.nul = nul;
            return this;
        }

        public final void setNUL(Boolean nul) {
            this.nul = nul;
        }

        public AttributeValue build() {
            return new AttributeValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttributeValue> {
        public Builder s(String var1);

        public Builder n(String var1);

        public Builder b(SdkBytes var1);

        public Builder ss(Collection<String> var1);

        public Builder ss(String ... var1);

        public Builder ns(Collection<String> var1);

        public Builder ns(String ... var1);

        public Builder bs(Collection<SdkBytes> var1);

        public Builder bs(SdkBytes ... var1);

        public Builder m(Map<String, AttributeValue> var1);

        public Builder l(Collection<AttributeValue> var1);

        public Builder l(AttributeValue ... var1);

        public Builder l(Consumer<Builder> ... var1);

        public Builder bool(Boolean var1);

        public Builder nul(Boolean var1);
    }
}

