/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListStreamsRequestModelMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limit").isBinary(false).build();
    private static final MarshallingInfo<String> EXCLUSIVESTARTSTREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExclusiveStartStreamArn").isBinary(false).build();
    private static final ListStreamsRequestModelMarshaller INSTANCE = new ListStreamsRequestModelMarshaller();

    private ListStreamsRequestModelMarshaller() {
    }

    public static ListStreamsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListStreamsRequest listStreamsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listStreamsRequest), (String)"listStreamsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listStreamsRequest.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)listStreamsRequest.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall((Object)listStreamsRequest.exclusiveStartStreamArn(), EXCLUSIVESTARTSTREAMARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

