/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.CreateReplicaAction;
import software.amazon.awssdk.services.dynamodb.model.DeleteReplicaAction;
import software.amazon.awssdk.services.dynamodb.transform.ReplicaUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicaUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, ReplicaUpdate> {
    private final CreateReplicaAction create;
    private final DeleteReplicaAction delete;

    private ReplicaUpdate(BuilderImpl builder) {
        this.create = builder.create;
        this.delete = builder.delete;
    }

    public CreateReplicaAction create() {
        return this.create;
    }

    public DeleteReplicaAction delete() {
        return this.delete;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.create());
        hashCode = 31 * hashCode + Objects.hashCode(this.delete());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaUpdate)) {
            return false;
        }
        ReplicaUpdate other = (ReplicaUpdate)obj;
        return Objects.equals(this.create(), other.create()) && Objects.equals(this.delete(), other.delete());
    }

    public String toString() {
        return ToString.builder((String)"ReplicaUpdate").add("Create", (Object)this.create()).add("Delete", (Object)this.delete()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Create": {
                return Optional.ofNullable(clazz.cast(this.create()));
            }
            case "Delete": {
                return Optional.ofNullable(clazz.cast(this.delete()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplicaUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private CreateReplicaAction create;
        private DeleteReplicaAction delete;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaUpdate model) {
            this.create(model.create);
            this.delete(model.delete);
        }

        public final CreateReplicaAction.Builder getCreate() {
            return this.create != null ? this.create.toBuilder() : null;
        }

        @Override
        public final Builder create(CreateReplicaAction create) {
            this.create = create;
            return this;
        }

        public final void setCreate(CreateReplicaAction.BuilderImpl create) {
            this.create = create != null ? create.build() : null;
        }

        public final DeleteReplicaAction.Builder getDelete() {
            return this.delete != null ? this.delete.toBuilder() : null;
        }

        @Override
        public final Builder delete(DeleteReplicaAction delete) {
            this.delete = delete;
            return this;
        }

        public final void setDelete(DeleteReplicaAction.BuilderImpl delete) {
            this.delete = delete != null ? delete.build() : null;
        }

        public ReplicaUpdate build() {
            return new ReplicaUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReplicaUpdate> {
        public Builder create(CreateReplicaAction var1);

        default public Builder create(Consumer<CreateReplicaAction.Builder> create) {
            return this.create((CreateReplicaAction)((CreateReplicaAction.Builder)CreateReplicaAction.builder().applyMutation(create)).build());
        }

        public Builder delete(DeleteReplicaAction var1);

        default public Builder delete(Consumer<DeleteReplicaAction.Builder> delete) {
            return this.delete((DeleteReplicaAction)((DeleteReplicaAction.Builder)DeleteReplicaAction.builder().applyMutation(delete)).build());
        }
    }
}

