/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.transform.AttributeValueUnmarshaller;

public class AttributeValueUpdateUnmarshaller
implements Unmarshaller<AttributeValueUpdate, JsonUnmarshallerContext> {
    private static final AttributeValueUpdateUnmarshaller INSTANCE = new AttributeValueUpdateUnmarshaller();

    public AttributeValueUpdate unmarshall(JsonUnmarshallerContext context) throws Exception {
        AttributeValueUpdate.Builder attributeValueUpdateBuilder = AttributeValueUpdate.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Value", targetDepth)) {
                    context.nextToken();
                    attributeValueUpdateBuilder.value(AttributeValueUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Action", targetDepth)) {
                    context.nextToken();
                    attributeValueUpdateBuilder.action((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AttributeValueUpdate)attributeValueUpdateBuilder.build();
    }

    public static AttributeValueUpdateUnmarshaller getInstance() {
        return INSTANCE;
    }
}

