/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBackupsRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, ListBackupsRequest> {
    private final String tableName;
    private final Integer limit;
    private final Instant timeRangeLowerBound;
    private final Instant timeRangeUpperBound;
    private final String exclusiveStartBackupArn;

    private ListBackupsRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.limit = builder.limit;
        this.timeRangeLowerBound = builder.timeRangeLowerBound;
        this.timeRangeUpperBound = builder.timeRangeUpperBound;
        this.exclusiveStartBackupArn = builder.exclusiveStartBackupArn;
    }

    public String tableName() {
        return this.tableName;
    }

    public Integer limit() {
        return this.limit;
    }

    public Instant timeRangeLowerBound() {
        return this.timeRangeLowerBound;
    }

    public Instant timeRangeUpperBound() {
        return this.timeRangeUpperBound;
    }

    public String exclusiveStartBackupArn() {
        return this.exclusiveStartBackupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRangeLowerBound());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRangeUpperBound());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartBackupArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupsRequest)) {
            return false;
        }
        ListBackupsRequest other = (ListBackupsRequest)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.timeRangeLowerBound(), other.timeRangeLowerBound()) && Objects.equals(this.timeRangeUpperBound(), other.timeRangeUpperBound()) && Objects.equals(this.exclusiveStartBackupArn(), other.exclusiveStartBackupArn());
    }

    public String toString() {
        return ToString.builder((String)"ListBackupsRequest").add("TableName", (Object)this.tableName()).add("Limit", (Object)this.limit()).add("TimeRangeLowerBound", (Object)this.timeRangeLowerBound()).add("TimeRangeUpperBound", (Object)this.timeRangeUpperBound()).add("ExclusiveStartBackupArn", (Object)this.exclusiveStartBackupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "TimeRangeLowerBound": {
                return Optional.ofNullable(clazz.cast(this.timeRangeLowerBound()));
            }
            case "TimeRangeUpperBound": {
                return Optional.ofNullable(clazz.cast(this.timeRangeUpperBound()));
            }
            case "ExclusiveStartBackupArn": {
                return Optional.ofNullable(clazz.cast(this.exclusiveStartBackupArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String tableName;
        private Integer limit;
        private Instant timeRangeLowerBound;
        private Instant timeRangeUpperBound;
        private String exclusiveStartBackupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupsRequest model) {
            super(model);
            this.tableName(model.tableName);
            this.limit(model.limit);
            this.timeRangeLowerBound(model.timeRangeLowerBound);
            this.timeRangeUpperBound(model.timeRangeUpperBound);
            this.exclusiveStartBackupArn(model.exclusiveStartBackupArn);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final Instant getTimeRangeLowerBound() {
            return this.timeRangeLowerBound;
        }

        @Override
        public final Builder timeRangeLowerBound(Instant timeRangeLowerBound) {
            this.timeRangeLowerBound = timeRangeLowerBound;
            return this;
        }

        public final void setTimeRangeLowerBound(Instant timeRangeLowerBound) {
            this.timeRangeLowerBound = timeRangeLowerBound;
        }

        public final Instant getTimeRangeUpperBound() {
            return this.timeRangeUpperBound;
        }

        @Override
        public final Builder timeRangeUpperBound(Instant timeRangeUpperBound) {
            this.timeRangeUpperBound = timeRangeUpperBound;
            return this;
        }

        public final void setTimeRangeUpperBound(Instant timeRangeUpperBound) {
            this.timeRangeUpperBound = timeRangeUpperBound;
        }

        public final String getExclusiveStartBackupArn() {
            return this.exclusiveStartBackupArn;
        }

        @Override
        public final Builder exclusiveStartBackupArn(String exclusiveStartBackupArn) {
            this.exclusiveStartBackupArn = exclusiveStartBackupArn;
            return this;
        }

        public final void setExclusiveStartBackupArn(String exclusiveStartBackupArn) {
            this.exclusiveStartBackupArn = exclusiveStartBackupArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBackupsRequest build() {
            return new ListBackupsRequest(this);
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    CopyableBuilder<Builder, ListBackupsRequest> {
        public Builder tableName(String var1);

        public Builder limit(Integer var1);

        public Builder timeRangeLowerBound(Instant var1);

        public Builder timeRangeUpperBound(Instant var1);

        public Builder exclusiveStartBackupArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

