/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RestoreTableToPointInTimeRequestModelMarshaller {
    private static final MarshallingInfo<String> SOURCETABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceTableName").isBinary(false).build();
    private static final MarshallingInfo<String> TARGETTABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetTableName").isBinary(false).build();
    private static final MarshallingInfo<Boolean> USELATESTRESTORABLETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UseLatestRestorableTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> RESTOREDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RestoreDateTime").isBinary(false).build();
    private static final RestoreTableToPointInTimeRequestModelMarshaller INSTANCE = new RestoreTableToPointInTimeRequestModelMarshaller();

    private RestoreTableToPointInTimeRequestModelMarshaller() {
    }

    public static RestoreTableToPointInTimeRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RestoreTableToPointInTimeRequest restoreTableToPointInTimeRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)restoreTableToPointInTimeRequest), (String)"restoreTableToPointInTimeRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)restoreTableToPointInTimeRequest.sourceTableName(), SOURCETABLENAME_BINDING);
            protocolMarshaller.marshall((Object)restoreTableToPointInTimeRequest.targetTableName(), TARGETTABLENAME_BINDING);
            protocolMarshaller.marshall((Object)restoreTableToPointInTimeRequest.useLatestRestorableTime(), USELATESTRESTORABLETIME_BINDING);
            protocolMarshaller.marshall((Object)restoreTableToPointInTimeRequest.restoreDateTime(), RESTOREDATETIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

