/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.RestoreSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RestoreSummaryMarshaller {
    private static final MarshallingInfo<String> SOURCEBACKUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceBackupArn").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCETABLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceTableArn").isBinary(false).build();
    private static final MarshallingInfo<Instant> RESTOREDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RestoreDateTime").isBinary(false).build();
    private static final MarshallingInfo<Boolean> RESTOREINPROGRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RestoreInProgress").isBinary(false).build();
    private static final RestoreSummaryMarshaller INSTANCE = new RestoreSummaryMarshaller();

    private RestoreSummaryMarshaller() {
    }

    public static RestoreSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RestoreSummary restoreSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)restoreSummary, (String)"restoreSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)restoreSummary.sourceBackupArn(), SOURCEBACKUPARN_BINDING);
            protocolMarshaller.marshall((Object)restoreSummary.sourceTableArn(), SOURCETABLEARN_BINDING);
            protocolMarshaller.marshall((Object)restoreSummary.restoreDateTime(), RESTOREDATETIME_BINDING);
            protocolMarshaller.marshall((Object)restoreSummary.restoreInProgress(), RESTOREINPROGRESS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

