/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.transform.WriteRequestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WriteRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, WriteRequest> {
    private final PutRequest putRequest;
    private final DeleteRequest deleteRequest;

    private WriteRequest(BuilderImpl builder) {
        this.putRequest = builder.putRequest;
        this.deleteRequest = builder.deleteRequest;
    }

    public PutRequest putRequest() {
        return this.putRequest;
    }

    public DeleteRequest deleteRequest() {
        return this.deleteRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.putRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteRequest)) {
            return false;
        }
        WriteRequest other = (WriteRequest)obj;
        return Objects.equals(this.putRequest(), other.putRequest()) && Objects.equals(this.deleteRequest(), other.deleteRequest());
    }

    public String toString() {
        return ToString.builder((String)"WriteRequest").add("PutRequest", (Object)this.putRequest()).add("DeleteRequest", (Object)this.deleteRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PutRequest": {
                return Optional.ofNullable(clazz.cast(this.putRequest()));
            }
            case "DeleteRequest": {
                return Optional.ofNullable(clazz.cast(this.deleteRequest()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WriteRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private PutRequest putRequest;
        private DeleteRequest deleteRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteRequest model) {
            this.putRequest(model.putRequest);
            this.deleteRequest(model.deleteRequest);
        }

        public final PutRequest.Builder getPutRequest() {
            return this.putRequest != null ? this.putRequest.toBuilder() : null;
        }

        @Override
        public final Builder putRequest(PutRequest putRequest) {
            this.putRequest = putRequest;
            return this;
        }

        public final void setPutRequest(PutRequest.BuilderImpl putRequest) {
            this.putRequest = putRequest != null ? putRequest.build() : null;
        }

        public final DeleteRequest.Builder getDeleteRequest() {
            return this.deleteRequest != null ? this.deleteRequest.toBuilder() : null;
        }

        @Override
        public final Builder deleteRequest(DeleteRequest deleteRequest) {
            this.deleteRequest = deleteRequest;
            return this;
        }

        public final void setDeleteRequest(DeleteRequest.BuilderImpl deleteRequest) {
            this.deleteRequest = deleteRequest != null ? deleteRequest.build() : null;
        }

        public WriteRequest build() {
            return new WriteRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WriteRequest> {
        public Builder putRequest(PutRequest var1);

        default public Builder putRequest(Consumer<PutRequest.Builder> putRequest) {
            return this.putRequest((PutRequest)((PutRequest.Builder)PutRequest.builder().applyMutation(putRequest)).build());
        }

        public Builder deleteRequest(DeleteRequest var1);

        default public Builder deleteRequest(Consumer<DeleteRequest.Builder> deleteRequest) {
            return this.deleteRequest((DeleteRequest)((DeleteRequest.Builder)DeleteRequest.builder().applyMutation(deleteRequest)).build());
        }
    }
}

