/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateItemResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, UpdateItemResponse> {
    private final Map<String, AttributeValue> attributes;
    private final ConsumedCapacity consumedCapacity;
    private final ItemCollectionMetrics itemCollectionMetrics;

    private UpdateItemResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
        this.consumedCapacity = builder.consumedCapacity;
        this.itemCollectionMetrics = builder.itemCollectionMetrics;
    }

    public Map<String, AttributeValue> attributes() {
        return this.attributes;
    }

    public ConsumedCapacity consumedCapacity() {
        return this.consumedCapacity;
    }

    public ItemCollectionMetrics itemCollectionMetrics() {
        return this.itemCollectionMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCollectionMetrics());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateItemResponse)) {
            return false;
        }
        UpdateItemResponse other = (UpdateItemResponse)((Object)obj);
        return Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.consumedCapacity(), other.consumedCapacity()) && Objects.equals(this.itemCollectionMetrics(), other.itemCollectionMetrics());
    }

    public String toString() {
        return ToString.builder((String)"UpdateItemResponse").add("Attributes", this.attributes()).add("ConsumedCapacity", (Object)this.consumedCapacity()).add("ItemCollectionMetrics", (Object)this.itemCollectionMetrics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "ConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.consumedCapacity()));
            }
            case "ItemCollectionMetrics": {
                return Optional.ofNullable(clazz.cast(this.itemCollectionMetrics()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private Map<String, AttributeValue> attributes = DefaultSdkAutoConstructMap.getInstance();
        private ConsumedCapacity consumedCapacity;
        private ItemCollectionMetrics itemCollectionMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateItemResponse model) {
            super(model);
            this.attributes(model.attributes);
            this.consumedCapacity(model.consumedCapacity);
            this.itemCollectionMetrics(model.itemCollectionMetrics);
        }

        public final Map<String, AttributeValue.Builder> getAttributes() {
            return this.attributes != null ? CollectionUtils.mapValues(this.attributes, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder attributes(Map<String, AttributeValue> attributes) {
            this.attributes = AttributeMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, AttributeValue.BuilderImpl> attributes) {
            this.attributes = AttributeMapCopier.copyFromBuilder(attributes);
        }

        public final ConsumedCapacity.Builder getConsumedCapacity() {
            return this.consumedCapacity != null ? this.consumedCapacity.toBuilder() : null;
        }

        @Override
        public final Builder consumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        public final void setConsumedCapacity(ConsumedCapacity.BuilderImpl consumedCapacity) {
            this.consumedCapacity = consumedCapacity != null ? consumedCapacity.build() : null;
        }

        public final ItemCollectionMetrics.Builder getItemCollectionMetrics() {
            return this.itemCollectionMetrics != null ? this.itemCollectionMetrics.toBuilder() : null;
        }

        @Override
        public final Builder itemCollectionMetrics(ItemCollectionMetrics itemCollectionMetrics) {
            this.itemCollectionMetrics = itemCollectionMetrics;
            return this;
        }

        public final void setItemCollectionMetrics(ItemCollectionMetrics.BuilderImpl itemCollectionMetrics) {
            this.itemCollectionMetrics = itemCollectionMetrics != null ? itemCollectionMetrics.build() : null;
        }

        @Override
        public UpdateItemResponse build() {
            return new UpdateItemResponse(this);
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    CopyableBuilder<Builder, UpdateItemResponse> {
        public Builder attributes(Map<String, AttributeValue> var1);

        public Builder consumedCapacity(ConsumedCapacity var1);

        default public Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> consumedCapacity) {
            return this.consumedCapacity((ConsumedCapacity)((ConsumedCapacity.Builder)ConsumedCapacity.builder().applyMutation(consumedCapacity)).build());
        }

        public Builder itemCollectionMetrics(ItemCollectionMetrics var1);

        default public Builder itemCollectionMetrics(Consumer<ItemCollectionMetrics.Builder> itemCollectionMetrics) {
            return this.itemCollectionMetrics((ItemCollectionMetrics)((ItemCollectionMetrics.Builder)ItemCollectionMetrics.builder().applyMutation(itemCollectionMetrics)).build());
        }
    }
}

