/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.dynamodb.model.DynamoDBRequest;
import software.amazon.awssdk.services.dynamodb.model.TimeToLiveSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateTimeToLiveRequest
extends DynamoDBRequest
implements ToCopyableBuilder<Builder, UpdateTimeToLiveRequest> {
    private final String tableName;
    private final TimeToLiveSpecification timeToLiveSpecification;

    private UpdateTimeToLiveRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.timeToLiveSpecification = builder.timeToLiveSpecification;
    }

    public String tableName() {
        return this.tableName;
    }

    public TimeToLiveSpecification timeToLiveSpecification() {
        return this.timeToLiveSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeToLiveSpecification());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTimeToLiveRequest)) {
            return false;
        }
        UpdateTimeToLiveRequest other = (UpdateTimeToLiveRequest)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.timeToLiveSpecification(), other.timeToLiveSpecification());
    }

    public String toString() {
        return ToString.builder((String)"UpdateTimeToLiveRequest").add("TableName", (Object)this.tableName()).add("TimeToLiveSpecification", (Object)this.timeToLiveSpecification()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.of(clazz.cast(this.tableName()));
            }
            case "TimeToLiveSpecification": {
                return Optional.of(clazz.cast(this.timeToLiveSpecification()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDBRequest.BuilderImpl
    implements Builder {
        private String tableName;
        private TimeToLiveSpecification timeToLiveSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTimeToLiveRequest model) {
            this.tableName(model.tableName);
            this.timeToLiveSpecification(model.timeToLiveSpecification);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final TimeToLiveSpecification.Builder getTimeToLiveSpecification() {
            return this.timeToLiveSpecification != null ? this.timeToLiveSpecification.toBuilder() : null;
        }

        @Override
        public final Builder timeToLiveSpecification(TimeToLiveSpecification timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification;
            return this;
        }

        public final void setTimeToLiveSpecification(TimeToLiveSpecification.BuilderImpl timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification != null ? timeToLiveSpecification.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateTimeToLiveRequest build() {
            return new UpdateTimeToLiveRequest(this);
        }
    }

    public static interface Builder
    extends DynamoDBRequest.Builder,
    CopyableBuilder<Builder, UpdateTimeToLiveRequest> {
        public Builder tableName(String var1);

        public Builder timeToLiveSpecification(TimeToLiveSpecification var1);

        default public Builder timeToLiveSpecification(Consumer<TimeToLiveSpecification.Builder> timeToLiveSpecification) {
            return this.timeToLiveSpecification((TimeToLiveSpecification)((TimeToLiveSpecification.Builder)TimeToLiveSpecification.builder().apply(timeToLiveSpecification)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

