/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueListCopier;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.transform.ExpectedAttributeValueMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ExpectedAttributeValue
implements StructuredPojo,
ToCopyableBuilder<Builder, ExpectedAttributeValue> {
    private final AttributeValue value;
    private final Boolean exists;
    private final String comparisonOperator;
    private final List<AttributeValue> attributeValueList;

    private ExpectedAttributeValue(BuilderImpl builder) {
        this.value = builder.value;
        this.exists = builder.exists;
        this.comparisonOperator = builder.comparisonOperator;
        this.attributeValueList = builder.attributeValueList;
    }

    public AttributeValue value() {
        return this.value;
    }

    public Boolean exists() {
        return this.exists;
    }

    public ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(this.comparisonOperator);
    }

    public String comparisonOperatorString() {
        return this.comparisonOperator;
    }

    public List<AttributeValue> attributeValueList() {
        return this.attributeValueList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.exists());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeValueList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpectedAttributeValue)) {
            return false;
        }
        ExpectedAttributeValue other = (ExpectedAttributeValue)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.exists(), other.exists()) && Objects.equals(this.comparisonOperatorString(), other.comparisonOperatorString()) && Objects.equals(this.attributeValueList(), other.attributeValueList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (this.exists() != null) {
            sb.append("Exists: ").append(this.exists()).append(",");
        }
        if (this.comparisonOperatorString() != null) {
            sb.append("ComparisonOperator: ").append(this.comparisonOperatorString()).append(",");
        }
        if (this.attributeValueList() != null) {
            sb.append("AttributeValueList: ").append(this.attributeValueList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
            case "Exists": {
                return Optional.of(clazz.cast(this.exists()));
            }
            case "ComparisonOperator": {
                return Optional.of(clazz.cast(this.comparisonOperatorString()));
            }
            case "AttributeValueList": {
                return Optional.of(clazz.cast(this.attributeValueList()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExpectedAttributeValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private AttributeValue value;
        private Boolean exists;
        private String comparisonOperator;
        private List<AttributeValue> attributeValueList;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpectedAttributeValue model) {
            this.value(model.value);
            this.exists(model.exists);
            this.comparisonOperator(model.comparisonOperator);
            this.attributeValueList(model.attributeValueList);
        }

        public final AttributeValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        @Override
        public final Builder value(AttributeValue value) {
            this.value = value;
            return this;
        }

        public final void setValue(AttributeValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        public final Boolean getExists() {
            return this.exists;
        }

        @Override
        public final Builder exists(Boolean exists) {
            this.exists = exists;
            return this;
        }

        public final void setExists(Boolean exists) {
            this.exists = exists;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Collection<AttributeValue.Builder> getAttributeValueList() {
            return this.attributeValueList != null ? (Collection)this.attributeValueList.stream().map(AttributeValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributeValueList(Collection<AttributeValue> attributeValueList) {
            this.attributeValueList = AttributeValueListCopier.copy(attributeValueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValueList(AttributeValue ... attributeValueList) {
            this.attributeValueList(Arrays.asList(attributeValueList));
            return this;
        }

        public final void setAttributeValueList(Collection<AttributeValue.BuilderImpl> attributeValueList) {
            this.attributeValueList = AttributeValueListCopier.copyFromBuilder(attributeValueList);
        }

        public ExpectedAttributeValue build() {
            return new ExpectedAttributeValue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExpectedAttributeValue> {
        public Builder value(AttributeValue var1);

        default public Builder value(Consumer<AttributeValue.Builder> value) {
            return this.value((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().apply(value)).build());
        }

        public Builder exists(Boolean var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder attributeValueList(Collection<AttributeValue> var1);

        public Builder attributeValueList(AttributeValue ... var1);
    }
}

