/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.StreamViewType;
import software.amazon.awssdk.services.dynamodb.transform.StreamRecordMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StreamRecord
implements StructuredPojo,
ToCopyableBuilder<Builder, StreamRecord> {
    private final Instant approximateCreationDateTime;
    private final Map<String, AttributeValue> keys;
    private final Map<String, AttributeValue> newImage;
    private final Map<String, AttributeValue> oldImage;
    private final String sequenceNumber;
    private final Long sizeBytes;
    private final String streamViewType;

    private StreamRecord(BuilderImpl builder) {
        this.approximateCreationDateTime = builder.approximateCreationDateTime;
        this.keys = builder.keys;
        this.newImage = builder.newImage;
        this.oldImage = builder.oldImage;
        this.sequenceNumber = builder.sequenceNumber;
        this.sizeBytes = builder.sizeBytes;
        this.streamViewType = builder.streamViewType;
    }

    public Instant approximateCreationDateTime() {
        return this.approximateCreationDateTime;
    }

    public Map<String, AttributeValue> keys() {
        return this.keys;
    }

    public Map<String, AttributeValue> newImage() {
        return this.newImage;
    }

    public Map<String, AttributeValue> oldImage() {
        return this.oldImage;
    }

    public String sequenceNumber() {
        return this.sequenceNumber;
    }

    public Long sizeBytes() {
        return this.sizeBytes;
    }

    public StreamViewType streamViewType() {
        return StreamViewType.fromValue(this.streamViewType);
    }

    public String streamViewTypeString() {
        return this.streamViewType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.approximateCreationDateTime() == null ? 0 : this.approximateCreationDateTime().hashCode());
        hashCode = 31 * hashCode + (this.keys() == null ? 0 : this.keys().hashCode());
        hashCode = 31 * hashCode + (this.newImage() == null ? 0 : this.newImage().hashCode());
        hashCode = 31 * hashCode + (this.oldImage() == null ? 0 : this.oldImage().hashCode());
        hashCode = 31 * hashCode + (this.sequenceNumber() == null ? 0 : this.sequenceNumber().hashCode());
        hashCode = 31 * hashCode + (this.sizeBytes() == null ? 0 : this.sizeBytes().hashCode());
        hashCode = 31 * hashCode + (this.streamViewTypeString() == null ? 0 : this.streamViewTypeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamRecord)) {
            return false;
        }
        StreamRecord other = (StreamRecord)obj;
        if (other.approximateCreationDateTime() == null ^ this.approximateCreationDateTime() == null) {
            return false;
        }
        if (other.approximateCreationDateTime() != null && !other.approximateCreationDateTime().equals(this.approximateCreationDateTime())) {
            return false;
        }
        if (other.keys() == null ^ this.keys() == null) {
            return false;
        }
        if (other.keys() != null && !other.keys().equals(this.keys())) {
            return false;
        }
        if (other.newImage() == null ^ this.newImage() == null) {
            return false;
        }
        if (other.newImage() != null && !other.newImage().equals(this.newImage())) {
            return false;
        }
        if (other.oldImage() == null ^ this.oldImage() == null) {
            return false;
        }
        if (other.oldImage() != null && !other.oldImage().equals(this.oldImage())) {
            return false;
        }
        if (other.sequenceNumber() == null ^ this.sequenceNumber() == null) {
            return false;
        }
        if (other.sequenceNumber() != null && !other.sequenceNumber().equals(this.sequenceNumber())) {
            return false;
        }
        if (other.sizeBytes() == null ^ this.sizeBytes() == null) {
            return false;
        }
        if (other.sizeBytes() != null && !other.sizeBytes().equals(this.sizeBytes())) {
            return false;
        }
        if (other.streamViewTypeString() == null ^ this.streamViewTypeString() == null) {
            return false;
        }
        return other.streamViewTypeString() == null || other.streamViewTypeString().equals(this.streamViewTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.approximateCreationDateTime() != null) {
            sb.append("ApproximateCreationDateTime: ").append(this.approximateCreationDateTime()).append(",");
        }
        if (this.keys() != null) {
            sb.append("Keys: ").append(this.keys()).append(",");
        }
        if (this.newImage() != null) {
            sb.append("NewImage: ").append(this.newImage()).append(",");
        }
        if (this.oldImage() != null) {
            sb.append("OldImage: ").append(this.oldImage()).append(",");
        }
        if (this.sequenceNumber() != null) {
            sb.append("SequenceNumber: ").append(this.sequenceNumber()).append(",");
        }
        if (this.sizeBytes() != null) {
            sb.append("SizeBytes: ").append(this.sizeBytes()).append(",");
        }
        if (this.streamViewTypeString() != null) {
            sb.append("StreamViewType: ").append(this.streamViewTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApproximateCreationDateTime": {
                return Optional.of(clazz.cast(this.approximateCreationDateTime()));
            }
            case "Keys": {
                return Optional.of(clazz.cast(this.keys()));
            }
            case "NewImage": {
                return Optional.of(clazz.cast(this.newImage()));
            }
            case "OldImage": {
                return Optional.of(clazz.cast(this.oldImage()));
            }
            case "SequenceNumber": {
                return Optional.of(clazz.cast(this.sequenceNumber()));
            }
            case "SizeBytes": {
                return Optional.of(clazz.cast(this.sizeBytes()));
            }
            case "StreamViewType": {
                return Optional.of(clazz.cast(this.streamViewTypeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant approximateCreationDateTime;
        private Map<String, AttributeValue> keys;
        private Map<String, AttributeValue> newImage;
        private Map<String, AttributeValue> oldImage;
        private String sequenceNumber;
        private Long sizeBytes;
        private String streamViewType;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamRecord model) {
            this.approximateCreationDateTime(model.approximateCreationDateTime);
            this.keys(model.keys);
            this.newImage(model.newImage);
            this.oldImage(model.oldImage);
            this.sequenceNumber(model.sequenceNumber);
            this.sizeBytes(model.sizeBytes);
            this.streamViewType(model.streamViewType);
        }

        public final Instant getApproximateCreationDateTime() {
            return this.approximateCreationDateTime;
        }

        @Override
        public final Builder approximateCreationDateTime(Instant approximateCreationDateTime) {
            this.approximateCreationDateTime = approximateCreationDateTime;
            return this;
        }

        public final void setApproximateCreationDateTime(Instant approximateCreationDateTime) {
            this.approximateCreationDateTime = approximateCreationDateTime;
        }

        public final Map<String, AttributeValue.Builder> getKeys() {
            return this.keys != null ? CollectionUtils.mapValues(this.keys, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder keys(Map<String, AttributeValue> keys) {
            this.keys = AttributeMapCopier.copy(keys);
            return this;
        }

        public final void setKeys(Map<String, AttributeValue.BuilderImpl> keys) {
            this.keys = AttributeMapCopier.copyFromBuilder(keys);
        }

        public final Map<String, AttributeValue.Builder> getNewImage() {
            return this.newImage != null ? CollectionUtils.mapValues(this.newImage, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder newImage(Map<String, AttributeValue> newImage) {
            this.newImage = AttributeMapCopier.copy(newImage);
            return this;
        }

        public final void setNewImage(Map<String, AttributeValue.BuilderImpl> newImage) {
            this.newImage = AttributeMapCopier.copyFromBuilder(newImage);
        }

        public final Map<String, AttributeValue.Builder> getOldImage() {
            return this.oldImage != null ? CollectionUtils.mapValues(this.oldImage, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder oldImage(Map<String, AttributeValue> oldImage) {
            this.oldImage = AttributeMapCopier.copy(oldImage);
            return this;
        }

        public final void setOldImage(Map<String, AttributeValue.BuilderImpl> oldImage) {
            this.oldImage = AttributeMapCopier.copyFromBuilder(oldImage);
        }

        public final String getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public final Long getSizeBytes() {
            return this.sizeBytes;
        }

        @Override
        public final Builder sizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return this;
        }

        public final void setSizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
        }

        public final String getStreamViewType() {
            return this.streamViewType;
        }

        @Override
        public final Builder streamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
            return this;
        }

        @Override
        public final Builder streamViewType(StreamViewType streamViewType) {
            this.streamViewType(streamViewType.toString());
            return this;
        }

        public final void setStreamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
        }

        public StreamRecord build() {
            return new StreamRecord(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StreamRecord> {
        public Builder approximateCreationDateTime(Instant var1);

        public Builder keys(Map<String, AttributeValue> var1);

        public Builder newImage(Map<String, AttributeValue> var1);

        public Builder oldImage(Map<String, AttributeValue> var1);

        public Builder sequenceNumber(String var1);

        public Builder sizeBytes(Long var1);

        public Builder streamViewType(String var1);

        public Builder streamViewType(StreamViewType var1);
    }
}

