/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.Shard;

@SdkInternalApi
public class ShardMarshaller {
    private static final MarshallingInfo<String> SHARDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShardId").build();
    private static final MarshallingInfo<StructuredPojo> SEQUENCENUMBERRANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SequenceNumberRange").build();
    private static final MarshallingInfo<String> PARENTSHARDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentShardId").build();
    private static final ShardMarshaller INSTANCE = new ShardMarshaller();

    public static ShardMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Shard shard, ProtocolMarshaller protocolMarshaller) {
        if (shard == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)shard.shardId(), SHARDID_BINDING);
            protocolMarshaller.marshall((Object)shard.sequenceNumberRange(), SEQUENCENUMBERRANGE_BINDING);
            protocolMarshaller.marshall((Object)shard.parentShardId(), PARENTSHARDID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

