/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.transform.KeySchemaElementUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ProjectionUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ProvisionedThroughputUnmarshaller;

public class GlobalSecondaryIndexUnmarshaller
implements Unmarshaller<GlobalSecondaryIndex, JsonUnmarshallerContext> {
    private static final GlobalSecondaryIndexUnmarshaller INSTANCE = new GlobalSecondaryIndexUnmarshaller();

    public GlobalSecondaryIndex unmarshall(JsonUnmarshallerContext context) throws Exception {
        GlobalSecondaryIndex.Builder globalSecondaryIndexBuilder = GlobalSecondaryIndex.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("IndexName", targetDepth)) {
                    context.nextToken();
                    globalSecondaryIndexBuilder.indexName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KeySchema", targetDepth)) {
                    context.nextToken();
                    globalSecondaryIndexBuilder.keySchema(new ListUnmarshaller((Unmarshaller)KeySchemaElementUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Projection", targetDepth)) {
                    context.nextToken();
                    globalSecondaryIndexBuilder.projection(ProjectionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ProvisionedThroughput", targetDepth)) {
                    context.nextToken();
                    globalSecondaryIndexBuilder.provisionedThroughput(ProvisionedThroughputUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (GlobalSecondaryIndex)globalSecondaryIndexBuilder.build();
    }

    public static GlobalSecondaryIndexUnmarshaller getInstance() {
        return INSTANCE;
    }
}

