/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeNameMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeValueMapCopier;
import software.amazon.awssdk.services.dynamodb.model.PutItemInputAttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutItemRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutItemRequest> {
    private final String tableName;
    private final Map<String, AttributeValue> item;
    private final Map<String, ExpectedAttributeValue> expected;
    private final String returnValues;
    private final String returnConsumedCapacity;
    private final String returnItemCollectionMetrics;
    private final String conditionalOperator;
    private final String conditionExpression;
    private final Map<String, String> expressionAttributeNames;
    private final Map<String, AttributeValue> expressionAttributeValues;

    private PutItemRequest(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.item = builder.item;
        this.expected = builder.expected;
        this.returnValues = builder.returnValues;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.returnItemCollectionMetrics = builder.returnItemCollectionMetrics;
        this.conditionalOperator = builder.conditionalOperator;
        this.conditionExpression = builder.conditionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
    }

    public String tableName() {
        return this.tableName;
    }

    public Map<String, AttributeValue> item() {
        return this.item;
    }

    public Map<String, ExpectedAttributeValue> expected() {
        return this.expected;
    }

    public String returnValues() {
        return this.returnValues;
    }

    public String returnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public String returnItemCollectionMetrics() {
        return this.returnItemCollectionMetrics;
    }

    public String conditionalOperator() {
        return this.conditionalOperator;
    }

    public String conditionExpression() {
        return this.conditionExpression;
    }

    public Map<String, String> expressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public Map<String, AttributeValue> expressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tableName() == null ? 0 : this.tableName().hashCode());
        hashCode = 31 * hashCode + (this.item() == null ? 0 : this.item().hashCode());
        hashCode = 31 * hashCode + (this.expected() == null ? 0 : this.expected().hashCode());
        hashCode = 31 * hashCode + (this.returnValues() == null ? 0 : this.returnValues().hashCode());
        hashCode = 31 * hashCode + (this.returnConsumedCapacity() == null ? 0 : this.returnConsumedCapacity().hashCode());
        hashCode = 31 * hashCode + (this.returnItemCollectionMetrics() == null ? 0 : this.returnItemCollectionMetrics().hashCode());
        hashCode = 31 * hashCode + (this.conditionalOperator() == null ? 0 : this.conditionalOperator().hashCode());
        hashCode = 31 * hashCode + (this.conditionExpression() == null ? 0 : this.conditionExpression().hashCode());
        hashCode = 31 * hashCode + (this.expressionAttributeNames() == null ? 0 : this.expressionAttributeNames().hashCode());
        hashCode = 31 * hashCode + (this.expressionAttributeValues() == null ? 0 : this.expressionAttributeValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutItemRequest)) {
            return false;
        }
        PutItemRequest other = (PutItemRequest)((Object)obj);
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.item() == null ^ this.item() == null) {
            return false;
        }
        if (other.item() != null && !other.item().equals(this.item())) {
            return false;
        }
        if (other.expected() == null ^ this.expected() == null) {
            return false;
        }
        if (other.expected() != null && !other.expected().equals(this.expected())) {
            return false;
        }
        if (other.returnValues() == null ^ this.returnValues() == null) {
            return false;
        }
        if (other.returnValues() != null && !other.returnValues().equals(this.returnValues())) {
            return false;
        }
        if (other.returnConsumedCapacity() == null ^ this.returnConsumedCapacity() == null) {
            return false;
        }
        if (other.returnConsumedCapacity() != null && !other.returnConsumedCapacity().equals(this.returnConsumedCapacity())) {
            return false;
        }
        if (other.returnItemCollectionMetrics() == null ^ this.returnItemCollectionMetrics() == null) {
            return false;
        }
        if (other.returnItemCollectionMetrics() != null && !other.returnItemCollectionMetrics().equals(this.returnItemCollectionMetrics())) {
            return false;
        }
        if (other.conditionalOperator() == null ^ this.conditionalOperator() == null) {
            return false;
        }
        if (other.conditionalOperator() != null && !other.conditionalOperator().equals(this.conditionalOperator())) {
            return false;
        }
        if (other.conditionExpression() == null ^ this.conditionExpression() == null) {
            return false;
        }
        if (other.conditionExpression() != null && !other.conditionExpression().equals(this.conditionExpression())) {
            return false;
        }
        if (other.expressionAttributeNames() == null ^ this.expressionAttributeNames() == null) {
            return false;
        }
        if (other.expressionAttributeNames() != null && !other.expressionAttributeNames().equals(this.expressionAttributeNames())) {
            return false;
        }
        if (other.expressionAttributeValues() == null ^ this.expressionAttributeValues() == null) {
            return false;
        }
        return other.expressionAttributeValues() == null || other.expressionAttributeValues().equals(this.expressionAttributeValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.item() != null) {
            sb.append("Item: ").append(this.item()).append(",");
        }
        if (this.expected() != null) {
            sb.append("Expected: ").append(this.expected()).append(",");
        }
        if (this.returnValues() != null) {
            sb.append("ReturnValues: ").append(this.returnValues()).append(",");
        }
        if (this.returnConsumedCapacity() != null) {
            sb.append("ReturnConsumedCapacity: ").append(this.returnConsumedCapacity()).append(",");
        }
        if (this.returnItemCollectionMetrics() != null) {
            sb.append("ReturnItemCollectionMetrics: ").append(this.returnItemCollectionMetrics()).append(",");
        }
        if (this.conditionalOperator() != null) {
            sb.append("ConditionalOperator: ").append(this.conditionalOperator()).append(",");
        }
        if (this.conditionExpression() != null) {
            sb.append("ConditionExpression: ").append(this.conditionExpression()).append(",");
        }
        if (this.expressionAttributeNames() != null) {
            sb.append("ExpressionAttributeNames: ").append(this.expressionAttributeNames()).append(",");
        }
        if (this.expressionAttributeValues() != null) {
            sb.append("ExpressionAttributeValues: ").append(this.expressionAttributeValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String tableName;
        private Map<String, AttributeValue> item;
        private Map<String, ExpectedAttributeValue> expected;
        private String returnValues;
        private String returnConsumedCapacity;
        private String returnItemCollectionMetrics;
        private String conditionalOperator;
        private String conditionExpression;
        private Map<String, String> expressionAttributeNames;
        private Map<String, AttributeValue> expressionAttributeValues;

        private BuilderImpl() {
        }

        private BuilderImpl(PutItemRequest model) {
            this.setTableName(model.tableName);
            this.setItem(model.item);
            this.setExpected(model.expected);
            this.setReturnValues(model.returnValues);
            this.setReturnConsumedCapacity(model.returnConsumedCapacity);
            this.setReturnItemCollectionMetrics(model.returnItemCollectionMetrics);
            this.setConditionalOperator(model.conditionalOperator);
            this.setConditionExpression(model.conditionExpression);
            this.setExpressionAttributeNames(model.expressionAttributeNames);
            this.setExpressionAttributeValues(model.expressionAttributeValues);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Map<String, AttributeValue> getItem() {
            return this.item;
        }

        @Override
        public final Builder item(Map<String, AttributeValue> item) {
            this.item = PutItemInputAttributeMapCopier.copy(item);
            return this;
        }

        public final void setItem(Map<String, AttributeValue> item) {
            this.item = PutItemInputAttributeMapCopier.copy(item);
        }

        public final Map<String, ExpectedAttributeValue> getExpected() {
            return this.expected;
        }

        @Override
        public final Builder expected(Map<String, ExpectedAttributeValue> expected) {
            this.expected = ExpectedAttributeMapCopier.copy(expected);
            return this;
        }

        public final void setExpected(Map<String, ExpectedAttributeValue> expected) {
            this.expected = ExpectedAttributeMapCopier.copy(expected);
        }

        public final String getReturnValues() {
            return this.returnValues;
        }

        @Override
        public final Builder returnValues(String returnValues) {
            this.returnValues = returnValues;
            return this;
        }

        @Override
        public final Builder returnValues(ReturnValue returnValues) {
            this.returnValues(returnValues.toString());
            return this;
        }

        public final void setReturnValues(String returnValues) {
            this.returnValues = returnValues;
        }

        public final String getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final String getReturnItemCollectionMetrics() {
            return this.returnItemCollectionMetrics;
        }

        @Override
        public final Builder returnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        @Override
        public final Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics(returnItemCollectionMetrics.toString());
            return this;
        }

        public final void setReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
        }

        public final String getConditionalOperator() {
            return this.conditionalOperator;
        }

        @Override
        public final Builder conditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
            return this;
        }

        @Override
        public final Builder conditionalOperator(ConditionalOperator conditionalOperator) {
            this.conditionalOperator(conditionalOperator.toString());
            return this;
        }

        public final void setConditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
        }

        public final String getConditionExpression() {
            return this.conditionExpression;
        }

        @Override
        public final Builder conditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public final void setConditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return this.expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public final Map<String, AttributeValue> getExpressionAttributeValues() {
            return this.expressionAttributeValues;
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
        }

        public PutItemRequest build() {
            return new PutItemRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutItemRequest> {
        public Builder tableName(String var1);

        public Builder item(Map<String, AttributeValue> var1);

        public Builder expected(Map<String, ExpectedAttributeValue> var1);

        public Builder returnValues(String var1);

        public Builder returnValues(ReturnValue var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);

        public Builder returnItemCollectionMetrics(String var1);

        public Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics var1);

        public Builder conditionalOperator(String var1);

        public Builder conditionalOperator(ConditionalOperator var1);

        public Builder conditionExpression(String var1);

        public Builder expressionAttributeNames(Map<String, String> var1);

        public Builder expressionAttributeValues(Map<String, AttributeValue> var1);
    }
}

