/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.CreateGlobalSecondaryIndexAction;
import software.amazon.awssdk.services.dynamodb.model.DeleteGlobalSecondaryIndexAction;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalSecondaryIndexAction;
import software.amazon.awssdk.services.dynamodb.transform.GlobalSecondaryIndexUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GlobalSecondaryIndexUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, GlobalSecondaryIndexUpdate> {
    private final UpdateGlobalSecondaryIndexAction update;
    private final CreateGlobalSecondaryIndexAction create;
    private final DeleteGlobalSecondaryIndexAction delete;

    private GlobalSecondaryIndexUpdate(BuilderImpl builder) {
        this.update = builder.update;
        this.create = builder.create;
        this.delete = builder.delete;
    }

    public UpdateGlobalSecondaryIndexAction update() {
        return this.update;
    }

    public CreateGlobalSecondaryIndexAction create() {
        return this.create;
    }

    public DeleteGlobalSecondaryIndexAction delete() {
        return this.delete;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.update() == null ? 0 : this.update().hashCode());
        hashCode = 31 * hashCode + (this.create() == null ? 0 : this.create().hashCode());
        hashCode = 31 * hashCode + (this.delete() == null ? 0 : this.delete().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalSecondaryIndexUpdate)) {
            return false;
        }
        GlobalSecondaryIndexUpdate other = (GlobalSecondaryIndexUpdate)obj;
        if (other.update() == null ^ this.update() == null) {
            return false;
        }
        if (other.update() != null && !other.update().equals(this.update())) {
            return false;
        }
        if (other.create() == null ^ this.create() == null) {
            return false;
        }
        if (other.create() != null && !other.create().equals(this.create())) {
            return false;
        }
        if (other.delete() == null ^ this.delete() == null) {
            return false;
        }
        return other.delete() == null || other.delete().equals(this.delete());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.update() != null) {
            sb.append("Update: ").append(this.update()).append(",");
        }
        if (this.create() != null) {
            sb.append("Create: ").append(this.create()).append(",");
        }
        if (this.delete() != null) {
            sb.append("Delete: ").append(this.delete()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GlobalSecondaryIndexUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private UpdateGlobalSecondaryIndexAction update;
        private CreateGlobalSecondaryIndexAction create;
        private DeleteGlobalSecondaryIndexAction delete;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalSecondaryIndexUpdate model) {
            this.setUpdate(model.update);
            this.setCreate(model.create);
            this.setDelete(model.delete);
        }

        public final UpdateGlobalSecondaryIndexAction getUpdate() {
            return this.update;
        }

        @Override
        public final Builder update(UpdateGlobalSecondaryIndexAction update) {
            this.update = update;
            return this;
        }

        public final void setUpdate(UpdateGlobalSecondaryIndexAction update) {
            this.update = update;
        }

        public final CreateGlobalSecondaryIndexAction getCreate() {
            return this.create;
        }

        @Override
        public final Builder create(CreateGlobalSecondaryIndexAction create) {
            this.create = create;
            return this;
        }

        public final void setCreate(CreateGlobalSecondaryIndexAction create) {
            this.create = create;
        }

        public final DeleteGlobalSecondaryIndexAction getDelete() {
            return this.delete;
        }

        @Override
        public final Builder delete(DeleteGlobalSecondaryIndexAction delete) {
            this.delete = delete;
            return this;
        }

        public final void setDelete(DeleteGlobalSecondaryIndexAction delete) {
            this.delete = delete;
        }

        public GlobalSecondaryIndexUpdate build() {
            return new GlobalSecondaryIndexUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GlobalSecondaryIndexUpdate> {
        public Builder update(UpdateGlobalSecondaryIndexAction var1);

        public Builder create(CreateGlobalSecondaryIndexAction var1);

        public Builder delete(DeleteGlobalSecondaryIndexAction var1);
    }
}

