/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinitionsCopier;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexListCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexListCopier;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateTableRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateTableRequest> {
    private final List<AttributeDefinition> attributeDefinitions;
    private final String tableName;
    private final List<KeySchemaElement> keySchema;
    private final List<LocalSecondaryIndex> localSecondaryIndexes;
    private final List<GlobalSecondaryIndex> globalSecondaryIndexes;
    private final ProvisionedThroughput provisionedThroughput;
    private final StreamSpecification streamSpecification;

    private CreateTableRequest(BuilderImpl builder) {
        this.attributeDefinitions = builder.attributeDefinitions;
        this.tableName = builder.tableName;
        this.keySchema = builder.keySchema;
        this.localSecondaryIndexes = builder.localSecondaryIndexes;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.streamSpecification = builder.streamSpecification;
    }

    public List<AttributeDefinition> attributeDefinitions() {
        return this.attributeDefinitions;
    }

    public String tableName() {
        return this.tableName;
    }

    public List<KeySchemaElement> keySchema() {
        return this.keySchema;
    }

    public List<LocalSecondaryIndex> localSecondaryIndexes() {
        return this.localSecondaryIndexes;
    }

    public List<GlobalSecondaryIndex> globalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public ProvisionedThroughput provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public StreamSpecification streamSpecification() {
        return this.streamSpecification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributeDefinitions() == null ? 0 : this.attributeDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.tableName() == null ? 0 : this.tableName().hashCode());
        hashCode = 31 * hashCode + (this.keySchema() == null ? 0 : this.keySchema().hashCode());
        hashCode = 31 * hashCode + (this.localSecondaryIndexes() == null ? 0 : this.localSecondaryIndexes().hashCode());
        hashCode = 31 * hashCode + (this.globalSecondaryIndexes() == null ? 0 : this.globalSecondaryIndexes().hashCode());
        hashCode = 31 * hashCode + (this.provisionedThroughput() == null ? 0 : this.provisionedThroughput().hashCode());
        hashCode = 31 * hashCode + (this.streamSpecification() == null ? 0 : this.streamSpecification().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTableRequest)) {
            return false;
        }
        CreateTableRequest other = (CreateTableRequest)((Object)obj);
        if (other.attributeDefinitions() == null ^ this.attributeDefinitions() == null) {
            return false;
        }
        if (other.attributeDefinitions() != null && !other.attributeDefinitions().equals(this.attributeDefinitions())) {
            return false;
        }
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.keySchema() == null ^ this.keySchema() == null) {
            return false;
        }
        if (other.keySchema() != null && !other.keySchema().equals(this.keySchema())) {
            return false;
        }
        if (other.localSecondaryIndexes() == null ^ this.localSecondaryIndexes() == null) {
            return false;
        }
        if (other.localSecondaryIndexes() != null && !other.localSecondaryIndexes().equals(this.localSecondaryIndexes())) {
            return false;
        }
        if (other.globalSecondaryIndexes() == null ^ this.globalSecondaryIndexes() == null) {
            return false;
        }
        if (other.globalSecondaryIndexes() != null && !other.globalSecondaryIndexes().equals(this.globalSecondaryIndexes())) {
            return false;
        }
        if (other.provisionedThroughput() == null ^ this.provisionedThroughput() == null) {
            return false;
        }
        if (other.provisionedThroughput() != null && !other.provisionedThroughput().equals(this.provisionedThroughput())) {
            return false;
        }
        if (other.streamSpecification() == null ^ this.streamSpecification() == null) {
            return false;
        }
        return other.streamSpecification() == null || other.streamSpecification().equals(this.streamSpecification());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attributeDefinitions() != null) {
            sb.append("AttributeDefinitions: ").append(this.attributeDefinitions()).append(",");
        }
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.keySchema() != null) {
            sb.append("KeySchema: ").append(this.keySchema()).append(",");
        }
        if (this.localSecondaryIndexes() != null) {
            sb.append("LocalSecondaryIndexes: ").append(this.localSecondaryIndexes()).append(",");
        }
        if (this.globalSecondaryIndexes() != null) {
            sb.append("GlobalSecondaryIndexes: ").append(this.globalSecondaryIndexes()).append(",");
        }
        if (this.provisionedThroughput() != null) {
            sb.append("ProvisionedThroughput: ").append(this.provisionedThroughput()).append(",");
        }
        if (this.streamSpecification() != null) {
            sb.append("StreamSpecification: ").append(this.streamSpecification()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<AttributeDefinition> attributeDefinitions;
        private String tableName;
        private List<KeySchemaElement> keySchema;
        private List<LocalSecondaryIndex> localSecondaryIndexes;
        private List<GlobalSecondaryIndex> globalSecondaryIndexes;
        private ProvisionedThroughput provisionedThroughput;
        private StreamSpecification streamSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTableRequest model) {
            this.setAttributeDefinitions(model.attributeDefinitions);
            this.setTableName(model.tableName);
            this.setKeySchema(model.keySchema);
            this.setLocalSecondaryIndexes(model.localSecondaryIndexes);
            this.setGlobalSecondaryIndexes(model.globalSecondaryIndexes);
            this.setProvisionedThroughput(model.provisionedThroughput);
            this.setStreamSpecification(model.streamSpecification);
        }

        public final Collection<AttributeDefinition> getAttributeDefinitions() {
            return this.attributeDefinitions;
        }

        @Override
        public final Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(AttributeDefinition ... attributeDefinitions) {
            this.attributeDefinitions(Arrays.asList(attributeDefinitions));
            return this;
        }

        public final void setAttributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Collection<KeySchemaElement> getKeySchema() {
            return this.keySchema;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
        }

        public final Collection<LocalSecondaryIndex> getLocalSecondaryIndexes() {
            return this.localSecondaryIndexes;
        }

        @Override
        public final Builder localSecondaryIndexes(Collection<LocalSecondaryIndex> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexListCopier.copy(localSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexes(LocalSecondaryIndex ... localSecondaryIndexes) {
            this.localSecondaryIndexes(Arrays.asList(localSecondaryIndexes));
            return this;
        }

        public final void setLocalSecondaryIndexes(Collection<LocalSecondaryIndex> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexListCopier.copy(localSecondaryIndexes);
        }

        public final Collection<GlobalSecondaryIndex> getGlobalSecondaryIndexes() {
            return this.globalSecondaryIndexes;
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndex> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(GlobalSecondaryIndex ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        public final void setGlobalSecondaryIndexes(Collection<GlobalSecondaryIndex> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexListCopier.copy(globalSecondaryIndexes);
        }

        public final ProvisionedThroughput getProvisionedThroughput() {
            return this.provisionedThroughput;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
        }

        public final StreamSpecification getStreamSpecification() {
            return this.streamSpecification;
        }

        @Override
        public final Builder streamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        public final void setStreamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
        }

        public CreateTableRequest build() {
            return new CreateTableRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateTableRequest> {
        public Builder attributeDefinitions(Collection<AttributeDefinition> var1);

        public Builder attributeDefinitions(AttributeDefinition ... var1);

        public Builder tableName(String var1);

        public Builder keySchema(Collection<KeySchemaElement> var1);

        public Builder keySchema(KeySchemaElement ... var1);

        public Builder localSecondaryIndexes(Collection<LocalSecondaryIndex> var1);

        public Builder localSecondaryIndexes(LocalSecondaryIndex ... var1);

        public Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndex> var1);

        public Builder globalSecondaryIndexes(GlobalSecondaryIndex ... var1);

        public Builder provisionedThroughput(ProvisionedThroughput var1);

        public Builder streamSpecification(StreamSpecification var1);
    }
}

