/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.spec;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.event.ProgressListener;
import software.amazon.awssdk.services.dynamodb.document.Expected;
import software.amazon.awssdk.services.dynamodb.document.KeyAttribute;
import software.amazon.awssdk.services.dynamodb.document.PrimaryKey;
import software.amazon.awssdk.services.dynamodb.document.spec.AbstractSpecWithPrimaryKey;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;

public class DeleteItemSpec
extends AbstractSpecWithPrimaryKey<DeleteItemRequest> {
    private Collection<Expected> expected;
    private Map<String, String> nameMap;
    private Map<String, Object> valueMap;

    public DeleteItemSpec() {
        super((AmazonWebServiceRequest)DeleteItemRequest.builder().build());
    }

    public DeleteItemSpec withPrimaryKey(KeyAttribute ... components) {
        super.withPrimaryKey(components);
        return this;
    }

    public DeleteItemSpec withPrimaryKey(PrimaryKey primaryKey) {
        super.withPrimaryKey(primaryKey);
        return this;
    }

    public DeleteItemSpec withPrimaryKey(String hashKeyName, Object hashKeyValue) {
        super.withPrimaryKey(hashKeyName, hashKeyValue);
        return this;
    }

    public DeleteItemSpec withPrimaryKey(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        super.withPrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue);
        return this;
    }

    public Collection<Expected> getExpected() {
        return this.expected;
    }

    public DeleteItemSpec withExpected(Expected ... expected) {
        if (expected == null) {
            this.expected = null;
            return this;
        }
        return this.withExpected(Arrays.asList(expected));
    }

    public DeleteItemSpec withExpected(Collection<Expected> expected) {
        if (expected == null) {
            this.expected = null;
            return this;
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Expected e : expected) {
            names.add(e.getAttribute());
        }
        if (names.size() != expected.size()) {
            throw new IllegalArgumentException("attribute names must not duplicate in the list of expected");
        }
        this.expected = Collections.unmodifiableCollection(expected);
        return this;
    }

    public String getConditionExpression() {
        return ((DeleteItemRequest)this.getRequest()).conditionExpression();
    }

    public DeleteItemSpec withConditionExpression(String conditionExpression) {
        this.setRequest((AmazonWebServiceRequest)((DeleteItemRequest)this.getRequest()).toBuilder().conditionExpression(conditionExpression).build());
        return this;
    }

    public Map<String, String> nameMap() {
        return this.nameMap;
    }

    public DeleteItemSpec withNameMap(Map<String, String> nameMap) {
        this.nameMap = nameMap == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, String>(nameMap));
        return this;
    }

    public Map<String, Object> valueMap() {
        return this.valueMap;
    }

    public DeleteItemSpec valueMap(Map<String, Object> valueMap) {
        this.valueMap = valueMap == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(valueMap));
        return this;
    }

    public String getConditionalOperator() {
        return ((DeleteItemRequest)this.getRequest()).conditionalOperator();
    }

    public DeleteItemSpec withConditionalOperator(ConditionalOperator conditionalOperator) {
        this.setRequest((AmazonWebServiceRequest)((DeleteItemRequest)this.getRequest()).toBuilder().conditionalOperator(conditionalOperator).build());
        return this;
    }

    public String getReturnConsumedCapacity() {
        return ((DeleteItemRequest)this.getRequest()).returnConsumedCapacity();
    }

    public DeleteItemSpec withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.setRequest((AmazonWebServiceRequest)((DeleteItemRequest)this.getRequest()).toBuilder().returnConsumedCapacity(returnConsumedCapacity).build());
        return this;
    }

    public String getReturnItemCollectionMetrics() {
        return ((DeleteItemRequest)this.getRequest()).returnItemCollectionMetrics();
    }

    public DeleteItemSpec withReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
        this.setRequest((AmazonWebServiceRequest)((DeleteItemRequest)this.getRequest()).toBuilder().returnItemCollectionMetrics(returnItemCollectionMetrics).build());
        return this;
    }

    public String getReturnValues() {
        return ((DeleteItemRequest)this.getRequest()).returnValues();
    }

    public DeleteItemSpec withReturnValues(ReturnValue returnValues) {
        this.setRequest((AmazonWebServiceRequest)((DeleteItemRequest)this.getRequest()).toBuilder().returnValues(returnValues).build());
        return this;
    }

    @Override
    public DeleteItemSpec withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }
}

